/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskPackage;

public class TaskContainerPackages
extends Task
implements ContainerTaskInterface {
    private List<Task> m_subTaskList = new ArrayList<Task>();

    public TaskContainerPackages(TaskPackage[] subtaskArr) {
        if (subtaskArr != null) {
            for (TaskPackage t : subtaskArr) {
                this.addTaskToContainer(t);
            }
        }
    }

    @Override
    public boolean performTask() {
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4407", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4457", false);
    }

    @Override
    public boolean hasSubtasks() {
        return this.isContainerTask();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        List<Task> subTaskList = this.m_subTaskList;
        if (subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public Task addTaskToContainer(Task t) {
        if (!this.m_subTaskList.contains(t)) {
            this.m_subTaskList.add(t);
        }
        return t;
    }

    @Override
    public boolean isContainerTask() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        if (this.isContainerTask()) {
            for (Task t : this.m_subTaskList) {
                t.setNodeList(nodeList);
            }
        }
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        return false;
    }

    @Override
    public Task getContainerObject() {
        return this;
    }

    @Override
    public Task finalizeContainer() {
        return this;
    }
}

