/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksUnavailableException;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.NoSuchNodeException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.ContainerTaskInterface;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFreeSpace;
import oracle.ops.verification.framework.engine.task.sTaskFreeSpace;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskContainerFreeSpace
extends Task
implements ContainerTaskInterface {
    private static boolean m_visited = false;
    private List<Task> m_subTaskList = new ArrayList<Task>();
    private Hashtable<String, List<MountPoint>> m_nodeMntPntLocationTable = new Hashtable();
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1056", false);

    public TaskContainerFreeSpace(String[] nodeList) {
        this.m_nodeList = nodeList;
        Trace.out((String)"Constructor");
    }

    public void addPathDetails(String location, StorageSize requiredFreeSpace, StorageSize requiredFreeSpaceForRimNode, boolean temp, SeverityType severity) {
        Trace.out((String)("Location: '" + location + "' Required free space: '" + ReportUtil.unitizeSize(requiredFreeSpace, 1) + "' Required Free space for RIM/LEAF nodes: '" + ReportUtil.unitizeSize(requiredFreeSpaceForRimNode, 1) + "' Severity: '" + (Object)((Object)severity) + "'"));
        if (VerificationUtil.isStringGood(location)) {
            if (temp) {
                Vector<String> failedNodes;
                ClusterCmd clusterCmd;
                block14: {
                    int i;
                    Trace.out((String)"checking if temp dir exists");
                    clusterCmd = new ClusterCmd();
                    failedNodes = null;
                    try {
                        if (this.m_nodeList == null) break block14;
                        clusterCmd.dirExists(this.m_nodeList, location);
                    }
                    catch (ClusterException e) {
                        Trace.out((String)("temp dir doesn't exist on all nodes" + e.getMessage()));
                        failedNodes = new Vector<String>(this.m_nodeList.length);
                        for (i = 0; i < this.m_nodeList.length; ++i) {
                            failedNodes.add(this.m_nodeList[i]);
                        }
                        VerificationLogData.logError("CLUSTEREXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                    }
                    catch (ClusterOperationException e) {
                        VerificationLogData.logError("CLUSTEROPERATIONEXCEPTION: " + e.getMessage() + "\n" + Trace.getStackTrace((Throwable)e));
                        Trace.out((String)("temp dir doesn't exist on some nodes" + e.getMessage()));
                        failedNodes = new Vector();
                        for (i = 0; i < this.m_nodeList.length; ++i) {
                            try {
                                if (e.getStatus(this.m_nodeList[i]) == 0) continue;
                                failedNodes.add(this.m_nodeList[i]);
                                continue;
                            }
                            catch (NoSuchNodeException ne) {
                                Trace.out((String)("no such node exception for node" + this.m_nodeList[i]));
                                Trace.out((Exception)((Object)ne));
                            }
                        }
                    }
                }
                try {
                    if (failedNodes != null && failedNodes.size() > 0) {
                        clusterCmd.createDirInNodes(failedNodes.toArray(new String[0]), location);
                    }
                }
                catch (ClusterException e) {
                    Trace.out((String)("error creating temp dir in failed nodes" + e.getMessage()));
                    String msg = s_msgBundle.getMessage("7509", true, (Object[])new String[]{location});
                    ReportUtil.sureprintln(msg);
                }
            }
            this.processLocation(location, requiredFreeSpace, requiredFreeSpaceForRimNode, severity);
        } else {
            Trace.out((String)"Input location was not a valid string. Ignoring...");
        }
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"EXIT");
        }
    }

    public void generateTaskFreeSpaceList() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        String bootStrapPath = null;
        String mntPnt = null;
        if ((ParamManager.isRuncluvfy() || m_isAPImode) && !m_visited) {
            bootStrapPath = CVUAutoUpdateManager.getDerivedCVUHome();
            mntPnt = TaskContainerFreeSpace.getMntPnt(bootStrapPath);
        }
        for (String node : this.m_nodeMntPntLocationTable.keySet()) {
            List<MountPoint> mntPntList = this.m_nodeMntPntLocationTable.get(node);
            if ((ParamManager.isRuncluvfy() || m_isAPImode) && m_localNode.equalsIgnoreCase(node)) {
                MountPoint mpRef = this.findMountPointInList(mntPnt, mntPntList);
                if (mntPnt != null && !mntPnt.equals("UNKNOWN") && mpRef != null) {
                    this.ignoreBootStrapSpace(mpRef, bootStrapPath);
                }
            }
            for (MountPoint mountPoint : mntPntList) {
                TaskFreeSpace tfs = new TaskFreeSpace(node, mountPoint);
                VerificationLogData.logInfo("\n    Adding to Task List:  on node (" + node + ") For mount point : " + mountPoint.toString());
                this.addTaskToContainer(tfs);
            }
        }
    }

    public static String getMntPnt(String loc) {
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace();
        String cmd = sTask.getCommand(loc);
        ResultSet rsltSet = new ResultSet();
        String mountPoint = "UNKNOWN";
        globalExec.runGenericCmd(new String[]{m_localNode}, cmd, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Result result = (Result)t.get(m_localNode);
        if (result.getStatus() == 1) {
            String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
            mountPoint = sTask.getData(cmdOut, 6);
        }
        Trace.out((String)("   Location  :" + loc + "\n" + "   Mnt Point :" + mountPoint));
        return mountPoint;
    }

    public boolean ignoreBootStrapSpace(MountPoint mp, String bsLoc) {
        VerificationCommand cmdOP;
        Result result;
        Trace.out((String)"Inside ignoreBootStrapSpace().....");
        ResultSet rsltSet = new ResultSet();
        String[] arg = new String[]{"-getdirsize", bsLoc};
        String[] env = null;
        VerificationCommand[] cmd = new VerificationCommand[]{new VerificationCommand(m_localNode, arg, env)};
        boolean cmdResult = new GlobalHandler().submit((Command[])cmd, 0, rsltSet);
        if (cmdResult && (result = (Result)rsltSet.getResultTable().get(m_localNode)).getStatus() == 1 && (cmdOP = cmd[0]).getVfyCode() == 0) {
            String cmdOut = cmdOP.getOutput();
            if (cmdOut == null) {
                return false;
            }
            String[] op = (cmdOut = cmdOut.trim()).split("\n");
            if (op.length > 0) {
                cmdOut = op[0];
            }
            StorageSize sizeAvail = new StorageSize((double)new Double(cmdOut), StorageUnit.BYTE);
            mp.getAvailableSpace().add(sizeAvail);
            return true;
        }
        return false;
    }

    @Override
    public boolean performTask() {
        return true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4438", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4491", false);
    }

    @Override
    public boolean hasSubtasks() {
        return this.isContainerTask();
    }

    @Override
    public List<VerificationTask> getSubtasks() throws SubtasksUnavailableException {
        ArrayList<VerificationTask> listOfSubtasks = new ArrayList<VerificationTask>();
        if (this.m_subTaskList.isEmpty()) {
            throw new SubtasksUnavailableException(s_msgBundle.getMessage("7504", false));
        }
        for (Task t : this.m_subTaskList) {
            listOfSubtasks.add(t);
        }
        return listOfSubtasks;
    }

    @Override
    public Task addTaskToContainer(Task t) {
        if (!this.m_subTaskList.contains(t)) {
            this.m_subTaskList.add(t);
        }
        return t;
    }

    @Override
    public boolean isContainerTask() {
        return !this.m_subTaskList.isEmpty();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        if (!this.m_subTaskList.isEmpty()) {
            ArrayList<Task> applicableList = new ArrayList<Task>();
            for (Task t : this.m_subTaskList) {
                if (t.isApplicable()) {
                    Trace.out((String)(t.getTaskName() + " is applicable from this container."));
                    applicableList.add(t);
                    continue;
                }
                Trace.out((String)(t.getTaskName() + " is NOT applicable from this container."));
            }
            this.m_subTaskList.clear();
            this.m_subTaskList.addAll(applicableList);
            return !this.m_subTaskList.isEmpty();
        }
        return false;
    }

    @Override
    public void setNodeList(String[] nodeList) {
        this.m_nodeList = nodeList;
        if (this.isContainerTask()) {
            for (Task t : this.m_subTaskList) {
                t.setNodeList(nodeList);
            }
        }
    }

    @Override
    public Task getContainerObject() {
        return this;
    }

    @Override
    public Task finalizeContainer() {
        return this;
    }

    private void processLocation(String location, StorageSize requiredFreeSpace, StorageSize requiredFreeSpaceForRimNode, SeverityType severity) {
        GlobalExecution globalExec = new GlobalExecution();
        sTaskFreeSpace sTask = new sTaskFreeSpace(this);
        String originalLoc = location;
        Trace.out((String)("\n    Processing Location [" + location + "] ' Required free space: '" + ReportUtil.unitizeSize(requiredFreeSpace, 1) + "' Required free space for RIM nodes: '" + ReportUtil.unitizeSize(requiredFreeSpaceForRimNode, 1) + "' Severity: '" + (Object)((Object)severity) + "'"));
        String newLoc = VerificationUtil.getLongestExistingParentPath(this.m_nodeList, location, false);
        if (!VerificationUtil.isStringGood(newLoc) && VerificationUtil.isStringGood(location) && location.trim().startsWith(FSEP)) {
            newLoc = new String(FSEP);
        }
        if (VerificationUtil.isStringGood(newLoc) && !newLoc.contentEquals(location)) {
            Trace.out((String)("\nProcessing old location: " + location + "\ninto new location: " + newLoc));
            location = newLoc;
        }
        String cmd = sTask.getCommand(location);
        Trace.out((String)("\n    Executing command: " + cmd + "\n    on nodeList:      " + VerificationUtil.strArr2List(this.m_nodeList)));
        ResultSet rsltSet = new ResultSet();
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (nativeSystem.isUnixSystem()) {
            globalExec.runGenericCmd(this.m_nodeList, cmd, rsltSet);
        } else {
            globalExec.getSpaceCmd(this.m_nodeList, location, rsltSet);
        }
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String mountPoint;
            String node = (String)e.nextElement();
            Location nodeLoc = new Location(originalLoc, requiredFreeSpace, requiredFreeSpaceForRimNode, severity);
            nodeLoc.setPath(location);
            Result result = (Result)t.get(node);
            StorageSize availableFreeSpaceAtLocOnNode = new StorageSize(0.0, StorageUnit.BYTE);
            Trace.out((String)("Processing node: '" + node + "'"));
            if (result.getStatus() == 2) {
                Trace.out((String)("Operation failure on node: '" + node + "'"));
                mountPoint = "UNKNOWN";
                availableFreeSpaceAtLocOnNode = new StorageSize(0.0, StorageUnit.MBYTE);
            } else {
                String cmdOut = VerificationUtil.strArr2List((String[])result.getResultInfoSet().get(1), System.getProperty("line.separator"));
                String sizeTxt = sTask.getData(cmdOut, 4);
                mountPoint = sTask.getData(cmdOut, 6);
                availableFreeSpaceAtLocOnNode = new StorageSize((double)new Double(sizeTxt), StorageUnit.MBYTE);
                VerificationUtil.traceAndLog("For location ( " + nodeLoc.getOriginalPath() + ") Node (" + node + ") reports mount point (" + mountPoint + ") and available size as (" + ReportUtil.unitizeSize(availableFreeSpaceAtLocOnNode, 1) + ")");
            }
            Trace.out((String)("\n    Processing:  \n    Node:        " + node + "\n    Location Original:    " + nodeLoc.getOriginalPath() + "\n    Location longest existing parent path:    " + nodeLoc.getPath() + "\n    Available space:    " + ReportUtil.unitizeSize(availableFreeSpaceAtLocOnNode, 1) + "\n    Mount Point: " + mountPoint));
            nodeLoc.setAvailableFreeSpace(availableFreeSpaceAtLocOnNode);
            if (this.m_nodeMntPntLocationTable.containsKey(node)) {
                MountPoint mpRef = this.findMountPointInList(mountPoint, this.m_nodeMntPntLocationTable.get(node));
                if (mpRef == null) {
                    mpRef = new MountPoint(mountPoint);
                    mpRef.addLocation(nodeLoc);
                    this.m_nodeMntPntLocationTable.get(node).add(mpRef);
                } else {
                    mpRef.addLocation(nodeLoc);
                }
                mpRef.setAvailableSpace(availableFreeSpaceAtLocOnNode);
                continue;
            }
            MountPoint mp = new MountPoint(mountPoint);
            mp.addLocation(nodeLoc);
            mp.setAvailableSpace(availableFreeSpaceAtLocOnNode);
            ArrayList<MountPoint> mntPntList = new ArrayList<MountPoint>();
            mntPntList.add(mp);
            this.m_nodeMntPntLocationTable.put(node, mntPntList);
        }
    }

    private MountPoint findMountPointInList(String mountPoint, List<MountPoint> mntPntList) {
        for (MountPoint mntPnt : mntPntList) {
            if (!mntPnt.getMountPoint().equals(mountPoint)) continue;
            return mntPnt;
        }
        return null;
    }

    public static class Location {
        private String m_path;
        private StorageSize m_reqdFreeSpace;
        private StorageSize m_reqdRimFreeSpace;
        private StorageSize m_availFreeSpace;
        private SeverityType m_severity;
        private final String m_originalPath;

        public Location(String path, StorageSize requiredFreeSpace, StorageSize rimReqFreeSpace, SeverityType severity) {
            this.m_path = path;
            this.m_reqdFreeSpace = requiredFreeSpace;
            this.m_reqdRimFreeSpace = rimReqFreeSpace;
            this.m_severity = severity;
            this.m_originalPath = path;
            this.m_availFreeSpace = new StorageSize(0.0, StorageUnit.MBYTE);
            Trace.out((String)("Constructor: " + this.toString()));
        }

        public String getOriginalPath() {
            return this.m_originalPath;
        }

        public void setAvailableFreeSpace(StorageSize availFreeSpace) {
            this.m_availFreeSpace = availFreeSpace;
        }

        public void setPath(String path) {
            this.m_path = path;
        }

        public String getPath() {
            return this.m_path;
        }

        public StorageSize getReqdFreeSpace() {
            return this.m_reqdFreeSpace;
        }

        public StorageSize getReqdRimFreeSpace() {
            return this.m_reqdRimFreeSpace;
        }

        public StorageSize getAvailableFreeSpace() {
            return this.m_availFreeSpace;
        }

        public SeverityType getSeverity() {
            return this.m_severity;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n    Memory addr:      " + this.hashCode() + "\n    Location:      " + this.m_path + "\n    Reqd Free space:        " + this.m_reqdFreeSpace + "\n    Reqd Rim Free space:    " + this.m_reqdRimFreeSpace + "\n    Avail Free space:       " + ReportUtil.unitizeSize(this.m_availFreeSpace, 1) + "\n    Severity:         " + (Object)((Object)this.m_severity));
            return sb.toString();
        }
    }

    public static class MountPoint {
        private String m_mountPoint;
        private StorageSize m_mountAvailableSpace;
        private List<Location> m_locations;

        public MountPoint(String mountPoint) {
            this.m_mountPoint = VerificationUtil.isStringGood(mountPoint) ? mountPoint : "UNKNOWN";
            this.m_mountAvailableSpace = new StorageSize(0.0, StorageUnit.MBYTE);
            this.m_locations = new ArrayList<Location>();
        }

        public void setAvailableSpace(StorageSize size) {
            this.m_mountAvailableSpace = size;
            for (Location loc : this.m_locations) {
                loc.setAvailableFreeSpace(this.m_mountAvailableSpace);
            }
        }

        public void addLocations(List<Location> locations) {
            for (Location loc : locations) {
                this.addLocation(loc);
            }
        }

        public void addLocation(Location location) {
            boolean isExist = false;
            for (Location loc : this.m_locations) {
                if (!loc.getPath().equals(location.getPath())) continue;
                isExist = true;
            }
            if (!isExist) {
                this.m_locations.add(location);
            }
        }

        public String getMountPoint() {
            return this.m_mountPoint;
        }

        public List<Location> getLocations() {
            if (this.m_mountAvailableSpace.sizeIn(StorageUnit.BYTE) > 0.0) {
                for (Location loc : this.m_locations) {
                    loc.setAvailableFreeSpace(this.m_mountAvailableSpace);
                }
            }
            return this.m_locations;
        }

        public StorageSize getAvailableSpace() {
            return this.m_mountAvailableSpace;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("\n    Memory addr:      " + this.hashCode() + "\n    Mount Point:      " + this.m_mountPoint + "\n    Mount location available space:        " + ReportUtil.unitizeSize(this.m_mountAvailableSpace, 1));
            if (!this.m_locations.isEmpty()) {
                sb.append("\nLOCATIONS FOR THIS MOUNT POINT\n");
            }
            for (Location loc : this.getLocations()) {
                sb.append(loc.toString());
            }
            return sb.toString();
        }
    }
}

