/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckRACUserASMPrivilege
extends Task {
    private String m_user;
    private String m_group;

    public TaskCheckRACUserASMPrivilege() {
    }

    public TaskCheckRACUserASMPrivilege(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_user = CVUVariables.getValue(CVUVariableConstants.INSTALL_USER);
        this.m_group = CVUVariables.getValue(CVUVariableConstants.ASM_DBA_GROUP);
        SeverityType sType = SeverityType.IGNORABLE;
        if (Boolean.parseBoolean(CVUVariables.getValue("DATA_ON_ASM"))) {
            sType = SeverityType.CRITICAL;
        }
        this.setSeverity(sType);
        VerificationUtil.traceAndLog("user: %s, group: %s, severity: %s", this.m_user, this.m_group, sType.toString());
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_DB_INST: {
                if (!this.m_globalContext.isUnixSystem() || !VerificationUtil.isStringGood(this.m_user) || !VerificationUtil.isStringGood(this.m_group)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean performTask() {
        TaskGroupMembership taskGrpMembr = TaskGroupMembership.generate(this.m_user, this.m_group, false, this.m_nodeList, false);
        this.addChildTask(taskGrpMembr);
        taskGrpMembr.perform();
        ResultSet usrInGrpRslt = taskGrpMembr.getResultSet();
        this.m_resultSet.uploadResultSet(usrInGrpRslt);
        if (usrInGrpRslt.allSuccess()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        String failedNodes = VerificationUtil.strCollection2String(usrInGrpRslt.getFailedNodes());
        ErrorDescription errDesc = new ErrorDescription(s_gMsgBundle.getMessage("10464", true, (Object[])new String[]{this.m_user, failedNodes}));
        this.m_resultSet.addErrorDescription(errDesc);
        this.m_resultSet.addResult(failedNodes, 3);
        return false;
    }

    @Override
    public String getTaskID() {
        return "CHECK_RAC_USER_ASM_MEMBERSHIP";
    }

    @Override
    public String getTaskName() {
        return this.getTaskID() + "_" + this.m_user + "_" + this.m_group;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("10462", false, (Object[])new String[]{this.m_user});
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("10463", false, (Object[])new String[]{this.m_user});
    }
}

