/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Scanner;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.ASMDiskData;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCheckDiskScheduler
extends Task {
    private String[] m_inputDevicePaths = null;
    private String m_typeScheduler;
    private boolean m_preCRSInst = false;

    public TaskCheckDiskScheduler(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_typeScheduler = VDMUtil.getDefaultIOScheduler();
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                this.initPre();
                break;
            }
        }
    }

    private void initPre() {
        String asmDeviceString = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
        String asmDiscoveryString = CVUVariables.getValue(CVUVariableConstants.ASM_DISK_DISCOVERY_STRING);
        Trace.out((String)"ASM Disks=%s, ASM Discovery String=%s", (Object[])new Object[]{asmDeviceString, asmDiscoveryString});
        asmDeviceString = asmDeviceString != null ? asmDeviceString : asmDiscoveryString;
        String[] devarr = null;
        if (asmDeviceString != null) {
            devarr = asmDeviceString.split(",");
        } else {
            devarr = this.m_globalContext.getASMdevices();
            Trace.out((Object)"Using ASM Devices from context: %s", (String)VerificationUtil.strArr2List(devarr));
        }
        this.setInputDevicePaths(devarr);
        this.setPreCRSInst();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        block8: {
            block7: {
                if (VerificationUtil.isEngineeredSystem()) break block7;
                TaskCheckDiskScheduler taskCheckDiskScheduler = this;
                if (!taskCheckDiskScheduler.m_globalContext.isMemberCluster()) break block8;
            }
            return false;
        }
        switch (this.m_globalContext.getVerificationType()) {
            case PREREQ_CRS_INST: 
            case BESTPRACTICE_PRE_CRS_INST: 
            case PREREQ_USM_CONFIG: {
                return this.m_inputDevicePaths != null;
            }
            case POSTREQ_CRS_INST: 
            case BESTPRACTICE_POSTREQ_CRS_INST: {
                return this.m_globalContext.isOCROrVdiskOnASM();
            }
            case POSTREQ_USM_CONFIG: {
                return true;
            }
        }
        return false;
    }

    public TaskCheckDiskScheduler(String[] nodeList, String typeScheduler) {
        super(nodeList, null, 1);
        this.m_typeScheduler = typeScheduler;
    }

    public String[] getInputDevicePaths() {
        return this.m_inputDevicePaths;
    }

    public void setInputDevicePaths(String[] devicePaths) {
        this.m_inputDevicePaths = devicePaths;
    }

    public void setPreCRSInst() {
        this.m_preCRSInst = true;
    }

    @Override
    public boolean performTask() {
        Hashtable<String, Hashtable<String, List<String>>> nodeGroupsDisks = new Hashtable<String, Hashtable<String, List<String>>>();
        Hashtable<String, List<ASMDiskData>> nodeDevicesMap = new Hashtable<String, List<ASMDiskData>>();
        Trace.out((String)"ENTRY");
        ReportUtil.sureprintln(LSEP + s_gMsgBundle.getMessage("11972", false));
        boolean cvuqdiskAvailable = false;
        ResultSet pkgRsltSet = new ResultSet();
        cvuqdiskAvailable = VerificationUtil.isCVUQDiskAvailable(this.m_nodeList, pkgRsltSet, this);
        if (!cvuqdiskAvailable) {
            this.m_resultSet.addResultSetData(pkgRsltSet);
            Trace.out((String)"cvuqdisk rpm is not installed. Skipping validation of I/O scheduler");
            Enumeration enumNodes = this.m_resultSet.getResultTable().keys();
            while (enumNodes.hasMoreElements()) {
                String node = (String)enumNodes.nextElement();
                ((Result)this.m_resultSet.getResultTable().get(node)).setStatus(4);
            }
            this.m_resultSet.setStatus(4);
            this.setSeverity(SeverityType.IGNORABLE);
            return false;
        }
        Trace.out((int)1, (String)"cvuqdisk rpm is installed. Performing validation of I/O scheduler");
        this.m_resultSet.addResult(this.m_nodeList, 1);
        if (this.m_preCRSInst) {
            if (this.m_inputDevicePaths != null && this.m_inputDevicePaths.length > 0) {
                for (String node : this.m_nodeList) {
                    List<String> expandedDeviceList = StorageUtil.expandDevicePaths(node, this.m_inputDevicePaths);
                    expandedDeviceList = new ArrayList<String>(new LinkedHashSet<String>(expandedDeviceList));
                    Trace.out((String)("expanded device list: " + expandedDeviceList));
                    ArrayList<String> resolvedDevicePathList = new ArrayList<String>();
                    ArrayList<String> devicesManagedByASM = new ArrayList<String>();
                    StorageUtil.processASMDiskStamps(new String[]{node}, expandedDeviceList, devicesManagedByASM, resolvedDevicePathList);
                    Trace.out((String)("node [" + node + "] resolvedPaths: " + resolvedDevicePathList));
                    ArrayList<ASMDiskData> disks = new ArrayList<ASMDiskData>();
                    for (String asmDiskPath : resolvedDevicePathList) {
                        ASMDiskData diskData = new ASMDiskData();
                        diskData.setASMDisk(asmDiskPath);
                        disks.add(diskData);
                    }
                    nodeDevicesMap.put(node, disks);
                }
            }
        } else {
            ResultSet diskGroupRS = new ResultSet();
            try {
                boolean result = new ASMDiskGroupsUtil().getDiskGroupsDiskMap(this.m_nodeList, diskGroupRS, nodeGroupsDisks);
                if (!result) {
                    Trace.out((String)"Failed to retrieve the disk group information");
                    List<VerificationError> errorList = diskGroupRS.getErrors();
                    for (VerificationError err : errorList) {
                        ReportUtil.printError(err.getErrorMessage());
                    }
                    this.m_resultSet.addResultSetData(diskGroupRS);
                    return false;
                }
                if (diskGroupRS.anyFailure()) {
                    ReportUtil.printWarning(s_gMsgBundle.getMessage("11978", false));
                    this.m_resultSet.addResult(this.m_nodeList, 4);
                    this.setSeverity(SeverityType.IGNORABLE);
                    return true;
                }
                Enumeration<String> nodekeys = nodeGroupsDisks.keys();
                Enumeration<String> groupkeys = null;
                Hashtable<String, List<String>> groupDev = null;
                List<String> devices = null;
                String groupkey = null;
                String nodeKey = null;
                ASMDiskData diskData = null;
                while (nodekeys.hasMoreElements()) {
                    nodeKey = nodekeys.nextElement();
                    groupDev = nodeGroupsDisks.get(nodeKey);
                    groupkeys = groupDev.keys();
                    while (groupkeys.hasMoreElements()) {
                        groupkey = groupkeys.nextElement();
                        devices = groupDev.get(groupkey);
                        ArrayList<String> resolvedDevicePathList = new ArrayList<String>();
                        ArrayList<String> devicesManagedByASM = new ArrayList<String>();
                        StorageUtil.processASMDiskStamps(new String[]{nodeKey}, devices, devicesManagedByASM, resolvedDevicePathList);
                        Trace.out((String)("node [" + nodeKey + "] resolvedPaths: " + resolvedDevicePathList));
                        List<Object> disks = null;
                        disks = nodeDevicesMap.containsKey(nodeKey) && nodeDevicesMap.get(nodeKey) != null ? nodeDevicesMap.get(nodeKey) : new ArrayList();
                        for (String devicePath : resolvedDevicePathList) {
                            diskData = new ASMDiskData();
                            diskData.setASMDisk(devicePath);
                            diskData.setASMDiskGroup(groupkey);
                            disks.add(diskData);
                        }
                        nodeDevicesMap.put(nodeKey, disks);
                    }
                }
            }
            catch (ASMDiskGroupsUtilException asme) {
                Trace.out((String)("Failed to discover the asm disks of the disk groups\n" + asme.getMessage()));
                VerificationLogData.log(asme.getMessage());
                ReportUtil.printError(asme.getMessage());
                this.m_resultSet.addResultSetData(diskGroupRS);
                return false;
            }
        }
        ResultSet checkSchedulerRset = new ResultSet();
        if (nodeDevicesMap.size() > 0) {
            this.performCheckDiskScheduler(nodeDevicesMap, checkSchedulerRset);
        } else {
            checkSchedulerRset.addResult(this.m_nodeList, 1);
            for (String node : this.m_nodeList) {
                this.m_resultSet.getResult(node).setHasResultValues(false);
            }
        }
        this.m_resultSet.addResultSetData(checkSchedulerRset);
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11973", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11974", false));
        return false;
    }

    private void performCheckDiskScheduler(Hashtable<String, List<ASMDiskData>> nodeDevices, ResultSet rset) {
        RunGenericCommand diskSchedCommand = null;
        RunGenericCommand blockDeviceCommand = null;
        ArrayList<RunGenericCommand> diskSchedCommands = new ArrayList<RunGenericCommand>();
        ArrayList<RunGenericCommand> blockDeviceCommands = new ArrayList<RunGenericCommand>();
        StorageInfo storageInfo = null;
        List<ASMDiskData> asmDisks = null;
        String realPathdevice = null;
        String nodeName = null;
        Enumeration<String> nodeNames = nodeDevices.keys();
        while (nodeNames.hasMoreElements()) {
            nodeName = nodeNames.nextElement();
            asmDisks = nodeDevices.get(nodeName);
            Trace.out((Object)"Getting storage info on node %s...", (String)nodeName);
            for (ASMDiskData asmDiskData : asmDisks) {
                String asmDiskDataDeviceString = asmDiskData.getASMDisk();
                Trace.out((Object)"originalPath[%s]", (String)asmDiskDataDeviceString);
                try {
                    Scanner digitScanner;
                    storageInfo = new TypeFinder().getStorageInstance(asmDiskDataDeviceString, nodeName);
                    if (storageInfo == null) continue;
                    String storageInfoPath = storageInfo.getPath();
                    Trace.out((Object)"realPath[%s]", (String)storageInfoPath);
                    if (storageInfoPath.contains(VerificationConstants.FSEP)) {
                        realPathdevice = storageInfoPath.substring(storageInfoPath.lastIndexOf(VerificationConstants.FSEP) + 1);
                    }
                    if ((digitScanner = new Scanner(realPathdevice).useDelimiter("\\d+")).hasNext()) {
                        realPathdevice = digitScanner.next();
                    }
                    Trace.out((Object)"deviceId[%s]", (String)realPathdevice);
                    blockDeviceCommand = new RunGenericCommand(nodeName, "/usr/bin/find /sys/block/* -name " + realPathdevice);
                    blockDeviceCommands.add(blockDeviceCommand);
                    asmDiskData.setBlockDeviceCommand(blockDeviceCommand);
                    asmDiskData.setStorageInfo(storageInfo);
                }
                catch (StorageException se) {
                    Trace.out((String)("StorageException getting storage type for: " + asmDiskDataDeviceString));
                    rset.addResult(nodeName, 1);
                    rset.addErrorDescription(nodeName, new ErrorDescription(se.getMessage()));
                    VerificationLogData.log(se.getMessage());
                    ReportUtil.sureprintln(se.getMessage());
                }
            }
        }
        if (blockDeviceCommands.isEmpty()) {
            Trace.out((String)"No device information found, nothing to check");
            return;
        }
        String node = null;
        ResultSet schedulerRset = new ResultSet();
        Result schedulerResult = null;
        new GlobalHandler().submit(blockDeviceCommands.toArray(new Command[0]), 0, schedulerRset);
        nodeNames = nodeDevices.keys();
        String[] resString = null;
        String[] tokens = null;
        String value = null;
        String blockDevice = null;
        Result resultDevice = null;
        while (nodeNames.hasMoreElements()) {
            nodeName = nodeNames.nextElement();
            asmDisks = nodeDevices.get(nodeName);
            Trace.out((String)("Get block device node[" + nodeName + "] ASMDSKS: " + asmDisks));
            for (ASMDiskData asmDiskData : asmDisks) {
                schedulerResult = asmDiskData.getBlockDeviceCommand().getResult();
                Trace.out((int)1, (String)("Check if path is on block device: " + asmDiskData.getASMDisk()));
                node = schedulerResult.getNode();
                if (schedulerResult.getStatus() == 1) {
                    resString = asmDiskData.getBlockDeviceCommand().getCommandResult().getResultString();
                    value = VerificationUtil.fetchVerificationValue(VerificationUtil.strArr2String(resString));
                    if (VerificationUtil.isStringGood(value)) {
                        tokens = VerificationUtil.string2strArr(value, "/");
                        if (tokens == null || tokens.length <= 2) continue;
                        blockDevice = tokens[tokens.length - 2];
                        if (blockDevice.equals("block")) {
                            blockDevice = tokens[tokens.length - 1];
                        }
                        asmDiskData.setBlockDevice(blockDevice);
                        diskSchedCommand = new RunGenericCommand(nodeName, "/bin/cat /sys/block/" + blockDevice + "/queue/scheduler");
                        diskSchedCommands.add(diskSchedCommand);
                        asmDiskData.setCommand(diskSchedCommand);
                        asmDiskData.setFlagBlockDevice(true);
                        continue;
                    }
                    Trace.out((String)"Path [%s] is not block device on node [%s]", (Object[])new Object[]{asmDiskData.getASMDisk(), node});
                    asmDiskData.setFlagBlockDevice(false);
                    continue;
                }
                resultDevice = new Result(node);
                resultDevice.setStatus(1);
                String errMsg = schedulerResult.getExecutionErrorDetails();
                ErrorDescription errorDesc = new ErrorDescription(errMsg);
                Trace.out((String)("Check Sheduler failed: " + errMsg));
                resultDevice.addErrorDescription(errorDesc);
                rset.addResult(node, resultDevice);
                VerificationLogData.log(errMsg);
                ReportUtil.sureprintln(errMsg);
            }
        }
        new GlobalHandler().submit(diskSchedCommands.toArray(new Command[0]), 0, schedulerRset);
        Result resultScheduler = null;
        String verificationValue = null;
        String currentScheduler = null;
        String[] schResString = null;
        String[] ioSchedulers = null;
        Hashtable<String, List<String>> schedulerNotSet = new Hashtable<String, List<String>>();
        Hashtable<ASMDiskData, List<String>> schedulerNotExpected = new Hashtable<ASMDiskData, List<String>>();
        nodeNames = nodeDevices.keys();
        while (nodeNames.hasMoreElements()) {
            nodeName = nodeNames.nextElement();
            asmDisks = nodeDevices.get(nodeName);
            Trace.out((String)("Check I/O scheduler configuration node[" + nodeName + "] ASMDSKS: " + asmDisks));
            for (ASMDiskData asmDiskData : asmDisks) {
                boolean matchScheduler = false;
                if (asmDiskData.isBlockDevice()) {
                    schedulerResult = asmDiskData.getCommand().getResult();
                    node = schedulerResult.getNode();
                    if (schedulerResult.getStatus() == 1) {
                        schResString = asmDiskData.getCommand().getCommandResult().getResultString();
                        verificationValue = VerificationUtil.fetchVerificationValue(VerificationUtil.strArr2String(schResString));
                        if (!verificationValue.matches(".*/sys/block/" + asmDiskData.getBlockDevice() + "/queue/scheduler.*")) {
                            for (String scheduler : ioSchedulers = VerificationUtil.string2strArr(verificationValue, " ")) {
                                Trace.out((String)("t scheduler[" + scheduler + "]"));
                                if (!scheduler.matches("\\[(.*)\\]")) continue;
                                currentScheduler = scheduler;
                                matchScheduler = true;
                                break;
                            }
                        }
                        if (!matchScheduler) {
                            resultScheduler = new Result(node);
                            resultScheduler.setStatus(1);
                            Trace.out((String)("Not scheduler configured " + verificationValue));
                            this.addDeviceNode(asmDiskData.getStorageInfo().getPath(), node, schedulerNotSet);
                            rset.addResult(node, resultScheduler);
                            continue;
                        }
                        if ((currentScheduler = currentScheduler.substring(1, currentScheduler.length() - 1)).equals(this.m_typeScheduler.toString().toLowerCase())) {
                            Trace.out((String)("success scheduler node[" + node + "] [" + asmDiskData.getASMDisk() + "] " + "[" + asmDiskData.getStorageInfo().getPath() + "]  [" + currentScheduler + "]"));
                            resultScheduler = new Result(node);
                            resultScheduler.setStatus(1);
                            rset.addResult(node, resultScheduler);
                            continue;
                        }
                        Trace.out((String)("failed scheduler node W[" + node + "] [" + asmDiskData.getASMDisk() + "] " + "[" + asmDiskData.getStorageInfo().getPath() + "]  [" + currentScheduler + "]"));
                        resultScheduler = new Result(node);
                        resultScheduler.setStatus(4);
                        this.setSeverity(SeverityType.IGNORABLE);
                        asmDiskData.setScheduler(currentScheduler);
                        this.addDeviceSchedulerNode(asmDiskData, node, schedulerNotExpected);
                        rset.addResult(node, resultScheduler);
                        continue;
                    }
                    resultScheduler = new Result(node);
                    resultScheduler.setStatus(1);
                    String errMsg = schedulerResult.getExecutionErrorDetails();
                    ErrorDescription errorDesc = new ErrorDescription(errMsg);
                    Trace.out((String)("Check Sheduler failed: " + errMsg));
                    resultScheduler.addErrorDescription(errorDesc);
                    rset.addResult(node, resultScheduler);
                    VerificationLogData.log(errMsg);
                    ReportUtil.sureprintln(errMsg);
                    continue;
                }
                resultScheduler = new Result(node);
                resultScheduler.setStatus(1);
                rset.addResult(node, resultScheduler);
            }
        }
        this.displayErrorMessages(schedulerNotSet, rset);
        this.displayErrorMessages(schedulerNotExpected, rset);
    }

    private void displayErrorMessages(Hashtable devicesNodes, ResultSet rset) {
        List nodesError = null;
        Enumeration keys = null;
        String errMsg = null;
        Object key = null;
        String device = null;
        ASMDiskData diskData = null;
        keys = devicesNodes.keys();
        while (keys.hasMoreElements()) {
            key = keys.nextElement();
            if (key instanceof String) {
                device = key;
                nodesError = (List)devicesNodes.get(device);
                errMsg = s_gMsgBundle.getMessage("11977", true, (Object[])new String[]{device, VerificationUtil.strList2List(nodesError)});
            }
            if (key instanceof ASMDiskData) {
                diskData = key;
                nodesError = (List)devicesNodes.get(diskData);
                errMsg = this.m_preCRSInst ? s_gMsgBundle.getMessage("11975", true, (Object[])new String[]{diskData.getStorageInfo().getPath(), VerificationUtil.strList2List(nodesError), this.m_typeScheduler.toString().toLowerCase(), diskData.getScheduler()}) : s_gMsgBundle.getMessage("11976", true, (Object[])new String[]{diskData.getStorageInfo().getPath(), diskData.getASMDisk(), diskData.getASMDiskGroup(), VerificationUtil.strList2List(nodesError), this.m_typeScheduler.toString().toLowerCase(), diskData.getScheduler()});
            }
            ErrorDescription errorDesc = new ErrorDescription(errMsg);
            rset.addErrorDescription(nodesError, errorDesc);
            VerificationLogData.log(errMsg);
            ReportUtil.printWarning(errMsg);
        }
    }

    private void addDeviceNode(String device, String node, Hashtable<String, List<String>> deviceNodes) {
        List<Object> nodes = null;
        if (deviceNodes.containsKey(device)) {
            nodes = deviceNodes.get(device);
        } else {
            nodes = new ArrayList();
            deviceNodes.put(device, nodes);
        }
        nodes.add(node);
    }

    private void addDeviceSchedulerNode(ASMDiskData deviceScheduler, String node, Hashtable<ASMDiskData, List<String>> deviceNodes) {
        List<Object> nodes = null;
        if (deviceNodes.containsKey(deviceScheduler)) {
            nodes = deviceNodes.get(deviceScheduler);
        } else {
            nodes = new ArrayList();
            deviceNodes.put(deviceScheduler, nodes);
        }
        nodes.add(node);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11970", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11971", false);
    }
}

