/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskNTP;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ResourceState;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCTSSIntegrity
extends Task {
    Hashtable<String, Vector<Object>> ctssResultNodeTable = new Hashtable();
    boolean m_noctss = false;
    boolean m_isDBChecksEnabled = false;
    String CTSS_OBSERVER_STATUS_TXT = "CRS-4700:";
    String CTSS_ACTIVE_STATUS_TXT = "CRS-4701:";
    String CTSS_OFFSET_MSG_TXT = "CRS-4702:";
    String CTSS_OFFLINE_STATUS_TXT = "CRS-4703:";
    private final String CTSS_CHECK_COMMAND = "crsctl check ctss";
    private final String CTSS_RES_QUERY_COMMAND = "crsctl stat resource ora.ctssd -init";
    private TaskNTP taskNTP = null;

    public TaskCTSSIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        if (vType != null) {
            switch (vType) {
                case PREREQ_DB_INST: {
                    this.setEnableDBChecks();
                }
            }
        }
    }

    public TaskCTSSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskCTSSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskCTSSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        if (this.taskNTP == null) {
            this.taskNTP = new TaskNTP(this.m_nodeList);
        }
        this.performCTSSIntegrityChecks();
        this.m_resultSet.setStatus();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9651", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("9652", true));
        return false;
    }

    boolean performCTSSIntegrityChecks() {
        ErrorDescription errorDesc;
        String errMsg;
        try {
            ParamManager pm = ParamManager.getInstance();
            this.m_noctss = pm.checkArgNoCtss();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        if (this.m_noctss && !VerificationUtil.isOPC() && !VerificationUtil.isODALiteEnv()) {
            return this.doRunNTPChecks(this.m_nodeList);
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("9675", false));
        String[] validNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet, true);
        if (validNodeArr == null) {
            String errMsg2 = s_gMsgBundle.getMessage("1450", true, (Object[])new String[]{VerificationUtil.strArr2List(this.m_nodeList)});
            ReportUtil.printError(errMsg2);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg2);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        if (validNodeArr.length == this.m_nodeList.length) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("1451", false));
            ReportUtil.blankln();
        } else {
            String[] failNodeArr = this.m_resultSet.getFailureNodes();
            errMsg = s_gMsgBundle.getMessage("1450", true, (Object[])new String[]{VerificationUtil.strArr2List(failNodeArr)});
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(failNodeArr, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(failNodeArr, errDesc);
        }
        if (!this.m_noctss) {
            String activeCRSVer = VerificationUtil.getCRSActiveVersion();
            if (activeCRSVer == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)"Failed to retrieve active version for CRS");
                }
                errMsg = s_msgBundle.getMessage("5300", true);
                ReportUtil.printError(errMsg);
                errorDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(validNodeArr, errorDesc);
                this.m_resultSet.addResult(validNodeArr, 2);
                return false;
            }
            if (VerificationUtil.isVersionPre(activeCRSVer, "11.2")) {
                String informationalMessage = s_msgBundle.getMessage("9692", false);
                this.taskNTP.addTaskInformationalDetails(ReportUtil.addSpaces(this.getChildTaskLevel()) + informationalMessage);
                ReportUtil.sureprintln(informationalMessage);
                ReportUtil.sureblankln();
                this.m_noctss = true;
            }
        }
        if (this.m_noctss && !VerificationUtil.isOPC() && !VerificationUtil.isODALiteEnv()) {
            return this.doRunNTPChecks(this.m_nodeList);
        }
        String crshome = VerificationUtil.getCRSHome();
        if (crshome == null) {
            errMsg = s_msgBundle.getMessage("5301", true);
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
            ReportUtil.printError(errMsg);
            return false;
        }
        Vector<String> resokNodes = new Vector<String>();
        boolean allResOK = this.checkCTSSResources(validNodeArr, resokNodes, crshome);
        if (!allResOK || resokNodes.size() == 0) {
            return false;
        }
        validNodeArr = resokNodes.toArray(new String[resokNodes.size()]);
        boolean ret = false;
        VerificationCommand[] ctssCmdArray = new VerificationCommand[validNodeArr.length];
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((int)5, (String)("Node List to run CTSS Check command " + Arrays.asList(validNodeArr)));
        }
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("9679", false));
        String stateCmd = this.getCTSSCheckCommand(crshome);
        for (int j = 0; j < validNodeArr.length; ++j) {
            String[] arg = new String[]{"-rungencmd", stateCmd};
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("CTSS command args: " + Arrays.asList(arg)));
            }
            String[] env = null;
            ctssCmdArray[j] = new VerificationCommand(validNodeArr[j], arg, env);
        }
        ResultSet locrs = new ResultSet();
        new GlobalHandler().submit((Command[])ctssCmdArray, 0, locrs);
        this.m_resultSet.addResultSetData(locrs);
        if (!locrs.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Global failure executing ctss command " + stateCmd));
            }
            ArrayList<String> ctssCmdErrors = new ArrayList<String>();
            String message = s_msgBundle.getMessage("9653", true, (Object[])new String[]{stateCmd});
            ctssCmdErrors.add(message);
            for (int i = 0; i < validNodeArr.length; ++i) {
                String cmdOut = ctssCmdArray[i].getResult().getExectaskOutput();
                if (!VerificationUtil.isStringGood(cmdOut)) continue;
                String nodeDetails = VerificationUtil.fetchExecutionDetailsMessage(validNodeArr[i], cmdOut);
                message = message + LSEP + nodeDetails;
                ctssCmdErrors.add(nodeDetails);
            }
            ErrorDescription errorDesc2 = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(validNodeArr, errorDesc2);
            ReportUtil.reportErrors(ctssCmdErrors);
            return false;
        }
        Vector<String> failNodes = new Vector<String>();
        ArrayList<String> runCommandErrors = new ArrayList<String>();
        for (int nodeIndex = 0; nodeIndex < validNodeArr.length; ++nodeIndex) {
            VerificationCommand ctssCmd = ctssCmdArray[nodeIndex];
            Result result = ctssCmd.getResult();
            String node = ctssCmd.getNode();
            if (result.getStatus() == 1) {
                String output = ctssCmd.getOutput();
                if (output == null) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Error retreiving output of crsctl check ctss command on node " + node));
                    }
                    String errMsg3 = s_msgBundle.getMessage("9654", true, (Object[])new String[]{stateCmd, node});
                    runCommandErrors.add(errMsg3);
                    ErrorDescription errorDesc3 = new ErrorDescription(errMsg3);
                    result.addErrorDescription(errorDesc3);
                    this.m_resultSet.addErrorDescription(node, errorDesc3);
                    this.m_resultSet.addResult(node, 2);
                    failNodes.add(node);
                    continue;
                }
                Vector<Object> valVec = new Vector<Object>();
                valVec.add(result);
                boolean ok = this.parseCTSSOutput(output, valVec);
                Trace.out((String)("value vector size " + valVec.size()));
                if (!ok) {
                    Trace.out((String)("Error parsing output of crsctl check ctss command:" + LSEP + "Output=" + output));
                    result.setStatus(3);
                    String errMsg4 = s_gMsgBundle.getMessage("1455", true, (Object[])new String[]{stateCmd, node}) + LSEP + output;
                    ErrorDescription errorDesc4 = new ErrorDescription(errMsg4);
                    result.addErrorDescription(errorDesc4);
                    this.m_resultSet.addErrorDescription(node, errorDesc4);
                    this.m_resultSet.addResult(node, 3);
                    runCommandErrors.add(errMsg4);
                    failNodes.add(node);
                    continue;
                }
                this.ctssResultNodeTable.put(node, valVec);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Error executing ctss check command on node " + node));
            }
            String errMsg5 = s_msgBundle.getMessage("9656", true, (Object[])new String[]{node, result.getErrMessage()});
            runCommandErrors.add(errMsg5);
            ErrorDescription errorDesc5 = new ErrorDescription(errMsg5);
            result.addErrorDescription(errorDesc5);
            this.m_resultSet.addResult(node, result.getStatus());
            this.m_resultSet.addErrorDescription(node, errorDesc5);
            failNodes.add(node);
        }
        ReportUtil.reportErrors(runCommandErrors);
        if (this.ctssResultNodeTable.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Error executing ctss check command on all nodes ");
            }
            String errMsg6 = s_gMsgBundle.getMessage("1456", false);
            ReportUtil.printError(errMsg6);
            return false;
        }
        if (failNodes.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"CTSS query execution passed on all nodes tested.");
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("9684", false));
            ReportUtil.sureblankln();
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"CTSS query execution failed on some nodes.");
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("9680", false, (Object[])new String[]{VerificationUtil.strList2List(failNodes)}));
            ReportUtil.sureblankln();
        }
        boolean active = false;
        boolean observer = false;
        Vector<String> activeNodes = new Vector<String>();
        Vector<String> observNodes = new Vector<String>();
        ReportUtil.println(s_msgBundle.getMessage("9681", false));
        ReportUtil.println(s_msgBundle.getMessage("9698", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9688", false));
        Enumeration<String> e = this.ctssResultNodeTable.keys();
        while (e.hasMoreElements()) {
            String node = e.nextElement();
            Object[] objArr = this.ctssResultNodeTable.get(node).toArray();
            if (((Boolean)objArr[1]).booleanValue()) {
                ReportUtil.writeRecord(node, s_msgBundle.getMessage("9689", false));
                activeNodes.add(node);
                active = true;
                continue;
            }
            ReportUtil.writeRecord(node, s_msgBundle.getMessage("9690", false));
            observNodes.add(node);
            observer = true;
        }
        if (active && observer) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Inconsistent CTSS status reported, with nodes " + activeNodes + " in Active state, and nodes " + observNodes + " in Observer state. All nodes should be in the same state."));
            }
            ErrorDescription errorDesc6 = new ErrorDescription(s_msgBundle.getMessage("9664", true, (Object[])new String[]{activeNodes.toString(), observNodes.toString()}));
            ReportUtil.printResult(s_msgBundle.getMessage("9664", true, (Object[])new String[]{activeNodes.toString(), observNodes.toString()}));
            ReportUtil.sureblankln();
            this.m_resultSet.addResult(validNodeArr, 3);
            this.m_resultSet.addErrorDescription(errorDesc6);
            ReportUtil.printError(errorDesc6.getErrorMessage());
            return false;
        }
        if (observer) {
            String informationalMessage = null;
            if (!VerificationUtil.isOPC() && !VerificationUtil.isODALiteEnv()) {
                informationalMessage = s_msgBundle.getMessage("9666", false);
                this.taskNTP.addTaskInformationalDetails(ReportUtil.addSpaces(this.getChildTaskLevel()) + informationalMessage);
                ReportUtil.sureprintln(informationalMessage);
                ReportUtil.sureblankln();
                String[] nodeArr = observNodes.toArray(new String[observNodes.size()]);
                ret = this.doRunNTPChecks(nodeArr);
            } else {
                informationalMessage = s_gMsgBundle.getMessage("1049", false);
                ReportUtil.sureprintln(informationalMessage);
                if (ReportUtil.isVerbose()) {
                    this.taskNTP.addTaskInformationalDetails(ReportUtil.addSpaces(this.getChildTaskLevel()) + informationalMessage);
                }
                ret = true;
            }
        }
        if (active) {
            ret = this.checkActiveNodeResults(this.ctssResultNodeTable);
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("performCTSSIntegrityChecks(): Returning with value: " + ret));
        }
        return ret;
    }

    private boolean doRunNTPChecks(String[] nodeArr) {
        this.taskNTP.setNodeList(nodeArr);
        this.addChildTask(this.taskNTP);
        if (this.m_isDBChecksEnabled) {
            this.taskNTP.setEnableDBChecks();
        }
        this.taskNTP.perform();
        this.m_resultSet.uploadResultSet(this.taskNTP.getResultSet());
        return this.m_resultSet.getStatus() == 1 || this.m_resultSet.getStatus() == 4;
    }

    private boolean checkActiveNodeResults(Hashtable<String, Vector<Object>> ctssResultNodeTable) {
        ReportUtil.sureprintln(s_msgBundle.getMessage("9682", false));
        float offsetLimit = VerificationUtil.getCTSSOffsetLimit();
        boolean ret = false;
        Vector<String> offsetOKNodes = new Vector<String>();
        Vector<String> offsetBadNodes = new Vector<String>();
        Vector<String> offsetBadValues = new Vector<String>();
        Enumeration<String> e = ctssResultNodeTable.keys();
        boolean nodesOK = false;
        String refNode = null;
        boolean hdrPrinted = false;
        while (e.hasMoreElements()) {
            String node = e.nextElement();
            Object[] objArr = ctssResultNodeTable.get(node).toArray();
            if (!((Boolean)objArr[1]).booleanValue() || objArr[2] == null) continue;
            float curOffset = ((Float)objArr[2]).floatValue();
            if (!hdrPrinted) {
                ReportUtil.println(s_msgBundle.getMessage("9687", false, (Object[])new String[]{new Float(offsetLimit).toString()}));
                ReportUtil.println(s_msgBundle.getMessage("9699", false));
                ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("9685", false), s_msgBundle.getMessage("8018", false));
                hdrPrinted = true;
            }
            if (Math.abs(curOffset) < offsetLimit) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Offset " + curOffset + " is within limits of threshold " + offsetLimit + " on node " + node));
                }
                ReportUtil.writeRecord(node, Float.toString(curOffset), ReportUtil.PASSED);
                nodesOK = true;
                offsetOKNodes.add(node);
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Offset " + curOffset + " is NOT within limits of threshold " + offsetLimit + " on node " + node));
            }
            ReportUtil.writeRecord(node, Float.toString(curOffset), ReportUtil.FAILED);
            this.m_resultSet.addResult(node, 3);
            nodesOK = false;
            offsetBadNodes.add(node);
            offsetBadValues.add(String.valueOf(curOffset));
        }
        if (offsetBadNodes.size() == 0) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Time Offset from reference node " + refNode + " is within limits on the following nodes where CTSS was queried."));
            }
            ReportUtil.blankln();
            ReportUtil.println(s_msgBundle.getMessage("9660", false, (Object[])new String[]{offsetOKNodes.toString()}));
            ReportUtil.printResult(s_msgBundle.getMessage("9683", false));
            ReportUtil.sureblankln();
            ret = true;
        } else {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Time Offset from reference node " + refNode + " is not within limits on the following nodes where CTSS was queried."));
            }
            String strOffsetLimit = String.valueOf(offsetLimit);
            ArrayList<String> offsetErrors = new ArrayList<String>();
            for (int i = 0; i < offsetBadNodes.size(); ++i) {
                String badNode = (String)offsetBadNodes.get(i);
                String badValue = (String)offsetBadValues.get(i);
                String errMsg = s_msgBundle.getMessage("9661", true, (Object[])new String[]{badNode, badValue, strOffsetLimit});
                offsetErrors.add(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(badNode, errDesc);
            }
            ReportUtil.reportErrors(offsetErrors);
            this.m_resultSet.addResult(offsetBadNodes, 3);
            ret = false;
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("checkActiveNodeResults(): Returning with value: " + ret));
        }
        return ret;
    }

    boolean parseCTSSOutput(String output, Vector<Object> valVec) {
        String[] outArr = output.split(LSEP);
        boolean ret = false;
        if (Trace.isLevelEnabled((int)5)) {
            for (int i = 0; i < outArr.length; ++i) {
                Trace.out((String)("Output Split Line " + i + "=" + outArr[i]));
            }
        }
        if (outArr[0].contains(this.CTSS_OBSERVER_STATUS_TXT)) {
            Trace.out((String)"Observer state");
            valVec.add(new Boolean(false));
            ret = true;
        } else if (outArr[0].contains(this.CTSS_ACTIVE_STATUS_TXT)) {
            boolean err = false;
            Trace.out((String)"Active state");
            valVec.add(new Boolean(true));
            String[] offArr = outArr[1].split(":");
            if (offArr.length > 1 && outArr[1].contains(this.CTSS_OFFSET_MSG_TXT)) {
                try {
                    valVec.add(new Float(offArr[2]));
                    Trace.out((String)("Added Float to vector: " + offArr[2]));
                }
                catch (NumberFormatException e) {
                    Trace.out((String)("Number not correct" + outArr[1]));
                    valVec.clear();
                    ret = false;
                    err = true;
                }
            }
            if (!err) {
                if (valVec.size() != 3) {
                    valVec.clear();
                    ret = false;
                } else {
                    ret = true;
                }
            }
        } else if (outArr[0].startsWith(this.CTSS_OFFLINE_STATUS_TXT)) {
            Trace.out((String)"ctss service offline");
            ret = false;
        } else {
            Trace.out((String)"invalid output");
            ret = false;
        }
        return ret;
    }

    private boolean checkCTSSResources(String[] validNodeArr, Vector<String> resokNodes, String crshome) {
        int resOksz;
        ErrorDescription errorDesc;
        ReportUtil.println(s_msgBundle.getMessage("9677", false));
        String resstatCmd = this.getCTSSResStatCommand(crshome);
        VerificationCommand[] ctssCmdArray = new VerificationCommand[validNodeArr.length];
        for (int j = 0; j < validNodeArr.length; ++j) {
            String[] arg = new String[]{"-rungencmd", resstatCmd};
            String[] env = null;
            ctssCmdArray[j] = new VerificationCommand(validNodeArr[j], arg, env);
        }
        ResultSet locrs = new ResultSet();
        new GlobalHandler().submit((Command[])ctssCmdArray, 0, locrs);
        this.m_resultSet.addResultSetData(locrs);
        ArrayList<String> ctssResCmdErrors = new ArrayList<String>();
        if (!locrs.anySuccess()) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Global failure checking CTSS resource status with command " + resstatCmd));
            }
            String message = s_msgBundle.getMessage("9668", true, (Object[])new String[]{resstatCmd});
            ctssResCmdErrors.add(message);
            ErrorDescription errorDesc2 = new ErrorDescription(message);
            this.m_resultSet.addErrorDescription(errorDesc2);
            for (int j = 0; j < validNodeArr.length; ++j) {
                String exectaskOutput = ctssCmdArray[j].getExectaskOutput();
                if (!VerificationUtil.isStringGood(exectaskOutput)) continue;
                String nodeError = VerificationUtil.fetchExecutionDetailsMessage(validNodeArr[j], exectaskOutput);
                ctssResCmdErrors.add(nodeError);
            }
            ReportUtil.reportErrors(ctssResCmdErrors);
            return false;
        }
        Vector<String> failNodes = new Vector<String>();
        ReportUtil.println(s_msgBundle.getMessage("9697", false));
        ReportUtil.writeColHeaders(s_msgBundle.getMessage("8000", false), s_msgBundle.getMessage("8018", false));
        Vector<String> noOutputNodeVect = new Vector<String>();
        Vector<String> offlineNodeVect = new Vector<String>();
        StringBuilder cmdFailedOutput = new StringBuilder();
        boolean addWithLsep = false;
        for (int nodeIndex = 0; nodeIndex < validNodeArr.length; ++nodeIndex) {
            VerificationCommand ctssCmd = ctssCmdArray[nodeIndex];
            Result result = ctssCmd.getResult();
            String node = ctssCmd.getNode();
            if (result.getStatus() == 1) {
                String output = ctssCmd.getOutput();
                if (output == null) {
                    if (Trace.isLevelEnabled((int)5)) {
                        Trace.out((String)("Error retreiving output of crsctl check ctss command on node " + node));
                    }
                    noOutputNodeVect.add(node);
                    ReportUtil.writeRecord(node, ReportUtil.FAILED);
                    continue;
                }
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("Parsing command output: " + output));
                }
                ResourceState resst = ResourceState.checkState(output);
                switch (resst) {
                    case ONLINE: 
                    case INTERMEDIATE: {
                        resokNodes.add(node);
                        this.m_resultSet.addResult(node, 1);
                        ReportUtil.writeRecord(node, ReportUtil.PASSED);
                        break;
                    }
                    case OFFLINE: {
                        offlineNodeVect.add(node);
                        ReportUtil.writeRecord(node, ReportUtil.FAILED);
                        Trace.out((String)("ctss is in offline or unknown mode on node " + node + " output= " + output));
                        break;
                    }
                    default: {
                        failNodes.add(node);
                        ReportUtil.writeRecord(node, ReportUtil.FAILED);
                        Trace.out((String)"resource is in undefined state");
                        if (!addWithLsep) {
                            cmdFailedOutput.append(output);
                            addWithLsep = true;
                            break;
                        }
                        cmdFailedOutput.append(LSEP + output);
                    }
                }
                continue;
            }
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)("Error executing ctss resource check on node " + node));
            }
            String errMsg = s_gMsgBundle.getMessage("1454", true, (Object[])new String[]{resstatCmd, node});
            ctssResCmdErrors.add(errMsg);
            String execTaskOutput = ctssCmd.getExectaskOutput();
            if (VerificationUtil.isStringGood(execTaskOutput)) {
                String nodeError = VerificationUtil.fetchExecutionDetailsMessage(node, execTaskOutput);
                errMsg = errMsg + LSEP + nodeError;
                ctssResCmdErrors.add(nodeError);
            }
            if (!addWithLsep) {
                cmdFailedOutput.append(errMsg);
                addWithLsep = true;
            } else {
                cmdFailedOutput.append(LSEP + errMsg);
            }
            ErrorDescription errorDesc3 = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errorDesc3);
            this.m_resultSet.addResult(node, 2);
            ReportUtil.writeRecord(node, ReportUtil.FAILED);
            failNodes.add(node);
        }
        if (noOutputNodeVect.size() != 0) {
            String errMsg = s_gMsgBundle.getMessage("1452", true, (Object[])new String[]{resstatCmd, VerificationUtil.strList2List(noOutputNodeVect)});
            ctssResCmdErrors.add(errMsg);
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(noOutputNodeVect, errorDesc);
            this.m_resultSet.addResult(noOutputNodeVect, 2);
        }
        if (offlineNodeVect.size() != 0) {
            String errMsg = s_gMsgBundle.getMessage("1453", true, (Object[])new String[]{VerificationUtil.strList2List(offlineNodeVect)});
            ctssResCmdErrors.add(errMsg);
            errorDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(offlineNodeVect, 3);
            this.m_resultSet.addErrorDescription(offlineNodeVect, errorDesc);
        }
        if (failNodes.size() != 0 || ctssResCmdErrors.size() > 0) {
            ReportUtil.reportErrors(ctssResCmdErrors);
        }
        if ((resOksz = resokNodes.size()) != 0) {
            if (resOksz == this.m_nodeList.length) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9674", false));
            } else {
                ReportUtil.sureprintln(s_msgBundle.getMessage("9673", false, (Object[])new String[]{VerificationUtil.strList2List(resokNodes)}));
            }
        }
        return true;
    }

    private String getCTSSCheckCommand(String crshome) {
        return crshome + FSEP + "bin" + FSEP + "crsctl check ctss";
    }

    private String getCTSSResStatCommand(String crshome) {
        return crshome + FSEP + "bin" + FSEP + "crsctl stat resource ora.ctssd -init";
    }

    public void setEnableDBChecks() {
        this.m_isDBChecksEnabled = true;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("9662", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("9663", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }
}

