/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskCRSVersionConsistency
extends Task {
    private boolean m_consistencyMandatory;
    private boolean m_nonRollingUpgrade;
    private VerificationType m_verificationType;

    public TaskCRSVersionConsistency(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        this.m_consistencyMandatory = this.m_globalContext.isUpgrade();
        this.m_nonRollingUpgrade = !this.m_globalContext.isRolling();
        this.m_verificationType = this.m_globalContext.getVerificationType();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_globalContext.isUpgrade();
    }

    public TaskCRSVersionConsistency(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskCRSVersionConsistency(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskCRSVersionConsistency(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    public boolean performTask() {
        this.performVersionConsistency();
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("10602", false));
            return true;
        }
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("10603", true));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    private void performVersionConsistency() {
        String errMsg;
        String errMsg2;
        String ver;
        boolean first;
        String releaseVersionNodeString;
        String[] validNodeArr;
        String[] crsNodeArr;
        String releaseVer = null;
        ArrayList<String> failNodeVer = new ArrayList<String>();
        ArrayList<String> sucNodeVer = new ArrayList<String>();
        ArrayList<String> upgNodeVer = new ArrayList<String>();
        ArrayList<String> curNodeVer = new ArrayList<String>();
        String newReleaseVer = null;
        ErrorDescription errDesc = null;
        Hashtable<String, ArrayList<String>> releaseVersionHT = new Hashtable<String, ArrayList<String>>();
        if (this.m_nonRollingUpgrade) {
            String[] nodeList = new String[]{m_localNode};
            crsNodeArr = VerificationUtil.getNodesWithCRSInstall(nodeList, this.m_resultSet);
            validNodeArr = this.m_nodeList;
        } else {
            validNodeArr = crsNodeArr = VerificationUtil.getNodesWithCRSInstall(this.m_nodeList, this.m_resultSet);
        }
        if (crsNodeArr == null) {
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return;
        }
        ReportUtil.sureblankln();
        String activeCRSVer = VerificationUtil.getCRSActiveVersion();
        if (activeCRSVer == null && !this.m_nonRollingUpgrade) {
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)"Failed to retrieve active version for CRS");
            }
            errDesc = new ErrorDescription("5300", s_msgBundle);
            ReportUtil.printError(errDesc.getErrorMessage());
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(validNodeArr, 2);
            return;
        }
        Trace.out((String)("\nCRSActiveVersion: " + activeCRSVer));
        String crsHome = VerificationUtil.getCRSHome();
        Trace.out((String)("CRS HOME : " + crsHome));
        for (String node : validNodeArr) {
            releaseVer = VerificationUtil.getCRSReleaseVersion(crsHome, node);
            if (releaseVer == null) {
                if (Trace.isLevelEnabled((int)5)) {
                    Trace.out((String)("\nReleaseVersion on node: " + node + " is NULL"));
                }
                if (VerificationType.PREREQ_DB_CONFIG.equals((Object)this.m_verificationType) || VerificationType.PREREQ_DB_INST.equals((Object)this.m_verificationType)) {
                    Trace.out((int)5, (String)"Ignoring failure in retrieving release version from node %s during db install", (Object[])new Object[]{node});
                    continue;
                }
                failNodeVer.add(node);
                errDesc = new ErrorDescription("5316", new String[]{node}, s_msgBundle);
                this.m_resultSet.addErrorDescription(errDesc);
                this.m_resultSet.addResult(node, 3);
                continue;
            }
            if (activeCRSVer != null) {
                if (releaseVer.equals(activeCRSVer)) {
                    curNodeVer.add(node);
                } else {
                    newReleaseVer = releaseVer;
                    upgNodeVer.add(node);
                }
            }
            sucNodeVer.add(node);
            ArrayList<String> nodeList = (ArrayList<String>)releaseVersionHT.get(releaseVer);
            if (nodeList == null) {
                nodeList = new ArrayList<String>();
                releaseVersionHT.put(releaseVer, nodeList);
            }
            nodeList.add(node);
        }
        if (failNodeVer.size() > 0) {
            ReportUtil.printError(s_gMsgBundle.getMessage("10604", false));
            ReportUtil.sureprintNodelist(failNodeVer);
            ReportUtil.sureblankln();
        }
        if (sucNodeVer.size() == 0) {
            ReportUtil.printError(s_msgBundle.getMessage("0007", false));
            return;
        }
        if (releaseVersionHT.size() == 1) {
            String releaseVersion = (String)releaseVersionHT.keys().nextElement();
            if (activeCRSVer == null) {
                Trace.out((int)5, (String)"Release version found to be consistent across the nodes.", (Object[])new Object[]{activeCRSVer});
                this.m_resultSet.addResult(sucNodeVer, 1);
                return;
            }
            if (releaseVersion.equals(activeCRSVer)) {
                Trace.out((int)5, (String)"Active version [%s] found to be consistent with the release version.", (Object[])new Object[]{activeCRSVer});
                this.m_resultSet.addResult(sucNodeVer, 1);
                return;
            }
            Trace.out((int)5, (String)"Release version [%s] found to be consistent across nodes but does not match active version [%s].", (Object[])new Object[]{releaseVersion, activeCRSVer});
            this.m_resultSet.addResult(sucNodeVer, 3);
            errDesc = new ErrorDescription("10605", new String[]{releaseVersion, activeCRSVer}, s_gMsgBundle);
            this.m_resultSet.addErrorDescription(sucNodeVer, errDesc);
            ReportUtil.printError(errDesc.getErrorMessage());
        } else if (this.m_nonRollingUpgrade) {
            releaseVersionNodeString = "";
            Enumeration softVersEnum = releaseVersionHT.keys();
            first = true;
            while (softVersEnum.hasMoreElements()) {
                if (first) {
                    first = false;
                } else {
                    releaseVersionNodeString = releaseVersionNodeString + ";";
                }
                ver = (String)softVersEnum.nextElement();
                releaseVersionNodeString = releaseVersionNodeString + ver + "=[" + VerificationUtil.strCollection2String((Collection)releaseVersionHT.get(ver), ",") + "]";
            }
            this.m_resultSet.addResult(sucNodeVer, 3);
            errMsg2 = s_gMsgBundle.getMessage("10606", true, (Object[])new String[]{releaseVersionNodeString});
            errDesc = new ErrorDescription(errMsg2);
            this.m_resultSet.addErrorDescription(sucNodeVer, errDesc);
            ReportUtil.printError(errMsg2);
        } else if (this.m_consistencyMandatory) {
            releaseVersionNodeString = "";
            Enumeration softVersEnum = releaseVersionHT.keys();
            first = true;
            while (softVersEnum.hasMoreElements()) {
                if (first) {
                    first = false;
                } else {
                    releaseVersionNodeString = releaseVersionNodeString + ";";
                }
                ver = (String)softVersEnum.nextElement();
                releaseVersionNodeString = releaseVersionNodeString + ver + "=[" + VerificationUtil.strCollection2String((Collection)releaseVersionHT.get(ver), ",") + "]";
            }
            this.m_resultSet.addResult(sucNodeVer, 3);
            errMsg2 = s_gMsgBundle.getMessage("10606", true, (Object[])new String[]{releaseVersionNodeString});
            errDesc = new ErrorDescription(errMsg2);
            this.m_resultSet.addErrorDescription(sucNodeVer, errDesc);
            ReportUtil.printError(errMsg2);
        } else if (this.isASMRunning()) {
            if (this.isRollingMigration()) {
                Trace.out((String)"According to ASM, the clusterware is in the middle of an upgrade . The release version inconsistency is acceptable.");
                this.m_resultSet.addResult(sucNodeVer, 1);
                errMsg = s_msgBundle.getMessage("5317", false, (Object[])new String[]{newReleaseVer, activeCRSVer, VerificationUtil.strCollection2String(curNodeVer)});
                ReportUtil.println(errMsg);
            } else {
                Trace.out((String)"The clusterware is not in middle of an upgrade according to ASM but the software versions are inconsistent. This is an error.");
                this.m_resultSet.addResult(sucNodeVer, 3);
                String msg = "Clusterware is not in the middle of an upgrade, but the software versions are incosistent across nodes.";
                String errMsg3 = s_msgBundle.getMessage("5317", true, (Object[])new String[]{newReleaseVer, activeCRSVer, VerificationUtil.strCollection2String(curNodeVer)});
                this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg3));
                ReportUtil.printError(errMsg3);
            }
        } else {
            Trace.out((String)"ASM is not running, clusterware upgrade status cannot be determined. Issue a warning in this case");
            this.m_resultSet.addResult(sucNodeVer, 4);
            errMsg = s_msgBundle.getMessage("5317", false, (Object[])new String[]{newReleaseVer, activeCRSVer, VerificationUtil.strCollection2String(curNodeVer)});
            this.m_resultSet.addErrorDescription(new ErrorDescription(errMsg));
            ReportUtil.printWarning(errMsg);
        }
    }

    private boolean isASMRunning() {
        boolean asmRunning = false;
        try {
            KFODUtil kfodUtil = new KFODUtil(VerificationUtil.getCRSHome());
            asmRunning = kfodUtil.isASMRunning(m_localNode);
        }
        catch (CmdToolUtilException e) {
            Trace.out((Exception)((Object)e));
        }
        return asmRunning;
    }

    private boolean isRollingMigration() {
        boolean rollingMigration = false;
        try {
            KFODUtil kfodUtil = new KFODUtil(VerificationUtil.getCRSHome());
            rollingMigration = kfodUtil.isRollingMigration();
        }
        catch (CmdToolUtilException e) {
            Trace.out((Exception)((Object)e));
        }
        return rollingMigration;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("10600", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("10601", false);
    }

    public void setConsistenyMandatory(boolean consistencyMandatory) {
        this.m_consistencyMandatory = consistencyMandatory;
    }

    public void setNonRollingUpgrade(boolean nonRollingUpgrade) {
        this.m_nonRollingUpgrade = nonRollingUpgrade;
    }

    public void setVerificationType(VerificationType verType) {
        this.m_verificationType = verType;
    }
}

