/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.PeerCompatibleTask;
import oracle.ops.verification.framework.engine.task.TaskPeerCompatibility;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAvailableMemory
extends TaskPeerCompatibility
implements PeerCompatibleTask {
    private StorageSize m_reqMemSize;
    private StorageSize m_reqRimMemSize;
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1063", false);

    public TaskAvailableMemory(long size, StorageUnit unit) {
        this.m_reqMemSize = new StorageSize((double)size, unit);
    }

    public TaskAvailableMemory(StorageSize size) {
        this.m_reqMemSize = size;
    }

    @Override
    public boolean performTask() {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet memRsltSet = new ResultSet();
        globalExec.checkAvailMemory(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), memRsltSet);
        this.m_resultSet.addResultSetData(memRsltSet);
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        NodeManager nm = null;
        boolean bigCluster = false;
        List<Object> rimNodeList = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager();
            bigCluster = nm.isBigCluster();
            if (bigCluster) {
                rimNodeList = Arrays.asList(nm.getNodes(NodeRoleCapability.RIM));
            }
        }
        catch (NodeManagerFactoryException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        catch (NoSuchNodesException e) {
            rimNodeList = new ArrayList();
        }
        catch (NodeManagerException e) {
            Trace.out((String)("NodeManagerFactoryException :" + e.getMessage()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(e.getMessage()));
            ReportUtil.printError(e.getMessage());
            return false;
        }
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.STATUS);
        Hashtable t = memRsltSet.getResultTable();
        String nstatus = ReportUtil.UNKNOWN;
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            ErrorDescription errDesc;
            String avl;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            StorageSize requiredStorageSize = this.m_reqMemSize;
            if (this.m_reqRimMemSize != null && bigCluster && rimNodeList.contains(node)) {
                requiredStorageSize = this.m_reqRimMemSize;
            }
            CollectionElement collectionElement = new CollectionElement(this.getElementName(), null, requiredStorageSize, null, this.getDefaultDescription(), 5);
            this.m_resultSet.addCollectionElement(node, collectionElement);
            if (result.getStatus() == 1) {
                StorageSize avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                this.m_resultSet.getResult(node).setStatus(1);
                this.m_resultSet.getResult(node).setHasResultValues(true);
                this.m_resultSet.getResult(node).setExpectedValue(ReportUtil.unitizeSize(requiredStorageSize));
                this.m_resultSet.getResult(node).setActualValue(ReportUtil.unitizeSize(avlSS));
                collectionElement.setValue(ReportUtil.unitizeSize(avlSS, 1));
                if (avlSS.compareTo(requiredStorageSize) >= 0) {
                    nstatus = ReportUtil.PASSED;
                    collectionElement.setStatus(1);
                } else {
                    errDesc = new ErrorDescription(s_msgBundle.getMessage("7562", true, (Object[])new String[]{node, this.m_reqMemSize.toString()}), s_msgBundle, "7562");
                    this.m_resultSet.addResult(node, 3);
                    this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                    collectionElement.setStatus(3);
                    collectionElement.addErrorDescription(errDesc);
                    nstatus = ReportUtil.FAILED;
                }
            } else {
                avl = ReportUtil.UNKNOWN;
                errDesc = new ErrorDescription(s_msgBundle.getMessage("7563", true, (Object[])new String[]{node}), s_msgBundle, "7563");
                this.m_resultSet.getResult(node).addErrorDescription(errDesc);
                collectionElement.setStatus(2);
                collectionElement.addErrorDescription(errDesc);
                collectionElement.setValue(avl);
                nstatus = ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(requiredStorageSize), nstatus);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
            this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0302", false, (Object[])new String[]{ReportUtil.unitizeSize(this.m_reqMemSize)}));
            return true;
        }
        ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        this.m_resultSet.setResultSummary(s_gMsgBundle.getMessage("0303", false, (Object[])new String[]{ReportUtil.unitizeSize(this.m_reqMemSize), VerificationUtil.strCollection2String(this.m_resultSet.getFailedNodes())}));
        ReportUtil.printErrorNodes(this.m_resultSet);
        return false;
    }

    @Override
    protected boolean matchesReferenceNode(Object nodeValue, Object referenceNodeValue) {
        StorageSize nodeSize = (StorageSize)nodeValue;
        StorageSize refNodeSize = (StorageSize)referenceNodeValue;
        if (nodeSize == refNodeSize) {
            return true;
        }
        if (nodeSize == null || refNodeSize == null) {
            return false;
        }
        return nodeSize.compareTo(refNodeSize) >= 0;
    }

    @Override
    public String getTaskID() {
        return "CHECK_AVAILABLE_MEMORY";
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4404", false);
    }

    @Override
    public String getDefaultDescription() {
        Object[] msgParams = new String[]{ReportUtil.unitizeSize(this.m_reqMemSize)};
        return s_msgBundle.getMessage("4454", false, msgParams);
    }

    @Override
    public ResultSet performPeer() throws VerificationException {
        GlobalExecution globalExec = new GlobalExecution();
        ResultSet archRsltSet = new ResultSet();
        globalExec.checkAvailMemory(this.m_nodeList, new StorageSize(0.0, StorageUnit.BYTE), archRsltSet);
        return archRsltSet;
    }

    @Override
    public String getElementDisplayName() {
        return s_msgBundle.getMessage("9971", false);
    }

    public void setRimValue(StorageSize storageSize) {
        this.m_reqRimMemSize = storageSize;
    }
}

