/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.DatabaseTask;
import oracle.ops.verification.framework.engine.task.DatabaseTaskException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageCheckContext;
import oracle.ops.verification.framework.storage.StorageData;
import oracle.ops.verification.framework.storage.StorageDataHandler;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAuditFileDestCheck
extends DatabaseTask {
    private static final String m_query = "select i.instance_name, i.host_name, p.value audit_file_dest from GV$INSTANCE i, GV$PARAMETER p where i.inst_id = p.inst_id and name = 'audit_file_dest'";

    public TaskAuditFileDestCheck(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        super.init();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        return this.m_isDBInfoInitialized;
    }

    public TaskAuditFileDestCheck(Version crsVer, Collection<DatabaseConnectInfo> dbConInfo) {
        super(crsVer, dbConInfo);
    }

    @Override
    public boolean performTask() {
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        VerificationUtil.traceAndLog("Performing shared AUDIT_FILE_DEST location check...");
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11122", false));
        for (String database : this.databases()) {
            String errMsg;
            String dbHome;
            ArrayList<String> pathList;
            ArrayList<String> nodeList;
            ArrayList<String> instList;
            block14: {
                instList = new ArrayList<String>();
                nodeList = new ArrayList<String>();
                pathList = new ArrayList<String>();
                dbHome = null;
                if (isUnix) {
                    try {
                        if (!VerificationUtil.isStringGood(database)) break block14;
                        DatabaseInfo dbInfo = this.m_dbUtils.getDatabaseInfo(database);
                        dbHome = dbInfo.getHome();
                        Trace.out((String)("got DB home " + dbHome + " for database " + database));
                    }
                    catch (DBUtilsException e) {
                        VerificationUtil.traceAndLog("db utils exception while trying to get rac home for database " + database + ". message :" + e.getMessage());
                        errMsg = s_gMsgBundle.getMessage("11126", true, (Object[])new String[]{database});
                        errMsg = errMsg + LSEP + e.getMessage();
                        this.m_resultSet.addErrorDescription(database, new ErrorDescription(errMsg));
                        this.m_resultSet.addResult(database, 2, ResultKeyType.DB);
                        ReportUtil.sureprintln(errMsg);
                        continue;
                    }
                }
            }
            try {
                OracleConnection conn = this.getConnection(database);
                Statement stmt = conn.createStatement();
                java.sql.ResultSet rs = stmt.executeQuery(m_query);
                while (rs.next()) {
                    instList.add(rs.getString(1));
                    nodeList.add(rs.getString(2));
                    pathList.add(rs.getString(3));
                }
                rs.close();
                stmt.close();
                if (isUnix && nodeList.size() > 0) {
                    String errMsg2;
                    Result rslt;
                    String currentUser = VerificationUtil.getDefaultOracleUser();
                    String node = (String)nodeList.get(0);
                    String dbHomeUser = VerificationUtil.getOracleUser(dbHome, node, rslt = new Result(database, ResultKeyType.DB_INSTANCE));
                    if (VerificationUtil.isStringGood(dbHomeUser)) {
                        dbHomeUser = dbHomeUser.trim();
                    }
                    if (rslt.getStatus() != 1 || dbHomeUser == null || dbHomeUser.length() == 0) {
                        this.m_resultSet.addResult(database, rslt);
                        errMsg2 = s_gMsgBundle.getMessage("1186", true, (Object[])new String[]{dbHome});
                        ReportUtil.sureprintln(errMsg2);
                        continue;
                    }
                    Trace.out((String)("racuser user for DB " + database + " is " + dbHomeUser + " and current user is " + currentUser));
                    if (!dbHomeUser.equals(currentUser)) {
                        if (!VerificationUtil.isCVUResource()) {
                            errMsg2 = s_gMsgBundle.getMessage("11127", true, (Object[])new String[]{database, dbHomeUser, dbHome, currentUser});
                            this.m_resultSet.addResult(database, 4, ResultKeyType.DB_INSTANCE);
                            ErrorDescription errDesc = new ErrorDescription(errMsg2);
                            this.m_resultSet.addErrorDescription(database, errDesc);
                            ReportUtil.sureprintln(errMsg2);
                            continue;
                        }
                        Trace.out((String)"no warning for different user in cvu resource");
                        this.m_resultSet.addResult(database, 1, ResultKeyType.DB_INSTANCE);
                        continue;
                    }
                }
                this.verifyAuditFileDest(database, instList, nodeList, pathList);
            }
            catch (DatabaseTaskException exDT) {
                VerificationUtil.traceAndLog("SQLException while verifying AUDIT_FILE_DEST for database " + database + ". message :" + exDT.getMessage());
                errMsg = s_gMsgBundle.getMessage("11125", true);
                errMsg = errMsg + LSEP + exDT.getMessage();
                this.m_resultSet.addErrorDescription(database, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(database, 2, ResultKeyType.DB_INSTANCE);
                ReportUtil.sureprintln(errMsg);
            }
            catch (SQLException exSql) {
                VerificationUtil.traceAndLog("SQLException while verifying AUDIT_FILE_DEST for database " + database + ". message :" + exSql.getMessage());
                errMsg = s_gMsgBundle.getMessage("11125", true);
                errMsg = errMsg + LSEP + exSql.getMessage();
                this.m_resultSet.addErrorDescription(database, new ErrorDescription(errMsg));
                this.m_resultSet.addResult(database, 2, ResultKeyType.DB_INSTANCE);
                ReportUtil.sureprintln(errMsg);
            }
        }
        int retVal = this.m_resultSet.getStatus();
        if (this.m_resultSet.getStatus() == 1) {
            VerificationUtil.traceAndLog("Check for shared AUDIT_FILE_DEST location passed.");
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("11124", false));
            return true;
        }
        return false;
    }

    private void verifyAuditFileDest(String dbName, List<String> instList, List<String> nodeList, List<String> pathList) {
        int i;
        if (instList.size() < 2) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return;
        }
        StorageCheckContext scCtx = new StorageCheckContext();
        scCtx.setUsageType(OracleFileType.RAC_SOFTWARE);
        StorageDataHandler sdHndlr = new StorageDataHandler(scCtx);
        ArrayList<StorageData> sdList = new ArrayList<StorageData>();
        ArrayList<String> nList = new ArrayList<String>();
        ArrayList<String> iList = new ArrayList<String>();
        ArrayList<String> pList = new ArrayList<String>();
        for (i = 0; i < instList.size(); ++i) {
            String inst = instList.get(i);
            String node = nodeList.get(i);
            String path = pathList.get(i);
            VerificationUtil.traceAndLog("Getting storage data for inst='%s' auditFileDest='%s' node='%s'", inst, path, node);
            StorageData stData = sdHndlr.getStorageData(path, node);
            StorageType stType = stData.getStorageTypeEnum();
            VerificationUtil.traceAndLog("StorageType='%s'", stType.name());
            if (stType == StorageType.UNKNOWN) {
                VerificationUtil.traceAndLog("Failed to get the storage type for Audit Destination '%' on node '%s'", path, node);
                this.m_resultSet.addResult(dbName, 2, ResultKeyType.DB_INSTANCE);
                String errMsg = s_gMsgBundle.getMessage("11125", true);
                this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
                for (VerificationError verificationError : stData.getErrors()) {
                    this.m_resultSet.addErrorDescription(dbName, (ErrorDescription)verificationError);
                }
                return;
            }
            if (stType != StorageType.ACFS) continue;
            sdList.add(stData);
            iList.add(inst);
            nList.add(node);
            pList.add(path);
        }
        if (iList.size() < 2) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return;
        }
        for (i = 0; i < iList.size(); ++i) {
            String errMsg;
            VerificationUtil.traceAndLog("Checking for sharedness of inst='%s'", iList.get(i));
            boolean bBadInst = false;
            String badInsts = (String)iList.get(i);
            String auditFileDest = (String)pList.get(i);
            for (int j = i + 1; j < iList.size(); ++j) {
                HashMap<String, StorageData> nodeSDmap = new HashMap<String, StorageData>();
                nodeSDmap.put((String)nList.get(i), (StorageData)sdList.get(i));
                nodeSDmap.put((String)nList.get(j), (StorageData)sdList.get(j));
                VerificationUtil.traceAndLog("Attempt to determine sharedness of '%s' between nodes '%s' and '%s'", auditFileDest, nList.get(i), nList.get(j));
                ResultSet locRS = new ResultSet();
                sdHndlr.checkSharedness(nodeSDmap, locRS);
                if (locRS.getStatus() != 2) {
                    VerificationUtil.traceAndLog("Sharedness check could not be performed");
                    this.m_resultSet.addResult(dbName, 2, ResultKeyType.DB_INSTANCE);
                    errMsg = s_gMsgBundle.getMessage("11125", true);
                    this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
                    for (VerificationError verificationError : locRS.getErrors()) {
                        this.m_resultSet.addErrorDescription(dbName, (ErrorDescription)verificationError);
                    }
                    return;
                }
                if (locRS.getStatus() == 1) continue;
                badInsts = badInsts + ',' + (String)iList.get(j);
                VerificationUtil.traceAndLog("'%s' is shared between instances '%s'", auditFileDest, badInsts);
                bBadInst = true;
            }
            if (!bBadInst) continue;
            VerificationUtil.traceAndLog("Report about the sharedness of audit file destination '%s' for database '%s' between instances '%s'", auditFileDest, dbName, badInsts);
            this.m_resultSet.addResult(dbName, 3, ResultKeyType.DB_INSTANCE);
            errMsg = s_gMsgBundle.getMessage("11123", true, (Object[])new String[]{auditFileDest, badInsts, dbName});
            this.m_resultSet.addErrorDescription(dbName, new ErrorDescription(errMsg));
            ReportUtil.sureprintln(errMsg);
        }
        this.m_resultSet.addResult(dbName, 1, ResultKeyType.DB_INSTANCE);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11121", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11120", false);
    }
}

