/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.SeverityType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAnonymousProxy
extends Task {
    Task m_parentTask = null;

    public TaskAnonymousProxy(String name) {
        this(name, null);
    }

    public TaskAnonymousProxy(String name, String[] nodeList) {
        this(name, nodeList, null);
    }

    public TaskAnonymousProxy(String name, String[] nodeList, Task pTask) {
        this(name, nodeList, pTask, null);
    }

    public TaskAnonymousProxy(String name, String[] nodeList, Task pTask, ResultSet resultSet) {
        String pTaskName = null;
        if (pTask != null) {
            this.m_parentTask = pTask;
            this.setSeverity(this.m_parentTask.getSeverity());
            pTaskName = pTask.getClass().getName();
            if (pTaskName.contains(".")) {
                pTaskName = pTaskName.substring(pTaskName.lastIndexOf(".") + 1);
            }
        } else {
            this.setSeverity(SeverityType.IGNORABLE);
        }
        Trace.out((String)("Defining proxy task with: '" + name + "'\nnodeList: '" + VerificationUtil.strArr2List(nodeList) + "' \nfrom task: '" + pTaskName + "'\nCalled from: '" + VerificationUtil.getLocationInSource(true) + "'"));
        this.m_elementName = name;
        this.m_nodeList = nodeList;
        if (pTask != null) {
            pTask.addChildTask(this);
        }
        if (resultSet != null) {
            this.m_resultSet.overwriteResultSet(resultSet);
        }
    }

    public boolean performAnonymousTask(ResultSet resultSet) {
        if (resultSet != null) {
            this.m_resultSet.overwriteResultSet(resultSet);
        }
        if (this.m_parentTask != null) {
            this.m_parentTask.getResultSet().uploadResultSet(resultSet);
        }
        return this.perform();
    }

    @Override
    public boolean performTask() {
        Trace.out((String)("TaskAnonymousProxy: called from: '" + VerificationUtil.getLocationInSource(true) + "'"));
        return this.m_resultSet.allSuccess();
    }

    @Override
    public String getDefaultElementName() {
        Trace.out((String)"NO ELEMENT NAME DEFINED!!");
        return "";
    }

    @Override
    public String getDefaultDescription() {
        Trace.out((String)"NO ELEMENT DESCRIPTION DEFINED!!");
        return "";
    }
}

