/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.CollectionResultImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.util.OSCollectionsCommandHandler;

public class TaskAllKernelParamCollection
extends Task {
    private String m_commandId;

    public TaskAllKernelParamCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("COMMAND_ID".equals(argName)) {
                this.m_commandId = argVal;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
    }

    @Override
    protected boolean performTask() {
        Trace.out((String)"ENTRY");
        if (!OSCollectionsCommandHandler.kernelParamCollectionAvailable()) {
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        String command = null;
        ResultSet rsltSet = new ResultSet();
        GlobalExecution globalExec = new GlobalExecution();
        command = OSCollectionsCommandHandler.genKernelParamDiscoveryCommand(this.m_commandId);
        Trace.out((int)5, (String)("Executing command=>" + command));
        globalExec.runGenericCmd(this.m_nodeList, command, rsltSet);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            CollectionResultImpl<Hashtable<String, String>> colRes = OSCollectionsCommandHandler.parseKernelParamCollection(this.m_commandId, node, command, result);
            this.m_resultSet.addResult(node, colRes.getStatus());
            if (colRes.getStatus() != 1) {
                for (VerificationError error : colRes.getErrors()) {
                    this.m_resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            try {
                for (String kernelParamName : colRes.getCollectedValue().keySet()) {
                    CollectionElement ce = new CollectionElement(kernelParamName, colRes.getCollectedValue().get(kernelParamName), null, null, kernelParamName, 1);
                    this.m_resultSet.addCollectionElement(node, ce);
                }
            }
            catch (CollectionValueUnavailableException e1) {
                Trace.out((Exception)e1);
            }
        }
        return true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.OS_KERNEL_PARAMS;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13000", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13101", false);
    }
}

