/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskAllInittabEntriesCollection
extends Task {
    final String m_inittabLocation = "/etc/inittab";

    public TaskAllInittabEntriesCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean performTask() {
        String msg;
        Trace.out((String)"ENTRY");
        String scratchPath = VerificationUtil.getCVUSubDirPath() + "scratch";
        File tempArea = new File(scratchPath);
        if (!tempArea.exists()) {
            tempArea.mkdirs();
        }
        if (!tempArea.isDirectory()) {
            tempArea.delete();
            tempArea.mkdir();
        }
        if (!tempArea.exists() || !tempArea.isDirectory()) {
            Trace.out((String)("Couldn't create " + tempArea.getName()));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            String msg2 = s_gMsgBundle.getMessage("13125", true, (Object[])new String[]{scratchPath});
            ErrorDescription errDesc = new ErrorDescription(msg2);
            this.m_resultSet.addErrorDescription(errDesc);
            ReportUtil.sureprintln(msg2);
            return false;
        }
        ArrayList<String> inittabNotExistNodes = new ArrayList<String>();
        ArrayList<String> inittabExistNodes = new ArrayList<String>();
        ClusterCmd clusterCmd = new ClusterCmd();
        for (String node : this.m_nodeList) {
            boolean copyStatus = false;
            Trace.out((String)("copying file from node:" + node));
            try {
                boolean currentNodeStatus = clusterCmd.fileExists(node, "/etc/inittab");
                if (!currentNodeStatus) {
                    Trace.out((String)("inittab does not exists on node" + node));
                    inittabNotExistNodes.add(node);
                    continue;
                }
                String nodeFilePath = scratchPath + "/inittab_" + node;
                File prvCopy = new File(nodeFilePath);
                if (prvCopy.exists()) {
                    prvCopy.delete();
                }
                copyStatus = clusterCmd.copyFileFromNode(node, "/etc/inittab", nodeFilePath);
                Trace.out((String)("copy status = " + copyStatus));
                if (copyStatus) {
                    inittabExistNodes.add(node);
                    continue;
                }
                inittabNotExistNodes.add(node);
            }
            catch (ClusterException e) {
                Trace.out((String)"ClusterException while looking for inittab");
                this.m_resultSet.addResult(node, 2);
                String msg3 = s_gMsgBundle.getMessage("13122", true, (Object[])new String[]{"/etc/inittab", node, m_localNode}) + LSEP + e.getMessage();
                this.m_resultSet.addErrorDescription(node, new ErrorDescription(msg3));
                ReportUtil.sureprintln(msg3);
                return false;
            }
        }
        if (inittabNotExistNodes.size() > 0 && inittabExistNodes.size() > 0) {
            Trace.out((String)"inittab exists on some nodes");
            msg = s_gMsgBundle.getMessage("13123", true, (Object[])new String[]{"/etc/inittab", VerificationUtil.strList2List(inittabNotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(inittabNotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
        } else if (inittabExistNodes.size() == 0) {
            Trace.out((String)"inittab exists on some nodes");
            msg = s_msgBundle.getMessage("13123", true, (Object[])new String[]{"/etc/inittab", VerificationUtil.strList2List(inittabNotExistNodes)});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addResult(inittabNotExistNodes.toArray(new String[0]), 3);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        for (String node : inittabExistNodes) {
            this.m_resultSet.addResult(node, 1);
            Trace.out((String)("Parsing inittab of node:" + node));
            try {
                String line;
                BufferedReader in = new BufferedReader(new FileReader(scratchPath + "/inittab_" + node));
                while ((line = in.readLine()) != null) {
                    String[] tokens;
                    line = line.trim();
                    Trace.out((String)("line [" + line + "]"));
                    if (line.length() == 0 || line.startsWith("#") || line.startsWith(";")) continue;
                    int index = line.indexOf("#");
                    if (index != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((index = line.indexOf(";")) != -1) {
                        line = line.substring(0, index).trim();
                    }
                    if ((tokens = line.split(":")).length < 3) continue;
                    CollectionElement inittabEntryCE = new CollectionElement("/etc/inittab:" + tokens[0], null, null, null, "/etc/inittab:" + tokens[0], 1);
                    CollectionElement inittabEntryIDCE = new CollectionElement(s_gMsgBundle.getMessage("13128", false, (Object[])new String[]{"/etc/inittab", node}), tokens[0], null, null, tokens[0], 1);
                    CollectionElement inittabEntryRunlevelsCE = new CollectionElement(s_gMsgBundle.getMessage("13129", false, (Object[])new String[]{"/etc/inittab", node}), tokens[1], null, null, tokens[1], 1);
                    CollectionElement inittabEntryActionCE = new CollectionElement(s_gMsgBundle.getMessage("13130", false, (Object[])new String[]{"/etc/inittab", node}), tokens[2], null, null, tokens[2], 1);
                    String processTxt = tokens.length > 3 ? tokens[3] : "";
                    CollectionElement inittabEntryProcessCE = new CollectionElement(s_gMsgBundle.getMessage("13131", false, (Object[])new String[]{"/etc/inittab", node}), processTxt, null, null, processTxt, 1);
                    inittabEntryCE.addChild(inittabEntryIDCE);
                    inittabEntryCE.addChild(inittabEntryRunlevelsCE);
                    inittabEntryCE.addChild(inittabEntryActionCE);
                    inittabEntryCE.addChild(inittabEntryProcessCE);
                    this.m_resultSet.addCollectionElement(node, inittabEntryCE);
                }
                in.close();
            }
            catch (IOException e) {
                Trace.out((String)("IOException while reading copied inittab for node :" + node));
                this.m_resultSet.addResult(node, 2);
                String msg4 = s_gMsgBundle.getMessage("13127", true, (Object[])new String[]{"/etc/inittab", node}) + VerificationConstants.LSEP + e.getMessage();
                ErrorDescription errDesc = new ErrorDescription(msg4);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(msg4);
            }
        }
        return true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.INITTAB_ENTRIES;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("131010", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13111", false);
    }
}

