/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.HashMap;
import java.util.Hashtable;
import oracle.cluster.verification.CollectionResult;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CollectionValueUnavailableException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.util.CollectionGroup;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.CollectionElement;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.OSCollectionsCommandHandler;

public class TaskAllEnvironmentVariableCollection
extends Task {
    public TaskAllEnvironmentVariableCollection(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
    }

    @Override
    protected boolean performTask() {
        Trace.out((String)"ENTRY");
        CollectionResultSet<Hashtable<String, String>> colRes = OSCollectionsCommandHandler.getAllEnvironmentVariables(this.m_nodeList);
        HashMap<String, CollectionResult<Hashtable<String, String>>> t = colRes.getNodeCollectionResults();
        for (String node : t.keySet()) {
            CollectionResult<Hashtable<String, String>> result = t.get(node);
            this.m_resultSet.addResult(node, result.getNodeResultStatus().getResultStatus());
            if (result.getNodeResultStatus() != NodeResultStatus.SUCCESSFUL) {
                for (VerificationError error : colRes.getErrors()) {
                    this.m_resultSet.addErrorDescription(node, (ErrorDescription)error);
                }
                continue;
            }
            try {
                for (String paramName : result.getCollectedValue().keySet()) {
                    CollectionElement ce = new CollectionElement(paramName, result.getCollectedValue().get(paramName), null, null, paramName, 1);
                    this.m_resultSet.addCollectionElement(node, ce);
                }
            }
            catch (CollectionValueUnavailableException e1) {
                Trace.out((Exception)e1);
            }
        }
        return true;
    }

    @Override
    public CollectionGroup getCollectionGroup() {
        return CollectionGroup.ENVIRONMENT_VARIABLES;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("13108", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("13109", false);
    }
}

