/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.KFODUtil;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMUtils;
import oracle.ops.verification.framework.util.ASMUtilsException;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskASMMissizedDiskCheck
extends Task {
    private boolean m_isSIHA = false;
    final String ASMCMD_ERR_STR = "ASMCMD-";
    private String m_activeCRSVersion = new Version().toString();

    public TaskASMMissizedDiskCheck(VerificationTaskContext ctx) {
        super(ctx);
    }

    @Override
    protected void init() {
        ExecutableInfo execInfo = this.m_ctx.getExecInfo();
        for (ExecutableArgument arg : execInfo.getExecutableArgs()) {
            String argName = arg.getArgName();
            String argVal = arg.getArgVal(true);
            if ("IS_SIHA".equals(argName) && VerificationUtil.isStringGood(argVal)) {
                if ("true".equalsIgnoreCase(argVal)) {
                    this.m_isSIHA = true;
                    continue;
                }
                this.m_isSIHA = false;
                continue;
            }
            Trace.out((String)("unknown argument. name=" + argName + ". value=" + argVal));
        }
        this.m_activeCRSVersion = this.m_isSIHA ? VerificationUtil.getSIHAReleaseVersion() : VerificationUtil.getCRSActiveVersion();
    }

    @Override
    protected boolean isTaskApplicable() throws VerificationException {
        ASMDiskGroupsUtil asmdg = new ASMDiskGroupsUtil();
        ResultSet asmRsltSet = new ResultSet();
        List<String> asmRunningNodes = asmdg.getASMInstanceRunningNodes(this.m_nodeList, asmRsltSet);
        if (asmRunningNodes != null && !asmRunningNodes.isEmpty()) {
            String destVersion = CVUVariables.getValue(CVUVariableConstants.DEST_VERSION);
            if (destVersion != null && VerificationUtil.isVersionPost(destVersion, "12.1")) {
                if (m_isAPImode || ParamManager.isRuncluvfy()) {
                    return true;
                }
                if (this.m_activeCRSVersion != null && !VerificationUtil.isVersionPre(this.m_activeCRSVersion, "12.1")) {
                    return true;
                }
            }
        } else {
            Trace.out((String)"ASM is not running on any of the cluster nodes. Hence this task is not applicable");
            VerificationLogData.log("ASM is not running on any of the cluster nodes. Hence this task is not applicable");
        }
        return false;
    }

    public TaskASMMissizedDiskCheck(String[] nodeList) {
        super(nodeList);
        this.setSeverity(SeverityType.IGNORABLE);
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Checking ASM disk size consistency...");
        if (VerificationUtil.isCVUTestEnv() && VerificationUtil.isStringGood(VerificationUtil.getEnv("OSM_INSTALL_TEST"))) {
            Trace.out((String)"Found OSM_INSTALL_TEST variable set.Its a Dummy Disk environment. Hence skipping TaskASMMissizedDiskCheck and returning SUCCESS");
            this.m_resultSet.addResult(this.m_nodeList, 1);
            return true;
        }
        return this.checkASMMissizedDisks();
    }

    private boolean checkASMMissizedDisks() {
        ReportUtil.sureprintln(s_gMsgBundle.getMessage("11633", false));
        String kfodLocation = null;
        KFODUtil kf = null;
        try {
            boolean isPreGIInst = true;
            kfodLocation = VerificationUtil.getKFODLocation(m_localNode, isPreGIInst);
            Trace.out((String)("running kfod from " + kfodLocation));
            kf = m_isAPImode || m_isFromRuncluvfy ? new KFODUtil(kfodLocation, true) : new KFODUtil(kfodLocation, false);
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("exception while trying to get Missized ASM disks " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        catch (VerificationException e) {
            Trace.out((String)("exception while trying to get Missized ASM disks " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        String discoveryString = null;
        try {
            discoveryString = ASMUtils.getASMDiscoveryString(this.m_activeCRSVersion);
        }
        catch (ASMUtilsException e) {
            Trace.out((String)("exception while trying to get asm discovery string" + e.getMessage()));
            String errMsg = s_gMsgBundle.getMessage("4672", false) + LSEP + e.getMessage();
            VerificationLogData.logError(errMsg);
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        try {
            List asmMissizedDiskList = kf.getMissizedASMDiskList(m_localNode, discoveryString);
            if (asmMissizedDiskList.size() == 0) {
                Trace.out((String)"All ASM disks have correct header information and matching with the actual disk size");
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("11634", false));
                this.m_resultSet.addResult(this.m_nodeList, 1);
                return true;
            }
            ArrayList<String> missizedDiskList = new ArrayList<String>();
            for (String missizedDiskInfo : asmMissizedDiskList) {
                String[] missizedDiskArray = missizedDiskInfo.split("\\s+");
                if (missizedDiskArray.length <= 1) continue;
                missizedDiskList.add(missizedDiskArray[1]);
            }
            String missizedDisks = VerificationUtil.strList2List(missizedDiskList, ",");
            Trace.out((String)("The following ASM disks are having wrong disk header information:" + LSEP + missizedDisks));
            VerificationLogData.logError("The following  ASM disks are  having wrong disk header information:" + LSEP + missizedDisks);
            String msg = s_gMsgBundle.getMessage("11635", true, (Object[])new String[]{missizedDisks});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
        catch (CmdToolUtilException e) {
            Trace.out((String)("exception while trying to check if there are any mis-sized asm disks: " + e.getMessage()));
            VerificationLogData.logError(e.getMessage());
            String errMsg = e.getMessage();
            ReportUtil.printError(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            return false;
        }
    }

    void setSIHAMode() {
        this.m_isSIHA = true;
    }

    @Override
    public String getDefaultElementName() {
        return s_gMsgBundle.getMessage("11631", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_gMsgBundle.getMessage("11632", false);
    }
}

