/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskACFSIntegrity
extends Task {
    private String m_fileSystem = null;

    public TaskACFSIntegrity(VerificationTaskContext ctx) {
        super(ctx);
    }

    public TaskACFSIntegrity(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskACFSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskACFSIntegrity(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
    }

    @Override
    protected void init() {
        VerificationType vType = this.m_globalContext.getVerificationType();
        switch (vType) {
            case COMPONENT_ACFS_INTEGRITY: {
                this.setFileSystem(CVUVariables.getValue(CVUVariableConstants.FILE_SYSTEM));
                break;
            }
        }
    }

    public void setFileSystem(String fileSystem) {
        this.m_fileSystem = fileSystem;
    }

    @Override
    public boolean performTask() {
        Trace.out((String)"Performing ASM/USM Integrity verification task... ");
        if (!VerificationUtil.isACFSSupported(true)) {
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4388", false));
        if (this.m_fileSystem == null) {
            Trace.out((int)5, (String)"fileSystem is NULL.");
            this.m_resultSet.addResult(this.m_nodeList, 1);
        } else {
            Trace.out((int)5, (String)("Checking fileSystem: '" + this.m_fileSystem + "'"));
            TaskSharedStorageAccess taskSSAccess = new TaskSharedStorageAccess(this.m_nodeList);
            String[] fileSystemList = new String[]{this.m_fileSystem};
            taskSSAccess.setStorageIDlist(fileSystemList);
            Trace.out((String)"Setting file type to RAC_SOFTWARE");
            taskSSAccess.setOracleFileType(OracleFileType.RAC_SOFTWARE);
            taskSSAccess.setCheckWritableFS(true);
            taskSSAccess.setCheckACFS(true);
            this.addChildTask(taskSSAccess);
            taskSSAccess.perform();
            ResultSet ssaRset = taskSSAccess.getResultSet();
            Trace.out((String)"==== Uploading results from ssaRset");
            this.m_resultSet.uploadResultSet(ssaRset);
        }
        if (this.m_resultSet.allSuccess()) {
            ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4389", false));
            return true;
        }
        ReportUtil.sureprintln(LSEP + s_msgBundle.getMessage("4390", false));
        return false;
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("4447", false);
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("4497", false);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("    NodeList: " + VerificationUtil.strArr2List(this.m_nodeList));
        return sb.toString();
    }

    @Override
    public NodeRoleCapability getApplicableNodeRoleCapability() {
        return NodeRoleCapability.HUB_CAPABLE;
    }
}

