/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.stage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import oracle.cluster.verification.ParamPreReq;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.stage.Stage;
import oracle.ops.verification.framework.engine.stage.StageInitException;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RDBMSInstallStage
extends Stage
implements VerificationAPIConstants {
    private String m_oracleHome;
    private boolean m_oracleHomeOnCFS;
    private String m_osdba;
    private String m_osoper;
    private String m_osbackup;
    private String m_osdg;
    private String m_oskm;
    private String m_oraInv;
    private ParamPreReqDBInst m_param = null;
    private boolean m_ASMCheck;
    private boolean m_USMCheck;
    private String[] m_ASMDGList;
    private String m_release;

    @Override
    public void init() throws StageInitException {
        super.init();
        Trace.out((String)"Inside RDBMSInstallStage:init()...");
        if (this.m_verificationMode == 1) {
            this.m_oracleHome = CVUVariables.getValue(CVUVariableConstants.ORACLE_HOME);
            Trace.out((String)("==== ParamManager reports Oracle Home as: " + this.m_oracleHome));
            this.m_oracleHomeOnCFS = this.m_paramMgr.checkArgCfsOh();
            Trace.out((String)("==== ParamManager reports OracleHome-On-CFS as: " + this.m_oracleHomeOnCFS));
            this.m_ASMCheck = this.m_paramMgr.checkASM();
            Trace.out((String)("==== ParamManager reports Check-ASM as " + this.m_ASMCheck));
            this.m_USMCheck = this.m_paramMgr.checkUSM();
            Trace.out((String)("==== ParamManager reports Check-USM as " + this.m_USMCheck));
            this.m_osdba = CVUVariables.getValue(CVUVariableConstants.DBA_GROUP);
            Trace.out((String)("==== ParamManager reports OSDBA as: " + this.m_osdba));
            this.m_osoper = CVUVariables.getValue(CVUVariableConstants.OPER_GROUP);
            Trace.out((String)("==== ParamManager reports OSOPER as: " + this.m_osoper));
            this.m_osbackup = CVUVariables.getValue(CVUVariableConstants.OSBACKUPDBA_GROUP);
            Trace.out((String)("==== ParamManager reports OSBACKUP as: " + this.m_osbackup));
            this.m_osdg = CVUVariables.getValue(CVUVariableConstants.DGDBA_GROUP);
            Trace.out((String)("==== ParamManager reports OSDG as: " + this.m_osdg));
            this.m_oskm = CVUVariables.getValue(CVUVariableConstants.KMDBA_GROUP);
            Trace.out((String)("==== ParamManager reports OSKM as: " + this.m_oskm));
            this.m_oraInv = VerificationUtil.getOraInventoryGroup();
            this.m_release = VerificationUtil.getRequestedRelease();
            if ("10gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.1";
            } else if ("10gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "10.2";
            } else if ("11gR1".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.1";
            } else if ("11gR2".equalsIgnoreCase(this.m_release)) {
                this.m_release = "11.2";
            }
            Trace.out((String)"Entering values into ParamPreReqDBInst...");
            this.m_param = new ParamPreReqDBInst();
            this.m_param.setOraInv(this.m_oraInv);
            this.m_param.setOrclHomeOnOCFS(this.m_oracleHomeOnCFS);
            this.m_param.setCRSHome(VerificationUtil.getCRSHome());
            this.m_param.setHAHome(VerificationUtil.getHAHome());
            this.m_param.setASMCheck(this.m_ASMCheck);
            this.m_param.setUSMCheck(this.m_USMCheck);
            this.m_param.setASMDGList(this.m_ASMDGList);
            this.m_param.setRelease(this.m_release);
            Vector<String> succNodes = new Vector<String>();
            Vector<String> failNodes = new Vector<String>();
            if (VerificationUtil.isStringGood(this.m_oracleHome)) {
                if (!VerificationUtil.isDirPathWritable(this.m_nodeList, this.m_oracleHome, succNodes, failNodes)) {
                    Trace.out((String)(this.m_oracleHome + " is not writable on nodes " + VerificationUtil.strCollection2String(failNodes)));
                    String errMsg = s_gMsgBundle.getMessage("11930", true, (Object[])new String[]{this.m_oracleHome, VerificationUtil.strCollection2String(failNodes)});
                    throw new StageInitException(errMsg);
                }
                this.m_param.setOrclHome(this.m_oracleHome);
            }
            if (this.m_paramMgr.checkArgUpgrade()) {
                if (VerificationUtil.isVersionPre(CVUVariables.getValue(CVUVariableConstants.DEST_VERSION), "11.2.0.1.0")) {
                    String msg = s_gMsgBundle.getMessage("1195", true);
                    throw new StageInitException(msg);
                }
                this.m_param.setRelease(CVUVariables.getValue(CVUVariableConstants.DEST_VERSION));
                try {
                    this.m_nodeList = VerificationUtil.getStaticNodelist();
                    VerificationUtil.setLocalNodeOperation(false);
                }
                catch (NodelistNotFoundException e) {
                    this.m_resultSet.addResult(this.m_nodeList, 2);
                    throw new StageInitException(e.getMessage());
                }
                String dbVersion = null;
                String oracleHome = null;
                try {
                    oracleHome = CVUVariables.getValue(CVUVariableConstants.SRC_RAC_HOME);
                    Version crsActiveVersion = VerificationUtil.getCRSActiveVersionObj();
                    dbVersion = new DBUtils(crsActiveVersion).getDBVersionString(oracleHome);
                    if (!VerificationUtil.isStringGood(dbVersion)) {
                        throw new StageInitException(s_gMsgBundle.getMessage("0602", true, (Object[])new String[]{oracleHome}));
                    }
                }
                catch (DBUtilsException e) {
                    Trace.out((String)"Could not find data base version while upgrading.");
                    throw new StageInitException(s_gMsgBundle.getMessage("0602", true, (Object[])new String[]{oracleHome}) + LSEP + e.getMessage());
                }
                if (VerificationUtil.compareVersions(CVUVariables.getValue(CVUVariableConstants.DEST_VERSION), dbVersion, ".") == 0) {
                    throw new StageInitException(s_gMsgBundle.getMessage("0601", true, (Object[])new String[]{VerificationUtil.getRDBMSVersion()}));
                }
            }
        }
    }

    @Override
    protected boolean checkSetup() {
        boolean resUE = false;
        try {
            if (this.m_nodeList.length == 1 && this.m_nodeList[0].equals(VerificationUtil.getLocalNodename()) && VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
                this.setExcludeUserEquiv(true);
            }
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("Node List not found:" + e));
            String msg = e.getMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP;
            ReportUtil.printError(msg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(new ErrorDescription(msg));
            return false;
        }
        resUE = super.checkSetup();
        if (!resUE) {
            return false;
        }
        if (this.m_validNodeList == null || this.m_validNodeList.length == 0) {
            return false;
        }
        ResultSet rs = new ResultSet();
        String[] nodesWithCRSinstall = VerificationUtil.getNodesWithCRSInstall(this.m_validNodeList, rs);
        this.setValidNodeList(nodesWithCRSinstall);
        if (!this.checkUpgradeSetup()) {
            return false;
        }
        if (nodesWithCRSinstall != null && nodesWithCRSinstall.length != 0) {
            return false;
        }
        return nodesWithCRSinstall.length == this.getNodeList().length;
    }

    private boolean checkUpgradeSetup() {
        if (this.m_paramMgr.checkArgUpgrade()) {
            Trace.out((String)"setting install option to upgrade");
            CVUVariables.setValue(CVUVariableConstants.INSTALL_OPTION, VAR_VAL_UPGRADE);
            DBUtils dbUtils = new DBUtils(VerificationUtil.getCRSActiveVersionObj());
            String[] dbArr = this.m_paramMgr.getMultiPartArgVal(CVUVariables.getValue(CVUVariableConstants.DB_NAME));
            ArrayList<String> dbList = new ArrayList<String>();
            ArrayList<String> failDbList = new ArrayList<String>();
            try {
                if (dbArr == null) {
                    dbArr = dbUtils.getDatabases();
                }
                dbList.addAll(Arrays.asList(dbArr));
                for (String db : dbList) {
                    Trace.out((String)("Adding database connection info for database " + db));
                    ResultSet dbRes = dbUtils.addDBConnectInfo(db);
                    if (!dbRes.allSuccess()) {
                        Trace.out((String)("Failed to add connection info for the database " + db));
                        failDbList.add(db);
                    }
                    this.m_resultSet.addResultSetData(dbRes);
                }
                dbList.removeAll(failDbList);
                CVUVariables.setValue(CVUVariableConstants.DB_NAME, VerificationUtil.strList2List(dbList));
            }
            catch (DBUtilsException dbex) {
                VerificationUtil.traceAndLog("Failed to obtain information about the+ databases. " + dbex.getMessage());
                return false;
            }
        }
        return true;
    }

    RDBMSInstallStage(int verificationMode) throws StageInitException {
        super(verificationMode);
        this.init();
    }

    @Override
    protected void setTaskList() throws TaskFactoryException, PreReqNotSupportedException {
        if (this.m_verificationMode == 1) {
            List<Task> dbInstStageTaskList = null;
            dbInstStageTaskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, this.getValidNodeList(), (ParamPreReq)this.m_param, this);
            this.addToCurrentTaskSet(dbInstStageTaskList.toArray(new Task[0]));
        }
    }

    @Override
    public void generateReport() {
    }
}

