/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.factory.parser;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import oracle.cluster.verification.SeverityType;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.NodeVisitorCB;
import oracle.cluster.verification.pluggable.DarwinSQLDataComparator;
import oracle.cluster.verification.pluggable.PluggableTaskUtil;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.cluster.verification.pluggable.SQLDataComparator;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.security.NullSecurityManager;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.engine.factory.context.PluggableTaskContext;
import oracle.ops.verification.framework.engine.factory.context.VerificationTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataComparator;
import oracle.ops.verification.framework.engine.factory.data.DataComparatorType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ExecutableResultType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.engine.factory.data.ExternalDataComparator;
import oracle.ops.verification.framework.engine.factory.data.InitialValidation;
import oracle.ops.verification.framework.engine.factory.data.InstanceType;
import oracle.ops.verification.framework.engine.factory.data.OperationMode;
import oracle.ops.verification.framework.engine.factory.data.StdDataComparator;
import oracle.ops.verification.framework.engine.factory.data.TaskFactoryConstants;
import oracle.ops.verification.framework.engine.task.PluggableDatabaseTask;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.engine.task.Target;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.util.ConditionsUtil;
import oracle.ops.verification.framework.util.InvalidRangeManipulationException;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RangeOfValue;
import oracle.ops.verification.framework.util.RangeOperator;
import oracle.ops.verification.framework.util.RangeType;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.resources.PrveMsgID;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class TaskFactoryXmlParser
implements VerificationAPIConstants,
TaskFactoryConstants {
    private GlobalVerificationContext m_globalContext = null;
    private static MessageBundle s_prveMsgBundle = VerificationUtil.getMessageBundle("Prve");
    Element m_rootElementTaskPlacement = null;
    Element m_rootElementTaskDef = null;
    String m_dbConnDescr = null;
    boolean m_darwinChecks = false;
    boolean m_isRootCredsAvailable = false;

    public TaskFactoryXmlParser() {
        Trace.out((String)"Constructor");
        this.m_globalContext = GlobalVerificationContext.getInstance();
        try {
            if (RootAutomationUtility.isRootExecutionConfigured()) {
                RootAutomationUtility.getRootExecutionInfo();
                this.m_isRootCredsAvailable = true;
                Trace.out((String)"root automation is configured");
            }
        }
        catch (VerificationException e) {
            Trace.out((String)"root automation is not configured");
        }
    }

    public List<Task> getTasks(String release, String distID, String targetID, String[] nodeList) throws XmlParserException {
        Trace.out((String)"Method release=%s, distID=%s, targetID=%s, nodeList", (Object[])new Object[]{release, distID, targetID, nodeList});
        try {
            this.m_darwinChecks = false;
            List<Task> parsedTasks = this.parse(release, distID, targetID, nodeList);
            ArrayList<Task> cvuTasks = new ArrayList();
            if (parsedTasks != null && !parsedTasks.isEmpty()) {
                for (Task taskObj : parsedTasks) {
                    try {
                        if (taskObj.isApplicable()) {
                            cvuTasks.add(taskObj);
                            continue;
                        }
                        Trace.out((String)("The verification task (" + taskObj.getDefaultTaskID() + ") was parsed from the taskplacement xml file but is " + "being report not applicable in the current scenario."));
                    }
                    catch (VerificationException e) {
                        Trace.out((String)("Failed to determine if The verification task (" + taskObj.getDefaultTaskID() + ") is applicable in the current" + " scenario. Error is " + e.getMessage()));
                    }
                }
            } else {
                cvuTasks = parsedTasks;
            }
            Trace.out((String)"getting darwin checks");
            this.m_darwinChecks = true;
            List<Task> darwinTasks = this.parse(release, distID, targetID, nodeList);
            if (cvuTasks != null) {
                if (darwinTasks != null) {
                    cvuTasks.addAll(darwinTasks);
                }
            } else {
                cvuTasks = darwinTasks;
            }
            return cvuTasks;
        }
        catch (XmlFilePathException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (ParserConfigurationException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (SAXException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
        catch (IOException e) {
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    public Element getRootElement(String xmlFile) throws XmlParserException, ParserConfigurationException, SAXException, IOException, XmlFilePathException {
        DocumentBuilderFactory m_xmlFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder m_xmlParser = null;
        Document m_xmlDocument = null;
        String m_xsdURI = VerificationUtil.getTaskFactoryXmlSchemaURI();
        File file_xsdURI = null;
        File file_xmlFile = null;
        try {
            Trace.out((String)("==== URIs obtained :xsd URI = " + m_xsdURI));
            Trace.out((String)("==== URIs obtained :xml URI = " + xmlFile));
            if (m_xsdURI != null) {
                file_xsdURI = new File(new URI(m_xsdURI));
            }
            if (file_xsdURI == null || !file_xsdURI.exists()) {
                Trace.out((String)("xsdFile: " + m_xsdURI + " does not exists. returning null"));
                return null;
            }
            if (xmlFile != null) {
                file_xmlFile = new File(new URI(xmlFile));
            }
            if (file_xmlFile == null || !file_xmlFile.exists()) {
                Trace.out((String)("xmlFile: " + xmlFile + " does not exists. returning null"));
                return null;
            }
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
            m_xmlFactory.setNamespaceAware(true);
            m_xmlFactory.setValidating(true);
            m_xmlFactory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaSource", m_xsdURI);
            m_xmlParser = m_xmlFactory.newDocumentBuilder();
            ErrorHandler handler = new ErrorHandler(){

                @Override
                public void error(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void fatalError(SAXParseException arg0) throws SAXException {
                    throw arg0;
                }

                @Override
                public void warning(SAXParseException arg0) throws SAXException {
                    Trace.out((String)("Igonred waring while parsing: " + arg0));
                }
            };
            m_xmlParser.setErrorHandler(handler);
            m_xmlDocument = m_xmlParser.parse(xmlFile);
            return m_xmlDocument.getDocumentElement();
        }
        catch (SAXException se) {
            Trace.out((String)("Caught SAXException Error is :" + se.getMessage()));
            throw new XmlParserException(se.getMessage(), se);
        }
        catch (IOException ioe) {
            Trace.out((String)("Caught IOException Error is :" + ioe.getMessage()));
            throw new XmlParserException(ioe.getMessage(), ioe);
        }
        catch (FactoryConfigurationError fce) {
            Trace.out((String)("Caught FactoryConfigurationError Error is :" + fce.getMessage()));
            throw new XmlParserException(fce.getMessage(), fce);
        }
        catch (ParserConfigurationException pce) {
            Trace.out((String)("Caught ParserConfigurationException Error is :" + pce.getMessage()));
            throw new XmlParserException(pce.getMessage(), pce);
        }
        catch (Exception e) {
            Trace.out((String)("Exception " + e.getClass().getName() + " occured. Msg " + e.getMessage()));
            throw new XmlParserException(e.getMessage(), e);
        }
    }

    private List<Task> parse(String release, String distID, String targetID, String[] nodeList) throws XmlParserException, ParserConfigurationException, SAXException, IOException, XmlFilePathException {
        Element elem;
        int i;
        Trace.out((int)5, (String)"Method release=%s, distID=%s, targetID=%s, nodeList", (Object[])new Object[]{release, distID, targetID, nodeList});
        String xmlTaskDefFile = null;
        String xmlPlacementFile = null;
        if (this.m_darwinChecks) {
            xmlTaskDefFile = VerificationUtil.getPluggableTaskDarwinXmlURI();
            xmlPlacementFile = VerificationUtil.getPluggableTaskDarwinXmlURI();
        } else {
            xmlTaskDefFile = VerificationUtil.getTaskDefinitionXmlURI();
            xmlPlacementFile = VerificationUtil.getTaskPlacementXmlURI();
        }
        this.m_rootElementTaskDef = this.getRootElement(xmlTaskDefFile);
        this.m_rootElementTaskPlacement = this.getRootElement(xmlPlacementFile);
        if (this.m_rootElementTaskPlacement == null || this.m_rootElementTaskDef == null) {
            Trace.out((String)"Either the definition xml or target xml not found or could not be parsed");
            return null;
        }
        NodeList softwareReleaseList = this.m_rootElementTaskPlacement.getElementsByTagName(TaskFactoryConstants.XMLTags.SOFTWARE);
        Element releaseElem = null;
        String version = null;
        for (i = 0; i < softwareReleaseList.getLength(); ++i) {
            elem = (Element)softwareReleaseList.item(i);
            version = this.getRequiredAttributeValue(elem, TaskFactoryConstants.XMLAttributes.VERSION);
            if (!version.equalsIgnoreCase(release) || this.getTargetForRelease(elem, targetID) == null) continue;
            Trace.out((String)("Found a software element for matching release (" + release + ") defining the target (" + targetID + ") inside xml"));
            releaseElem = elem;
            break;
        }
        if (releaseElem == null) {
            VerificationUtil.traceAndLog("Explicit release (" + release + ") entry NOT FOUND for" + " target (" + targetID + ") inside xml. Using current release as " + "default release for this target.");
            release = Version.getCurrentVersion().getMajorVersion() + "." + Version.getCurrentVersion().getMinorVersion();
            for (i = 0; i < softwareReleaseList.getLength(); ++i) {
                elem = (Element)softwareReleaseList.item(i);
                version = this.getRequiredAttributeValue(elem, TaskFactoryConstants.XMLAttributes.VERSION);
                if (!version.equalsIgnoreCase(release) || this.getTargetForRelease(elem, targetID) == null) continue;
                Trace.out((String)("Found a software element for matching release (" + release + ") defining the target (" + targetID + ") inside xml"));
                releaseElem = elem;
                break;
            }
        }
        if (releaseElem == null) {
            return null;
        }
        Trace.out((String)("The releaseElem selected for the input release :" + version));
        return this.parseTargetList(releaseElem, distID, targetID, nodeList);
    }

    private List<Task> parseTargetList(Element releaseElem, String distID, String targetID, String[] nodeList) throws XmlParserException {
        Trace.out((int)5, (String)"Method releaseElem=%s, distID=%s, targetID=%s", (Object[])new Object[]{releaseElem.getTagName(), distID, targetID});
        Element targetElem = this.getTargetForRelease(releaseElem, targetID);
        if (targetElem == null) {
            Trace.out((int)5, (String)"No prereq tasks found! For distID=%s, targetID=%s", (Object[])new Object[]{distID, targetID});
            return new ArrayList<Task>();
        }
        return this.parseTarget(targetElem, distID, nodeList);
    }

    private List<Task> parseTarget(Element targetListElem, String distID, String[] nodeList) throws XmlParserException {
        Trace.out((String)("Method Entry. TargetListElem=>" + targetListElem.getNodeName() + "Dist ID =>" + distID));
        Element taskListElem = this.getFirstChildByTagName(targetListElem, TaskFactoryConstants.XMLTags.TASK_LIST);
        return this.parseTaskList(taskListElem, distID, nodeList);
    }

    private void parseChildrenConditionally(NodeVisitorCB visitorCallback, Element xmlElem, String distID, String[] nodeList) throws XmlParserException {
        Trace.out((String)("Method Entry. xmlElem=" + xmlElem.getNodeName()));
        NodeList childNodeList = xmlElem.getChildNodes();
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            Node childNode = childNodeList.item(i);
            if (childNode.getNodeType() != 1) continue;
            Trace.out((String)("Processing pCC , current Node Visited is =>" + childNode.getNodeName()));
            Element elem = (Element)childNodeList.item(i);
            if (elem.getNodeName().equals(TaskFactoryConstants.XMLTags.CONDITION)) {
                if (ConditionsUtil.evaluateCondition(elem, nodeList)) {
                    this.parseChildrenConditionally(visitorCallback, elem, distID, nodeList);
                    continue;
                }
                NodeList elseNodeList = this.getChildrenByTagName(elem, TaskFactoryConstants.XMLTags.ELSE);
                if (elseNodeList.getLength() != 1) continue;
                this.parseChildrenConditionally(visitorCallback, (Element)elseNodeList.item(0), distID, nodeList);
                continue;
            }
            Trace.out((String)("Non-condition node encountered =>" + elem.getNodeName()));
            visitorCallback.handle(elem, null, null, null);
        }
    }

    private NodeList getChildrenByTagName(Element elem, String tagName) {
        Trace.out((String)"Method Entry. elem=%s, tagName=%s", (Object[])new Object[]{elem.getTagName(), tagName});
        NodeList allChildren = elem.getChildNodes();
        final ArrayList<Node> _items = new ArrayList<Node>();
        NodeList immediateChildren = new NodeList(){

            @Override
            public int getLength() {
                return _items.size();
            }

            @Override
            public Node item(int paramInt) {
                return (Node)_items.get(paramInt);
            }
        };
        boolean j = false;
        for (int i = 0; i < allChildren.getLength(); ++i) {
            Node toddler = allChildren.item(i);
            if (toddler == null || !toddler.getNodeName().equals(tagName)) continue;
            _items.add(toddler);
            Trace.out((String)("Adding the node " + toddler.getNodeName()));
        }
        return immediateChildren;
    }

    private List<Task> parseTaskList(Element tlElem, final String distID, final String[] nodeList) throws XmlParserException {
        Trace.out((String)"Method Entry. tlElem=%s, distID=%s", (Object[])new Object[]{tlElem.getTagName(), distID});
        final ArrayList<Task> taskList = new ArrayList<Task>();
        this.parseChildrenConditionally(new NodeVisitorCB(){

            @Override
            public void handle(Element elem, String conditionVar, String choiceVar, String selection) throws XmlParserException {
                if (elem.getNodeName().equals(TaskFactoryConstants.XMLTags.TASK)) {
                    Trace.out((String)"NodeVisitorCB handle called , adding Task list");
                    Task task = TaskFactoryXmlParser.this.parsePlacementTask(elem, distID, nodeList);
                    if (task != null) {
                        taskList.add(task);
                    }
                }
            }
        }, tlElem, distID, nodeList);
        return taskList;
    }

    private void sqlPluggableTask(PluggableTask task) throws XmlParserException {
        try {
            ExecutableInfo ei = task.getExecutableInfo();
            InstanceType insType = ei.getInstanceType();
            ArrayList<ExecutableArgument> execArgs = new ArrayList<ExecutableArgument>();
            List<ExecutableArgument> prevArgs = task.getExecutableInfo().getExecutableArgs();
            for (ExecutableArgument ea : prevArgs) {
                if (ea.getArgType().equals((Object)ArgType.DEFINED)) {
                    execArgs.add(ea);
                    continue;
                }
                if (!ea.getArgType().equals((Object)ArgType.DERIVED)) continue;
                String argName = ea.getArgName();
                String argVal = ea.getArgVal(true);
                if (VerificationUtil.isStringGood(argVal)) {
                    execArgs.add(new ExecutableArgument(argName, ArgType.DEFINED, DataType.STRING, argVal));
                    continue;
                }
                execArgs.add(ea);
            }
            ei.setExecutableArgs(execArgs);
        }
        catch (Exception ex) {
            Trace.out((String)("Exception: class" + ex.getClass()));
            Trace.out((String)("Exception: message" + ex.getMessage()));
        }
    }

    public Task parsePlacementTask(Element elTask, String distID, String[] nodeList) throws XmlParserException {
        Trace.out((String)"Method Entry.elTask.getElementName=%s, distID=%s", (Object[])new Object[]{elTask.getTagName(), distID});
        return this.parsePlacementTask(elTask, distID, nodeList, this.m_rootElementTaskDef);
    }

    public Task parsePlacementTask(Element elTask, String distID, String[] nodeList, Element rootElementTaskDef) throws XmlParserException {
        NodeList referenceNodeList;
        String isTaskDisabledStr;
        boolean isTaskDisabled;
        Trace.out((String)"Method Entry.elTask.getElementName=%s, distID=%s", (Object[])new Object[]{elTask.getTagName(), distID});
        String taskID = this.getRequiredAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.ID);
        String isTargetStr = this.getOptionalAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.IS_TARGET);
        boolean isTarget = "true".equalsIgnoreCase(isTargetStr);
        Task task = null;
        if (isTarget) {
            Trace.out((String)("Processing a target (" + taskID + ") from xml"));
            VerificationType targetType = VerificationType.getType(taskID);
            Trace.out((String)("Target ID string (" + taskID + ") mapped to " + (Object)((Object)targetType)));
            if (targetType != null) {
                task = new Target(targetType);
            } else {
                VerificationUtil.traceAndLogWarning("The verification type (" + taskID + ") is unknown. Skipping this target from xml file.");
            }
            return task;
        }
        task = this.parseTask(taskID, nodeList, distID, rootElementTaskDef);
        if (task == null) {
            Trace.out((String)"Returning NULL");
            return null;
        }
        String operationModeStr = this.getOptionalAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.APPLICABILITY);
        if (VerificationUtil.isStringGood(operationModeStr) && !this.isApplicableForCurrentOperationMode(operationModeStr)) {
            VerificationUtil.traceAndLog("Task " + taskID + " with applicable mode (" + operationModeStr + ") is not applicable to this operation mode.");
            return null;
        }
        List<OperationMode> notApplicableInOperationModes = this.parseOperationModes(operationModeStr, true);
        if (notApplicableInOperationModes.contains((Object)OperationMode.bestpractice)) {
            task.setBestPractice(false);
        }
        if (isTaskDisabled = "true".equalsIgnoreCase(isTaskDisabledStr = this.getOptionalAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.DISABLED))) {
            Trace.out((String)"Task is explicitly disabled, Setting disable true for the task object");
            task.disable();
        } else {
            Trace.out((String)"Task is not disabled");
        }
        String severityStr = this.getOptionalAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.SEVERITY);
        if (severityStr != null) {
            SeverityType severity = this.getSeverityAttributeValue(severityStr);
            task.setSeverity(severity);
        }
        String idMsgParamsStr = this.getOptionalAttributeValue(elTask, TaskFactoryConstants.XMLAttributes.ID_MSG_PARAMS);
        String[] idMsgParams = null;
        if (VerificationUtil.isStringGood(idMsgParamsStr) && task.isPluggable()) {
            idMsgParams = idMsgParamsStr.split(",");
            ((PluggableTask)task).setIdMsgParams(idMsgParams);
        }
        if ((referenceNodeList = elTask.getElementsByTagName(TaskFactoryConstants.XMLTags.REFERENCE)).getLength() > 0) {
            ArrayList<String> referenceList = new ArrayList<String>();
            for (int i = 0; i < referenceNodeList.getLength(); ++i) {
                Element referenceElement = (Element)referenceNodeList.item(i);
                String reference = referenceElement.getFirstChild().getNodeValue();
                if (reference == null) continue;
                referenceList.add(reference.trim());
            }
            task.setReferences(referenceList);
        }
        ExecutableInfo ei = task.getExecutableInfo();
        if (this.getFirstChildByTagName(elTask, TaskFactoryConstants.XMLTags.EXECUTABLE_ARGUMENTS) != null) {
            NodeList externalExecArgsList = elTask.getElementsByTagName(TaskFactoryConstants.XMLTags.ARG);
            if (externalExecArgsList == null || externalExecArgsList.getLength() == 0) {
                if (ei != null) {
                    ei.setExecutableArgs(new ArrayList<ExecutableArgument>());
                }
            } else {
                for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                    Element argElement = (Element)externalExecArgsList.item(i);
                    String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.NAME), TaskFactoryConstants.XMLAttributes.VALUE);
                    String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.TYPE), TaskFactoryConstants.XMLAttributes.VALUE);
                    String argValue = null;
                    String argDefaultValue = null;
                    ArgType execArgType = null;
                    Element valElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLTags.VAL);
                    Element varElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.VAR);
                    if (valElem != null) {
                        argValue = this.getRequiredAttributeValue(valElem, TaskFactoryConstants.XMLAttributes.VALUE);
                        execArgType = ArgType.DEFINED;
                    } else if (varElem != null) {
                        argValue = this.getRequiredAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.VALUE);
                        argDefaultValue = this.getOptionalAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.DEFAULT);
                        execArgType = ArgType.DERIVED;
                    } else {
                        throw new XmlParserException("Argument VAL or VAR not specified");
                    }
                    DataType execArgDataType = this.mapDataType(argType);
                    ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue, argDefaultValue);
                    ei.replaceExecArgument(execArg);
                }
            }
        }
        if (this.getFirstChildByTagName(elTask, TaskFactoryConstants.XMLTags.EXCLUDE_SUBTASKS) != null) {
            ArrayList<String> excludeChildTaskIDList = new ArrayList<String>();
            NodeList excludeSubTaskList = elTask.getElementsByTagName(TaskFactoryConstants.XMLTags.TASK);
            for (int i = 0; i < excludeSubTaskList.getLength(); ++i) {
                Element taskElement = (Element)excludeSubTaskList.item(i);
                String id = this.getRequiredAttributeValue(taskElement, TaskFactoryConstants.XMLAttributes.ID);
                if (!VerificationUtil.isStringGood(id)) continue;
                excludeChildTaskIDList.add(id);
            }
            task.setChildTasksToExclude(excludeChildTaskIDList);
        }
        if (this.getFirstChildByTagName(elTask, TaskFactoryConstants.XMLTags.ANALYZER) != null) {
            this.parseAnalyzer(taskID, elTask, ei);
        }
        if (task.isPluggable() && task.getExecutableInfo().getExecutableType() == ExecutableType.SQL) {
            this.sqlPluggableTask((PluggableTask)task);
        }
        return task;
    }

    private Task parseTask(String taskID, String[] nodeList, String distID, Element rootElementTaskDef) throws XmlParserException {
        String moreDetailsId;
        Trace.out((String)("Method Entry. taskID=" + taskID));
        NodeList taskDefList = rootElementTaskDef.getElementsByTagName(TaskFactoryConstants.XMLTags.TASK_DEFINITION);
        Element taskElem = null;
        String taskName = null;
        for (int i = 0; i < taskDefList.getLength(); ++i) {
            Element e = (Element)taskDefList.item(i);
            taskName = this.getOptionalAttributeValue(e, TaskFactoryConstants.XMLAttributes.SYNONYM);
            if (this.getRequiredAttributeValue(e, TaskFactoryConstants.XMLAttributes.ID).equals(taskID)) {
                taskElem = e;
                break;
            }
            if (!VerificationUtil.isStringGood(taskName) || !taskName.equals(taskID)) continue;
            taskElem = e;
            break;
        }
        if (taskElem == null) {
            Trace.out((String)"Returning NULL");
            return null;
        }
        String isTaskDisabledStr = this.getRequiredAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.DISABLED);
        boolean isTaskDisabled = "true".equalsIgnoreCase(isTaskDisabledStr);
        if (isTaskDisabled) {
            Trace.out((String)"Task definition is explicitly disabled, returning NULL");
            return null;
        }
        if (!this.isApplicableToCurrentOS(taskElem, distID)) {
            Trace.out((String)"Not applicable to current platform. returning NULL");
            return null;
        }
        boolean isBestPractice = true;
        String operationModeStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.APPLICABILITY);
        if (VerificationUtil.isStringGood(operationModeStr)) {
            if (!this.isApplicableForCurrentOperationMode(operationModeStr)) {
                VerificationUtil.traceAndLog("Task " + taskID + " with applicable mode (" + operationModeStr + ") " + "is not applicable to this operation mode.");
                return null;
            }
            List<OperationMode> notApplicableInOperationModes = this.parseOperationModes(operationModeStr, true);
            if (notApplicableInOperationModes.contains((Object)OperationMode.bestpractice)) {
                isBestPractice = false;
            }
        }
        String rootPrivilegeRequiredStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.ROOT_PRIVILEGE_REQUIRED);
        boolean rootPrivilegeRequired = "true".equalsIgnoreCase(rootPrivilegeRequiredStr);
        String severityStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.SEVERITY);
        String idMsgParamsStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.ID_MSG_PARAMS);
        String[] idMsgParams = null;
        if (VerificationUtil.isStringGood(idMsgParamsStr)) {
            idMsgParams = idMsgParamsStr.split(",");
        }
        String isFixableStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.FIXABLE);
        boolean isFixable = false;
        if (VerificationUtil.isStringGood(isFixableStr)) {
            isFixable = "true".equalsIgnoreCase(isFixableStr);
        }
        String isFixupRebootRequiredStr = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.FIXUP_REBOOT);
        boolean isFixupRebootRequired = false;
        if (VerificationUtil.isStringGood(isFixupRebootRequiredStr)) {
            isFixupRebootRequired = "true".equalsIgnoreCase(isFixupRebootRequiredStr);
        }
        Trace.out((String)("rootPrivilegeRequired=" + rootPrivilegeRequired));
        if (rootPrivilegeRequired && !this.m_isRootCredsAvailable) {
            Trace.out((String)"Root prvilege is required but not supplied. returning NULL");
            return null;
        }
        ExecutableInfo ei = this.parseExecutableInfo(taskID, taskElem);
        Task task = null;
        if (ei.getExecutableType().equals((Object)ExecutableType.JAVA)) {
            Element javaElem = this.getFirstChildByTagName(taskElem, TaskFactoryConstants.XMLTags.JAVA);
            String packageLoc = this.getOptionalAttributeValue(javaElem, TaskFactoryConstants.XMLAttributes.PACKAGE);
            String className = this.getRequiredAttributeValue(javaElem, TaskFactoryConstants.XMLAttributes.NAME);
            task = this.createJavaTask(taskID, className, packageLoc, nodeList, idMsgParams, ei);
            task.setNodeList(nodeList);
        } else {
            PluggableTaskContext ctx = new PluggableTaskContext(ei, idMsgParams, this.m_darwinChecks);
            ctx.setNodeList(nodeList);
            task = ei.getExecutableType().equals((Object)ExecutableType.SQL) && ei.getInstanceType().equals((Object)InstanceType.DB) ? new PluggableDatabaseTask(ctx, taskID) : new PluggableTask(ctx, taskID, isFixable, isFixupRebootRequired);
            List<InitialValidation> initValList = this.parseInitialValidationList(taskElem);
            ((PluggableTask)task).setInitialValidation(initValList);
        }
        if (severityStr != null) {
            SeverityType severity = this.getSeverityAttributeValue(severityStr);
            task.setSeverity(severity);
        }
        if ((moreDetailsId = this.getOptionalAttributeValue(taskElem, TaskFactoryConstants.XMLAttributes.MORE_DETAILS_ID)) != null) {
            String[] msgArgs = null;
            if (ei.getExecutableType().equals((Object)ExecutableType.SQL)) {
                msgArgs = new String[]{ei.getExecutableName()};
            }
            String moreDetails = this.getMoreDetailsMsg(moreDetailsId, msgArgs);
            task.setMoreDetails(moreDetails);
        }
        task.setBestPractice(isBestPractice);
        task.setBaseline(true);
        task.setTaskName(taskName);
        NodeList referenceNodeList = taskElem.getElementsByTagName(TaskFactoryConstants.XMLTags.REFERENCE);
        if (referenceNodeList.getLength() > 0) {
            ArrayList<String> referenceList = new ArrayList<String>();
            for (int i = 0; i < referenceNodeList.getLength(); ++i) {
                Element referenceElement = (Element)referenceNodeList.item(i);
                String reference = referenceElement.getFirstChild().getNodeValue();
                if (reference == null) continue;
                referenceList.add(reference.trim());
            }
            task.setReferences(referenceList);
        }
        return task;
    }

    private Task createJavaTask(String taskID, String className, String packageLoc, String[] nodeList, String[] idMsgParams, ExecutableInfo execInfo) throws XmlParserException {
        String classLoc = VerificationUtil.isStringGood(packageLoc) ? packageLoc : "oracle.ops.verification.framework.engine.task." + className;
        VerificationTaskContext taskData = new VerificationTaskContext(nodeList, execInfo);
        try {
            Class[] clsArr = new Class[]{VerificationTaskContext.class};
            Constructor constructor = PluggableTaskUtil.getClassConstructFromPackage(className, VerificationUtil.isStringGood(packageLoc) ? packageLoc : "oracle.ops.verification.framework.engine.task", clsArr);
            Object[] params = new Object[]{taskData};
            Task object = (Task)constructor.newInstance(params);
            return object;
        }
        catch (InstantiationException e) {
            VerificationUtil.traceAndLogError("error while constructing " + classLoc + " from class " + classLoc + " Error: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (IllegalAccessException e) {
            VerificationUtil.traceAndLogError("Illegal Access while constructing object of class " + classLoc + " Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (IllegalArgumentException e) {
            VerificationUtil.traceAndLogError("IllegalArgumentException while constructing object of class " + classLoc + " Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (InvocationTargetException e) {
            VerificationUtil.traceAndLogError("InvocationTargetException while constructing object of class " + classLoc + " Error is :\n" + e.getCause().getStackTrace());
            throw new XmlParserException(e.getMessage());
        }
        catch (NoSuchMethodException e) {
            VerificationUtil.traceAndLogError("Constructor " + classLoc + " not found in class " + classLoc + " Error: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (ClassNotFoundException e) {
            VerificationUtil.traceAndLogError("Class " + classLoc + " not found: " + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
        catch (ClassCastException e) {
            VerificationUtil.traceAndLogError("ClassCastException while casting the object of class " + classLoc + " to Task, Error is :\n" + e.getMessage());
            throw new XmlParserException(e.getMessage());
        }
    }

    private String getMoreDetailsMsg(String msgId, String[] msgArgs) {
        String message = null;
        try {
            Class<PrveMsgID> c = PrveMsgID.class;
            Field f = c.getField(msgId);
            String msgID = null;
            if (f != null) {
                msgID = f.get(null).toString();
            }
            message = msgID != null ? (msgArgs == null ? s_prveMsgBundle.getMessage(msgID, false) : s_prveMsgBundle.getMessage(msgID, false, (Object[])msgArgs)) : null;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        return message;
    }

    private List<InitialValidation> parseInitialValidationList(Element taskElem) {
        NodeList dbInstalled;
        ArrayList<InitialValidation> initValList = new ArrayList<InitialValidation>();
        NodeList crsInstalled = taskElem.getElementsByTagName(TaskFactoryConstants.XMLTags.CRS_INSTALLED);
        if (crsInstalled.getLength() > 0) {
            initValList.add(InitialValidation.CRS_INSTALL);
        }
        if ((dbInstalled = taskElem.getElementsByTagName(TaskFactoryConstants.XMLTags.DB_INSTALLED)).getLength() > 0) {
            initValList.add(InitialValidation.DB_INSTALL);
        }
        return initValList;
    }

    private boolean isApplicableToCurrentOS(Element taskElem, String distID) throws DOMException, XmlParserException {
        NodeList osNL = taskElem.getElementsByTagName(TaskFactoryConstants.XMLTags.OPERATING_SYSTEM);
        if (osNL.getLength() == 0) {
            return true;
        }
        for (int i = 0; i < osNL.getLength(); ++i) {
            Element osElem = (Element)osNL.item(i);
            String osType = this.getRequiredAttributeValue(osElem, TaskFactoryConstants.XMLAttributes.TYPE);
            String osVersion = this.getRequiredAttributeValue(osElem, TaskFactoryConstants.XMLAttributes.VERSION);
            String osArchitecture = this.getRequiredAttributeValue(osElem, TaskFactoryConstants.XMLAttributes.ARCHITECTURE);
            if (!this.matchOSType(osType) || !this.matchOSVersion(osVersion, distID) || !this.matchOSArchitecture(osArchitecture)) continue;
            return true;
        }
        return false;
    }

    private boolean matchOSType(String osType) {
        boolean osTypeMatches = false;
        if (osType.equalsIgnoreCase("all")) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase(VerificationUtil.getSupportedOSPlatform().toString())) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase("unix")) {
            osTypeMatches = new SystemFactory().CreateSystem().isUnixSystem();
        }
        return osTypeMatches;
    }

    private boolean matchOSVersion(String osVersion, String distID) {
        String[] osVersions;
        if (!VerificationUtil.isStringGood(distID)) {
            return false;
        }
        distID = distID.toUpperCase();
        if (osVersion.equalsIgnoreCase("all")) {
            return true;
        }
        ArrayList<String> inclusions = new ArrayList<String>();
        ArrayList<String> negations = new ArrayList<String>();
        for (String osV : osVersions = osVersion.split("/")) {
            if ((osV = osV.trim().toUpperCase()).startsWith("!")) {
                osV = osV.substring(osV.lastIndexOf("!") + 1);
                negations.add(osV);
                continue;
            }
            inclusions.add(osV);
        }
        if (negations.contains(distID)) {
            return false;
        }
        if (inclusions.isEmpty()) {
            return true;
        }
        return inclusions.contains(distID);
    }

    private boolean matchOSArchitecture(String string) {
        boolean matches = false;
        if (string.equalsIgnoreCase("all")) {
            matches = true;
        } else {
            String archRegEx = string.replaceAll("\\*", ".*");
            Pattern archPtn = Pattern.compile(archRegEx, 2);
            String osArch = VerificationUtil.getCurrentArch();
            if (osArch != null) {
                matches = archPtn.matcher(osArch).matches();
            }
        }
        return matches;
    }

    private ExecutableInfo parseExecutableInfo(String taskID, Element taskElem) throws XmlParserException {
        Trace.out((String)("taskID: '" + taskID + "'"));
        ExecutableInfo ei = null;
        ResultKeyType resKeyType = null;
        String resKeyStr = null;
        Element execInfoElem = this.getFirstChildByTagName(taskElem, TaskFactoryConstants.XMLTags.EXECUTABLE_INFO);
        String type = this.getRequiredAttributeValue(execInfoElem, TaskFactoryConstants.XMLAttributes.TYPE);
        String runOn = this.getOptionalAttributeValue(execInfoElem, "RUN_ON");
        InstanceType insType = this.mapInstanceType(runOn);
        ExecutableType execType = this.mapExecutableType(type);
        Element execResultTypeElem = this.getFirstChildByTagName(execInfoElem, TaskFactoryConstants.XMLTags.RESULT_TYPE);
        ExecutableResultType execResultType = ExecutableResultType.ANALYZED;
        if (this.getRequiredAttributeValue(execResultTypeElem, TaskFactoryConstants.XMLAttributes.VALUE).equals(ExecutableResultType.TO_BE_ANALYZED.toString())) {
            execResultType = ExecutableResultType.TO_BE_ANALYZED;
        }
        resKeyStr = this.getOptionalAttributeValue(execResultTypeElem, TaskFactoryConstants.XMLAttributes.KEY);
        resKeyType = ResultKeyType.getResultKeyType(resKeyStr);
        Trace.out((int)1, (String)("resKeyStr: '" + resKeyStr + "'"));
        NodeList inlineElemNL = execInfoElem.getElementsByTagName(TaskFactoryConstants.XMLTags.INLINE);
        NodeList javaElemNL = execInfoElem.getElementsByTagName(TaskFactoryConstants.XMLTags.JAVA);
        if (inlineElemNL.getLength() > 0) {
            Element inlineElem = (Element)inlineElemNL.item(0);
            String execName = this.getRequiredAttributeValue(inlineElem, TaskFactoryConstants.XMLAttributes.VALUE);
            ei = new ExecutableInfo(execName, execType, execResultType);
            ei.setInstanceType(insType);
            ei.setExecInfoKeyType(resKeyType);
            NodeList externalExecArgsList = inlineElem.getElementsByTagName(TaskFactoryConstants.XMLTags.ARG);
            for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                Element argElement = (Element)externalExecArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.NAME), TaskFactoryConstants.XMLAttributes.VALUE);
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.TYPE), TaskFactoryConstants.XMLAttributes.VALUE);
                String argValue = null;
                String argDefaultValue = null;
                ArgType execArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLTags.VAL);
                Element varElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.VAR);
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    execArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    argDefaultValue = this.getOptionalAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.DEFAULT);
                    execArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType execArgDataType = this.mapDataType(argType);
                ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue, argDefaultValue);
                ei.addExecArgument(execArg);
            }
        } else if (javaElemNL.getLength() > 0) {
            Element javaClassElem = (Element)javaElemNL.item(0);
            String javaClassName = this.getRequiredAttributeValue(javaClassElem, TaskFactoryConstants.XMLAttributes.NAME);
            ei = new ExecutableInfo(javaClassName, execType, execResultType);
            NodeList methodArgsList = javaClassElem.getElementsByTagName(TaskFactoryConstants.XMLTags.ARG);
            for (int i = 0; i < methodArgsList.getLength(); ++i) {
                Element argElement = (Element)methodArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.NAME), TaskFactoryConstants.XMLAttributes.VALUE);
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.TYPE), TaskFactoryConstants.XMLAttributes.VALUE);
                String argValue = null;
                String argDefaultValue = null;
                ArgType methodArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLTags.VAL);
                Element varElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.VAR);
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    methodArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    argDefaultValue = this.getOptionalAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.DEFAULT);
                    methodArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType methodArgDataType = this.mapDataType(argType);
                ExecutableArgument methodArg = new ExecutableArgument(argName, methodArgType, methodArgDataType, argValue, argDefaultValue);
                ei.addExecArgument(methodArg);
            }
        } else {
            Element externalExecElement = this.getFirstChildByTagName(execInfoElem, "EXTERNAL");
            Element externalExecNameElem = this.getFirstChildByTagName(externalExecElement, TaskFactoryConstants.XMLAttributes.NAME);
            String execName = this.getRequiredAttributeValue(externalExecNameElem, TaskFactoryConstants.XMLAttributes.VALUE);
            ei = new ExecutableInfo(execName, execType, execResultType);
            NodeList externalExecArgsList = externalExecElement.getElementsByTagName(TaskFactoryConstants.XMLTags.ARG);
            for (int i = 0; i < externalExecArgsList.getLength(); ++i) {
                Element argElement = (Element)externalExecArgsList.item(i);
                String argName = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.NAME), TaskFactoryConstants.XMLAttributes.VALUE);
                String argType = this.getRequiredAttributeValue(this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.TYPE), TaskFactoryConstants.XMLAttributes.VALUE);
                String argValue = null;
                String argDefaultValue = null;
                ArgType execArgType = null;
                Element valElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLTags.VAL);
                Element varElem = this.getFirstChildByTagName(argElement, TaskFactoryConstants.XMLAttributes.VAR);
                if (valElem != null) {
                    argValue = this.getRequiredAttributeValue(valElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    execArgType = ArgType.DEFINED;
                } else if (varElem != null) {
                    argValue = this.getRequiredAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.VALUE);
                    argDefaultValue = this.getOptionalAttributeValue(varElem, TaskFactoryConstants.XMLAttributes.DEFAULT);
                    execArgType = ArgType.DERIVED;
                } else {
                    throw new XmlParserException("Argument VAL or VAR not specified");
                }
                DataType execArgDataType = this.mapDataType(argType);
                ExecutableArgument execArg = new ExecutableArgument(argName, execArgType, execArgDataType, argValue, argDefaultValue);
                ei.addExecArgument(execArg);
            }
        }
        if (execResultType.equals((Object)ExecutableResultType.TO_BE_ANALYZED)) {
            this.parseAnalyzer(taskID, taskElem, ei);
        }
        return ei;
    }

    private void parseAnalyzer(String taskID, Element taskElem, ExecutableInfo ei) throws XmlParserException {
        Trace.out((String)"Method Entry.");
        Element analyzerElem = this.getFirstChildByTagName(taskElem, TaskFactoryConstants.XMLTags.ANALYZER);
        Element standardAnalyzerElem = this.getFirstChildByTagName(analyzerElem, TaskFactoryConstants.XMLTags.STANDARD_ANALYZER);
        Element sqlAnalyzerElem = this.getFirstChildByTagName(analyzerElem, TaskFactoryConstants.XMLTags.SQL_ANALYZER);
        DataComparator dc = null;
        if (standardAnalyzerElem != null) {
            Element comparatorElem = this.getFirstChildByTagName(standardAnalyzerElem, TaskFactoryConstants.XMLTags.COMPARATOR);
            dc = new StdDataComparator(this.parseReferenceInfo(comparatorElem));
        } else if (sqlAnalyzerElem != null) {
            String refColumn = null;
            boolean emptyResultSetImpliesSuccess = "true".equalsIgnoreCase(this.getOptionalAttributeValue(sqlAnalyzerElem, TaskFactoryConstants.XMLAttributes.EMPTY_RESULTSET_IMPLIES_SUCCESS));
            ArrayList<ReferenceInfo> columnReferenceList = new ArrayList<ReferenceInfo>();
            Element referenceColumnElem = this.getFirstChildByTagName(analyzerElem, TaskFactoryConstants.XMLTags.REFERENCE_COLUMN);
            if (referenceColumnElem != null) {
                refColumn = this.getRequiredAttributeValue(referenceColumnElem, TaskFactoryConstants.XMLAttributes.NAME);
            }
            NodeList refColumnNodeList = analyzerElem.getElementsByTagName(TaskFactoryConstants.XMLTags.COLUMN);
            ArrayList<String> columnNameList = new ArrayList<String>();
            for (int i = 0; i < refColumnNodeList.getLength(); ++i) {
                Element columnElem = (Element)refColumnNodeList.item(i);
                columnNameList.add(this.getRequiredAttributeValue(columnElem, TaskFactoryConstants.XMLAttributes.NAME));
                Element comparatorElem = this.getFirstChildByTagName(columnElem, TaskFactoryConstants.XMLTags.COMPARATOR);
                columnReferenceList.add(this.parseReferenceInfo(comparatorElem));
            }
            dc = this.m_darwinChecks ? new DarwinSQLDataComparator(taskID, refColumn, columnNameList, columnReferenceList, emptyResultSetImpliesSuccess) : new SQLDataComparator(taskID, refColumn, columnNameList, columnReferenceList, emptyResultSetImpliesSuccess);
        } else {
            Element externalAnalyzerElem = this.getFirstChildByTagName(analyzerElem, TaskFactoryConstants.XMLAttributes.EXTERNAL_ANALYZER);
            String globalAnalyzerStr = this.getOptionalAttributeValue(externalAnalyzerElem, TaskFactoryConstants.XMLAttributes.GLOBAL_ANALYZER);
            boolean globalAnalyzer = "TRUE".equalsIgnoreCase(globalAnalyzerStr);
            ExecutableInfo analyzerExecInfo = this.parseExecutableInfo(taskID, externalAnalyzerElem);
            analyzerExecInfo.setLocalNodeCheck(globalAnalyzer);
            dc = new ExternalDataComparator(analyzerExecInfo);
        }
        ei.setDataComparator(dc);
    }

    private ReferenceInfo parseReferenceInfo(Element comparatorElem) throws XmlParserException {
        String type = this.getRequiredAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.TYPE);
        DataType referenceDataType = this.mapDataType(type);
        DataComparatorType referenceDCT = null;
        Object referenceDataValue = null;
        String eq = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.EQ);
        String eq_no_case = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.EQ_NO_CASE);
        String ge = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.GE);
        String gt = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.GT);
        String le = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.LE);
        String lt = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.LT);
        String re = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.RE);
        String ne = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.NE);
        String in = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.IN);
        String not_in = this.getOptionalAttributeValue(comparatorElem, TaskFactoryConstants.XMLAttributes.NOT_IN);
        if (eq_no_case != null) {
            if (type.equalsIgnoreCase(DataType.STRING.toString())) {
                referenceDataValue = eq_no_case;
                referenceDCT = DataComparatorType.EQ_NO_CASE;
            } else {
                eq = eq_no_case;
            }
        }
        if (eq != null) {
            referenceDataValue = eq;
            referenceDCT = DataComparatorType.EQ;
        } else if (ne != null) {
            referenceDataValue = ne;
            referenceDCT = DataComparatorType.NE;
        } else if (re != null) {
            referenceDataValue = re;
            referenceDCT = DataComparatorType.RE;
        } else if (ge != null) {
            if (le != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GE, ge, RangeOperator.LE, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else if (lt != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GE, ge, RangeOperator.LT, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else {
                referenceDCT = DataComparatorType.GE;
                referenceDataValue = ge;
            }
        } else if (gt != null) {
            if (le != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GT, gt, RangeOperator.LE, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else if (lt != null) {
                referenceDCT = DataComparatorType.RANGE;
                RangeOfValue rov = new RangeOfValue(this.mapRangeType(type));
                try {
                    rov.include(RangeOperator.GT, gt, RangeOperator.LT, le);
                }
                catch (InvalidRangeManipulationException e) {
                    throw new XmlParserException(e.getMessage(), e);
                }
                referenceDataValue = rov;
            } else {
                referenceDCT = DataComparatorType.GT;
                referenceDataValue = gt;
            }
        } else if (le != null) {
            referenceDCT = DataComparatorType.LE;
            referenceDataValue = le;
        } else if (lt != null) {
            referenceDCT = DataComparatorType.LT;
            referenceDataValue = lt;
        } else if (in != null) {
            referenceDCT = DataComparatorType.IN;
            referenceDataValue = in;
        } else if (not_in != null) {
            referenceDCT = DataComparatorType.NOT_IN;
            referenceDataValue = not_in;
        }
        return new ReferenceInfo(referenceDataType, referenceDataValue, referenceDCT);
    }

    private ExecutableType mapExecutableType(String executableType) {
        Trace.out((int)5, (String)"Method Entry. executableType=%s", (Object[])new Object[]{executableType});
        ExecutableType et = ExecutableType.SHELL;
        if (ExecutableType.PERL.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.PERL;
        } else if (ExecutableType.SQL.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.SQL;
        } else if (ExecutableType.PLSQL.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.PLSQL;
        } else if (ExecutableType.BINARY.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.BINARY;
        } else if (ExecutableType.JAVA.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.JAVA;
        } else if (ExecutableType.SCRIPT.toString().equalsIgnoreCase(executableType)) {
            et = ExecutableType.SCRIPT;
        }
        return et;
    }

    private DataType mapDataType(String dataType) {
        Trace.out((int)5, (String)"Method Entry. dataType=%s", (Object[])new Object[]{dataType});
        DataType dt = DataType.STRING;
        if (DataType.NUMERIC.toString().equalsIgnoreCase(dataType)) {
            dt = DataType.NUMERIC;
        } else if (DataType.VERSION.toString().equalsIgnoreCase(dataType)) {
            dt = DataType.VERSION;
        } else if (DataType.LIST.toString().equalsIgnoreCase(dataType)) {
            dt = DataType.LIST;
        } else if (DataType.EXECUTABLE.toString().equalsIgnoreCase(dataType)) {
            dt = DataType.EXECUTABLE;
        }
        return dt;
    }

    private RangeType mapRangeType(String rangeType) {
        Trace.out((int)5, (String)"Method Entry. dataType=%s", (Object[])new Object[]{rangeType});
        RangeType rt = RangeType.STRING;
        if (DataType.NUMERIC.toString().equalsIgnoreCase(rangeType)) {
            rt = RangeType.FLOAT;
        } else if (DataType.VERSION.toString().equalsIgnoreCase(rangeType)) {
            rt = RangeType.VERSION;
        }
        return rt;
    }

    private InstanceType mapInstanceType(String runOn) {
        Trace.out((String)("Method Entry. runOn = " + runOn));
        InstanceType insType = InstanceType.DB;
        if ("ASM".equals(runOn)) {
            insType = InstanceType.ASM;
        }
        return insType;
    }

    private String getRequiredAttributeValue(Element elem, String key) throws XmlParserException {
        if (!elem.hasAttribute(key)) {
            String[] msgParams = new String[]{elem.getTagName(), key};
            String msg = "A required attribute is missing";
            Trace.out((String)msg);
            throw new XmlParserException(msg);
        }
        String value = elem.getAttribute(key);
        return value;
    }

    private String getOptionalAttributeValue(Element elem, String key) {
        String attributeValue = null;
        if (elem.hasAttribute(key)) {
            attributeValue = elem.getAttribute(key);
        }
        return attributeValue;
    }

    private Element getFirstChildByTagName(Element osElem, String elemName) throws XmlParserException {
        if (osElem == null || elemName == null) {
            return null;
        }
        NodeList nl = osElem.getElementsByTagName(elemName);
        if (nl.getLength() >= 1) {
            return (Element)nl.item(0);
        }
        return null;
    }

    private SeverityType getSeverityAttributeValue(String severityStr) throws XmlParserException {
        SeverityType severity = SeverityType.CRITICAL;
        if (SeverityType.FATAL.toString().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.FATAL;
        } else if (SeverityType.IGNORABLE.toString().equalsIgnoreCase(severityStr)) {
            severity = SeverityType.IGNORABLE;
        }
        return severity;
    }

    private List<OperationMode> parseOperationModes(String operationModeStr, boolean onlyNegations) {
        String[] modesArray;
        ArrayList<OperationMode> modes = new ArrayList<OperationMode>();
        if (VerificationUtil.isStringGood(operationModeStr) && (modesArray = VerificationUtil.string2strArr(operationModeStr)) != null && modesArray.length > 0) {
            for (String mode : modesArray) {
                OperationMode modeType = null;
                if ((mode = mode.trim()).startsWith("!")) {
                    modeType = OperationMode.valueOf(mode.substring(1));
                    modes.add(modeType);
                    continue;
                }
                modeType = OperationMode.valueOf(mode);
                if (onlyNegations) continue;
                modes.add(modeType);
            }
        }
        return modes;
    }

    private Element getTargetForRelease(Element releaseElem, String targetID) throws XmlParserException {
        Element targetElem = null;
        if (releaseElem != null) {
            NodeList targetList = releaseElem.getElementsByTagName(TaskFactoryConstants.XMLTags.TARGET);
            if (VerificationUtil.isStringGood(targetID) && targetList != null) {
                for (int i = 0; i < targetList.getLength(); ++i) {
                    Element elem = (Element)targetList.item(i);
                    String id = this.getRequiredAttributeValue(elem, TaskFactoryConstants.XMLAttributes.ID);
                    if (!targetID.equalsIgnoreCase(id)) continue;
                    targetElem = elem;
                    break;
                }
            }
        }
        return targetElem;
    }

    private boolean isApplicableForCurrentOperationMode(String taskOperationModeStr) {
        boolean retVal = true;
        List<OperationMode> allModes = this.parseOperationModes(taskOperationModeStr, false);
        List<OperationMode> negations = this.parseOperationModes(taskOperationModeStr, true);
        for (OperationMode mode : allModes) {
            boolean isModeCurrent = false;
            switch (mode) {
                case cli: {
                    isModeCurrent = VerificationUtil.isCLIMode();
                    break;
                }
                case api: {
                    isModeCurrent = VerificationUtil.isAPIMode();
                    break;
                }
                case bestpractice: {
                    isModeCurrent = VerificationUtil.isBestPracticeMode();
                    break;
                }
                case baseline: {
                    isModeCurrent = VerificationUtil.isBaselineCollectionMode();
                    break;
                }
                case healthcheck: {
                    isModeCurrent = VerificationUtil.isHealthCheckMode();
                    break;
                }
                case resource: 
                case resource_h: 
                case resource_q: {
                    isModeCurrent = VerificationUtil.isCVUResource();
                    break;
                }
                case all: {
                    isModeCurrent = true;
                }
            }
            if (negations.contains((Object)mode)) {
                retVal &= !isModeCurrent;
                continue;
            }
            retVal &= isModeCurrent;
        }
        return retVal;
    }

    public static void main(String[] args) {
        if (!VerificationUtil.isCVUTestEnv()) {
            System.exit(0);
        }
        String tracePackages = new String("oracle.cluster.verification.constraints,oracle.cluster.verification.constraints.parser");
        if (System.getSecurityManager() == null) {
            System.setSecurityManager((SecurityManager)new NullSecurityManager());
        }
        System.setProperty("TRACING.ENABLED", "true");
        System.setProperty("TRACING.LEVEL", "5");
        System.setProperty("TRACING.PACKAGE", tracePackages);
        String logDir = VerificationUtil.getTraceLoc();
        if (logDir == null) {
            logDir = VerificationUtil.getCVHome();
        }
        if (logDir == null) {
            logDir = "./";
        }
        Trace.out((String)("logDir = " + logDir));
        Trace.out((String)("log file = " + logDir + "trace.log"));
        Trace.configure((boolean)true, (boolean)true, (boolean)true, (boolean)true, (String)(logDir + "trace.log"), (boolean)true);
        ParamManager paramMgr = null;
        try {
            paramMgr = ParamManager.getInstance(OperationMode.api, args);
        }
        catch (InvalidCommandlineException e) {
            e.printStackTrace();
        }
        String[] nodelist = null;
        try {
            nodelist = VerificationUtil.getNodelist();
        }
        catch (NodelistNotFoundException e) {
            e.printStackTrace();
        }
        String classpath = System.getProperty("CLASSPATH");
        Trace.out((String)("System property CLASSPATH: " + classpath));
        String cp = System.getenv("CLASSPATH");
        Trace.out((String)("Env CLASSPATH: " + cp));
        TaskFactoryXmlParser parser = new TaskFactoryXmlParser();
        try {
            List<Task> taskList = parser.getTasks("11gR2", "OEL5", "STAGE_PRE_CRSINST", null);
            if (taskList != null) {
                for (Task task : taskList) {
                    System.out.println(task);
                }
            }
        }
        catch (XmlParserException e) {
            e.printStackTrace(System.out);
        }
        catch (Exception xe) {
            xe.printStackTrace(System.out);
        }
    }
}

