/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class OLRComponent
extends Component {
    private String m_olrLocation;

    OLRComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    protected boolean checkSetup() {
        ErrorDescription errDesc = null;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"==== OLR Component checkSetup");
        }
        super.checkSetup();
        if (this.getValidNodeList() == null) {
            return false;
        }
        if (!VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
            errDesc = new ErrorDescription("5314", s_msgBundle);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList[0], 2);
            ReportUtil.printError(errDesc.getErrorMessage() + LSEP + s_msgBundle.getMessage("0007", false) + LSEP);
            return false;
        }
        return true;
    }

    @Override
    public boolean verify() {
        if (!this.checkSetup()) {
            return false;
        }
        if (null == this.getValidNodeList()) {
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_OLR_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "OLR";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9964", false);
    }
}

