/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.VerificationUtil;

public class OHASDComponent
extends Component {
    OHASDComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        this.checkSetup();
        if (null == this.getValidNodeList()) {
            return false;
        }
        if (!VerificationUtil.isHAConfigured() && !VerificationUtil.isCRSConfigured()) {
            Trace.out((String)"No CRS or HA is found installed on local node");
            String errorMsg = s_msgBundle.getMessage("5314", true);
            ReportUtil.printError(errorMsg);
            ErrorDescription errDesc = new ErrorDescription(errorMsg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.getValidNodeList(), 2);
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_OHASD_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "OHASD";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9963", false);
    }
}

