/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.ParamPreReqCFSSetup;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.engine.factory.context.GlobalVerificationContext;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;

public class CFSComponent
extends Component {
    String m_fileSystem;

    CFSComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
        this.m_fileSystem = CVUVariables.getValue(CVUVariableConstants.FILE_SYSTEM);
        Trace.out((String)("==== ParamManager reports File System is: " + this.m_fileSystem));
        ParamPreReqCFSSetup param = new ParamPreReqCFSSetup();
        param.setFileSystem(this.m_fileSystem);
        try {
            GlobalVerificationContext.getInstance().setParamPrereq(param, this.m_verificationType);
        }
        catch (VerificationException e) {
            Trace.out((String)("Caught VerificationException while setting the param prereq. Error is :" + e.getMessage()));
            throw new ComponentInitException(e.getMessage());
        }
    }

    @Override
    public boolean verify() {
        Trace.out((String)"Commencing CFS Integrity verify()...");
        this.checkSetup();
        if (null == this.getValidNodeList()) {
            Trace.out((String)"No valid nodes found. Returning");
            return false;
        }
        switch (this.m_verificationType) {
            case COMPONENT_CFS_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "CFS";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9951", false);
    }
}

