/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.component;

import oracle.cluster.verification.util.VerificationType;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.component.Component;
import oracle.ops.verification.framework.engine.component.ComponentInitException;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ASMComponent
extends Component {
    ASMComponent(VerificationType verificationType) throws ComponentInitException {
        super(verificationType);
        this.init();
    }

    @Override
    public void init() throws ComponentInitException {
        super.init();
    }

    @Override
    public boolean verify() {
        Trace.out((String)"Commencing ASM Integrity verify()...");
        this.checkSetup();
        String[] validNodeArr = this.getValidNodeList();
        if (null == validNodeArr) {
            Trace.out((String)"No valid nodes found. Returning");
            return false;
        }
        String[] crsNodes = VerificationUtil.getNodesWithCRSInstall(validNodeArr, this.m_resultSet);
        if (null == crsNodes) {
            Trace.out((String)"CRS is not installed on any of the nodes, skipping check");
            this.m_resultSet.addErrorDescription(new ErrorDescription(s_msgBundle.getMessage("4037", true)));
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        this.setValidNodeList(crsNodes);
        switch (this.m_verificationType) {
            case COMPONENT_ASM_INTEGRITY: {
                return super.verifyComponent();
            }
        }
        Trace.out((String)"ERROR: Invalid Verification Type!");
        return false;
    }

    @Override
    public String getComponentName() {
        return "ASM";
    }

    @Override
    public String getComponentDisplayName() {
        return s_msgBundle.getMessage("9950", false);
    }
}

