/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageUnit;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.config.Constraint;
import oracle.ops.verification.framework.config.InvalidConstraintDataException;
import oracle.ops.verification.framework.config.PeerCompatible;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.report.ReportUtil;

public class SwapConstraint
extends Constraint
implements PeerCompatible {
    private static String CONSTRAINT_NAME = s_msgBundle.getMessage("1057", false);
    private double m_reqSwap = 0.0;

    public SwapConstraint(String quali, String fbaction, long val) {
        super("SWAP", quali, fbaction);
        this.m_reqSwap = val;
        this.setValid(false);
    }

    public SwapConstraint(Hashtable ht) throws InvalidConstraintDataException {
        super("SWAP");
        this.validate(ht);
        this.m_qualifier = (String)ht.get("Qualifier");
        this.m_fbAction = (String)ht.get("FallbackAction");
        if (!this.m_qualifier.equals("COMPARE")) {
            Vector rdVec = (Vector)ht.get("RefData");
            this.m_reqSwap = Double.parseDouble((String)rdVec.firstElement());
        }
        this.setValid(true);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("SwapConstraint[");
        sb.append("Qualifier: " + this.m_qualifier);
        sb.append(", FallbackAction: " + this.m_fbAction);
        sb.append(", Swap reqd: " + this.m_reqSwap + "]");
        return sb.toString();
    }

    @Override
    public void validate(Hashtable ht) throws InvalidConstraintDataException {
        super.validate(ht);
        if (!((String)ht.get("Type")).equals("SWAP")) {
            throw new InvalidConstraintDataException("Constraint type does not match");
        }
        String quali = (String)ht.get("Qualifier");
        int dsetlen = 0;
        if (quali.equals("GT") || quali.equals("GTE")) {
            if (!ht.containsKey("RefData")) {
                throw new InvalidConstraintDataException("Missing RefData");
            }
            try {
                Vector rdVec = (Vector)ht.get("RefData");
                Double.parseDouble((String)rdVec.firstElement());
            }
            catch (NumberFormatException nfe) {
                throw new InvalidConstraintDataException(nfe.getMessage());
            }
            dsetlen = 4;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
                throw new InvalidConstraintDataException(errtxt);
            }
        } else if (quali.equals("COMPARE")) {
            dsetlen = 3;
            if (ht.size() != dsetlen) {
                String errtxt = "Invalid data set for " + this.getClass().getName() + ". EXPECTED: " + dsetlen + ", FOUND: " + ht.size();
                throw new InvalidConstraintDataException(errtxt);
            }
        } else {
            throw new InvalidConstraintDataException("Qualifier '" + quali + "' is not supported for " + this.getClass().getName());
        }
    }

    @Override
    public boolean applyConstraint(String[] nodeList, ResultSet rset) throws InvalidConstraintDataException {
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Can not apply invalid constraint");
        }
        GlobalExecution globalExec = new GlobalExecution();
        return globalExec.checkSwapSpace(nodeList, new StorageSize(this.m_reqSwap, StorageUnit.KBYTE), rset);
    }

    @Override
    public boolean checkCompatibility(String[] nodeList, String refNode, ResultSet resultSet) throws InvalidConstraintDataException {
        Trace.out((String)("Checking compatibility:" + this));
        if (!this.isValid()) {
            throw new InvalidConstraintDataException("Invalid constraint. Compatibility check can not proceed");
        }
        GlobalExecution globalExec = new GlobalExecution();
        boolean cmdStatus = globalExec.checkSwapSpace(nodeList, 0L, resultSet);
        if (refNode == null || refNode.trim().length() == 0) {
            return cmdStatus;
        }
        Hashtable ht = resultSet.getResultTable();
        if (!ht.containsKey(refNode)) {
            Trace.out((String)"==== ERROR: refnode data missing");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        Result refResult = (Result)ht.get(refNode);
        if (refResult.getStatus() == 2) {
            Trace.out((String)"==== ERROR: execution error at refnode");
            resultSet.addResult(nodeList, 2);
            resultSet.setStatus();
            return false;
        }
        StorageSize refSS = (StorageSize)refResult.getResultInfoSet().firstElement();
        String refDataStr = Double.toString(refSS.sizeIn(StorageUnit.KBYTE));
        this.m_reqSwap = Double.parseDouble(refDataStr);
        Trace.out((String)("==== Reference data: " + this.m_reqSwap));
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            boolean compStatus;
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                continue;
            }
            if (result.getStatus() == 2) continue;
            StorageSize avlSS = (StorageSize)result.getResultInfoSet().firstElement();
            String dataStr = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
            double data = Double.parseDouble(dataStr);
            Trace.out((String)("==== Refdata:" + refDataStr + "Nodedata: " + dataStr));
            boolean bl = compStatus = data == this.m_reqSwap;
            if (compStatus) {
                result.setStatus(1);
                Trace.out((String)"==== Result status reset to op_successful");
                continue;
            }
            result.setStatus(3);
            Trace.out((String)"==== Result status reset to vf_failed");
        }
        resultSet.setStatus();
        return cmdStatus;
    }

    @Override
    public void report(ResultSet rsltSet) {
        ReportUtil.blankln();
        ReportUtil.println(s_msgBundle.getMessage("1000", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.writeColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REQUIRED, ReportUtil.COMMENT);
        Hashtable t = rsltSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String comment;
            String avl;
            StorageSize avlSS;
            String node = (String)e.nextElement();
            String reqd = Double.toString(this.m_reqSwap);
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                comment = ReportUtil.PASSED;
            } else if (result.getStatus() == 3) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                comment = ReportUtil.FAILED;
            } else {
                avl = ReportUtil.UNKNOWN;
                comment = ReportUtil.FAILED;
            }
            ReportUtil.writeRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(reqd, StorageUnit.KBYTE), comment);
        }
        if (rsltSet.getStatus() == 1) {
            ReportUtil.printResult(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.printResult(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
            ReportUtil.printErrorNodes(rsltSet);
        }
    }

    @Override
    public void reportCompatibility(ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1005", false, (Object[])new String[]{CONSTRAINT_NAME}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, CONSTRAINT_NAME);
        Hashtable t = resultSet.getResultTable();
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String avl;
            StorageSize avlSS;
            String node = (String)e.nextElement();
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
            } else if (result.getStatus() == 3) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
            } else {
                avl = ReportUtil.UNKNOWN;
            }
            ReportUtil.surewriteRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE));
        }
        if (t.size() > 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1007", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }

    @Override
    public void reportCompatibility(String refNode, ResultSet resultSet) {
        ReportUtil.sureblankln();
        ReportUtil.sureprintln(s_msgBundle.getMessage("1009", false, (Object[])new String[]{CONSTRAINT_NAME, refNode}));
        ReportUtil.surewriteColHeaders(ReportUtil.NODENAME, ReportUtil.AVAILABLE, ReportUtil.REF_STATUS, ReportUtil.COMMENT);
        Hashtable t = resultSet.getResultTable();
        String reqd = Double.toString(this.m_reqSwap);
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String comment;
            String avl;
            StorageSize avlSS;
            String node = (String)e.nextElement();
            if (node.equals(refNode)) continue;
            Result result = (Result)t.get(node);
            if (result.getStatus() == 1) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                comment = ReportUtil.MATCHED;
            } else if (result.getStatus() == 3) {
                avlSS = (StorageSize)result.getResultInfoSet().firstElement();
                avl = Double.toString(avlSS.sizeIn(StorageUnit.KBYTE));
                comment = ReportUtil.MISMATCHED;
            } else {
                avl = ReportUtil.UNKNOWN;
                comment = ReportUtil.MISMATCHED;
            }
            ReportUtil.surewriteRecord(node, ReportUtil.unitizeSize(avl, StorageUnit.KBYTE), ReportUtil.unitizeSize(reqd, StorageUnit.KBYTE), comment);
        }
        if (resultSet.getStatus() == 1) {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1001", false, (Object[])new String[]{CONSTRAINT_NAME}));
        } else {
            ReportUtil.sureprintln(s_msgBundle.getMessage("1003", false, (Object[])new String[]{CONSTRAINT_NAME}));
        }
    }
}

