/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.ComponentCollector;
import oracle.ops.verification.framework.config.ComponentSoftwareDistribution;
import oracle.ops.verification.framework.config.DPMComponentCollector;
import oracle.ops.verification.framework.config.SoftwareConfigException;
import oracle.ops.verification.framework.util.FileInfo;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.ois.oisc.oiscu.OiscuFatalException;
import oracle.sysman.ois.oisc.oiscx.OiscxComponentBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxFileMapReader;
import oracle.sysman.ois.oisc.oiscx.OiscxFilesListBuilder;
import oracle.sysman.ois.oisc.oiscx.OiscxIncludeData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SoftwareConfigXMLGenerator {
    String m_sMapFile = "";
    String m_sCompName = null;
    String m_sPathToSourceHome = null;
    String m_sCompLangs = "";
    String m_commonPlatform = "";
    String m_specificPlatform = "";
    private String SRCHOME_PROPERTY = "SRCHOME";
    private final String SRCHOME_ENV = "SRCHOME";
    private final String PLATFORM_COMMON_DIST_DIR = "PLATFORM_COMMON_DIST_DIR";
    private final String PLATFORM_SPECIFIC_DIST_DIR = "PLATFORM_SPECIFIC_DIST_DIR";
    static final String DATABASE_COMPONENT = "database";
    static final String TAG_COMPONENT_NAME = "Name";
    static final String TAG_FILE = "File";
    static final String TAG_CONDITION = "CONDITION";
    static final String TAG_CONDITION_VAR = "VAR";
    static final String TAG_CONDITION_EQUALS = "EQ";
    static final String VALUE_CONDITION_VAR = "DB_EDITION";
    static final String VALUE_CONDITION_EQUALS = "EE";
    static final String TAG_COMPONENT = "Component";
    static final String TAG_ATT_CONDITION_NAME = "name";
    private static final String TAG_VERSION = "version";
    private static final String TAG_VERSION_VALUE = "122";
    private static final String CRS_TOP_COMPONENT = "crs";
    private static final String HA_TOP_COMPONENT = "ha";
    private static final String DATABASE_TOP_COMPONENT = "database";
    private static final String[] INSTALLER_ROOTED_FILES = new String[]{"%ORACLE_HOME%/bin/extjob", "%ORACLE_HOME%/bin/oradism", "%ORACLE_HOME%/bin/jssu"};
    ComponentCollector m_componentCollector;
    Properties m_oProperties = new Properties();
    Properties m_oSLVProps = new Properties();
    List<String> m_generatedFiles = new ArrayList<String>();
    String crsConfigFilePerms = null;
    String crsConfigDirs = null;
    String crsConfigFiles = null;
    String excludeListFile = null;
    String relinkedListFile = null;
    String cusMakeListFile = null;
    static String m_product = null;
    List<String> crsConfigFilesHM = new ArrayList<String>();
    List<String> excludedFiles = new ArrayList<String>();
    List<String> relinkedFiles = new ArrayList<String>();
    List<String> cusMakeFiles = new ArrayList<String>();
    HashMap<String, HashMap<String, String>> crsConfigFilePermsHM = new LinkedHashMap<String, HashMap<String, String>>();
    HashMap<String, HashMap<String, String>> crsConfigDirsHM = new LinkedHashMap<String, HashMap<String, String>>();
    static boolean s_unixSystem = false;

    public SoftwareConfigXMLGenerator(ComponentCollector collector) {
        if (collector == null) {
            throw new IllegalArgumentException("The collector object can not be null");
        }
        this.m_componentCollector = collector;
    }

    public static final void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Insufficient arguments.");
            SoftwareConfigXMLGenerator.printUsage();
            System.exit(-1);
        }
        try {
            DPMComponentCollector componentCollector = new DPMComponentCollector();
            SoftwareConfigXMLGenerator crsSCG = new SoftwareConfigXMLGenerator(componentCollector);
            crsSCG.generate(args, CRS_TOP_COMPONENT);
            SoftwareConfigXMLGenerator haSCG = new SoftwareConfigXMLGenerator(componentCollector);
            haSCG.generate(args, HA_TOP_COMPONENT);
            SoftwareConfigXMLGenerator dbSCG = new SoftwareConfigXMLGenerator(componentCollector);
            dbSCG.generate(args, "database");
        }
        catch (MalformedURLException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (IOException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SAXException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (ParserConfigurationException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (TransformerException e) {
            System.out.println("Error occured while generating XML:");
            e.printStackTrace();
            System.exit(-1);
        }
        catch (SoftwareConfigException sce) {
            System.out.println("Error occured while generating XML:");
            sce.printStackTrace();
            System.exit(-1);
        }
    }

    public void generate(String[] args, String argComponent) throws IOException, MalformedURLException, SAXException, ParserConfigurationException, TransformerException, SoftwareConfigException {
        String[] tokensXml;
        String outputXML = null;
        String componentName = null;
        String mapFileXSD = null;
        String srcHome = null;
        boolean bIsHelp = false;
        for (int i = 0; !bIsHelp && i < args.length; ++i) {
            if (args[i].equalsIgnoreCase("-xsd") && mapFileXSD == null) {
                mapFileXSD = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-output") && outputXML == null) {
                outputXML = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-srcHome") && srcHome == null) {
                srcHome = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-crsconfig_fileperms") && this.crsConfigFilePerms == null) {
                this.crsConfigFilePerms = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-crsconfig_dirs") && this.crsConfigDirs == null) {
                this.crsConfigDirs = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-crsconfig_files") && this.crsConfigFiles == null) {
                this.crsConfigFiles = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-exclude_list") && this.excludeListFile == null) {
                this.excludeListFile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-relinked_list") && this.relinkedListFile == null) {
                this.relinkedListFile = args[++i].trim();
            } else if (args[i].equalsIgnoreCase("-cus_list") && this.cusMakeListFile == null) {
                this.cusMakeListFile = args[++i].trim();
            } else {
                bIsHelp = true;
                break;
            }
            if (!args[i].trim().equalsIgnoreCase("-help")) continue;
            bIsHelp = true;
            break;
        }
        componentName = argComponent;
        if (bIsHelp) {
            SoftwareConfigXMLGenerator.printUsage();
            return;
        }
        if (srcHome == null) {
            srcHome = System.getenv("SRCHOME");
        }
        if (m_product == null) {
            Trace.out((String)"NDE_PRODUCT environment variable is not set");
            return;
        }
        if (m_product.equals("has") && (tokensXml = outputXML.split("/")) != null && tokensXml.length > 0) {
            outputXML = srcHome + "/" + "cv" + "/" + "cvdata" + "/" + tokensXml[tokensXml.length - 1];
            Trace.out((String)("outputFile has[" + outputXML + "]"));
        }
        this.m_commonPlatform = System.getenv("PLATFORM_COMMON_DIST_DIR");
        this.m_specificPlatform = System.getenv("PLATFORM_SPECIFIC_DIST_DIR");
        if (this.m_commonPlatform == null) {
            Trace.out((String)"PLATFORM_COMMON_DIST_DIR environment variable is not set");
            return;
        }
        if (this.m_specificPlatform == null) {
            Trace.out((String)"PLATFORM_SPECIFIC_DIST_DIR environment variable is not set");
            return;
        }
        Trace.out((String)("env srcHome[" + srcHome + "] commonPlatform[" + this.m_commonPlatform + "] specificPlatform[" + this.m_specificPlatform + "]"));
        Trace.out((String)("outputXML[" + outputXML + "]"));
        File outputXMLFile = new File(outputXML);
        Document softwareDocument = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder softwareConfBuilder = factory.newDocumentBuilder();
        Element softwareComponentsEle = null;
        Element existingSoftCompEle = null;
        if (outputXMLFile.exists()) {
            softwareDocument = softwareConfBuilder.parse(outputXMLFile);
            softwareComponentsEle = softwareDocument.getDocumentElement();
            NodeList softComponentList = softwareComponentsEle.getElementsByTagName("SoftwareComponent");
            for (int i = 0; i < softComponentList.getLength(); ++i) {
                Element ele = (Element)softComponentList.item(i);
                if (!ele.getAttribute(TAG_COMPONENT_NAME).equals(componentName)) continue;
                existingSoftCompEle = ele;
            }
        } else {
            softwareDocument = softwareConfBuilder.newDocument();
            softwareComponentsEle = softwareDocument.createElement("SoftwareComponents");
            softwareComponentsEle.setAttribute(TAG_VERSION, TAG_VERSION_VALUE);
        }
        Element softwareComponentEle = softwareDocument.createElement("SoftwareComponent");
        softwareComponentEle.setAttribute(TAG_COMPONENT_NAME, componentName);
        this.process(componentName, mapFileXSD, srcHome, this.crsConfigFiles, this.crsConfigFilePerms, this.crsConfigDirs, softwareDocument, softwareComponentEle);
        if (existingSoftCompEle != null) {
            softwareComponentsEle.replaceChild(softwareComponentEle, existingSoftCompEle);
        } else {
            softwareComponentsEle.appendChild(softwareComponentEle);
        }
        this.printSoftwareConfFile(softwareComponentsEle, outputXML);
    }

    private String getSrcHome(String srcHome, String mapFile) {
        String retVal = srcHome;
        if (mapFile.contains("oracle.bali.dbui4")) {
            retVal = srcHome + File.separator + ".." + File.separator + "jewt" + File.separator + "dist" + File.separator + "oracle.bali.dbui4";
        }
        if (mapFile.contains("oracle.bali.ewt")) {
            retVal = srcHome + File.separator + ".." + File.separator + "ewt" + File.separator + "dist" + File.separator + "oracle.bali.ewt";
        }
        if (mapFile.contains("oracle.bali.jewt")) {
            retVal = srcHome + File.separator + ".." + File.separator + "jdevadf" + File.separator + "dist" + File.separator + "oracle.bali.jewt";
        }
        if (mapFile.contains("oracle.bali.jle3")) {
            retVal = srcHome + File.separator + ".." + File.separator + "jewt" + File.separator + "dist" + File.separator + "oracle.bali.jle3";
        }
        if (mapFile.contains("oracle.bali.share")) {
            retVal = srcHome + File.separator + ".." + File.separator + "balishare" + File.separator + "dist" + File.separator + "oracle.bali.share";
        }
        Trace.out((String)("Setting slv property srcHome=" + retVal + " for mapfile " + mapFile));
        return retVal;
    }

    private static void printUsage() {
        System.out.println("Input Parameters:  -mapfiles <comma separated map file names>");
        System.out.println("-xsd <map file xsd schema>");
        System.out.println("-comp <cmponent name, crs|database>");
        System.out.println("-output <output xml file>");
        System.out.println("-srcHome <source home>");
        System.out.println("-crsconfig_fileperms <crs config file perms>");
        System.out.println("-crsconfig_files <crs config files>");
        System.out.println("-exclude_list <file containing list of files to be excluded>");
        System.out.println("-relinked_list <file containing list of files relinked>");
        System.out.println("-help <print usage>");
    }

    private void printSoftwareConfFile(Element rootElement, String outputFile) throws TransformerException, FileNotFoundException {
        DOMSource xmlSource = new DOMSource(rootElement);
        StreamResult result = new StreamResult(new FileOutputStream(outputFile));
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.transform(xmlSource, result);
    }

    public void process(String componentName, String schemaLoc, String srcHome, String crsConfigFiles, String crsConfigFilePerms, String crsConfigDirs, Document softwareDocument, Element softwareComponentEle) throws SoftwareConfigException {
        boolean gridComponent;
        String currentOSFamily = "unix";
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        if (!nativeSystem.isUnixSystem()) {
            currentOSFamily = "windows";
        }
        boolean bl = gridComponent = CRS_TOP_COMPONENT.equalsIgnoreCase(componentName) || HA_TOP_COMPONENT.equalsIgnoreCase(componentName);
        if (gridComponent && crsConfigFiles != null) {
            this.processCrsConfigFiles(crsConfigFiles, this.crsConfigFilesHM, currentOSFamily, HA_TOP_COMPONENT.equalsIgnoreCase(componentName));
        }
        if (gridComponent && crsConfigFilePerms != null) {
            this.processCrsConfigFilePerms(crsConfigFilePerms, this.crsConfigFilePermsHM, currentOSFamily, HA_TOP_COMPONENT.equalsIgnoreCase(componentName));
        }
        if (gridComponent && crsConfigDirs != null) {
            this.processCrsConfigDirs(crsConfigDirs, this.crsConfigDirsHM, currentOSFamily, HA_TOP_COMPONENT.equalsIgnoreCase(componentName));
        }
        if (this.excludeListFile != null) {
            this.processExcludeFiles();
        }
        if (this.relinkedListFile != null) {
            this.processRelinkedFiles();
        }
        if (this.cusMakeListFile != null) {
            this.processCusMakeFiles();
        }
        try {
            System.setProperty("OSP_Schema_Location", schemaLoc);
            String key = "%" + this.SRCHOME_PROPERTY + "%";
            List<ComponentSoftwareDistribution> components = this.m_componentCollector.getComponentList(componentName);
            if (components == null) {
                throw new SoftwareConfigException("Error getting the list of components");
            }
            this.m_oSLVProps.setProperty("%PLATFORM_COMMON_DIST_DIR%", this.m_commonPlatform);
            this.m_oSLVProps.setProperty("%PLATFORM_SPECIFIC_DIST_DIR%", this.m_specificPlatform);
            String mapFile = null;
            for (ComponentSoftwareDistribution component : components) {
                mapFile = component.getMapFileName();
                File fMAP = new File(mapFile);
                if (!fMAP.exists() || !fMAP.isFile()) {
                    this.logErr("Invalid MAP file:" + mapFile, null, 0, false);
                    continue;
                }
                this.m_oSLVProps.setProperty(key, this.getSrcHome(srcHome, mapFile));
                this.generateFileList(component, srcHome, mapFile, softwareDocument, softwareComponentEle, this.crsConfigFilesHM, this.crsConfigFilePermsHM, gridComponent);
            }
            for (String file : this.crsConfigFilesHM) {
                String[] srcDest = file.split("\\|");
                this.createElement(softwareDocument, softwareComponentEle, srcDest[1], null, null, null, this.crsConfigFilePermsHM, gridComponent);
            }
            for (String file : this.crsConfigDirsHM.keySet()) {
                HashMap<String, String> attributes = this.crsConfigDirsHM.get(file);
                this.createElement(softwareDocument, softwareComponentEle, file, attributes.get("PERMISSIONS"), attributes.get("OWNER"), attributes.get("GROUP"), this.crsConfigFilePermsHM, gridComponent);
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            e.printStackTrace();
        }
    }

    private String getCusFilePermissions(String fileName) {
        String tmpPath = null;
        String path = null;
        String fileCusName = null;
        String fileCusPerms = null;
        for (String line : this.cusMakeFiles) {
            String[] tokens = line.split(" ");
            if (tokens == null || tokens.length < 2) continue;
            fileCusPerms = tokens[0];
            tmpPath = tokens[1];
            if ((tokens = tmpPath.split(VerificationConstants.FSEP)).length == 1) {
                path = tokens[0];
            }
            if (tokens.length > 1) {
                fileCusName = tokens[tokens.length - 1];
            }
            if (!fileName.equals(fileCusName)) continue;
            return fileCusPerms;
        }
        return null;
    }

    private void processCrsConfigFilePerms(String crsConfigFilePerms, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM, String currentOSFamily, boolean isHA) {
        try {
            BufferedReader filePermsReader = new BufferedReader(new FileReader(crsConfigFilePerms));
            String line = null;
            while ((line = filePermsReader.readLine()) != null) {
                String fileName;
                String[] fileAttributes;
                String osList;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(osList = (fileAttributes = line.split("\\s"))[0]).equalsIgnoreCase("all") && !osList.equalsIgnoreCase(currentOSFamily) || !(fileName = this.normalizePath(fileAttributes[1])).contains("%ORA_CRS_HOME%")) continue;
                fileName = fileName.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                String fileOwner = fileAttributes[2];
                String fileGroup = fileAttributes[3];
                String filePerms = fileAttributes[4];
                HashMap<String, String> fileAttributeHM = new HashMap<String, String>();
                fileAttributeHM.put("OWNER", fileOwner);
                fileAttributeHM.put("GROUP", fileGroup);
                if (isHA && VerificationUtil.isStringGood(filePerms)) {
                    char[] filePermChar = filePerms.toCharArray();
                    filePermChar[filePermChar.length - 1] = 48;
                    filePerms = new String(filePermChar);
                }
                fileAttributeHM.put("PERMISSIONS", filePerms);
                crsConfigFilePermsHM.put(fileName, fileAttributeHM);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processCrsConfigDirs(String crsConfigFilePerms, HashMap<String, HashMap<String, String>> crsConfigDirsHM, String currentOSFamily, boolean isHA) {
        try {
            BufferedReader filePermsReader = new BufferedReader(new FileReader(crsConfigFilePerms));
            String line = null;
            while ((line = filePermsReader.readLine()) != null) {
                String[] fileAttributes;
                String osList;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(osList = (fileAttributes = line.split("\\s"))[0]).equalsIgnoreCase("all") && !osList.equalsIgnoreCase(currentOSFamily)) continue;
                String fileName = this.normalizePath(fileAttributes[1]);
                if (fileName.contains("%ORA_CRS_HOME%")) {
                    fileName = fileName.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                }
                String fileOwner = fileAttributes.length > 2 ? fileAttributes[2] : null;
                String fileGroup = fileAttributes.length > 3 ? fileAttributes[3] : null;
                String filePerms = fileAttributes.length > 4 ? fileAttributes[4] : null;
                HashMap<String, String> fileAttributeHM = new HashMap<String, String>();
                fileAttributeHM.put("OWNER", fileOwner);
                fileAttributeHM.put("GROUP", fileGroup);
                if (isHA && VerificationUtil.isStringGood(filePerms)) {
                    char[] filePermChar = filePerms.toCharArray();
                    filePermChar[filePermChar.length - 1] = 48;
                    filePerms = new String(filePermChar);
                }
                fileAttributeHM.put("PERMISSIONS", filePerms);
                crsConfigDirsHM.put(fileName, fileAttributeHM);
            }
            filePermsReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processCrsConfigFiles(String crsConfigFiles, List<String> crsConfigFilesHM, String currentOSFamily, boolean isHA) {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(crsConfigFiles));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                String destPath;
                String[] fileMapping;
                String osList;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || !(osList = (fileMapping = line.split("\\s"))[0]).equalsIgnoreCase("all") && !osList.equalsIgnoreCase(currentOSFamily)) continue;
                String srcPath = fileMapping[1];
                if (srcPath.contains("%ORA_CRS_HOME%")) {
                    srcPath = this.normalizePath(srcPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME"));
                }
                if (!(destPath = this.normalizePath(fileMapping[2])).contains("%ORA_CRS_HOME%")) continue;
                destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                crsConfigFilesHM.add(srcPath + "|" + destPath);
            }
            filesReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void processExcludeFiles() {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(this.excludeListFile));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                String os;
                String[] tokens;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (tokens = line.split("\\s+")).length != 2) continue;
                String destPath = tokens[1];
                String excludedOSList = tokens[0];
                boolean isOSExcluded = false;
                String[] stringArray = excludedOSList.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && !(isOSExcluded = this.matchOSType(os = stringArray[i])); ++i) {
                }
                if (!isOSExcluded) continue;
                if (destPath.contains("%ORA_CRS_HOME%")) {
                    destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                }
                this.excludedFiles.add(this.normalizePath(destPath).toLowerCase());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Trace.out((String)"Excluded Files:");
        Trace.out((String)VerificationUtil.strCollection2String(this.excludedFiles, VerificationUtil.LINE_SEPARATOR));
    }

    private boolean matchOSType(String osType) {
        boolean osTypeMatches = false;
        if (osType.equalsIgnoreCase("all")) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase(VerificationUtil.getSupportedOSPlatform().toString()) || osType.equalsIgnoreCase(VerificationUtil.getSupportedOSPlatform().name())) {
            osTypeMatches = true;
        } else if (osType.equalsIgnoreCase("unix")) {
            osTypeMatches = new SystemFactory().CreateSystem().isUnixSystem();
        }
        return osTypeMatches;
    }

    private void processRelinkedFiles() {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(this.relinkedListFile));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                String os;
                String[] tokens;
                if ((line = line.trim()).length() == 0 || line.startsWith("#") || (tokens = line.split("\\s+")).length != 2) continue;
                String destPath = tokens[1];
                String excludedOSList = tokens[0];
                boolean isOSExcluded = false;
                String[] stringArray = excludedOSList.split(",");
                int n = stringArray.length;
                for (int i = 0; i < n && !(isOSExcluded = this.matchOSType(os = stringArray[i])); ++i) {
                }
                if (!isOSExcluded) continue;
                if (destPath.contains("%ORA_CRS_HOME%")) {
                    destPath = destPath.replaceAll("ORA_CRS_HOME", "ORACLE_HOME");
                }
                this.relinkedFiles.add(this.normalizePath(destPath).toLowerCase());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Trace.out((String)"Relinked Files:");
        Trace.out((String)VerificationUtil.strCollection2String(this.excludedFiles, VerificationUtil.LINE_SEPARATOR));
    }

    private void processCusMakeFiles() {
        try {
            BufferedReader filesReader = new BufferedReader(new FileReader(this.cusMakeListFile));
            String line = null;
            while ((line = filesReader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                this.cusMakeFiles.add(line);
            }
        }
        catch (IOException e) {
            Trace.out((String)("IGNORED: " + e.getMessage()));
        }
    }

    private boolean generateFileList(final ComponentSoftwareDistribution component, final String srcHome, final String mapFile, Document softwareDocument, Element softwareComponentEle, List<String> crsConfigFilesHM, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM, boolean gridComponent) {
        OiscxFilesListBuilder oFileListBuilder = new OiscxFilesListBuilder(this.m_oSLVProps, this.m_sCompLangs){
            final HashMap<String, String> permissionHM;
            {
                super(x0, x1);
                this.permissionHM = new HashMap();
            }

            public void addInclude(OiscxIncludeData incl) throws SAXException {
                String dest = incl.getDest();
                while (dest.endsWith("/") || dest.endsWith("\\")) {
                    dest = dest.substring(0, dest.length() - 1);
                }
                incl.setDest(dest);
                super.addInclude(incl);
                dest = this.substituteMacrosInString(dest);
                String destRename = incl.getDestRename();
                destRename = this.substituteMacrosInString(destRename);
                String fileName = dest + File.separator + destRename;
                this.permissionHM.put(fileName, incl.getPerm());
            }

            public ArrayList getFoundFilesList() {
                FileInfo fileInfoACL = null;
                ArrayList foundFileList = super.getFoundFilesList();
                for (Object oFileO : foundFileList) {
                    OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)oFileO;
                    String perm = this.permissionHM.get(oFile.getDest());
                    if (oFile.getDest().matches(".*\\.acl")) {
                        fileInfoACL = new FileInfo();
                        fileInfoACL.setFileName(oFile.getSourceFileName());
                        component.addAcl(fileInfoACL);
                    }
                    if (oFile.getDest().startsWith(srcHome)) {
                        oFile.setDest(oFile.getDest().replace(srcHome, "%ORACLE_HOME%"));
                    }
                    if (perm != null) {
                        oFile.setPerms(perm);
                    }
                    Trace.out((String)(mapFile + ":" + oFile.getDest()));
                }
                component.processACLFiles(foundFileList);
                return foundFileList;
            }
        };
        oFileListBuilder.setStageLangs(Locale.ENGLISH.toString());
        OiscxFileMapReader oFileMapReader = new OiscxFileMapReader((OiscxComponentBuilder)oFileListBuilder);
        int pos = mapFile.lastIndexOf(".map.xml");
        String textLocation = mapFile.substring(0, pos);
        try {
            oFileMapReader.parse(null, textLocation);
        }
        catch (OiscuFatalException e) {
            this.logErr("Fatal Exception occured :" + e.getMessage(), null, 0, false);
            this.logErr("Failed to parse mapfile.Exiting", null, 0, false);
            return false;
        }
        ArrayList results = oFileListBuilder.getFoundFilesList();
        if (results.size() == 0) {
            return true;
        }
        int iSize1 = results != null ? results.size() : 0;
        Element componentElement = null;
        componentElement = softwareDocument.createElement(TAG_COMPONENT);
        componentElement.setAttribute(TAG_ATT_CONDITION_NAME, component.getName());
        softwareComponentEle.appendChild(componentElement);
        for (int i = 0; i < iSize1; ++i) {
            OiscxFilesListBuilder.OiscxInclude oFile = (OiscxFilesListBuilder.OiscxInclude)results.get(i);
            if (oFile == null) continue;
            this.createElement(softwareDocument, componentElement, oFile.getDest(), oFile.getPerms(), null, null, crsConfigFilePermsHM, gridComponent);
        }
        return true;
    }

    private void createElement(Document softwareDocument, Element softwareComponentEle, String sDest, String permission, String owner, String group, HashMap<String, HashMap<String, String>> crsConfigFilePermsHM, boolean gridComponent) {
        Element softwareFileEle = null;
        HashMap<String, String> crsConfigFileHM = crsConfigFilePermsHM.get(sDest);
        if (crsConfigFileHM == null) {
            crsConfigFileHM = this.crsConfigDirsHM.get(sDest);
        }
        String crsConfigPerm = null;
        if (crsConfigFileHM != null) {
            String crsConfigGroup;
            crsConfigPerm = crsConfigFileHM.get("PERMISSIONS");
            String crsConfigOwner = crsConfigFileHM.get("OWNER");
            if (crsConfigOwner != null) {
                owner = crsConfigOwner;
            }
            if ((crsConfigGroup = crsConfigFileHM.get("GROUP")) != null) {
                group = crsConfigGroup;
            }
        }
        if (this.excludedFiles.contains(this.normalizePath(sDest).toLowerCase())) {
            return;
        }
        if (this.isInstantiated(sDest)) {
            return;
        }
        if (this.m_generatedFiles.contains(sDest)) {
            return;
        }
        this.m_generatedFiles.add(sDest);
        sDest = this.normalizePath(sDest);
        String[] pathComponents = sDest.split(Pattern.quote(File.separator));
        String path = "";
        for (int j = 0; j < pathComponents.length - 1; ++j) {
            if (pathComponents[j].equals("%ORACLE_HOME%")) continue;
            path = path + pathComponents[j] + File.separator;
        }
        String fileName = pathComponents[pathComponents.length - 1];
        String cusFilePermission = this.getCusFilePermissions(fileName);
        if (crsConfigPerm != null) {
            permission = crsConfigPerm;
        } else if (cusFilePermission != null) {
            permission = cusFilePermission;
        }
        if (this.relinkedFiles.contains(this.normalizePath(sDest).toLowerCase())) {
            permission = null;
            owner = null;
            group = null;
        }
        if (Arrays.asList(INSTALLER_ROOTED_FILES).contains(sDest)) {
            permission = "4750";
        }
        softwareFileEle = softwareDocument.createElement(TAG_FILE);
        softwareComponentEle.appendChild(softwareFileEle);
        softwareFileEle.setAttribute("Path", path);
        softwareFileEle.setAttribute(TAG_COMPONENT_NAME, fileName);
        if (s_unixSystem && permission != null && permission.length() > 0) {
            softwareFileEle.setAttribute("Permissions", permission);
        }
        if (s_unixSystem && owner != null && owner.length() > 0) {
            softwareFileEle.setAttribute("Owner", owner);
        }
        if (s_unixSystem && group != null && group.length() > 0) {
            softwareFileEle.setAttribute("Group", group);
        }
    }

    private void logErr(String string, Object object, int information, boolean b) {
        System.err.println(information + " " + string);
    }

    private String normalizePath(String path) {
        if (path == null || path.length() == 0) {
            return path;
        }
        path = s_unixSystem ? path.replaceAll(Pattern.quote("\\"), Matcher.quoteReplacement(File.separator)) : path.replaceAll(Pattern.quote("/"), Matcher.quoteReplacement(File.separator));
        return path;
    }

    private boolean isInstantiated(String file) {
        if (file == null) {
            return false;
        }
        return file.toLowerCase().endsWith("sbs") || file.toLowerCase().endsWith("template") || file.toLowerCase().endsWith("tmpl") || file.toLowerCase().endsWith("dbl");
    }

    static {
        String traceFileName = "SoftwareConfigXMLGenerator.log";
        String srcHome = System.getenv("SRCHOME");
        s_unixSystem = new SystemFactory().CreateSystem().isUnixSystem();
        int tracingLvl = 5;
        m_product = System.getenv("NDE_PRODUCT");
        if (m_product.equals("has")) {
            traceFileName = srcHome + "/" + "cv" + "/" + "cvdata" + "/" + traceFileName;
        }
        System.out.println("traceFileName[" + traceFileName + "]");
        boolean tracetostdout = false;
        Trace.enableTracing();
        boolean conRes = Trace.configure((boolean)false, (boolean)tracetostdout, (boolean)true, (boolean)true, (String)traceFileName, (boolean)true, (boolean)true);
        Trace.out((String)("Trace.configure returns " + conRes));
        Trace.setTraceLevel((int)tracingLvl);
        Trace.out((String)("tracing is on at level " + tracingLvl + " to file " + traceFileName));
    }
}

