/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class RunGenericCommand
extends VerificationCommand {
    private String m_arg1 = "-rungencmd";
    private static String DELIMIT_STRING = "!";

    public RunGenericCommand(String nodeName, String command) {
        this(nodeName, command, null);
    }

    public RunGenericCommand(String nodeName, String command, String exectask_cmd) {
        this(nodeName, command, exectask_cmd, null);
    }

    public RunGenericCommand(String nodeName, String command, String exectask_cmd, String[] env) {
        this(nodeName, command, exectask_cmd, null, env);
    }

    public RunGenericCommand(String nodeName, String command, String exectask_cmd, String[] cmdArgs, String[] env) {
        super(nodeName, null, env);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        int cmdArgsLength = cmdArgs != null ? cmdArgs.length : 0;
        String[] args = new String[2 + cmdArgsLength];
        args[0] = exectask_cmd == null ? this.m_arg1 : exectask_cmd;
        if (!nodeName.equals("localnode") && !VerificationUtil.isLocalNode(nodeName)) {
            String quotedCommand;
            String quote = "\"";
            StringBuffer sb = new StringBuffer();
            sb.append(quote + command + quote);
            args[1] = quotedCommand = sb.toString();
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Adding quotes to command.\nNew command: " + quotedCommand));
            }
        } else {
            args[1] = command;
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("Setting Local Execution for command: " + command));
            }
            super.setLocalExecution(true);
        }
        if (cmdArgsLength > 0) {
            for (int i = 0; i < cmdArgs.length; ++i) {
                if (!nodeName.equals("localnode") && !VerificationUtil.isLocalNode(nodeName)) {
                    String quotedArg;
                    String quote = "\"";
                    StringBuffer sb = new StringBuffer();
                    sb.append(quote + cmdArgs[i] + quote);
                    args[2 + i] = quotedArg = sb.toString();
                    if (!Trace.isLevelEnabled((int)1)) continue;
                    Trace.out((String)("Adding quotes to argument.\nNew arg: " + quotedArg));
                    continue;
                }
                args[2 + i] = cmdArgs[i];
            }
        }
        super.setArgs(args);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
    }

    @Override
    public boolean execute() {
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Entry");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("RunGenericCommand::Inside execute() " + Thread.currentThread().getName()));
        }
        if (Trace.isLevelEnabled((int)5)) {
            Trace.out((String)("Node:    " + this.m_node));
            Trace.out((String)("Command: " + this.m_args[1]));
        }
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for RunGenericCommand...";
            if (Trace.isLevelEnabled((int)5)) {
                Trace.out((String)trcTxt);
            }
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("RunGenericCommand failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (Trace.isLevelEnabled((int)3)) {
            Trace.out((String)("RunGenericCommand output: " + reoutput));
        }
        result.addResultInfo(reoutput);
        String resdelim = VerificationUtil.strArr2String(resultString, new String(DELIMIT_STRING));
        Trace.out((int)5, (String)("RunGenericCommand output 1 : " + resdelim));
        resdelim = VerificationUtil.fetchVerificationValue(resdelim);
        Trace.out((int)5, (String)("RunGenericCommand output 2 : " + resdelim));
        String[] resltArr = resdelim.split(DELIMIT_STRING);
        for (int j = 0; j < resltArr.length; ++j) {
            Trace.out((int)5, (String)("RunGenericCommand output 3 : " + resltArr[j]));
        }
        result.addResultInfo(resltArr);
        if (Trace.isLevelEnabled((int)2)) {
            Trace.out((String)"Exit");
        }
        return true;
    }
}

