/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckFileLinkCommand
extends VerificationCommand {
    private static String m_arg1 = "-chkfilelink";
    private String m_file;
    private String m_link;

    public CheckFileLinkCommand(String nodeName, String fname, String linkname) {
        super(nodeName, null, null);
        this.m_file = fname;
        this.m_link = linkname;
        String[] args = new String[]{m_arg1, this.m_file, this.m_link};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckFileLinkCommand::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckFileLinkCommand...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("checking file link failed");
            result.setStatus(2);
            return false;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (!VerificationUtil.fetchExecResult(reoutput)) {
            String trcTxt = "Exectask result shows failure for -CheckFileLink...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"checking file link  failed");
            String errMsg = VerificationUtil.fetchError(reoutput);
            if (VerificationUtil.isStringGood(errMsg)) {
                this.getCommandResult().setResultString(VerificationUtil.string2strArr(errMsg));
            }
            result.addErrorInfo("checking file link  failed");
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationStatus(reoutput)) {
            String trcTxt = "Exectask result shows verification failure for -CheckFileLink...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            Trace.out((String)"check link file :: The link does not exist");
            result.addErrorInfo("The link does not exist");
            result.setStatus(3);
            return false;
        }
        result.setStatus(1);
        return true;
    }
}

