/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.command;

import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CheckDirStructure
extends VerificationCommand {
    private static String m_arg = "-chkdirstruct";

    public CheckDirStructure(String nodeName, String oracleBase, String crshome) {
        super(nodeName, null, null);
        String[] args = new String[]{m_arg, oracleBase, crshome};
        super.setArgs(args);
    }

    @Override
    public boolean execute() {
        Trace.out((String)("CheckDirStructure::Inside execute() " + Thread.currentThread().getName()));
        boolean bResult = super.execute();
        Result result = this.getResult();
        if (!bResult) {
            String trcTxt = "super.execute() failed for CheckDirStructure...";
            Trace.out((String)trcTxt);
            result.addTraceInfo(trcTxt);
            result.addErrorInfo("check for directory structure failed");
            result.setStatus(2);
            return bResult;
        }
        String[] resultString = this.getCommandResult().getResultString();
        String reoutput = VerificationUtil.strArr2String(resultString);
        if (!VerificationUtil.fetchExecResult(reoutput)) {
            String errMsg = VerificationUtil.fetchError(reoutput);
            if (errMsg != null) {
                result.addErrorInfo(errMsg);
            } else {
                result.addErrorInfo("Execution of directory structure check failed");
            }
            result.setStatus(2);
            return false;
        }
        if (!VerificationUtil.fetchVerificationResult(reoutput).equals("0")) {
            result.addErrorInfo("Check for directory structure verification failed.");
            result.setStatus(3);
            return false;
        }
        result.setStatus(1);
        return true;
    }
}

