/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.util.ConsoleUtil;
import oracle.cluster.util.ConsoleUtilException;
import oracle.cluster.verification.ClusterwideCollectionUnavailableException;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.common.CVUException;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.database.DatabaseEdition;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.jdbc.driver.OracleConnection;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.command.registry.RegistryKeyData;
import oracle.ops.mgmt.database.ConfigurationException;
import oracle.ops.mgmt.nativesystem.NativeResult;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.util.Utils;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.RunGenericCommand;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.CVUHelperException;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CaseInsensitiveMap;
import oracle.ops.verification.framework.util.HeavyWeightVerificationUtil;
import oracle.ops.verification.framework.util.InvalidOUIInventoryDataException;
import oracle.ops.verification.framework.util.OUIData;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallCompInvEntry;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;

public class DBUtils
implements VerificationConstants {
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static String[] m_srvctlEnv = new String[]{"CSS_CLUSTERNAME", "ORA_CSS_VARS", "ORA_ENVIRON_OPTS", "HAS_DEVELOPMENT_ENVIRONMENT", "OCR_DEVELOPER_ENV", "OLR_LOC"};
    private static final String LIB_DIR = "lib";
    private static final String STRINGS_COMMAND = "strings";
    private static final String ORACLE_KEY_FILE = "oracle.key";
    private static final String ORACLE_REGISTRY = "HKEY_LOCAL_MACHINE\\";
    private static final String ORACLE_REGISTRY_BUNDLE_NAME = "ORACLE_BUNDLE_NAME";
    private static final String DB_ENTERPRISE = "Enterprise";
    private static final String DB_ENTERPRISE_EDITION_LINUX = "(.*)Enterprise Edition(.*)";
    private static final int DB_PASSWORD_ATTMPTS = 3;
    private static final CharSequence DB_CREDENTIAL_OERR = "ORA-01017";
    private Hashtable<String, List<String>> m_dbHomeUniquesNames;
    Version m_crsVer = null;
    private static HashMap<String, String> m_dbConnectDescriptorMap = new HashMap();

    public DBUtils(Version crsVer) {
        this.m_crsVer = crsVer;
        this.m_dbHomeUniquesNames = new Hashtable();
    }

    public String[] getDatabases() throws DBUtilsException {
        String[] cmdOutput = null;
        cmdOutput = Version.isPre112((Version)this.m_crsVer) ? this.runCrsStat(null) : this.runCrsctlStatus(null);
        ArrayList<String> dbLst = new ArrayList<String>();
        for (int i = 0; i < cmdOutput.length; ++i) {
            String[] prop = cmdOutput[i].split("=");
            Trace.out((String)("output line: " + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("NAME")) continue;
            String[] vals = prop[1].trim().split("\\.");
            Trace.out((String)("vals.length = " + vals.length));
            if (vals.length != 3 || !vals[0].equals("ora") || !vals[2].equals("db")) continue;
            Trace.out((String)("adding " + vals[1] + " to db list"));
            dbLst.add(vals[1]);
        }
        if (dbLst.size() == 0) {
            Trace.out((String)"No databases were found. Returning zero length array");
        }
        return dbLst.toArray(new String[0]);
    }

    public Map<String, Vector> getRACHomesFromInventory() throws DBUtilsException {
        OiiiInstallInventory inv = null;
        OiicStandardInventorySession session = null;
        String applicationName = "oracle.server";
        HashMap<String, Vector> oracleHomes = new HashMap<String, Vector>();
        try {
            if (!OiiiInstallAreaControl.isCleanMachine()) {
                session = new OiicStandardInventorySession(applicationName, this.m_crsVer.toString());
                session.initSession(2);
                inv = session.getInstallAreaControl().getInstallInventory();
            }
            if (inv != null) {
                Vector homes = inv.getHomes();
                for (int i = 0; i < homes.size(); ++i) {
                    OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)homes.elementAt(i);
                    OiiiInstallCompInvEntry installCompInv = inv.findCompInRange(homeInfo.getIndex(), applicationName, "0.0.0.0.0", "999.999.999.999.999");
                    if (installCompInv == null || homeInfo.getNodeList() == null || homeInfo.getNodeList().size() <= 0) continue;
                    oracleHomes.put(homeInfo.getLocation(), homeInfo.getNodeList());
                }
            }
        }
        catch (OiitTargetLockNotAvailableException e) {
            throw new DBUtilsException(e);
        }
        catch (IOException e) {
            throw new DBUtilsException(e);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            throw new DBUtilsException(e);
        }
        return oracleHomes;
    }

    public Map<String, Vector<String>> getRACHomes() throws DBUtilsException {
        HashMap<String, Vector<String>> oracleHomes = null;
        List databaseNames = null;
        Vector<String> nodes = null;
        String dbHome = null;
        Trace.out((String)"Execution getRACHomes()");
        String crsHome = this.getCRSHome();
        Trace.out((String)("crsHome[" + crsHome + "]"));
        DatabaseInfo dbInfo = null;
        try {
            databaseNames = new ClusterwareInfo().getHAManagedDatabases(crsHome);
        }
        catch (InstallException ie) {
            Trace.out((String)("InstallException: " + (Object)((Object)ie)));
            throw new DBUtilsException(ie);
        }
        oracleHomes = new SystemFactory().CreateSystem().isUnixSystem() ? new HashMap<String, Vector<String>>() : new CaseInsensitiveMap();
        if (databaseNames != null && databaseNames.size() > 0) {
            for (String dbName : databaseNames) {
                try {
                    Trace.out((String)("dbName [" + dbName + "]"));
                    dbInfo = this.getDatabaseInfo(dbName);
                    dbHome = dbInfo.getHome();
                    try {
                        dbHome = new File(dbInfo.getHome()).getCanonicalPath();
                    }
                    catch (IOException e) {
                        Trace.out((String)("Ignored IOException '" + e.getMessage() + "' while trying to get canonical path for dbhome " + dbHome));
                        dbHome = dbInfo.getHome();
                    }
                    nodes = new Vector<String>(Arrays.asList(this.getNodes(dbName)));
                    Trace.out((String)("dbHome[" + dbHome + "] nodes [" + nodes + "]"));
                    Vector existingNodes = (Vector)oracleHomes.get(dbHome);
                    if (existingNodes != null) {
                        nodes.removeAll(existingNodes);
                        nodes.addAll(existingNodes);
                    }
                    oracleHomes.put(dbHome, nodes);
                }
                catch (DBUtilsException e) {
                    Trace.out((String)("Encountered DBUtilsException e: " + e.getMessage() + " while retrieving database info for dbuniquname: " + dbName + ". DB will be skipped"));
                }
            }
        }
        return oracleHomes;
    }

    public List<DatabaseInfo> getDatabaseInfos() throws DBUtilsException {
        try {
            CollectionResultSet<List<DatabaseInfo>> dbInfoCR = CVUHelperUtil.getDatabaseInfos();
            if (dbInfoCR.getOverallStatus() != OverallStatus.SUCCESSFUL) {
                String errorMsg = "";
                for (VerificationError error : dbInfoCR.getErrors()) {
                    errorMsg = errorMsg + error.getErrorMessage() + LSEP;
                }
                throw new DBUtilsException(errorMsg);
            }
            if (!Version.isPre112((Version)this.m_crsVer)) {
                return dbInfoCR.getCollectedClusterwideValue();
            }
            ArrayList<DatabaseInfo> dbInfoList = new ArrayList<DatabaseInfo>();
            for (DatabaseInfo dbInfo : dbInfoCR.getCollectedClusterwideValue()) {
                String dbUniqueName = dbInfo.getUniqueName();
                String dbHome = dbInfo.getHome();
                String dbVersion = this.getDBVersionString(dbHome);
                dbInfoList.add(new DatabaseInfo(dbUniqueName, null, dbVersion, dbHome));
            }
            return dbInfoList;
        }
        catch (ClusterwideCollectionUnavailableException e) {
            throw new DBUtilsException(e);
        }
        catch (CVUHelperException e) {
            throw new DBUtilsException(e);
        }
    }

    public String getConnectDescriptor(DatabaseConnectInfo databaseConnectionInfo) throws DBUtilsException {
        if (databaseConnectionInfo == null) {
            Trace.out((String)"databaseConnectionInfo is null. returning null");
            return null;
        }
        String dbName = databaseConnectionInfo.dbUniqueName();
        String dbConnDescr = m_dbConnectDescriptorMap.get(dbName);
        if (dbConnDescr != null) {
            return dbConnDescr;
        }
        dbConnDescr = databaseConnectionInfo.listenerPort() != 0 ? this.getConnectDescriptor(dbName, databaseConnectionInfo.listenerPort()) : this.getConnectDescriptor(dbName);
        m_dbConnectDescriptorMap.put(dbName, dbConnDescr);
        return dbConnDescr;
    }

    public String getConnectDescriptor(String dbUniqueName) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        if (Version.isPre112((Version)this.m_crsVer)) {
            Trace.out((String)("use getConnectDescriptor with port in pre 11gR2 crs. m_crsVer is " + this.m_crsVer.toString()));
            throw new DBUtilsException(m_prvgMsgBundle, "11000", new Object[0]);
        }
        Trace.out((String)"Trying to get SCAN name and SCAN listener port");
        String[] scanInfo = this.getScanAndPort();
        Trace.out((String)"Trying to get database info");
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        StringBuilder conctDescpr = new StringBuilder();
        conctDescpr.append("(DESCRIPTION = (LOAD_BALANCE=on)  (ADDRESS = (PROTOCOL = TCP)(HOST = ");
        conctDescpr.append(scanInfo[0]);
        conctDescpr.append(")(PORT = ");
        conctDescpr.append(scanInfo[1]);
        conctDescpr.append(")) (CONNECT_DATA =(SERVER = DEDICATED)(SERVICE_NAME = ");
        conctDescpr.append(dbInfo.getDefaultServiceName());
        conctDescpr.append(")))");
        return conctDescpr.toString();
    }

    public String getConnectDescriptor(String dbUniqueName, int port) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        List<String> nodeVips = this.getNodeVipsPre112(dbUniqueName);
        StringBuilder conctDescpr = new StringBuilder();
        conctDescpr.append("(DESCRIPTION= (SOURCE_ROUTE=yes) (ADDRESS_LIST= (FAILOVER=on) (LOAD_BALANCE=off)");
        for (int i = 0; i < nodeVips.size(); ++i) {
            conctDescpr.append("(ADDRESS= (PROTOCOL=tcp) (HOST=");
            conctDescpr.append(nodeVips.get(i));
            conctDescpr.append(") (PORT=");
            conctDescpr.append(port);
            conctDescpr.append("))");
        }
        conctDescpr.append(')');
        conctDescpr.append("(CONNECT_DATA=(SERVICE_NAME=");
        conctDescpr.append(dbInfo.getDefaultServiceName());
        conctDescpr.append("))");
        conctDescpr.append(')');
        Trace.out((String)("ConnectDescriptor for db " + dbUniqueName + " using port " + port + " is :" + conctDescpr));
        return conctDescpr.toString();
    }

    public DatabaseInfo getDatabaseInfo(String dbUniqueName) throws DBUtilsException {
        if (dbUniqueName == null) {
            Trace.out((String)"dbUniqueName is null. returning null");
            return null;
        }
        if (Version.isPre112((Version)this.m_crsVer)) {
            Trace.out((String)"Trying to get databases in pre 112 clusterware");
            return this.getDatabaseInfoPre112(dbUniqueName);
        }
        Trace.out((String)"Trying to get databases in 112 or latter clusterware");
        return this.getDatabaseInfo112(dbUniqueName);
    }

    public boolean isPortRequiredForConnect(String dbUniqueName) throws DBUtilsException {
        if (Version.isPre112((Version)this.m_crsVer)) {
            return true;
        }
        DatabaseInfo dbInfo = this.getDatabaseInfo(dbUniqueName);
        return Version.isPre112((Version)dbInfo.getVersion());
    }

    private DatabaseInfo getDatabaseInfoPre112(String dbUniqueName) throws DBUtilsException {
        return this.getDatabaseInfoPre112(null, dbUniqueName);
    }

    private DatabaseInfo getDatabaseInfoPre112(String crsHome, String dbUniqueName) throws DBUtilsException {
        Trace.out((String)("Trying to get Database info. dbUniqueName: " + dbUniqueName + " CRS Version:" + this.m_crsVer.toString()));
        String[] args = new String[]{"config", "database", "-d", dbUniqueName, "-a"};
        String dbDomain = null;
        String dbHome = null;
        String dbVersion = null;
        String[] output = null;
        try {
            if (crsHome == null) {
                output = this.runSrvctl(args);
            } else {
                String[] env = new String[]{"ORACLE_HOME=" + crsHome, "NLS_LANG=American_America.US7ASCII"};
                output = this.runSrvctl(crsHome, env, args);
            }
        }
        catch (DBUtilsException dbe) {
            Trace.out((Exception)dbe);
            Trace.out((String)("DBUtilsException occured while running srvctl. message: " + dbe.getMessage()));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        for (int i = 0; i < output.length; ++i) {
            String[] prop = output[i].split(":");
            if (prop == null || prop.length != 2) continue;
            if (prop[0].equals("DOMAIN")) {
                dbDomain = prop[1].trim();
                Trace.out((String)("domain of " + dbUniqueName + " is " + dbDomain));
                if (!dbDomain.equals("null")) continue;
                Trace.out((String)"got dbDomain as 'null'");
                dbDomain = null;
                continue;
            }
            if (!prop[0].equals("ORACLE_HOME")) continue;
            dbHome = prop[1].trim();
            Trace.out((String)("home of " + dbUniqueName + " is " + dbHome));
        }
        if (dbHome == null) {
            Trace.out((String)("dbHome for database " + dbUniqueName + " is null. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        dbVersion = this.getDBVersionString(dbHome);
        return new DatabaseInfo(dbUniqueName, dbDomain, dbVersion, dbHome);
    }

    private DatabaseInfo getDatabaseInfo112(String dbUniqueName) throws DBUtilsException {
        Trace.out((String)("Trying to get Database info. dbUniqueName: " + dbUniqueName + " CRS Version:" + this.m_crsVer.toString()));
        String[] args = new String[]{"ora." + dbUniqueName.toLowerCase() + ".db", "-p"};
        String dbDomain = null;
        String dbHome = null;
        String dbVersion = null;
        Trace.out((String)("Trying to run crsctl to get Dababase info for database:" + dbUniqueName));
        String[] output = this.runCrsctlStatus(args);
        for (int i = 0; i < output.length; ++i) {
            String[] prop = output[i].split("=");
            if (prop == null || prop.length != 2) continue;
            if (prop[0].equals("USR_ORA_DOMAIN")) {
                dbDomain = prop[1].trim();
                Trace.out((String)("domain of " + dbUniqueName + " is " + dbDomain));
                continue;
            }
            if (!prop[0].equals("ORACLE_HOME")) continue;
            dbHome = prop[1].trim();
            Trace.out((String)("home of " + dbUniqueName + " is " + dbHome));
        }
        if (dbHome == null) {
            Trace.out((String)"dbHome is null. trying to run srvctl on each oracle home");
            String[] oHomes = this.getOracleHomeLocations();
            Trace.out((String)("oHomes=" + VerificationUtil.strArr2List(oHomes)));
            if (oHomes != null) {
                for (String oh : oHomes) {
                    try {
                        return this.getDatabaseInfoPre112(oh, dbUniqueName);
                    }
                    catch (DBUtilsException ex) {
                        Trace.out((String)ex.getMessage());
                    }
                }
            }
        }
        if (dbHome == null) {
            Trace.out((String)("dbHome for database " + dbUniqueName + " is null. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11005", dbUniqueName);
        }
        dbVersion = this.getDBVersionString(dbHome);
        return new DatabaseInfo(dbUniqueName, dbDomain, dbVersion, dbHome);
    }

    private String[] getOracleHomeLocations() throws DBUtilsException {
        OUIData oui = null;
        try {
            String inventoryFile = VerificationUtil.getInventoryFileLocation();
            oui = OUIData.getInstance(inventoryFile);
        }
        catch (InvalidOUIInventoryDataException e) {
            Trace.out((String)("Encounterd InvalidOUIInventoryDataException: " + e.getMessage()));
            throw new DBUtilsException(m_prvgMsgBundle, e.getMessage(), new Object[0]);
        }
        String[] oHomes = oui.getOracleHomeLocations();
        Trace.out((String)("oHomes=" + VerificationUtil.strArr2List(oHomes)));
        return oHomes;
    }

    private String getDBHome(String dbUniqueName) throws DBUtilsException {
        String[] oHomes = this.getOracleHomeLocations();
        if (oHomes == null || oHomes.length == 0) {
            return null;
        }
        String[] args = new String[]{"config", "database"};
        String[] output = null;
        for (String oh : oHomes) {
            for (String dbName : output = this.runSrvctl(oh, null, args)) {
                if (!dbUniqueName.equals(dbName.trim())) continue;
                return oh;
            }
        }
        return null;
    }

    private List<String> getNodeVipsPre112(String dbUniqueName) throws DBUtilsException {
        String[] prop;
        int i;
        ArrayList<String> vipLst = new ArrayList<String>();
        ArrayList<String> nodeLst = new ArrayList<String>();
        List<String> instLst = this.getDBInstancesPre112(dbUniqueName);
        Trace.out((String)("Trying to get Nodes on which db, '" + dbUniqueName + "' is running"));
        String[] args = new String[instLst.size() + 1];
        args[0] = "-p";
        for (int i2 = 0; i2 < instLst.size(); ++i2) {
            args[i2 + 1] = "ora." + dbUniqueName + "." + instLst.get(i2) + ".inst";
        }
        String[] cmdOutput = this.runCrsStat(args);
        for (i = 0; i < cmdOutput.length; ++i) {
            prop = cmdOutput[i].split("=");
            Trace.out((String)("Finding Nodes: cmdOutput[" + i + "]=" + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("HOSTING_MEMBERS")) continue;
            Trace.out((String)("Finding Nodes: adding " + prop[1] + " to nodeLst"));
            nodeLst.add(prop[1]);
        }
        Trace.out((String)("Trying to get Node VIPs of nodes on which db, '" + dbUniqueName + "' is running"));
        if (Version.isPre112((Version)this.m_crsVer)) {
            args = new String[nodeLst.size() + 1];
            args[0] = "-p";
            for (i = 0; i < nodeLst.size(); ++i) {
                args[i + 1] = "ora." + (String)nodeLst.get(i) + ".vip";
            }
            cmdOutput = this.runCrsStat(args);
        } else {
            i = 0;
            args = new String[nodeLst.size() + 1];
            for (i = 0; i < nodeLst.size(); ++i) {
                args[i] = "ora." + (String)nodeLst.get(i) + ".vip";
            }
            args[i] = "-p";
            cmdOutput = this.runCrsctlStatus(args);
        }
        for (i = 0; i < cmdOutput.length; ++i) {
            prop = cmdOutput[i].split("=");
            Trace.out((String)("Finding Node VIPs: cmdOutput[" + i + "]=" + cmdOutput[i]));
            if (prop.length != 2 || !prop[0].equals("USR_ORA_VIP")) continue;
            Trace.out((String)("Finding Node VIPs: adding " + prop[1] + " to vipLst"));
            vipLst.add(prop[1]);
        }
        if (vipLst.size() == 0) {
            Trace.out((String)("node VIPs are not defined for the nodes on which database " + dbUniqueName + " is running. Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11006", dbUniqueName);
        }
        return vipLst;
    }

    private List<String> getDBInstancesPre112(String dbUniqueName) throws DBUtilsException {
        ArrayList<String> instLst = new ArrayList<String>();
        String[] cmdOutput = this.runCrsStat(null);
        if (cmdOutput != null) {
            for (int i = 0; i < cmdOutput.length; ++i) {
                String[] prop = cmdOutput[i].split("=");
                Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
                if (prop.length != 2 || !prop[0].equals("NAME")) continue;
                String[] vals = prop[1].split("\\.");
                Trace.out((String)("vals.length = " + vals.length));
                if (vals.length != 4 || !vals[0].equals("ora") || !vals[1].equals(dbUniqueName) || !vals[3].equals("inst")) continue;
                Trace.out((String)("adding " + vals[2] + " inst list"));
                instLst.add(vals[2]);
            }
        }
        if (instLst.size() == 0) {
            Trace.out((String)("No instances are not defined for database " + dbUniqueName + "Throwing DBUtilsException..."));
            throw new DBUtilsException(m_prvgMsgBundle, "11007", dbUniqueName);
        }
        return instLst;
    }

    private String[] getScanAndPort() throws DBUtilsException {
        Object scanResName = null;
        String[] scanNames = null;
        String[] scanInfo = null;
        String[] lsnrPorts = null;
        String lsnrPort = null;
        ResultSet scnResultSet = new ResultSet();
        Trace.out((String)"Trying to get SCAN information");
        scanInfo = CVUHelperUtil.getScanInfo(new String[]{VerificationUtil.getLocalNode()}, scnResultSet);
        if (!scnResultSet.allSuccess()) {
            Trace.out((String)"Failed to obtain scan information");
            throw new DBUtilsException(scnResultSet.getAllErrorsStr());
        }
        if (scanInfo != null && scanInfo.length > 0 && VerificationUtil.isStringGood(scanInfo[0])) {
            scanNames = VerificationUtil.fetchTextByTagsRepeat(scanInfo[0], "<SCN_NME>", "</SCN_NME>");
            lsnrPorts = VerificationUtil.fetchTextByTagsRepeat(scanInfo[0], "<LSNR_PORT>", "</LSNR_PORT>");
        }
        if (scanNames == null || scanNames.length == 0 || !VerificationUtil.isStringGood((String)scanNames[0])) {
            Trace.out((String)"SCAN is not defined. throwing DBUtilsException");
            throw new DBUtilsException(m_prvgMsgBundle, "11003", new Object[0]);
        }
        if (lsnrPorts == null || lsnrPorts.length == 0 || !VerificationUtil.isStringGood((String)lsnrPorts[0])) {
            Trace.out((String)"SCAN listener is not defined. throwing DBUtilsException");
            throw new DBUtilsException(m_prvgMsgBundle, "11004", new Object[0]);
        }
        lsnrPort = lsnrPorts[0].split(" ")[0];
        Trace.out((String)("SCAN information gathered. SCAN name: " + scanNames[0] + " port: " + lsnrPort));
        return new String[]{scanNames[0], lsnrPort};
    }

    public Version getDBVersion(String dbHome) throws DBUtilsException {
        try {
            return Version.getVersion((String)this.getDBVersionString(dbHome));
        }
        catch (ConfigurationException cex) {
            throw new DBUtilsException(cex);
        }
    }

    public String getDBVersionString(String dbHome) throws DBUtilsException {
        String[] env = new String[]{"ORACLE_HOME=" + dbHome, "NLS_LANG=American_America.US7ASCII"};
        String[] args = new String[]{"-V"};
        String[] cmdOutput = this.runSrvctl(dbHome, env, args);
        String dbVersion = null;
        for (int i = 0; i < cmdOutput.length; ++i) {
            Trace.out((String)("cmdOutput[" + i + "]=" + cmdOutput[i]));
            String[] prop = cmdOutput[i].split(":");
            if (prop.length != 2 || !prop[0].equals("srvctl version")) continue;
            dbVersion = prop[1].trim();
            Trace.out((String)("dbVersion found in dbHome " + dbHome + " is " + dbVersion));
            break;
        }
        return dbVersion;
    }

    public String[] getNodes(String dbUniqueName) throws DBUtilsException {
        String[] nodes = null;
        try {
            nodes = CVUHelperUtil.getDbNodes(dbUniqueName);
        }
        catch (CVUHelperException ex) {
            Trace.out((String)("Failed to fetch node list for the unique database name " + dbUniqueName));
            throw new DBUtilsException(ex.getMessage());
        }
        return nodes;
    }

    private String[] runCrsStat(String[] crsstatArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        String crs_stat = crsHome + FSEP + "bin" + FSEP + "crs_stat";
        String[] args = null;
        if (crsstatArgs == null) {
            args = new String[]{"-runexe", crs_stat};
        } else {
            args = new String[crsstatArgs.length + 2];
            args[0] = "-rungencmd";
            args[1] = crs_stat;
            System.arraycopy(crsstatArgs, 0, args, 2, crsstatArgs.length);
        }
        VerificationCommand[] cmds = new VerificationCommand[1];
        String localNode = null;
        localNode = VerificationUtil.getLocalNode();
        cmds[0] = new VerificationCommand(localNode, args, null);
        ResultSet rs = new ResultSet();
        Trace.out((String)("Trying to run " + crs_stat + " on node " + localNode));
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            String output = cmds[0].getOutput();
            return output.split(LSEP);
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
        }
        Trace.out((String)("Error message from crs_stat:" + cause));
        throw new DBUtilsException(cause, m_prvfMsgBundle, "11001", crs_stat, localNode);
    }

    private String[] runCrsctlStatus(String[] crsctlArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        String crsctl = crsHome + FSEP + "bin" + FSEP + "crsctl";
        String[] fixedArgs = new String[]{"-runexe", crsctl, "status", "resource"};
        String crsctlCmd = crsctl + " status resource";
        String[] args = null;
        if (crsctlArgs == null) {
            args = fixedArgs;
        } else {
            args = new String[crsctlArgs.length + fixedArgs.length];
            System.arraycopy(fixedArgs, 0, args, 0, fixedArgs.length);
            System.arraycopy(crsctlArgs, 0, args, fixedArgs.length, crsctlArgs.length);
            for (int i = 0; i < crsctlArgs.length; ++i) {
                crsctlCmd = crsctlCmd + " " + crsctlArgs[i];
            }
        }
        VerificationCommand[] cmds = new VerificationCommand[1];
        String localNode = null;
        localNode = VerificationUtil.getLocalNode();
        cmds[0] = new VerificationCommand(localNode, args, null);
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess()) {
            String output = cmds[0].getOutput();
            return output.split(LSEP);
        }
        String cause = "";
        for (VerificationError vfe : rs.getErrors()) {
            String errMsg = vfe.getErrorMessage().replace("|", LSEP);
            cause = cause + LSEP + VerificationUtil.fetchVerificationValue(errMsg);
        }
        Trace.out((String)("Error message from crsctl:" + cause));
        throw new DBUtilsException(cause, m_prvfMsgBundle, "5303", crsctlCmd, localNode);
    }

    private String[] runSrvctl(String[] srvclArgs) throws DBUtilsException {
        String crsHome = this.getCRSHome();
        return this.runSrvctl(crsHome, null, srvclArgs);
    }

    private String[] runSrvctl(String crsHome, String[] env, String[] srvclArgs) throws DBUtilsException {
        String srvctlScriptName = new SystemFactory().CreateSystem().getScriptFileName("srvctl");
        String srvctl = crsHome + FSEP + "bin" + FSEP + srvctlScriptName;
        String[] args = new String[srvclArgs.length + 2];
        args[0] = "-runexe";
        args[1] = srvctl;
        System.arraycopy(srvclArgs, 0, args, 2, srvclArgs.length);
        String localNode = null;
        Trace.out((String)"Trying to get local node");
        localNode = VerificationUtil.getLocalNode();
        ArrayList<String> envList = new ArrayList<String>();
        if (env != null && Utils.isDevelopmentEnv()) {
            for (String envVar : m_srvctlEnv) {
                String envVal = System.getenv(envVar);
                if (!VerificationUtil.isStringGood(envVal)) continue;
                envList.add(envVar + "=" + envVal);
            }
            for (String e : env) {
                envList.add(e);
            }
            env = envList.toArray(new String[0]);
        }
        VerificationCommand[] cmds = new VerificationCommand[]{new VerificationCommand(localNode, args, env)};
        ResultSet rs = new ResultSet();
        new GlobalHandler().submit((Command[])cmds, 0, rs);
        if (rs.allSuccess() && cmds[0].getVfyCode() == 0) {
            return cmds[0].getOutput().split(LSEP);
        }
        String cause = "";
        if (rs.getErrors() != null && rs.getErrors().size() > 0) {
            boolean first = true;
            for (VerificationError vfe : rs.getErrors()) {
                String errMsg = vfe.getErrorMessage().replace("|", LSEP);
                if (first) {
                    first = false;
                } else {
                    cause = cause + LSEP;
                }
                cause = cause + errMsg;
            }
        } else {
            cause = cmds[0].getOutput();
        }
        Trace.out((String)("Error message from srvctl:" + cause));
        throw new DBUtilsException(cause, m_prvgMsgBundle, "11001", srvctl, localNode);
    }

    private String getCRSHome() throws DBUtilsException {
        String crsHome = VerificationUtil.getCRSHome();
        if (crsHome == null) {
            throw new DBUtilsException(m_prvfMsgBundle, "5301", new Object[0]);
        }
        return crsHome;
    }

    public String getDatabaseEnv(String crsHome, String dbUniqueName, String envVariableName) throws DBUtilsException {
        String[] env = new String[]{"ORACLE_HOME=" + crsHome, "NLS_LANG=American_America.US7ASCII"};
        String[] args = new String[]{"getenv", "database", "-d", dbUniqueName, "-t", envVariableName};
        String[] output = this.runSrvctl(crsHome, env, args);
        String val = null;
        if (output != null) {
            for (int i = 0; i < output.length; ++i) {
                String[] prop = output[i].split("=");
                Trace.out((String)("output[" + i + "]=" + output[i]));
                if (prop.length != 2 || !prop[0].equals(envVariableName)) continue;
                val = prop[1];
            }
        }
        return val;
    }

    public DatabaseEdition getDatabaseEdition(String databaseHome) throws DBUtilsException {
        String node = null;
        String[] homeNodes = null;
        Trace.out((String)("databaseHome[" + databaseHome + "]"));
        List<DatabaseInfo> dbInfoList = this.getDatabaseInfos();
        String dbUniqueName = null;
        boolean isUnix = new SystemFactory().CreateSystem().isUnixSystem();
        try {
            String canonicalDatabaseHome = new File(databaseHome).getCanonicalPath();
            for (DatabaseInfo dbInfo : dbInfoList) {
                if (isUnix) {
                    if (!new File(dbInfo.getHome()).getCanonicalPath().equals(canonicalDatabaseHome)) continue;
                    dbUniqueName = dbInfo.getUniqueName();
                } else {
                    if (!new File(dbInfo.getHome()).getCanonicalPath().equalsIgnoreCase(canonicalDatabaseHome)) continue;
                    dbUniqueName = dbInfo.getUniqueName();
                }
                break;
            }
        }
        catch (IOException e) {
            throw new DBUtilsException(e);
        }
        if (dbUniqueName == null) {
            throw new DBUtilsException(m_prvgMsgBundle, "11906", databaseHome);
        }
        homeNodes = this.getNodes(dbUniqueName);
        if (homeNodes == null) {
            throw new DBUtilsException(m_prvgMsgBundle, "11906", databaseHome);
        }
        node = homeNodes[0];
        Trace.out((String)("node[" + node + "]"));
        if (node == null) {
            throw new DBUtilsException(m_prvgMsgBundle, "11906", databaseHome);
        }
        return this.getDatabaseEdition(databaseHome, node);
    }

    public DatabaseEdition getDatabaseEdition(String databaseHome, String node) throws DBUtilsException {
        if (!new SystemFactory().CreateSystem().isUnixSystem()) {
            return this.getDatabaseEditionWindows(databaseHome, node);
        }
        return this.getDatabaseEditionLinux(databaseHome, node);
    }

    private DatabaseEdition getDatabaseEditionLinux(String databaseHome, String node) throws DBUtilsException {
        String dbCommand = null;
        Object verificationResult = null;
        String cvCmdOut = null;
        String libvsFile = "libvsn";
        String dbVersion = this.getDBVersionString(databaseHome);
        Trace.out((String)("DB version [" + dbVersion + "]"));
        if (dbVersion != null) {
            String[] tokens = dbVersion.split("\\.");
            if (tokens != null) {
                dbVersion = tokens[0];
            }
        } else {
            throw new DBUtilsException(m_prvgMsgBundle, "11907", databaseHome + VerificationConstants.FSEP + LIB_DIR + VerificationConstants.FSEP + libvsFile, node);
        }
        libvsFile = libvsFile + dbVersion + ".a";
        dbCommand = "strings " + databaseHome + VerificationConstants.FSEP + LIB_DIR + VerificationConstants.FSEP + libvsFile;
        RunGenericCommand cmd = new RunGenericCommand(node, dbCommand);
        Trace.out((String)("Trying to run " + dbCommand + " on node " + node));
        cmd.execute();
        cvCmdOut = cmd.getExectaskOutput();
        if (VerificationUtil.isStringGood(cvCmdOut)) {
            Pattern pattern = Pattern.compile(DB_ENTERPRISE_EDITION_LINUX, 32);
            Matcher matcher = pattern.matcher(cvCmdOut);
            if (matcher.matches()) {
                return DatabaseEdition.ENTERPRISE_EDITION;
            }
            return DatabaseEdition.STANDARD_EDITION;
        }
        throw new DBUtilsException(m_prvgMsgBundle, "11907", databaseHome + VerificationConstants.FSEP + LIB_DIR + VerificationConstants.FSEP + libvsFile, node);
    }

    private DatabaseEdition getDatabaseEditionWindows(String databaseHome, String node) throws DBUtilsException {
        String dbEdition = null;
        DatabaseEdition edition = null;
        String registryKeyFile = databaseHome + VerificationConstants.FSEP + "bin" + VerificationConstants.FSEP + ORACLE_KEY_FILE;
        String registryKey = null;
        try {
            FileReader oracleKeyReader = new FileReader(registryKeyFile);
            BufferedReader oracleKeyBufferReader = new BufferedReader(oracleKeyReader);
            registryKey = ORACLE_REGISTRY + oracleKeyBufferReader.readLine();
            oracleKeyBufferReader.close();
        }
        catch (FileNotFoundException fnfe) {
            Trace.out((String)("File [" + registryKeyFile + "]  " + fnfe.getMessage()));
            MessageBundle msgBundle = VerificationUtil.getMessageBundle("Prvg");
            throw new DBUtilsException(msgBundle, "11904", databaseHome, node);
        }
        catch (IOException ioe) {
            Trace.out((String)("File [" + registryKeyFile + "]  " + ioe.getMessage()));
            MessageBundle msgBundle = VerificationUtil.getMessageBundle("Prvg");
            throw new DBUtilsException(msgBundle, "11905", databaseHome, node);
        }
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        RegistryKeyData regData = new RegistryKeyData(registryKey, ORACLE_REGISTRY_BUNDLE_NAME);
        NativeResult nativeResult = new NativeResult();
        if (nativeSys.regKeyExists(node, registryKey, nativeResult)) {
            nativeResult.setStatus(false);
            nativeSys.regGetData(node, registryKey, ORACLE_REGISTRY_BUNDLE_NAME, regData, nativeResult);
            if (nativeResult.getStatus()) {
                dbEdition = regData.getStringData();
                Trace.out((String)("dbEdition [" + dbEdition + "]"));
                edition = dbEdition.equals(DB_ENTERPRISE) ? DatabaseEdition.ENTERPRISE_EDITION : DatabaseEdition.STANDARD_EDITION;
            }
        } else if (!nativeResult.getStatus()) {
            MessageBundle msgBundle = VerificationUtil.getMessageBundle("Prkn");
            throw new DBUtilsException(msgBundle, "1011", ORACLE_REGISTRY_BUNDLE_NAME, registryKey, node, nativeResult.getOSString());
        }
        return edition;
    }

    public List<String> getDatabaseUniquesNames(String dbHome) throws DBUtilsException {
        DatabaseInfo dbInfo = null;
        List<Object> homeUniquesNames = new Vector();
        if (this.m_dbHomeUniquesNames.containsKey(dbHome)) {
            homeUniquesNames = this.m_dbHomeUniquesNames.get(dbHome);
        } else {
            String[] uniquesNames = this.getDatabases();
            String dbInfoHome = null;
            if (uniquesNames != null) {
                for (String uniqueName : uniquesNames) {
                    dbInfo = this.getDatabaseInfo(uniqueName);
                    dbInfoHome = dbInfo.getHome();
                    if (new File(new File(dbInfoHome).getAbsolutePath()).compareTo(new File(new File(dbHome).getAbsolutePath())) == 0) {
                        homeUniquesNames.add(uniqueName);
                    }
                    this.m_dbHomeUniquesNames.put(dbHome, homeUniquesNames);
                }
                homeUniquesNames = this.m_dbHomeUniquesNames.get(dbHome);
            }
        }
        return this.m_dbHomeUniquesNames.get(dbHome);
    }

    public void testCredentials(String dbName, String dbUser, String dbPwd) throws DBConnectionException {
        OracleConnection oracleConnection = SQLFactory.getDBConnection((String)dbName, (String)dbUser, (String)dbPwd);
        try {
            oracleConnection.close();
        }
        catch (SQLException sqlEx) {
            Trace.out((String)("SQLException while closing the connection. Mesg:" + sqlEx.getMessage()));
        }
    }

    public ResultSet addDBConnectInfo(String database) {
        String userName = "DBSNMP";
        String password = null;
        String portStr = null;
        int port = 1521;
        String dbConnectDescr = null;
        ResultSet dbConRS = new ResultSet(1);
        ResultSet locrs = new ResultSet();
        try {
            boolean bPortReq = this.isPortRequiredForConnect(database);
            DatabaseConnectInfo dbConnInfo = null;
            if (VerificationUtil.isOTN()) {
                ConsoleUtil consoleUtil = new ConsoleUtil();
                if (bPortReq) {
                    String portPrompt = m_prvgMsgBundle.getMessage("11152", false, (Object[])new String[]{database});
                    portStr = consoleUtil.read(portPrompt);
                    try {
                        port = VerificationUtil.isStringGood(portStr) ? Integer.parseInt(portStr) : 1521;
                    }
                    catch (NumberFormatException e) {
                        Trace.out((String)("Invalid port. " + portStr + ". NumberFormatException occured. msg: " + e.getMessage()));
                        dbConRS = new ResultSet(2);
                        dbConRS.addErrorDescription(new ErrorDescription(e.getMessage()));
                        return dbConRS;
                    }
                    dbConnectDescr = this.getConnectDescriptor(database, port);
                } else {
                    dbConnectDescr = this.getConnectDescriptor(database);
                }
                String userNamePrompt = m_prvgMsgBundle.getMessage("11151", false, (Object[])new String[]{database, userName});
                userName = consoleUtil.read(userNamePrompt);
                if (!VerificationUtil.isStringGood(userName)) {
                    userName = "DBSNMP";
                }
                String passwordPrompt = m_prvgMsgBundle.getMessage("11150", false, (Object[])new String[]{userName, database});
                for (int nPasswdAtmts = 0; nPasswdAtmts < 3; ++nPasswdAtmts) {
                    try {
                        password = new String(consoleUtil.readPassword(passwordPrompt));
                        this.testCredentials(dbConnectDescr, userName, password);
                        dbConnInfo = bPortReq ? new DatabaseConnectInfo(database, userName, password, port) : new DatabaseConnectInfo(database, userName, password);
                        break;
                    }
                    catch (DBConnectionException e) {
                        String errMsg = e.getMessage();
                        Trace.out((String)("got DBConnectionException. mesg: " + errMsg));
                        if (!errMsg.contains(DB_CREDENTIAL_OERR) || nPasswdAtmts >= 2) {
                            throw e;
                        }
                        passwordPrompt = m_prvgMsgBundle.getMessage("11153", false, (Object[])new String[]{userName, database});
                        continue;
                    }
                }
            } else {
                password = HeavyWeightVerificationUtil.getDBPassword(database, userName, locrs);
                if (bPortReq) {
                    dbConnectDescr = this.getConnectDescriptor(database, port);
                    dbConnInfo = new DatabaseConnectInfo(database, userName, password, port);
                } else {
                    dbConnectDescr = this.getConnectDescriptor(database);
                    dbConnInfo = new DatabaseConnectInfo(database, userName, password);
                }
                this.testCredentials(dbConnectDescr, userName, password);
            }
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
        }
        catch (ConsoleUtilException e) {
            dbConRS = new ResultSet(2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                dbConRS.addErrorDescription(new ErrorDescription(msg));
            }
            return dbConRS;
        }
        catch (DBConnectionException e) {
            String msg = e.getMessage();
            dbConRS = new ResultSet(2);
            dbConRS.addErrorDescription(new ErrorDescription(msg));
            return dbConRS;
        }
        catch (DBUtilsException e) {
            dbConRS = new ResultSet(2);
            String msg = e.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                dbConRS.addErrorDescription(new ErrorDescription(msg));
            }
            return dbConRS;
        }
        catch (CVUException cvuEx) {
            dbConRS = new ResultSet(2);
            if (locrs.getResult(database).getStatus() == 3) {
                dbConRS.addResultSetData(locrs);
                return dbConRS;
            }
            String msg = cvuEx.getMessage();
            Trace.out((String)("CVUException occurred: msg" + msg));
            if (VerificationUtil.isStringGood(msg)) {
                dbConRS.addErrorDescription(new ErrorDescription(msg));
            }
            return dbConRS;
        }
        return dbConRS;
    }

    public static void main(String[] args) throws Exception {
        DBUtils u = new DBUtils(Version.getVersion((String)args[0]));
        String[] dbs = null;
        DatabaseInfo info = null;
        String desc = null;
        try {
            dbs = u.getDatabases();
            info = u.getDatabaseInfo(dbs[0]);
            desc = u.isPortRequiredForConnect(info.getUniqueName()) ? u.getConnectDescriptor(info.getUniqueName(), 1521) : u.getConnectDescriptor(info.getUniqueName());
            SQLFactory.main((String[])new String[]{desc, "scott", "tiger"});
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        System.out.println("database: " + dbs[0]);
        System.out.println("getDefaultServiceName: " + info.getDefaultServiceName());
        System.out.println("dbHome: " + info.getHome());
        System.out.println("dbVersion " + info.getVersion());
        System.out.println("Connect Descriptor: " + desc);
    }
}

