/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.pluggable;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.sql.DBConnectionException;
import oracle.cluster.sql.SQLFactory;
import oracle.cluster.verification.VerificationMessage;
import oracle.cluster.verification.VerificationMessageType;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.pluggable.DarwinPluggableTaskUtil;
import oracle.cluster.verification.pluggable.PluggableMsgType;
import oracle.cluster.verification.pluggable.VerificationExecutableException;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.rowset.OracleCachedRowSet;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.RunExeCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultKeyType;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.engine.factory.data.InstanceType;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.resources.PrveMsgID;

public class PluggableTaskUtil {
    protected static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prve");
    static final String LSEP = System.getProperty("line.separator");
    static final String FSEP = System.getProperty("file.separator");

    public static PluggableTaskUtil createPluggableTaskUtil(boolean darwin) {
        if (darwin) {
            return new DarwinPluggableTaskUtil();
        }
        return new PluggableTaskUtil();
    }

    public ResultSet execVerificationExecutable(String[] nodeList, ExecutableInfo execInfo) throws VerificationExecutableException {
        Trace.out((String)"Starting execVerificationExecutable...");
        ResultSet resultSet = PluggableTaskUtil.execExecutable(nodeList, execInfo);
        return resultSet;
    }

    public static ResultSet execExecutable(String[] nodeList, ExecutableInfo execInfo) throws VerificationExecutableException {
        Trace.out((String)"Starting execExecutable...");
        int numOfNodes = nodeList.length;
        String delim = " ";
        ResultSet resultSet = new ResultSet();
        if (execInfo.getExecutableType().equals((Object)ExecutableType.SQL)) {
            resultSet = PluggableTaskUtil.executeSQL(execInfo);
        } else {
            Command[] cmdList = new Command[numOfNodes];
            String command = null;
            String execName = null;
            Object executableArgs = null;
            Object execArgs = null;
            if (execInfo.getExecutableName() != null) {
                execName = execInfo.getExecutableNameWithPath();
                command = execInfo.getExecutableType().equals((Object)ExecutableType.SCRIPT) ? PluggableTaskUtil.getScriptNameWithExtension(execName) : execName;
                Trace.out((String)("Command: " + command));
                if (!new File(command).exists()) {
                    Trace.out((String)("Command '" + command + "' does not exist"));
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0007", true, (Object[])new String[]{command}));
                }
            } else {
                Trace.out((String)"Command not available with ExecuteInfo");
                throw new VerificationExecutableException(s_msgBundle.getMessage("0008", true));
            }
            StringBuilder commandLine = new StringBuilder();
            commandLine.append(command);
            List<ExecutableArgument> argList = execInfo.getExecutableArgs();
            for (ExecutableArgument eArg : argList) {
                String argVal = eArg.getArgVal(false);
                if (argVal == null || argVal.length() == 0) {
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0018", true));
                }
                if (eArg.getArgType() == ArgType.DERIVED) {
                    String varName = argVal;
                    argVal = eArg.getArgVal(true);
                    if (argVal == null || argVal.length() == 0) {
                        throw new VerificationExecutableException(s_msgBundle.getMessage("0009", true, (Object[])new String[]{varName}));
                    }
                }
                commandLine.append(" " + argVal);
            }
            for (int i = 0; i < numOfNodes; ++i) {
                cmdList[i] = new RunExeCommand(nodeList[i], commandLine.toString(), false);
            }
            new GlobalHandler().submit(cmdList, 0, resultSet);
            Hashtable ht = resultSet.getResultTable();
            Enumeration e = ht.keys();
            ResultSet rSet = new ResultSet();
            for (int i = 0; i < numOfNodes; ++i) {
                String node = cmdList[i].getNode();
                String[] rsltStr = cmdList[i].getCommandResult().getResultString();
                String reoutput = VerificationUtil.strArr2List(rsltStr, LSEP);
                Result tempRes = (Result)ht.get(node);
                tempRes.addResultInfo(reoutput);
                rSet.addResult(node, tempRes);
            }
            resultSet = PluggableTaskUtil.mapResultSet(rSet);
        }
        return resultSet;
    }

    private static ResultSet executeSQL(ExecutableInfo execInfo) throws VerificationExecutableException {
        String dbName = null;
        String roleASM = "sysdba";
        for (ExecutableArgument eArg : execInfo.getExecutableArgs()) {
            String argName = eArg.getArgName();
            String argVal = eArg.getArgVal(false);
            if (argVal == null || argVal.length() == 0) {
                throw new VerificationExecutableException(s_msgBundle.getMessage("0018", false));
            }
            if (eArg.getArgType() == ArgType.DERIVED) {
                String varName = argVal;
                argVal = eArg.getArgVal(true);
                if (argVal == null || argVal.length() == 0) {
                    throw new VerificationExecutableException(s_msgBundle.getMessage("0009", false, (Object[])new String[]{varName}));
                }
            }
            if (CVUVariableConstants.DB_NAME.name().equals(argName)) {
                dbName = argVal;
            }
            if (!CVUVariableConstants.ROLE_ASM.name().equals(argName)) continue;
            roleASM = argVal;
        }
        InstanceType insType = execInfo.getInstanceType();
        ResultSet rsltSet = new ResultSet();
        String query = execInfo.getExecutableName();
        Trace.out((String)("executing query: " + query + " on " + (Object)((Object)insType)));
        if (insType.equals((Object)InstanceType.ASM)) {
            String asmName = insType.toString();
            Result asmRes = new Result(asmName, execInfo.getExecInfoKeyType());
            OracleCachedRowSet rowSet = CVUHelperUtil.runASMQuery(query, roleASM, asmRes);
            rsltSet.addResult(asmName, asmRes);
            if (rowSet != null) {
                asmRes.addResultInfo(rowSet);
                rsltSet.addResult(asmName, 1);
            } else {
                rsltSet.addResult(asmName, 2);
            }
        } else {
            Result dbRes = new Result(dbName, ResultKeyType.DB_INSTANCE);
            String userName = null;
            String password = null;
            String connectString = null;
            rsltSet.addResult(dbName, dbRes);
            try {
                Version crsVer = VerificationUtil.getCRSActiveVersionObj();
                DBUtils dbUtils = new DBUtils(crsVer);
                DatabaseConnectInfo dbConnInfo = DatabaseConnectInfo.getDBConnectInfo(dbName);
                if (dbConnInfo != null) {
                    userName = dbConnInfo.userName();
                    password = dbConnInfo.userPassword();
                    connectString = dbUtils.getConnectDescriptor(dbConnInfo);
                }
                OracleConnection connection = SQLFactory.getDBConnection(connectString, (String)userName, password);
                Statement st = connection.createStatement();
                Trace.out((String)("executing query: " + query + " on " + (Object)((Object)insType)));
                java.sql.ResultSet rs = st.executeQuery(query);
                OracleCachedRowSet rowSet = new OracleCachedRowSet();
                rowSet.populate(rs);
                dbRes.addResultInfo(rowSet);
                rsltSet.addResult(dbName, 1);
                rs.close();
                st.close();
                connection.close();
            }
            catch (DBConnectionException e) {
                rsltSet.addResult(dbName, 2);
                rsltSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
                Trace.out((String)("DBConnectionException occured. message:" + e.getMessage()));
                Trace.out((Exception)((Object)e));
            }
            catch (SQLException e) {
                rsltSet.addResult(dbName, 2);
                rsltSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
                Trace.out((String)("SQLException occured. message:" + e.getMessage()));
                Trace.out((Exception)e);
            }
            catch (DBUtilsException e) {
                rsltSet.addResult(dbName, 2);
                rsltSet.addErrorDescription(dbName, new ErrorDescription(e.getMessage()));
                Trace.out((String)("DBUtilsException occured. message:" + e.getMessage()));
                Trace.out((Exception)e);
            }
        }
        return rsltSet;
    }

    public static ResultSet mapResultSet(ResultSet resultSet) {
        Trace.out((String)"Starting mapResultSet...");
        Hashtable ht = resultSet.getResultTable();
        Enumeration e = ht.keys();
        boolean i = false;
        ResultSet rsltSet = new ResultSet();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            String vfRslt = (String)result.getResultInfoSet().lastElement();
            if (VerificationUtil.isStringGood(vfRslt)) {
                String resultSetString = VerificationUtil.fetchTextByTags(vfRslt, "<RESULTSET>", "</RESULTSET>");
                if (VerificationUtil.isStringGood(resultSetString)) {
                    String[] resultStringArray;
                    for (String resultString : resultStringArray = VerificationUtil.fetchTextByTagsRepeat(resultSetString, "<RESULT>", "</RESULT>")) {
                        String rowIdStr = VerificationUtil.fetchTextByTags(resultSetString, "<ROW_ID>", "</ROW_ID>");
                        if (VerificationUtil.isStringGood(rowIdStr)) {
                            node = rowIdStr;
                        }
                        result = PluggableTaskUtil.mapResult(node, resultString, resultSet);
                        rsltSet.addResult(result.getNode(), result);
                    }
                    continue;
                }
                result = PluggableTaskUtil.mapResult(node, vfRslt, resultSet);
                rsltSet.addResult(result.getNode(), result);
                continue;
            }
            rsltSet.addResult(node, result);
        }
        return rsltSet;
    }

    private static Result mapResult(String node, String vfRslt, ResultSet rsltSet) {
        ErrorDescription errDesc;
        String execResult = new String();
        String execStatus = new String();
        String expectedVal = new String();
        String collectedVal = new String();
        String execErr = new String();
        String[] nlsMsgArr = null;
        Object data = null;
        String traceMsg = null;
        String global_err = null;
        String rowIdStr = null;
        String resultId = null;
        boolean displayFac = true;
        execStatus = VerificationUtil.fetchTextByTags(vfRslt, "<STATUS>", "</STATUS>");
        execResult = VerificationUtil.fetchTextByTags(vfRslt, "<RESULT>", "</RESULT>");
        expectedVal = VerificationUtil.fetchTextByTags(vfRslt, "<EXPECTED>", "</EXPECTED>");
        collectedVal = VerificationUtil.fetchTextByTags(vfRslt, "<COLLECTED>", "</COLLECTED>");
        execErr = VerificationUtil.fetchTextByTags(vfRslt, "<EXEC_ERROR>", "</EXEC_ERROR>");
        global_err = VerificationUtil.fetchTextByTags(vfRslt, "<GLOBAL_ERROR>", "</GLOBAL_ERROR>");
        nlsMsgArr = VerificationUtil.isStringGood(VerificationUtil.fetchVerificationValue(vfRslt)) ? VerificationUtil.fetchTextByTagsRepeat(VerificationUtil.fetchVerificationValue(vfRslt), "<NLS_MSG>", "</NLS_MSG>") : VerificationUtil.fetchTextByTagsRepeat(vfRslt, "<NLS_MSG>", "</NLS_MSG>");
        rowIdStr = VerificationUtil.fetchTextByTags(vfRslt, "<ROW_ID>", "</ROW_ID>");
        if (VerificationUtil.isStringGood(execStatus)) {
            execResult = execStatus;
        }
        ResultKeyType resultKeyType = null;
        if (VerificationUtil.isStringGood(rowIdStr)) {
            resultId = rowIdStr;
            resultKeyType = ResultKeyType.DB_INSTANCE;
        } else {
            resultId = node;
            resultKeyType = ResultKeyType.NODE;
        }
        Result result = new Result(resultId, resultKeyType);
        if (execResult != null) {
            if (execResult.equalsIgnoreCase("SUCC")) {
                result.setStatus(1);
                displayFac = false;
            } else if (execResult.equalsIgnoreCase("WARN")) {
                result.setStatus(4);
            } else if (execResult.equalsIgnoreCase("VFAIL")) {
                result.setStatus(3);
            } else if (execResult.equalsIgnoreCase("EFAIL")) {
                result.setStatus(2);
            } else {
                result.setStatus(5);
            }
        } else {
            Trace.out((String)"<RESULT> tags contain empty string.");
            result.addErrorInfo(s_msgBundle.getMessage("0010", false, (Object[])new String[]{vfRslt}));
            result.setStatus(5);
        }
        traceMsg = null;
        for (String nlsMsg : nlsMsgArr) {
            Trace.out((String)("Creating error description for nlsMsg: '" + nlsMsg + "'"));
            ErrorDescription errDesc2 = VerificationUtil.nlsTagsToErrorDescription(nlsMsg, displayFac);
            if (displayFac) {
                if (global_err != null && global_err.length() > 1) {
                    rsltSet.addErrorDescription(errDesc2);
                    continue;
                }
                result.addErrorDescription(errDesc2);
                continue;
            }
            String errMsg = errDesc2.getErrorMessage();
            VerificationMessage vfyMsg = new VerificationMessage(VerificationMessageType.VERBOSE, errMsg);
            if (global_err != null && global_err.length() > 1) {
                rsltSet.addVerificationMessage(vfyMsg);
                continue;
            }
            result.addVerificationMessage(vfyMsg);
        }
        traceMsg = VerificationUtil.fetchTextByTags(vfRslt, "<TRACE>", "</TRACE>");
        if (expectedVal != null) {
            result.setHasResultValues(true);
            Trace.out((String)("Creating error description for expectedVal: '" + expectedVal + "'"));
            errDesc = VerificationUtil.nlsTagsToErrorDescription(expectedVal, false);
            expectedVal = errDesc.getErrorMessage();
            result.setExpectedValue(expectedVal);
        }
        if (collectedVal != null) {
            result.setHasResultValues(true);
            Trace.out((String)("Creating error description for expectedVal: '" + expectedVal + "'"));
            errDesc = VerificationUtil.nlsTagsToErrorDescription(collectedVal, false);
            collectedVal = errDesc.getErrorMessage();
            result.setActualValue(collectedVal);
        }
        if (execErr != null) {
            result.addErrorInfo(execErr);
        }
        if (traceMsg != null) {
            result.addTraceInfo(traceMsg);
        }
        result.addResultInfo(vfRslt);
        Trace.out((String)("output " + execResult));
        Trace.out((String)("expectedVal " + expectedVal));
        Trace.out((String)("collecetdVal " + collectedVal));
        Trace.out((String)("execError " + execErr));
        Trace.out((String)("Trace " + traceMsg));
        Trace.out((String)("nlsMsg " + VerificationUtil.strArr2String(nlsMsgArr)));
        return result;
    }

    public static boolean cleanUp(String[] node, String dirPath, boolean isRecurse) {
        ClusterCmd cmd = new ClusterCmd();
        boolean ret = true;
        try {
            if (new File(dirPath).exists()) {
                cmd.removeDirectory(node, dirPath, isRecurse);
            }
        }
        catch (ClusterException ce) {
            ret = false;
            Trace.out((String)ce.getMessage());
        }
        return ret;
    }

    public String getPluggableMsg(PluggableMsgType msgType, String taskID, String[] msgParams, boolean displayErrCode) {
        String msgStr = null;
        try {
            String fieldName = msgType.getMsgIDExtn() + "_" + taskID;
            Class<?> c = Class.forName("oracle.ops.verification.resources.PrveMsgID");
            Field f = c.getField(fieldName);
            msgStr = s_msgBundle.getMessage((String)f.get(new GetPrveMsgID()), displayErrCode, (Object[])msgParams);
        }
        catch (ClassNotFoundException e) {
            Trace.out((String)("ClassNotFoundException encountered:" + e));
        }
        catch (NoSuchFieldException e) {
            Trace.out((String)("NoSuchFieldException encountered:" + e));
        }
        catch (IllegalAccessException e) {
            Trace.out((String)("IllegalAccessException encountered:" + e));
        }
        return msgStr;
    }

    public String getPluggableMsg(PluggableMsgType msgType, String taskID, String[] msgParams) {
        return this.getPluggableMsg(msgType, taskID, msgParams, false);
    }

    public static String getScriptNameWithExtension(String scriptFile) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            return scriptFile + ".sh";
        }
        return scriptFile + ".bat";
    }

    public static Constructor getClassConstructFromPackage(String className, String packageLocation, Class[] args) throws ClassNotFoundException, SecurityException, NoSuchMethodException {
        String classLocation = packageLocation + "." + className;
        Trace.out((String)("Creating Java object for \nClass: " + classLocation));
        Class<?> javaClass = Class.forName(classLocation);
        Constructor<?> constructor = javaClass.getConstructor(args);
        Trace.out((String)("Successfully Created constructor of \nClass: " + constructor.getName() + "\nConstructor Details: " + constructor.toGenericString()));
        return constructor;
    }

    public String getPluggableMsg(PluggableMsgType msgType, String taskID) {
        return this.getPluggableMsg(msgType, taskID, null);
    }

    private class GetPrveMsgID
    implements PrveMsgID {
        private GetPrveMsgID() {
        }
    }
}

