/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.nodemgr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.cmdtools.CRSCTLUtil;
import oracle.cluster.cmdtools.CmdToolUtilException;
import oracle.cluster.cmdtools.OLSNODESUtil;
import oracle.cluster.common.CSSMode;
import oracle.cluster.common.NodeRole;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.VerificationAPIConstants;
import oracle.cluster.verification.nodemgr.NoSuchNodesException;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.cluster.VoteDiskInfo;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.VerifyStorage;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.VerificationUtil;
import oracle.ops.verification.util.MultiNodeException;

public class NodeManager
implements VerificationAPIConstants {
    private Set<String> m_hubNodes = new HashSet<String>();
    private Set<String> m_rimNodes = new HashSet<String>();
    private Set<String> m_autoNodes = new HashSet<String>();
    private boolean m_bNewNodes = false;
    private Set<String> m_newHubNodes = new HashSet<String>();
    private Set<String> m_newRimNodes = new HashSet<String>();
    private Set<String> m_newAutoNodes = new HashSet<String>();
    private Set<String> m_activeRimNodes = new HashSet<String>();
    private Set<String> m_activeHubNodes = new HashSet<String>();
    private int m_hubSize = 0;
    private boolean m_isPre = false;
    private String[] m_asmDisks = null;
    private Set<String> m_hubCapableNodes = null;
    private Set<String> m_newHubCapableNodes = null;
    private Boolean m_isBigCluster = null;
    private boolean m_isSIDB = false;
    private boolean m_nodeRolesDetermined = true;
    private static String[] m_strArrType = new String[0];
    private static MessageBundle m_prvgMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static MessageBundle m_prvfMsgBundle = VerificationUtil.getMessageBundle("Prvf");
    private String m_crsActiveVersion = null;

    NodeManager(String[] hubNodes, String[] leafNodes, String[] autoNodes, int hubSize) {
        this.addArrayToSet(this.m_hubNodes, hubNodes);
        this.addArrayToSet(this.m_rimNodes, leafNodes);
        this.addArrayToSet(this.m_autoNodes, autoNodes);
        this.m_hubSize = hubSize;
        this.m_isPre = true;
        this.m_isBigCluster = true;
    }

    NodeManager(String[] nodeList) throws NodeManagerException {
        this(nodeList, false);
    }

    NodeManager(boolean isSIDB) throws NodeManagerException {
        this(null, isSIDB);
    }

    public NodeManager() throws NodeManagerException {
        this(false);
    }

    NodeManager(String[] nodeList, boolean isSIDB) throws NodeManagerException {
        boolean isPreCRSInst;
        boolean bl = isPreCRSInst = nodeList != null;
        if (isPreCRSInst && VerificationUtil.isUpgrade()) {
            isPreCRSInst = false;
        }
        if (isPreCRSInst) {
            this.addArrayToSet(this.m_hubNodes, nodeList);
            this.m_hubSize = this.m_hubNodes.size();
            this.m_isBigCluster = false;
            this.m_isPre = true;
            this.m_nodeRolesDetermined = false;
        } else {
            this.m_isSIDB = isSIDB;
            if (isSIDB) {
                return;
            }
            if (VerificationUtil.isCRSConfigured()) {
                String crsHome = VerificationUtil.getCRSHome();
                if (!VerificationUtil.isStringGood(crsHome)) {
                    Trace.out((String)"Unable to get CRS Home");
                    throw new NodeManagerException(m_prvfMsgBundle, "5301", new Object[0]);
                }
                Trace.out((String)"Calling VerificationUtil.getCRSActiveVersion()");
                this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersion();
                if (VerificationUtil.isVersionPre(this.m_crsActiveVersion, "12")) {
                    try {
                        Trace.out((String)"pre 12.1 cluster.");
                        this.m_hubNodes = new HashSet<String>();
                        Trace.out((String)"pre 12.1 cluster. trying to get all the nodes and set them as hub nodes");
                        this.addArrayToSet(this.m_hubNodes, VerificationUtil.getStaticNodelist());
                    }
                    catch (NodelistNotFoundException ex) {
                        Trace.out((String)("NodelistNotFoundException occured while getting static node list. mesg=" + ex.getMessage()));
                        throw new NodeManagerException(ex);
                    }
                    this.m_isBigCluster = new Boolean(false);
                    this.m_hubSize = this.m_hubNodes.size();
                    return;
                }
                try {
                    Trace.out((String)"Trying to get configured node roles");
                    HashMap roleMap = this.getClusterNodeConfigRoles(crsHome);
                    for (String string : roleMap.keySet()) {
                        NodeRole role = roleMap.get(string);
                        Trace.out((String)("node=" + string + ", role=" + role));
                        switch (role) {
                            case HUB: {
                                this.m_hubNodes.add(string);
                                break;
                            }
                            case RIM: {
                                this.m_rimNodes.add(string);
                                break;
                            }
                            case AUTO: {
                                this.m_autoNodes.add(string);
                            }
                        }
                    }
                    Trace.out((String)"Trying to get active node roles");
                    OLSNODESUtil olsNodes = new OLSNODESUtil(crsHome);
                    roleMap = olsNodes.getClusterNodeActiveRoles();
                    for (String node : roleMap.keySet()) {
                        NodeRole role = (NodeRole)roleMap.get(node);
                        Trace.out((String)("node=" + node + ", role=" + role));
                        switch ((NodeRole)roleMap.get(node)) {
                            case RIM: {
                                this.m_activeRimNodes.add(node);
                                break;
                            }
                            case HUB: {
                                this.m_activeHubNodes.add(node);
                            }
                        }
                    }
                    ClusterwareInfo clusterwareInfo = new ClusterwareInfo();
                    this.m_hubSize = clusterwareInfo.getTargetHubSize();
                }
                catch (CmdToolUtilException ctuEx) {
                    Trace.out((String)("CmdToolUtilException occured. message:" + ctuEx.getMessage()));
                    throw new NodeManagerException(ctuEx);
                }
                catch (InstallException iEx) {
                    Trace.out((String)("InstallException occured. message:" + iEx.getMessage()));
                    throw new NodeManagerException(iEx);
                }
            }
            if (VerificationUtil.isHAConfigured()) {
                this.m_isBigCluster = new Boolean(false);
                this.m_hubSize = 1;
                String localNode = VerificationUtil.getLocalNode();
                this.m_activeHubNodes.add(localNode);
                this.m_hubNodes.add(localNode);
            } else {
                Trace.out((String)"Throwing internal framework error because neither CRS nor HA was found to be configured.");
                throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
            }
        }
    }

    public synchronized void addNodes(String[] hubNodes, String[] leafNodes, String[] autoNodes, int hubSize) throws NodeManagerException {
        if (this.m_bNewNodes) {
            Trace.out((String)"addNodes is called more than once");
            Trace.stackTrace();
            throw new NoSuchNodesException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        this.addNodes(hubNodes, leafNodes, autoNodes);
        this.m_hubSize = hubSize;
    }

    public synchronized void addNodes(String[] hubNodes, String[] leafNodes, String[] autoNodes) throws NodeManagerException {
        if (this.m_bNewNodes) {
            Trace.out((String)"addNodes is called more than once");
            throw new NoSuchNodesException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        if (leafNodes != null && leafNodes.length > 0) {
            boolean isLeafAllowed = this.isBigCluster();
            if (isLeafAllowed) {
                if (this.m_crsActiveVersion == null) {
                    Trace.out((String)"Calling VerificationUtil.getCRSActiveVersion()");
                    this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersion();
                }
                if (!VerificationUtil.isVersionPre(this.m_crsActiveVersion, "12.2")) {
                    try {
                        ClusterwareInfo cwInfo = new ClusterwareInfo();
                        isLeafAllowed = ClusterwareInfo.isLeafNodeAllowed((String)VerificationUtil.getCRSHome());
                    }
                    catch (InstallException iEx) {
                        Trace.out((String)("InstallException occured. message:" + iEx.getMessage()));
                        Trace.stackTrace();
                        isLeafAllowed = false;
                    }
                }
            }
            if (!isLeafAllowed) {
                Trace.out((String)("addNodes() called with leaf nodes for non(FLEX/GNS) cluster isBigCluster: '" + this.isBigCluster() + "' isLeafAllowed: '" + isLeafAllowed + "'"));
                throw new NodeManagerException(m_prvgMsgBundle, "11410", new Object[0]);
            }
        }
        this.m_bNewNodes = true;
        this.m_newHubNodes = new HashSet<String>();
        this.addArrayToSet(this.m_newHubNodes, hubNodes);
        this.m_newRimNodes = new HashSet<String>();
        this.addArrayToSet(this.m_newRimNodes, leafNodes);
        this.m_newAutoNodes = new HashSet<String>();
        this.addArrayToSet(this.m_newAutoNodes, autoNodes);
    }

    public synchronized void addNodes(String[] nodes) throws NodeManagerException {
        if (this.m_bNewNodes) {
            Trace.out((String)"addNodes is called more than once");
            throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        this.m_bNewNodes = true;
        this.m_newHubNodes = new HashSet<String>();
        this.addArrayToSet(this.m_newHubNodes, nodes);
    }

    public boolean isNewNodesAvailable() {
        return this.m_bNewNodes;
    }

    public String[] getConfiguredHubNodes(String[] nodes) throws NoSuchNodesException {
        Set<String> hubNodes = this.intersect(this.m_hubNodes, nodes);
        if (hubNodes.size() == 0) {
            Trace.out((String)"No hub nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.HUB});
        }
        return hubNodes.toArray(m_strArrType);
    }

    public String[] getNewConfiguredHubNodes(String[] nodes) throws NoSuchNodesException, NodeManagerException {
        if (!this.m_bNewNodes) {
            Trace.out((String)"addNodes() shoould be called before calling this method");
            throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        Set<String> hubNodes = this.intersect(this.m_newHubNodes, nodes);
        if (hubNodes.size() == 0) {
            Trace.out((String)"No hub nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.HUB});
        }
        return hubNodes.toArray(m_strArrType);
    }

    public String[] getConfiguredHubNodes() throws NoSuchNodesException {
        return this.getConfiguredHubNodes(null);
    }

    public String[] getNewConfiguredHubNodes() throws NoSuchNodesException, NodeManagerException {
        return this.getNewConfiguredHubNodes(null);
    }

    public String[] getConfiguredRimNodes(String[] nodes) throws NoSuchNodesException {
        Set<String> rimNodes = this.intersect(this.m_rimNodes, nodes);
        if (rimNodes.size() == 0) {
            Trace.out((String)"no rim nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.RIM});
        }
        return rimNodes.toArray(m_strArrType);
    }

    public String[] getNewConfiguredRimNodes(String[] nodes) throws NoSuchNodesException, NodeManagerException {
        if (!this.m_bNewNodes) {
            Trace.out((String)"addNodes() shoould be called before calling this method");
            throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        Set<String> rimNodes = this.intersect(this.m_newRimNodes, nodes);
        if (rimNodes.size() == 0) {
            Trace.out((String)"no new rim nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.RIM});
        }
        return rimNodes.toArray(m_strArrType);
    }

    public String[] getConfiguredRimNodes() throws NoSuchNodesException {
        return this.getConfiguredRimNodes(null);
    }

    public String[] getNewConfiguredRimNodes() throws NoSuchNodesException, NodeManagerException {
        return this.getNewConfiguredRimNodes(null);
    }

    public String[] getConfiguredAutoNodes(String[] nodes) throws NoSuchNodesException {
        Set<String> autoNodes = this.intersect(this.m_autoNodes, nodes);
        if (autoNodes.size() == 0) {
            Trace.out((String)"no auto nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.AUTO});
        }
        return autoNodes.toArray(m_strArrType);
    }

    public String[] getNewConfiguredAutoNodes(String[] nodes) throws NoSuchNodesException, NodeManagerException {
        if (!this.m_bNewNodes) {
            Trace.out((String)"addNodes() shoould be called before calling this method");
            throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        Set<String> autoNodes = this.intersect(this.m_newAutoNodes, nodes);
        if (autoNodes.size() == 0) {
            Trace.out((String)"no new auto nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.AUTO});
        }
        return autoNodes.toArray(m_strArrType);
    }

    public String[] getConfiguredAutoNodes() throws NoSuchNodesException {
        return this.getConfiguredAutoNodes(null);
    }

    public String[] getAllConfiguredNodes(String[] nodes) throws NoSuchNodesException {
        Set<Object> allNodes = new HashSet<String>();
        allNodes.addAll(this.m_autoNodes);
        allNodes.addAll(this.m_hubNodes);
        allNodes.addAll(this.m_rimNodes);
        allNodes = this.intersect(allNodes, nodes);
        if (allNodes.size() == 0) {
            Trace.out((String)"no nodes were found among the nodes passed");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.ALL});
        }
        return allNodes.toArray(m_strArrType);
    }

    public String[] getAllConfiguredNodes() throws NoSuchNodesException, NodeManagerException {
        return this.getAllConfiguredNodes(null);
    }

    public String[] getNewConfiguredAutoNodes() throws NoSuchNodesException, NodeManagerException {
        return this.getNewConfiguredAutoNodes(null);
    }

    public String[] getHubCapableNodes(String[] nodes) throws NodeManagerException, NoSuchNodesException {
        Set<String> hubCapables = this.intersect(this.hubCapableNodesInternal(false), nodes);
        Trace.out((String)("hubCapables=" + hubCapables));
        if (hubCapables.size() == 0) {
            Trace.out((String)"no hub capable nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.HUB_CAPABLE});
        }
        return hubCapables.toArray(m_strArrType);
    }

    public String[] getNewHubCapableNodes(String[] nodes) throws NodeManagerException, NoSuchNodesException {
        if (!this.m_bNewNodes) {
            Trace.out((String)"addNodes() shoould be called before calling this method");
            throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
        }
        Set<String> hubCapables = this.intersect(this.hubCapableNodesInternal(true), nodes);
        Trace.out((String)("hubCapables=" + hubCapables));
        if (hubCapables.size() == 0) {
            Trace.out((String)"no new hub capable nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.HUB_CAPABLE});
        }
        return hubCapables.toArray(m_strArrType);
    }

    public String[] getHubCapableNodes() throws NodeManagerException, NoSuchNodesException {
        return this.getHubCapableNodes(null);
    }

    public String[] getNewHubCapableNodes() throws NodeManagerException, NoSuchNodesException {
        return this.getNewHubCapableNodes(null);
    }

    public String[] getActiveHubNodes(String[] nodes) throws NoSuchNodesException {
        Set<String> hubNodes = this.intersect(this.m_activeHubNodes, nodes);
        if (hubNodes.size() == 0) {
            Trace.out((String)"no active hub nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.HUB_ACTIVE});
        }
        return hubNodes.toArray(m_strArrType);
    }

    public String[] getActiveHubNodes() throws NoSuchNodesException {
        return this.getActiveHubNodes(null);
    }

    public String[] getActiveRimNodes(String[] nodes) throws NoSuchNodesException {
        Set<String> rimNodes = this.intersect(this.m_activeRimNodes, nodes);
        if (rimNodes.size() == 0) {
            Trace.out((String)"no active leaf nodes were found");
            throw new NoSuchNodesException(m_prvgMsgBundle, "11310", new Object[]{NodeRoleCapability.RIM_ACTIVE});
        }
        return rimNodes.toArray(m_strArrType);
    }

    public String[] getActiveRimNodes() throws NoSuchNodesException {
        return this.getActiveRimNodes(null);
    }

    public boolean isActiveRimNode(String node) {
        if (this.m_activeRimNodes.size() == 0) {
            return false;
        }
        Set<String> rimNodes = this.intersect(this.m_activeRimNodes, new String[]{node});
        if (rimNodes.size() == 0) {
            Trace.out((String)"not an active leaf node");
            return false;
        }
        Trace.out((String)"active leaf node");
        return true;
    }

    public String[] getNodes(String[] nodes, NodeRoleCapability type) throws NoSuchNodesException, NodeManagerException {
        String[] retNodes = null;
        switch (type) {
            case HUB: {
                retNodes = this.getConfiguredHubNodes(nodes);
                break;
            }
            case HUB_CAPABLE: {
                retNodes = this.getHubCapableNodes(nodes);
                break;
            }
            case RIM: {
                retNodes = this.getConfiguredRimNodes(nodes);
                break;
            }
            case AUTO: {
                retNodes = this.getConfiguredAutoNodes(nodes);
                break;
            }
            case HUB_ACTIVE: {
                retNodes = this.getActiveHubNodes(nodes);
                break;
            }
            case RIM_ACTIVE: {
                retNodes = this.getActiveRimNodes(nodes);
                break;
            }
            case ALL: {
                retNodes = this.getAllConfiguredNodes(nodes);
            }
        }
        return retNodes;
    }

    public String[] getNewNodes(String[] nodes, NodeRoleCapability type) throws NoSuchNodesException, NodeManagerException {
        String[] retNodes = null;
        switch (type) {
            case HUB: {
                retNodes = this.getNewConfiguredHubNodes(nodes);
                break;
            }
            case HUB_CAPABLE: {
                retNodes = this.getNewHubCapableNodes(nodes);
                break;
            }
            case RIM: {
                retNodes = this.getNewConfiguredRimNodes(nodes);
                break;
            }
            case AUTO: {
                retNodes = this.getNewConfiguredAutoNodes(nodes);
                break;
            }
            case ALL: {
                ArrayList<String> newNodeList = new ArrayList<String>();
                try {
                    newNodeList.addAll(Arrays.asList(this.getNewConfiguredHubNodes(nodes)));
                }
                catch (NoSuchNodesException nsne) {
                    Trace.out((String)"No Hub nodes found for ALL type.");
                }
                try {
                    newNodeList.addAll(Arrays.asList(this.getNewHubCapableNodes(nodes)));
                }
                catch (NoSuchNodesException nsne) {
                    Trace.out((String)"No HubCapable nodes found for ALL type.");
                }
                try {
                    newNodeList.addAll(Arrays.asList(this.getNewConfiguredRimNodes(nodes)));
                }
                catch (NoSuchNodesException nsne) {
                    Trace.out((String)"No Rim nodes found for ALL type.");
                }
                try {
                    newNodeList.addAll(Arrays.asList(this.getNewConfiguredAutoNodes(nodes)));
                }
                catch (NoSuchNodesException nsne) {
                    Trace.out((String)"No Auto nodes found for ALL type.");
                }
                retNodes = newNodeList.toArray(new String[newNodeList.size()]);
                break;
            }
            default: {
                Trace.out((String)("invalid NodeRoleCapability " + (Object)((Object)type) + " is specified."));
                throw new NodeManagerException(m_prvfMsgBundle, "7508", new Object[0]);
            }
        }
        return retNodes;
    }

    public String[] getNodes(NodeRoleCapability type) throws NoSuchNodesException, NodeManagerException {
        return this.getNodes(null, type);
    }

    public String[] getNewNodes(NodeRoleCapability type) throws NoSuchNodesException, NodeManagerException {
        return this.getNewNodes(null, type);
    }

    public int getTargetHubSize() {
        return this.m_hubSize;
    }

    public boolean isBigCluster() {
        if (this.m_isBigCluster == null) {
            if (this.m_isPre) {
                this.isBigClusterPre();
            } else {
                this.isBigClusterPost();
            }
        }
        return this.m_isBigCluster;
    }

    public boolean isSIDB() {
        return this.m_isSIDB;
    }

    public boolean nodeRolesDetermined() {
        return this.m_nodeRolesDetermined;
    }

    public boolean equals(String[] hubNodes, String[] rimNodes, String[] autoNodes, int hubSize) {
        boolean retVal = true;
        int arrLen = 0;
        HashSet tmpSet = new HashSet();
        arrLen = hubNodes == null ? 0 : hubNodes.length;
        boolean bl = retVal = this.m_hubNodes.size() == arrLen;
        if (retVal) {
            this.addArrayToSet(tmpSet, hubNodes);
            retVal = tmpSet.containsAll(this.m_hubNodes);
        }
        arrLen = rimNodes == null ? 0 : rimNodes.length;
        if (retVal &= this.m_rimNodes.size() == arrLen) {
            tmpSet.clear();
            this.addArrayToSet(tmpSet, rimNodes);
            retVal = tmpSet.containsAll(this.m_rimNodes);
        }
        arrLen = autoNodes == null ? 0 : autoNodes.length;
        if (retVal &= this.m_autoNodes.size() == arrLen) {
            tmpSet.clear();
            this.addArrayToSet(tmpSet, autoNodes);
            retVal = tmpSet.containsAll(this.m_autoNodes);
        }
        retVal = retVal && this.m_hubSize == hubSize;
        return retVal;
    }

    private synchronized Set<String> hubCapableNodesInternal(boolean bNewNodes) throws NodeManagerException {
        if (bNewNodes && this.m_newHubCapableNodes != null) {
            return this.m_newHubCapableNodes;
        }
        if (!bNewNodes && this.m_hubCapableNodes != null) {
            return this.m_hubCapableNodes;
        }
        HashSet<String> hubCapableNodes = new HashSet<String>();
        Set<String> autoNodes = null;
        Set<String> hubNodes = null;
        if (bNewNodes) {
            this.m_newHubCapableNodes = hubCapableNodes;
            autoNodes = this.m_newAutoNodes;
            hubNodes = this.m_newHubNodes;
        } else {
            this.m_hubCapableNodes = hubCapableNodes;
            autoNodes = this.m_autoNodes;
            hubNodes = this.m_hubNodes;
        }
        if (!this.isBigCluster()) {
            if (bNewNodes) {
                Trace.out((String)"Cluster is not Flex Cluster. all new hub nodes are hubcapable nodes");
            } else {
                Trace.out((String)"Cluster is not Flex Cluster. all hub nodes are hubcapable nodes");
            }
            Trace.out((String)("hubNodes=" + VerificationUtil.strCollection2String(hubNodes)));
            hubCapableNodes.addAll(hubNodes);
            return hubCapableNodes;
        }
        if (autoNodes.size() > 0) {
            if (this.m_asmDisks == null) {
                this.m_asmDisks = this.getVotingDisks();
            }
            hubCapableNodes.addAll(autoNodes);
            HashSet<String> succNodes = new HashSet<String>();
            Vector<StorageInfo> stInfoVect = new Vector<StorageInfo>();
            VerifyStorage vfyStorage = new VerifyStorage();
            boolean bEx = false;
            try {
                for (String disk : this.m_asmDisks) {
                    stInfoVect.clear();
                    succNodes.clear();
                    Trace.out((String)("Trying to get nodes where disk " + disk + " is shared"));
                    String release = this.m_crsActiveVersion;
                    if (release == null) {
                        release = "12.2";
                    }
                    vfyStorage.isShared(disk, hubCapableNodes.toArray(m_strArrType), stInfoVect, OracleFileType.RAC_OCR_VDISK, 0, succNodes, release, true);
                    hubCapableNodes.retainAll(succNodes);
                }
            }
            catch (StorageException stEx) {
                bEx = true;
                Trace.out((String)"StorageException exception occured while determining the asm disks sharedness");
                Trace.out((String)("Message : " + stEx.getMessage()));
                Trace.out((Exception)stEx);
                Trace.out((String)"Throwing NodeManagerException...");
                throw new NodeManagerException(stEx);
            }
            catch (MultiNodeException mEx) {
                bEx = true;
                Trace.out((String)"MultiNodeException exception occured while determining the asm disks sharedness");
                Trace.out((String)("Message : " + mEx.getMessage()));
                Trace.out((Exception)mEx);
                Trace.out((String)"Throwing NodeManagerException...");
                throw new NodeManagerException(mEx);
            }
            finally {
                if (bEx) {
                    if (bNewNodes) {
                        this.m_newHubCapableNodes = null;
                    } else {
                        this.m_hubCapableNodes = null;
                    }
                }
            }
        }
        hubCapableNodes.addAll(hubNodes);
        return hubCapableNodes;
    }

    private String[] getVotingDisks() throws NodeManagerException {
        String[] disks = null;
        if (this.m_isPre) {
            Trace.out((String)("getting disks in voting diskgroup from cvu variable " + VAR_ASM_DISKGROUP_DISKS));
            String disksStr = CVUVariables.getValue(CVUVariableConstants.ASM_DISKGROUP_DISKS);
            if (disksStr == null || disksStr.length() == 0) {
                Trace.out((String)(VAR_ASM_DISKGROUP_DISKS + " is set to empty. throwing NodeManagerException"));
                throw new NoSuchNodesException(m_prvfMsgBundle, "5461", VAR_ASM_DISKGROUP_DISKS);
            }
            Trace.out((String)("got " + VAR_ASM_DISKGROUP_DISKS + " = " + disksStr));
            disks = VerificationUtil.string2strArr(disksStr);
            return disks;
        }
        Trace.out((String)"Calling VerificationUtil.getCRSActiveVersionObj()");
        Version crsVer = VerificationUtil.getCRSActiveVersionObj();
        if (crsVer == null) {
            Trace.out((String)"could not get crs active version");
            throw new NodeManagerException(m_prvfMsgBundle, "5434", new Object[0]);
        }
        try {
            Trace.out((String)"Getting Voting Disk locations");
            String crsHome = VerificationUtil.getCRSHome();
            ClusterInfo ci = new ClusterInfo(crsHome, crsVer);
            VoteDiskInfo[] voteDiskList = ci.getVoteDiskLocations();
            HashSet<String> asmDisks = new HashSet<String>();
            for (VoteDiskInfo vDskInfo : voteDiskList) {
                if (vDskInfo.isASMPath() != 1) continue;
                Trace.out((String)("Voting Disk location on ASM: " + vDskInfo.toString()));
                asmDisks.add(vDskInfo.getPath());
            }
            disks = asmDisks.toArray(m_strArrType);
        }
        catch (ClusterInfoException ciEx) {
            Trace.out((String)"ClusterInfoException occured while getting Voting disk location");
            new NodeManagerException(ciEx);
        }
        return disks;
    }

    private Set<String> intersect(Set s1, String[] s2) {
        if (s2 == null) {
            return s1;
        }
        HashSet<String> s = new HashSet<String>();
        this.addArrayToSet(s, s2);
        s.retainAll(s1);
        return s;
    }

    private Set<String> intersect(String[] s1, String[] s2) {
        HashSet<String> set1 = new HashSet<String>();
        this.addArrayToSet(set1, s1);
        HashSet set2 = new HashSet();
        this.addArrayToSet(set2, s2);
        set1.retainAll(set2);
        return set1;
    }

    private void addArrayToSet(Set s, String[] strs) {
        if (strs == null) {
            return;
        }
        for (String str : strs) {
            s.add(str);
        }
    }

    private Map<String, NodeRole> getClusterNodeConfigRoles(String crsHome) throws CmdToolUtilException, NodeManagerException {
        String localNode = VerificationUtil.getLocalNode();
        CRSCTLUtil crsCtl = new CRSCTLUtil(crsHome);
        NodeRole localNodeRole = crsCtl.getNodeConfigRole(localNode);
        Trace.out((String)("localNodeRole = " + localNodeRole));
        if (localNodeRole != NodeRole.AUTO) {
            Trace.out((String)"treat configured node role as active node role.");
            OLSNODESUtil olsNodes = new OLSNODESUtil(crsHome);
            return olsNodes.getClusterNodeActiveRoles();
        }
        Trace.out((String)"localNodeRole is AUTO. treat all configured node roles as AUTO");
        String[] nodeList = null;
        try {
            nodeList = VerificationUtil.getNodelistFromOlsnodesWithException();
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("NodelistNotFoundException occured. mesg=" + e.getMessage()));
            throw new NodeManagerException(e);
        }
        HashMap<String, NodeRole> roleMap = new HashMap<String, NodeRole>();
        for (String node : nodeList) {
            roleMap.put(node, NodeRole.AUTO);
        }
        return roleMap;
    }

    private synchronized boolean isBigClusterPre() {
        Trace.out((String)"pre cluster operation.");
        String isBigStr = CVUVariables.getValue(CVUVariableConstants.BIGCLUSTER);
        boolean isBig = isBigStr != null && isBigStr.equalsIgnoreCase("YES");
        this.m_isBigCluster = isBig;
        VerificationUtil.traceAndLog("Setting m_isBigCluster to:" + this.m_isBigCluster);
        return isBig;
    }

    private synchronized boolean isBigClusterPost() {
        boolean isBig = false;
        Trace.out((String)"post cluster operation.");
        if (this.m_crsActiveVersion == null) {
            Trace.out((String)"Calling VerificationUtil.getCRSActiveVersion()");
            this.m_crsActiveVersion = VerificationUtil.getCRSActiveVersion();
        }
        if (VerificationUtil.isVersionPre(this.m_crsActiveVersion, "12.2")) {
            Trace.out((String)"pre 12.2 cluster.");
            isBig = CVUHelperUtil.getCSSMode() == CSSMode.cssBCCLUSTERED;
        } else {
            Trace.out((String)"12.2 cluster or later.");
            if (VerificationUtil.getClusterType().equalsIgnoreCase("flex")) {
                isBig = true;
            }
        }
        this.m_isBigCluster = isBig;
        VerificationUtil.traceAndLog("Setting m_isBigCluster to:" + this.m_isBigCluster);
        return isBig;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("\n  m_hubNodes: " + this.m_hubNodes.toString() + "\n  m_rimNodes: " + this.m_rimNodes.toString() + "\n  m_autoNodes: " + this.m_autoNodes.toString() + "\n  m_bNewNodes: " + this.m_bNewNodes + "\n  m_newHubNodes: " + this.m_newHubNodes.toString() + "\n  m_newRimNodes: " + this.m_newRimNodes.toString() + "\n  m_newAutoNodes: " + this.m_newAutoNodes.toString() + "\n  m_activeLeafNodes: " + this.m_activeRimNodes.toString() + "\n  m_activeHubNodes: " + this.m_activeHubNodes.toString() + "\n  m_hubSize: " + this.m_hubSize + "\n  m_isPre: " + this.m_isPre + "\n  m_hubCapableNodes: " + (this.m_hubCapableNodes == null ? "<null>" : this.m_hubCapableNodes.toString()) + "\n  m_newHubCapableNodes: " + (this.m_newHubCapableNodes == null ? "<null>" : this.m_newHubCapableNodes.toString()) + "\n  m_isBigCluster: " + this.m_isBigCluster + "\n  m_isSIDB: " + this.m_isSIDB + "\n  m_crsActiveVersion: " + this.m_crsActiveVersion + "\n  m_asmDisks: " + (this.m_asmDisks == null ? "<null>" : VerificationUtil.strArr2List(this.m_asmDisks)));
        return sb.toString();
    }
}

