/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.cluster.common.InvalidArgsException;
import oracle.cluster.impl.util.Utils;
import oracle.cluster.impl.verification.FixupResultSetImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.ExecCommandNoUserEq;
import oracle.cluster.remote.ExecException;
import oracle.cluster.remote.RemoteFactory;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.util.CompositeOperationException;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.fixup.SSHSetupConstants;
import oracle.cluster.verification.fixup.controller.SSHSetupNodeThread;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.VerificationUtil;

public class SetupSSHUserEquivalence
implements SSHSetupConstants {
    private Collection<String> m_nodesToSetupSSH;
    private UserInfo m_credentials;
    private List<Set<String>> m_homeSharingNodesGroupList;
    private int m_timeOutInSeconds = 10;
    private String m_forUser = null;
    private String m_userName = null;
    private String m_localNode = null;
    private boolean m_includeLocalNodeInSSHSetup = true;

    public SetupSSHUserEquivalence(Collection<String> nodeList, UserInfo credentials) throws FixupException {
        this.m_nodesToSetupSSH = nodeList;
        this.m_credentials = credentials;
        this.m_homeSharingNodesGroupList = new ArrayList<Set<String>>();
        if (this.m_credentials != null) {
            this.m_userName = this.m_credentials.getUsername();
        }
        this.init();
    }

    public SetupSSHUserEquivalence(Collection<String> nodeList, RemoteUserInfo credentials, String forUser) throws FixupException {
        this.m_nodesToSetupSSH = nodeList;
        this.m_credentials = credentials;
        this.m_forUser = forUser;
        if (this.m_credentials != null) {
            this.m_userName = credentials.getMode().equals((Object)ConfigurationSetup.ConfigMethod.ROOT) ? Utils.getRootUserName() : this.m_credentials.getUsername();
        }
        this.m_homeSharingNodesGroupList = new ArrayList<Set<String>>();
        this.init();
    }

    private void init() throws FixupException {
        this.m_localNode = VerificationUtil.getLocalNode();
        this.m_includeLocalNodeInSSHSetup = this.m_nodesToSetupSSH.contains(this.m_localNode);
        ResultSet resultSet = new ResultSet();
        HashSet<String> succNodes = new HashSet<String>();
        HashSet<String> failNodes = new HashSet<String>();
        VerificationUtil.checkDestLoc(new String[]{this.m_localNode}, resultSet, succNodes, failNodes, false);
        if (succNodes.isEmpty() || resultSet.anyFailure()) {
            throw new FixupException(VerificationUtil.errorCollection2String(resultSet.getErrors()));
        }
        Trace.out((String)"Initial setup is successful on local node for performing the SSH user equivalence fix-up");
    }

    public FixupResultSet performSetup() throws FixupException {
        FixupResultSetImpl resultSet = new FixupResultSetImpl(this.m_nodesToSetupSSH.toArray(new String[0]));
        ResultSet workdDirSetupRes = this.setupWorkDirectory(this.m_nodesToSetupSSH);
        resultSet.updateResultSet(workdDirSetupRes);
        List<Object> nodesToProceedWith = new ArrayList();
        if (!this.m_includeLocalNodeInSSHSetup && workdDirSetupRes.getSuccessfulNodes().contains(this.m_localNode)) {
            for (String n : workdDirSetupRes.getSuccessfulNodes()) {
                if (n.equalsIgnoreCase(this.m_localNode)) continue;
                nodesToProceedWith.add(n);
            }
        } else {
            nodesToProceedWith = workdDirSetupRes.getSuccessfulNodes();
        }
        if (!nodesToProceedWith.isEmpty()) {
            ResultSet rsaHostKeyGenRes = this.generateRSAHostKeys(nodesToProceedWith);
            resultSet.updateResultSet(rsaHostKeyGenRes);
            nodesToProceedWith = rsaHostKeyGenRes.getSuccessfulNodes();
            if (!nodesToProceedWith.isEmpty()) {
                Trace.out((String)("Work directory was successfully setup on nodes " + nodesToProceedWith + " Now generating the public/private " + "keys on these nodes"));
                ResultSet keyGenResultSet = this.generateSSHKeys(nodesToProceedWith);
                resultSet.updateResultSet(keyGenResultSet);
                nodesToProceedWith = keyGenResultSet.getSuccessfulNodes();
                if (!nodesToProceedWith.isEmpty()) {
                    Trace.out((String)("SSH Key generation was successful on nodes " + nodesToProceedWith));
                    Set<String> nodesForExportingKey = this.selectNodeFromNodesSharingHome(nodesToProceedWith);
                    Trace.out((String)("Now setting up the export key file on nodes " + nodesForExportingKey));
                    ResultSet exportKeysRes = this.setupExportKeyFile(nodesForExportingKey);
                    resultSet.updateResultSet(exportKeysRes);
                    nodesToProceedWith = exportKeysRes.getSuccessfulNodes();
                    if (!nodesToProceedWith.isEmpty()) {
                        Trace.out((String)("Public key list was successfully  exported to nodes " + nodesToProceedWith + " Now updating authorized_keys file " + " for nodes " + nodesToProceedWith));
                        ResultSet updateKeysRes = this.updateKeysFile(nodesToProceedWith, SSHSetupConstants.KeysFileType.AUTHORIZED_KEYS);
                        resultSet.updateResultSet(updateKeysRes);
                        Trace.out((String)("authorized_keys file was successfully  updated on nodes " + updateKeysRes.getSuccessfulNodes() + " Now updating RSA host keys inside known_hosts file " + " for nodes " + nodesToProceedWith));
                        ResultSet updateRSAHostKeysRes = this.updateKeysFile(nodesToProceedWith, SSHSetupConstants.KeysFileType.KNOWN_HOSTS);
                        resultSet.updateResultSet(updateRSAHostKeysRes);
                        Trace.out((String)("known_hosts file was successfully  updated on nodes " + updateRSAHostKeysRes.getSuccessfulNodes()));
                    }
                }
            }
        }
        this.cleanUpSSHSetupDirectory(this.m_nodesToSetupSSH);
        File exportFile = new File(EXPORT_PUBLIC_KEY_FILE_PATH);
        if (exportFile.exists()) {
            exportFile.delete();
        }
        return resultSet;
    }

    public void setMaximumCommandTimeOut(int timeOutInSeconds) {
        this.m_timeOutInSeconds = timeOutInSeconds;
    }

    private ResultSet generateRSAHostKeys(List<String> nodeList) throws FixupException {
        ArrayList<SSHSetupNodeThread> generateRSAHostKeyThreadList = new ArrayList<SSHSetupNodeThread>();
        for (String node : nodeList) {
            generateRSAHostKeyThreadList.add(new SSHSetupNodeThread.generateRSAHostKeyThread(node));
        }
        return this.spawnNodeThreads(generateRSAHostKeyThreadList, 0);
    }

    private ResultSet generateSSHKeys(List<String> nodeList) {
        ResultSet resultSet = new ResultSet();
        try {
            Hashtable<Object, String> nodePublicKeyLocationTable = new Hashtable<Object, String>();
            ExecCommandNoUserEq cmdObject = null;
            cmdObject = this.m_forUser == null || VerificationUtil.isStringGood(this.m_userName) && this.m_userName.equals(this.m_forUser) ? RemoteFactory.getInstance().getExecCommandNoUserEq(this.m_credentials) : RemoteFactory.getInstance().getExecCommandNoUserEq((RemoteUserInfo)this.m_credentials, this.m_forUser);
            Map resultMap = cmdObject.runCmd(EXECTASK_COMPLETE_PATH, EXECTASK_GENERATE_SSH_KEYS_ARGS, nodeList.toArray(new String[0]), this.m_timeOutInSeconds);
            for (Object node : resultMap.keySet()) {
                Result nodeResult = new Result((String)node);
                CommandResult commandResult = (CommandResult)resultMap.get(node);
                if (commandResult.getStatus()) {
                    String[] output = commandResult.getOutputString();
                    if (output != null) {
                        String publicKeyLocation = null;
                        for (String line : output) {
                            Trace.out((String)line);
                        }
                        String outputStr = VerificationUtil.strArr2String(output);
                        Trace.out((String)("The exectask command output is \n" + outputStr));
                        String keyGenerateTagsContent = VerificationUtil.fetchTextByTags(outputStr, "GENERATE");
                        if (VerificationUtil.isStringGood(keyGenerateTagsContent)) {
                            Trace.out((String)("The GENERATE tags contains (" + keyGenerateTagsContent + ")"));
                            if (keyGenerateTagsContent.contains("PUB_KEY")) {
                                publicKeyLocation = VerificationUtil.fetchTextByTags(keyGenerateTagsContent, "PUB_KEY");
                                Trace.out((String)("Pub key file location is " + publicKeyLocation));
                                nodePublicKeyLocationTable.put(node, publicKeyLocation);
                                nodeResult.setStatus(1);
                            } else {
                                String[] nlsMsgArr;
                                nodeResult.setStatus(2);
                                String dispFacilityStr = VerificationUtil.fetchTextByTags(keyGenerateTagsContent, "<DISP_FACILITY>", "</DISP_FACILITY>");
                                boolean dispFacility = true;
                                if (VerificationUtil.isStringGood(dispFacilityStr)) {
                                    dispFacility = Boolean.parseBoolean(dispFacilityStr);
                                }
                                if ((nlsMsgArr = VerificationUtil.fetchTextByTagsRepeat(keyGenerateTagsContent, "<NLS_MSG>", "</NLS_MSG>")) != null && nlsMsgArr.length > 0) {
                                    for (String nlsMsg : nlsMsgArr) {
                                        nodeResult.addErrorDescription(VerificationUtil.nlsTagsToErrorDescription(nlsMsg, dispFacility));
                                    }
                                } else {
                                    Trace.out((String)"Failed but no errors");
                                }
                            }
                        } else {
                            String errorMsg = s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(EXECTASK_GENERATE_SSH_KEYS_ARGS, " "), node, "0"}) + LSEP + outputStr;
                            VerificationUtil.traceAndLogError(errorMsg);
                            nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                            nodeResult.setStatus(2);
                        }
                    } else {
                        String errorMsg = s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(EXECTASK_GENERATE_SSH_KEYS_ARGS, " "), node, "0"});
                        VerificationUtil.traceAndLogError(errorMsg);
                        nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                        nodeResult.setStatus(2);
                    }
                } else {
                    VerificationUtil.traceAndLogError(commandResult.getErrorString());
                    nodeResult.setStatus(2);
                    nodeResult.addErrorDescription(new ErrorDescription(commandResult.getErrorString()));
                }
                resultSet.addResult((String)node, nodeResult);
            }
            ArrayList<SSHSetupNodeThread> importKeyThreadList = new ArrayList<SSHSetupNodeThread>();
            for (String node : nodePublicKeyLocationTable.keySet()) {
                importKeyThreadList.add(new SSHSetupNodeThread.ImportPublicKeyThread((String)nodePublicKeyLocationTable.get(node), node, this.m_credentials));
            }
            if (!importKeyThreadList.isEmpty()) {
                ResultSet importKeyRS = this.spawnNodeThreads(importKeyThreadList, 0);
                resultSet.uploadResultSet(importKeyRS);
            }
        }
        catch (InvalidArgsException iae) {
            String errorMsg = s_gMsgBundle.getMessage("9084", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodeList), VerificationUtil.isStringGood(this.m_userName) ? this.m_userName : ""}) + LSEP + iae.getMessage();
            VerificationUtil.traceAndLogError("Caught InvalidArgsException " + errorMsg);
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(errorMsg));
        }
        catch (ExecException ee) {
            VerificationUtil.traceAndLogError("Caught ExecException " + ee.getMessage());
            resultSet.setStatus(2);
            for (String node : nodeList) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(EXECTASK_GENERATE_SSH_KEYS_ARGS, " "), node}) + LSEP + ee.getMessage()));
            }
        }
        catch (CompositeOperationException coe) {
            VerificationUtil.traceAndLogError("Caught CompositeOperationException " + coe.getMessage());
            resultSet.setStatus(2);
            for (String node : nodeList) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(EXECTASK_GENERATE_SSH_KEYS_ARGS, " "), node}) + LSEP + coe.getMessage()));
            }
        }
        catch (FixupException fe) {
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(fe.getMessage()));
        }
        return resultSet;
    }

    private ResultSet cleanUpSSHSetupDirectory(Collection<String> nodeList) {
        ResultSet resultSet = new ResultSet();
        HashSet<String> nodesForCleanup = new HashSet<String>();
        nodesForCleanup.addAll(nodeList);
        nodesForCleanup.add(this.m_localNode);
        try {
            ArrayList<SSHSetupNodeThread> importFixupTraceThreadList = new ArrayList<SSHSetupNodeThread>();
            for (String node : nodeList) {
                importFixupTraceThreadList.add(new SSHSetupNodeThread.ImportFileThread(CVU_FIXUP_TRACE_FILE_LOC, CVU_SUBDIR_LOC + node + "_" + "cvu_fixup_trace_0.log", false, node, this.m_credentials));
            }
            if (!importFixupTraceThreadList.isEmpty()) {
                ResultSet imprtFixTrcRS = this.spawnNodeThreads(importFixupTraceThreadList, 0);
                resultSet.uploadResultSet(imprtFixTrcRS);
            }
            ExecCommandNoUserEq cmdObject = RemoteFactory.getInstance().getExecCommandNoUserEq(this.m_credentials);
            Map resultMap = cmdObject.runCmd("/bin/rm -rf", new String[]{SSH_SETUP_WORK_DIRECTORY}, nodesForCleanup.toArray(new String[0]), this.m_timeOutInSeconds);
            for (String node : resultMap.keySet()) {
                Result nodeResult = new Result(node);
                CommandResult commandResult = (CommandResult)resultMap.get(node);
                if (commandResult.getStatus()) {
                    nodeResult.setStatus(1);
                } else {
                    VerificationUtil.traceAndLogError(commandResult.getErrorString());
                    nodeResult.setStatus(2);
                    nodeResult.addErrorDescription(new ErrorDescription(commandResult.getErrorString()));
                }
                resultSet.addResult(node, nodeResult);
            }
        }
        catch (InvalidArgsException iae) {
            String errorMsg = s_gMsgBundle.getMessage("9084", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodesForCleanup), VerificationUtil.isStringGood(this.m_userName) ? this.m_userName : ""}) + LSEP + iae.getMessage();
            VerificationUtil.traceAndLogError("Caught InvalidArgsException " + errorMsg);
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(errorMsg));
        }
        catch (ExecException ee) {
            VerificationUtil.traceAndLogError("Caught ExecException " + ee.getMessage());
            resultSet.setStatus(2);
            for (String node : nodesForCleanup) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{"/bin/rm -rf " + SSH_SETUP_WORK_DIRECTORY, node}) + LSEP + ee.getMessage()));
            }
        }
        catch (CompositeOperationException coe) {
            VerificationUtil.traceAndLogError("Caught CompositeOperationException " + coe.getMessage());
            resultSet.setStatus(2);
            for (String node : nodesForCleanup) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{"/bin/rm -rf " + SSH_SETUP_WORK_DIRECTORY, node}) + LSEP + coe.getMessage()));
            }
        }
        catch (FixupException fe) {
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(fe.getMessage()));
        }
        return resultSet;
    }

    private void findNodesSharingHome(Hashtable<String, String> nodePublicKeyLocationTable) throws FixupException {
        ArrayList<SSHSetupNodeThread> checkSharedHomeThreadList = new ArrayList<SSHSetupNodeThread>();
        for (String string : nodePublicKeyLocationTable.keySet()) {
            checkSharedHomeThreadList.add(new SSHSetupNodeThread.CheckHomeSharednessThread(string, this.m_credentials, nodePublicKeyLocationTable.values()));
        }
        this.spawnNodeThreads(checkSharedHomeThreadList, 0);
        for (SSHSetupNodeThread sSHSetupNodeThread : checkSharedHomeThreadList) {
            Set<String> nodesSharingHome;
            Result nodeResult = sSHSetupNodeThread.getResult();
            if (nodeResult.getStatus() != 1 || (nodesSharingHome = ((SSHSetupNodeThread.CheckHomeSharednessThread)sSHSetupNodeThread).getNodesSharingHome()).isEmpty()) continue;
            boolean exists = false;
            for (Set<String> group : this.m_homeSharingNodesGroupList) {
                if (group.size() != nodesSharingHome.size() || !group.containsAll(nodesSharingHome)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.m_homeSharingNodesGroupList.add(nodesSharingHome);
        }
        for (Set set : this.m_homeSharingNodesGroupList) {
            Trace.out((String)("User's home directory is shared on nodes (" + VerificationUtil.strCollection2String(set) + ")"));
        }
    }

    private Set<String> selectNodeFromNodesSharingHome(List<String> nodesToFilter) {
        HashSet<String> nodesSelectedForOperation;
        block4: {
            String localNode;
            block5: {
                String node3;
                Set<String> group;
                block8: {
                    block6: {
                        block7: {
                            block3: {
                                nodesSelectedForOperation = new HashSet<String>();
                                if (!this.m_homeSharingNodesGroupList.isEmpty()) break block3;
                                nodesSelectedForOperation.addAll(nodesToFilter);
                                break block4;
                            }
                            localNode = VerificationUtil.getLocalNode();
                            if (this.m_homeSharingNodesGroupList.size() != 1) break block5;
                            group = this.m_homeSharingNodesGroupList.get(0);
                            if (!group.containsAll(nodesToFilter)) break block6;
                            if (!group.contains(localNode)) break block7;
                            nodesSelectedForOperation.add(localNode);
                            Trace.out((String)"The users home is shared across all the participating nodes and local node is also a participating node. Selecting local node from this group of nodes for further operation.");
                            break block4;
                        }
                        Iterator<String> iterator = group.iterator();
                        if (!iterator.hasNext()) break block4;
                        String node2 = iterator.next();
                        Trace.out((String)("Selecting node (" + node2 + ") from group (" + VerificationUtil.strCollection2String(group) + ")"));
                        nodesSelectedForOperation.add(node2);
                        break block4;
                    }
                    for (String node3 : nodesToFilter) {
                        if (group.contains(node3)) continue;
                        nodesSelectedForOperation.add(node3);
                    }
                    if (!group.contains(localNode)) break block8;
                    nodesSelectedForOperation.add(localNode);
                    Trace.out((String)("Selecting local node (" + localNode + ") from group (" + VerificationUtil.strCollection2String(group) + ")"));
                    break block4;
                }
                Iterator<String> iterator = group.iterator();
                if (!iterator.hasNext()) break block4;
                node3 = iterator.next();
                Trace.out((String)("Selecting node (" + node3 + ") from group (" + VerificationUtil.strCollection2String(group) + ")"));
                nodesSelectedForOperation.add(node3);
                break block4;
            }
            for (Set<String> group : this.m_homeSharingNodesGroupList) {
                if (group.contains(localNode)) {
                    nodesSelectedForOperation.add(localNode);
                    Trace.out((String)("Selecting local node (" + localNode + ") from group (" + VerificationUtil.strCollection2String(group) + ")"));
                    continue;
                }
                Iterator<String> iterator = group.iterator();
                if (!iterator.hasNext()) continue;
                String node = iterator.next();
                Trace.out((String)("Selecting node (" + node + ") from group (" + VerificationUtil.strCollection2String(group) + ")"));
                nodesSelectedForOperation.add(node);
            }
        }
        return nodesSelectedForOperation;
    }

    private ResultSet updateKeysFile(List<String> nodeList, SSHSetupConstants.KeysFileType keyFileType) {
        String[] args = null;
        args = keyFileType == SSHSetupConstants.KeysFileType.AUTHORIZED_KEYS ? EXECTASK_UPDATE_AUTH_KEYS_ARGS : EXECTASK_UPDATE_RSA_HOST_KEYS_ARGS;
        ResultSet resultSet = new ResultSet();
        try {
            ExecCommandNoUserEq cmdObject = null;
            cmdObject = this.m_forUser == null || VerificationUtil.isStringGood(this.m_userName) && this.m_userName.equals(this.m_forUser) ? RemoteFactory.getInstance().getExecCommandNoUserEq(this.m_credentials) : RemoteFactory.getInstance().getExecCommandNoUserEq((RemoteUserInfo)this.m_credentials, this.m_forUser);
            Map resultMap = cmdObject.runCmd(EXECTASK_COMPLETE_PATH, args, nodeList.toArray(new String[0]), this.m_timeOutInSeconds);
            for (String node : resultMap.keySet()) {
                Result nodeResult = new Result(node);
                CommandResult commandResult = (CommandResult)resultMap.get(node);
                if (commandResult.getStatus()) {
                    String[] output = commandResult.getOutputString();
                    if (output != null) {
                        for (String line : output) {
                            Trace.out((String)line);
                        }
                        String outputStr = VerificationUtil.strArr2String(output);
                        Trace.out((String)("The exectask command output is \n" + outputStr));
                        String keysUpdatedTagsContent = VerificationUtil.fetchTextByTags(outputStr, "UPDATE");
                        if (VerificationUtil.isStringGood(keysUpdatedTagsContent)) {
                            Trace.out((String)("The UPDATE tags contain (" + keysUpdatedTagsContent + ")"));
                            if (keysUpdatedTagsContent.contains("SUCCESS")) {
                                Trace.out((String)("All the exported keys were successfully updated inside the authorized_keys file on node " + node));
                                nodeResult.setStatus(1);
                            } else {
                                String[] nlsMsgArr;
                                nodeResult.setStatus(2);
                                String dispFacilityStr = VerificationUtil.fetchTextByTags(keysUpdatedTagsContent, "<DISP_FACILITY>", "</DISP_FACILITY>");
                                boolean dispFacility = true;
                                if (VerificationUtil.isStringGood(dispFacilityStr)) {
                                    dispFacility = Boolean.parseBoolean(dispFacilityStr);
                                }
                                if ((nlsMsgArr = VerificationUtil.fetchTextByTagsRepeat(keysUpdatedTagsContent, "<NLS_MSG>", "</NLS_MSG>")) != null && nlsMsgArr.length > 0) {
                                    for (String nlsMsg : nlsMsgArr) {
                                        ErrorDescription errDesc = VerificationUtil.nlsTagsToErrorDescription(nlsMsg, dispFacility);
                                        nodeResult.addErrorDescription(errDesc);
                                    }
                                } else {
                                    Trace.out((String)"Failed but no errors");
                                }
                            }
                        } else {
                            String errorMsg = s_gMsgBundle.getMessage("2034", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(args, " "), node, "0"}) + LSEP + outputStr;
                            VerificationUtil.traceAndLogError(errorMsg);
                            nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                            nodeResult.setStatus(2);
                        }
                    } else {
                        String errorMsg = s_gMsgBundle.getMessage("2035", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(args, " "), node, "0"});
                        VerificationUtil.traceAndLogError(errorMsg);
                        nodeResult.addErrorDescription(new ErrorDescription(errorMsg));
                        nodeResult.setStatus(2);
                    }
                }
                resultSet.addResult(node, nodeResult);
            }
        }
        catch (InvalidArgsException iae) {
            String errorMsg = s_gMsgBundle.getMessage("9084", true, (Object[])new String[]{VerificationUtil.strCollection2String(nodeList), VerificationUtil.isStringGood(this.m_userName) ? this.m_userName : ""}) + LSEP + iae.getMessage();
            VerificationUtil.traceAndLogError("Caught InvalidArgsException " + errorMsg);
            resultSet.setStatus(2);
            resultSet.addErrorDescription(new ErrorDescription(errorMsg));
        }
        catch (ExecException ee) {
            VerificationUtil.traceAndLogError("Caught ExecException " + ee.getMessage());
            resultSet.setStatus(2);
            for (String node : nodeList) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(args, " "), node}) + LSEP + ee.getMessage()));
            }
        }
        catch (CompositeOperationException coe) {
            VerificationUtil.traceAndLogError("Caught CompositeOperationException " + coe.getMessage());
            resultSet.setStatus(2);
            resultSet.setStatus(2);
            for (String node : nodeList) {
                resultSet.addResult(node, 2);
                resultSet.addErrorDescription(node, new ErrorDescription(s_gMsgBundle.getMessage("11001", true, (Object[])new String[]{EXECTASK_COMPLETE_PATH + " " + VerificationUtil.strArr2List(args, " "), node}) + LSEP + coe.getMessage()));
            }
        }
        return resultSet;
    }

    private ResultSet setupExportKeyFile(Collection<String> nodeList) throws FixupException {
        ResultSet res = new ResultSet();
        ArrayList<SSHSetupNodeThread> nodeThreadList = new ArrayList<SSHSetupNodeThread>();
        for (String node : nodeList) {
            nodeThreadList.add(new SSHSetupNodeThread.SetupExportKeyFileThread(node, this.m_credentials));
        }
        res = this.spawnNodeThreads(nodeThreadList, 0);
        return res;
    }

    private ResultSet setupWorkDirectory(Collection<String> nodeList) throws FixupException {
        ArrayList<SSHSetupNodeThread> nodeThreadList = new ArrayList<SSHSetupNodeThread>();
        if (!nodeList.contains(this.m_localNode)) {
            Trace.out((String)"Explicitly adding the local node to setup SSH setup work directory for this operation");
            nodeThreadList.add(new SSHSetupNodeThread.SetupWorkDirectoryThread(this.m_localNode, this.m_credentials));
        }
        for (String node : nodeList) {
            nodeThreadList.add(new SSHSetupNodeThread.SetupWorkDirectoryThread(node, this.m_credentials));
        }
        return this.spawnNodeThreads(nodeThreadList, 0);
    }

    private ResultSet spawnNodeThreads(Collection<SSHSetupNodeThread> nodeThreadArray, int interval) throws FixupException {
        ResultSet resultSet = new ResultSet();
        if (nodeThreadArray != null && !nodeThreadArray.isEmpty()) {
            for (SSHSetupNodeThread thread : nodeThreadArray) {
                Trace.out((String)(" Running node SSH Setup thread " + thread.getName()));
                thread.start();
                if (interval <= 0) continue;
                try {
                    Thread.sleep(interval);
                }
                catch (InterruptedException e) {
                    Trace.out((String)"Could not cause requested delay interval. Ignoring....");
                }
            }
            try {
                for (SSHSetupNodeThread thread : nodeThreadArray) {
                    Trace.out((String)("Waiting to join " + thread.getName()));
                    thread.join();
                    Trace.out((String)("Joined " + thread.getName()));
                }
            }
            catch (InterruptedException ie) {
                VerificationUtil.traceAndLog("InterruptedException-" + ie.getMessage());
                Trace.out((String)("Caught InterruptedException - Could not join thread list and Error is : " + ie.getMessage()));
                throw new FixupException(ie);
            }
            for (SSHSetupNodeThread thread : nodeThreadArray) {
                Result thrdRes = thread.getResult();
                if (thrdRes.getStatus() == 1) {
                    Trace.out((String)("The thread for operation ( " + thread.getOperation() + ") on node " + thrdRes.getNode() + " is successful"));
                } else {
                    VerificationUtil.traceAndLog("Failure in thread for operation ( " + thread.getOperation() + ") on node " + thrdRes.getNode());
                }
                resultSet.addResult(thrdRes.getNode(), thrdRes);
            }
        }
        return resultSet;
    }
}

