/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.fixup;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import oracle.cluster.impl.verification.FixupManualInstructionImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.UserInfo;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupManualInstruction;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.verification.fixup.FixupConstants;
import oracle.cluster.verification.fixup.FixupTaskListContainer;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.ops.mgmt.cluster.RemoteDirException;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.RootUserCredentials;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupUtility
implements FixupConstants {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private static String m_timeStamp = null;
    protected static boolean m_defaultFixupReqd;

    public static void setDefaultFixupRequirement(boolean fixupReqd) {
        m_defaultFixupReqd = fixupReqd;
    }

    public static boolean getDefaultFixupRequirement() {
        return m_defaultFixupReqd;
    }

    public static String getDefaultFixupScriptsLocation() {
        return VerificationUtil.getCVUSubDirPath() + "fixup" + VerificationConstants.FSEP;
    }

    public static String getDriverScriptCompletePath() {
        return FixupConstants.FIXUP_DESTLOC_DIR_PATH + FixupUtility.getScriptNameWithExtension("runfixup");
    }

    public static String getExectaskCompletePath() {
        return FixupConstants.FIXUP_DESTLOC_DIR_PATH + VerificationUtil.getCmd4RemExec();
    }

    public static String getFixupDataFileLocation() {
        return VerificationUtil.getCVUSubDirPath() + "fixup" + VerificationConstants.FSEP;
    }

    public static String getFixupDataFileCompletePath() {
        return FixupUtility.getFixupDataFileLocation() + "cvufixupdata" + "_" + FixupUtility.getTimeStampString() + ".xml";
    }

    public static String getFixupOutputFileCompletePath(String node) {
        return FixupUtility.getFixupDataFileLocation() + "cvufixupoutput" + "_" + node + ".xml";
    }

    public static String getFixupDataFileXSDCompletePath() {
        return CVUAutoUpdateManager.getCVUFileLocation("cv" + VerificationConstants.FSEP + "cvdata" + VerificationConstants.FSEP + "cvufixup" + ".xsd");
    }

    public static void assertPath(String path, boolean checkExistsLocal) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        if (!new File(path).isAbsolute()) {
            throw new InvalidPathException(s_msgBundle.getMessage("7518", false, (Object[])new String[]{path}));
        }
        if (checkExistsLocal && !new File(path).exists()) {
            throw new InvalidPathException(s_msgBundle.getMessage("0030", false, (Object[])new String[]{path}));
        }
    }

    public static void assertFixupExecutionOnNode(String node, String fixupOutFileCompletePathNode) throws FixupException {
        NativeSystem m_native = new SystemFactory().CreateSystem();
        try {
            if (!m_native.pathExists(VerificationUtil.isLocalNode(node) ? "localnode" : node, fixupOutFileCompletePathNode, 2)) {
                FixupManualInstructionImpl manualInstr = new FixupManualInstructionImpl(FixupUtility.getDriverScriptCompletePath(), Arrays.asList(node));
                throw new FixupException(s_gMsgBundle.getMessage("9023", true, (Object[])new String[]{manualInstr.getFixupInstruction(), node}));
            }
        }
        catch (RemoteDirException rde) {
            throw new FixupException(rde.getMessage());
        }
    }

    public static String getCVUFixupXmlSchemaURI() throws XmlFilePathException {
        String fullpath = new File(FixupUtility.getFixupDataFileXSDCompletePath()).toURI().toString();
        Trace.out((String)("==== CVU Fixup schema file: " + fullpath));
        return fullpath;
    }

    public static String getFixupScriptCompletePath(String name) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        return FixupConstants.FIXUP_DESTLOC_DIR_PATH + "fixup" + VerificationConstants.FSEP + nativeSys.getScriptFileName(name);
    }

    public static Task searchAndGetTaskWithSameIDInList(String taskId, List<Task> listOfTasks) {
        if (listOfTasks == null || !VerificationUtil.isStringGood(taskId)) {
            return null;
        }
        for (Task t : listOfTasks) {
            if (!t.getDefaultTaskID().equals(taskId.trim())) continue;
            return t;
        }
        return null;
    }

    public static String getFixupInstructionsFilePath() {
        return FixupUtility.getFixupDataFileLocation() + "fixup.conf";
    }

    public static List<Task> searchAndReplaceTaskWithSameIDInList(Task tasktoSearch, List<Task> listOfTasks, boolean addIfNotFound) {
        if (listOfTasks == null || tasktoSearch == null) {
            return listOfTasks;
        }
        ArrayList<Task> updatedList = new ArrayList<Task>();
        String taskId = tasktoSearch.getDefaultTaskID();
        boolean replaced = false;
        for (Task t : listOfTasks) {
            if (t.getDefaultTaskID().equals(taskId.trim())) {
                updatedList.add(tasktoSearch);
                replaced = true;
                continue;
            }
            updatedList.add(t);
        }
        if (!replaced && addIfNotFound) {
            updatedList.add(tasktoSearch);
        }
        return updatedList;
    }

    public static List<Integer> getCommonTaskIndex(List<Task> sourceList, String taskID) {
        ArrayList<Integer> filteredTaskIndex = new ArrayList<Integer>();
        for (int index = 0; index < sourceList.size(); ++index) {
            Task task = sourceList.get(index);
            if (!task.getDefaultTaskID().equals(taskID)) continue;
            filteredTaskIndex.add(index);
        }
        return filteredTaskIndex;
    }

    public static String createNativeErrorMsg(String nativeError, String node) {
        return s_gMsgBundle.getMessage("9016", true, (Object[])new String[]{nativeError, node});
    }

    public static String getTimeStampString() {
        if (!VerificationUtil.isStringGood(m_timeStamp)) {
            Calendar today = Calendar.getInstance();
            String year = Integer.toString(today.get(1));
            String month = Integer.toString(today.get(2) + 1);
            String day = Integer.toString(today.get(5));
            String hours = Integer.toString(today.get(11));
            String minutes = Integer.toString(today.get(12));
            String seconds = Integer.toString(today.get(13));
            m_timeStamp = new String(month + day + year + hours + minutes + seconds);
        }
        return m_timeStamp;
    }

    public static String getScriptNameWithExtension(String scriptPrefix) {
        NativeSystem nativeSys = new SystemFactory().CreateSystem();
        if (nativeSys.isUnixSystem()) {
            return scriptPrefix + ".sh";
        }
        return scriptPrefix + ".bat";
    }

    public static String getCompleteErrorMessageFromErrorList(List<VerificationError> errors) {
        StringBuffer errBuffer = new StringBuffer();
        for (VerificationError error : errors) {
            String errMsg = error.getErrorMessage();
            if (!VerificationUtil.isStringGood(errMsg)) continue;
            errBuffer.append(errMsg + VerificationConstants.LINE_SEPARATOR);
        }
        return errBuffer.toString();
    }

    /*
     * WARNING - void declaration
     */
    public static String getCompleteErrorMessageFromResultSet(ResultSet resultSet) {
        void var4_8;
        String[] failedNodes;
        StringBuffer errBuffer = new StringBuffer();
        if (resultSet.allSuccess()) {
            return "";
        }
        List<VerificationError> globalErrors = resultSet.getErrors();
        for (VerificationError verificationError : globalErrors) {
            String errMsg = verificationError.getErrorMessage();
            if (!VerificationUtil.isStringGood(errMsg)) continue;
            errBuffer.append(errMsg + VerificationConstants.LINE_SEPARATOR);
        }
        for (String failedNode : failedNodes = resultSet.getFailureNodes()) {
            try {
                String errMsg = FixupUtility.getCompleteErrorMessageFromErrorList(resultSet.getNodeResult(failedNode).getErrors());
                if (!VerificationUtil.isStringGood(errMsg)) continue;
                errBuffer.append(errMsg + VerificationConstants.LINE_SEPARATOR);
            }
            catch (NodeResultsUnavailableException nrue) {
                Trace.out((String)nrue.getMessage());
            }
        }
        String string = errBuffer.toString();
        if (string.endsWith(VerificationConstants.LINE_SEPARATOR)) {
            String string2 = string.substring(0, string.lastIndexOf(VerificationConstants.LINE_SEPARATOR));
        }
        return var4_8;
    }

    public static void validateRootAutomationSetup(String[] nodeList, RootUserCredentials userCredentials) throws RootAutomationException, VerificationException {
        if (null == userCredentials) {
            Trace.out((String)"Root Automation credentials are not available and hence not validating Root Automation setup.");
            return;
        }
        ConfigurationSetup.ConfigMethod method = userCredentials.getRootExecutionMode();
        ResultSet resultSet = null;
        UserInfo credentials = userCredentials.getRootUserCredentials();
        String sudoPbrunLocation = userCredentials.getSudoPbrunLocation();
        switch (method) {
            case ROOT: {
                resultSet = (ResultSet)RootAutomationUtility.checkRootPassword(nodeList, credentials.getPassword());
                if (resultSet.allSuccess()) break;
                throw new RootAutomationException(FixupUtility.getCompleteErrorMessageFromResultSet(resultSet));
            }
            case SUDO: {
                resultSet = (ResultSet)RootAutomationUtility.checkSudoExistence(nodeList, sudoPbrunLocation, credentials.getUsername(), credentials.getPassword());
                if (resultSet.allSuccess()) {
                    resultSet.clear();
                    resultSet = (ResultSet)RootAutomationUtility.checkSudoExecution(nodeList, sudoPbrunLocation, credentials.getUsername(), credentials.getPassword());
                    if (resultSet.allSuccess()) break;
                    throw new RootAutomationException(FixupUtility.getCompleteErrorMessageFromResultSet(resultSet));
                }
                throw new RootAutomationException(FixupUtility.getCompleteErrorMessageFromResultSet(resultSet));
            }
            case PBRUN: {
                resultSet = (ResultSet)RootAutomationUtility.checkPbrunExistence(nodeList, sudoPbrunLocation, credentials.getUsername(), credentials.getPassword());
                if (resultSet.allSuccess()) {
                    resultSet.clear();
                    resultSet = (ResultSet)RootAutomationUtility.checkPbrunExecution(nodeList, sudoPbrunLocation, credentials.getUsername(), credentials.getPassword());
                    if (resultSet.allSuccess()) break;
                    throw new RootAutomationException(FixupUtility.getCompleteErrorMessageFromResultSet(resultSet));
                }
                throw new RootAutomationException(FixupUtility.getCompleteErrorMessageFromResultSet(resultSet));
            }
        }
    }

    public static VerificationError buildVerificationErrorFromNlsMessage(String facility, String idStr, String[] data, boolean displayFacility) throws FixupException {
        Trace.out((String)("facility=" + facility + " ; idStr=" + idStr + " ; data=" + data));
        String errMsg = null;
        String cause = null;
        String action = null;
        ErrorDescription errDesc = null;
        if (facility != null && idStr != null) {
            MessageBundle msgBundle = VerificationUtil.getMessageBundle(facility);
            if (msgBundle != null) {
                errMsg = data != null && data.length >= 1 ? msgBundle.getMessage(idStr, displayFacility, (Object[])data) : msgBundle.getMessage(idStr, displayFacility);
                cause = msgBundle.getCause(idStr, false);
                action = msgBundle.getAction(idStr, false);
                Trace.out((String)("errMsg=" + errMsg));
                Trace.out((String)("cause=" + cause));
                Trace.out((String)("action=" + action));
                errDesc = new ErrorDescription(errMsg, cause, action);
            } else {
                Trace.out((String)("Couldn't get message bundle for facility: '" + facility + "'"));
                errMsg = s_msgBundle.getMessage("0015", false, (Object[])new String[]{facility});
                throw new FixupException(errMsg);
            }
        }
        return errDesc;
    }

    public static List<VerificationTask> getFixableTaskList() {
        ArrayList<VerificationTask> newTaskList = new ArrayList<VerificationTask>();
        for (VerificationTask task : FixupUtility.getAllFixupTasks()) {
            if (!task.isFixable()) continue;
            newTaskList.add(task);
        }
        Trace.out((String)("The total number of fixable tasks is " + newTaskList.size()));
        return newTaskList;
    }

    public static List<VerificationTask> getAllFixupTasks() {
        ArrayList<VerificationTask> newTaskList = new ArrayList<VerificationTask>();
        for (Task task : FixupTaskListContainer.getGeneratedFixupTaskList()) {
            newTaskList.add(task);
        }
        Trace.out((String)("The total number of fix-up tasks is " + newTaskList.size()));
        return newTaskList;
    }

    public static FixupManualInstruction getManualFixupInstruction(CVUFixup driver) throws FixupException {
        if (driver == null) {
            throw new FixupException(s_gMsgBundle.getMessage("7090", true));
        }
        if (driver.getFixableTaskList().size() == 0) {
            String exceptionMessage = s_gMsgBundle.getMessage("9000", false);
            for (Task fixupGenFailedTask : driver.getFixupGenerationFailedTaskList()) {
                String fixupGenFailedTaskError = FixupUtility.getCompleteErrorMessageFromErrorList(fixupGenFailedTask.getFixupResultSet().getErrors());
                if (!VerificationUtil.isStringGood(fixupGenFailedTaskError)) continue;
                exceptionMessage = exceptionMessage + VerificationConstants.LINE_SEPARATOR + fixupGenFailedTaskError;
            }
            throw new FixupException(exceptionMessage);
        }
        return new FixupManualInstructionImpl(FixupUtility.getDriverScriptCompletePath(), driver.getFixableNodes());
    }
}

