/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification.command;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import oracle.ops.mgmt.command.CommandResult;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.network.ConMatrix;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ICMPPingCommand
extends VerificationCommand {
    ConMatrix m_connectivityMatrix;
    String m_sourceNode;
    String m_outputFile;
    String m_copiedOutFile;
    public static final String m_cvuSubDirPath = VerificationUtil.getCVUSubDirPath();
    public static final String PING_FILE_NAME_PREFIX = "ping_";

    public ICMPPingCommand(String node, String[] args) {
        super(node, args, null);
        this.m_sourceNode = node;
    }

    public ICMPPingCommand(String node, String[] args, ConMatrix matrix) {
        this(node, args);
        String[] nodes = matrix.getNodeList();
        String[] ipAddresses = matrix.getIPList();
        this.m_connectivityMatrix = new ConMatrix(matrix.getKey(), nodes, ipAddresses, null);
        this.m_outputFile = args[2];
    }

    @Override
    public boolean execute() {
        super.execute();
        if (this.copyPingOutputFileFromNode()) {
            if (this.parseICMPPingCommandOutput()) {
                Trace.out((String)"ICMPPingCommand successful");
                return true;
            }
            Trace.out((String)("parsing ping command output file copied from node " + this.m_node + "failed"));
            return false;
        }
        Trace.out((String)("ping command output file copy from node " + this.m_node + " failed"));
        return false;
    }

    public ConMatrix getConnectivityMatrix() {
        return this.m_connectivityMatrix;
    }

    private boolean copyPingOutputFileFromNode() {
        String retVal = null;
        this.m_copiedOutFile = this.m_outputFile.concat(".lcl");
        retVal = this.nativeSystem.copyFile(this.m_sourceNode, this.m_outputFile, "localnode", this.m_copiedOutFile, true);
        this.commandResult = new CommandResult(retVal);
        if (!this.commandResult.getStatus()) {
            VerificationUtil.traceAndLog("Couldn't get remote ping output file " + this.m_outputFile + " on the node " + this.m_sourceNode);
            String msg = s_gMsgBundle.getMessage("11093", true, (Object[])new String[]{this.m_outputFile, this.m_sourceNode, VerificationUtil.getCVUSubDirPath()});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_result.addErrorDescription(errDesc);
            msg = this.commandResult.getErrorString();
            if (VerificationUtil.isStringGood(msg)) {
                errDesc = new ErrorDescription(msg);
                this.m_result.addErrorDescription(errDesc);
            }
            this.m_result.setStatus(2);
            return false;
        }
        VerificationUtil.traceAndLog("Copied " + this.m_outputFile + " from node:" + this.m_sourceNode + " as " + this.m_copiedOutFile);
        retVal = this.nativeSystem.removeFile(this.m_sourceNode, this.m_outputFile);
        if (!new CommandResult(retVal).getStatus()) {
            VerificationUtil.traceAndLog("Could not delete the remote file " + this.m_outputFile + " after " + "copying to local for processing.");
        }
        return true;
    }

    private boolean parseICMPPingCommandOutput() {
        FileInputStream inputStream;
        boolean retVal = true;
        try {
            inputStream = new FileInputStream(this.m_copiedOutFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            VerificationUtil.traceAndLog("Couldn't find remote ping output file " + this.m_outputFile + " on the node " + this.m_sourceNode);
            String msg = s_gMsgBundle.getMessage("11093", true, (Object[])new String[]{this.m_outputFile, this.m_sourceNode, VerificationUtil.getCVUSubDirPath()});
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_result.addErrorDescription(errDesc);
            msg = this.commandResult.getErrorString() + VerificationUtil.LSEP + fileNotFoundException.getMessage();
            if (VerificationUtil.isStringGood(msg)) {
                errDesc = new ErrorDescription(msg);
                this.m_result.addErrorDescription(errDesc);
            }
            this.m_result.setStatus(2);
            return false;
        }
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder pingOutputContents = new StringBuilder();
        String line = null;
        try {
            while ((line = bufferReader.readLine()) != null) {
                pingOutputContents.append(line);
            }
        }
        catch (IOException ioException) {
            Trace.out((String)("FileNotFoundException during deleting file " + this.m_copiedOutFile));
            this.m_result.setStatus(2);
            ErrorDescription errorDesc = new ErrorDescription(ioException.getMessage());
            this.m_result.addErrorDescription(errorDesc);
            File deleteFile = new File(this.m_copiedOutFile);
            deleteFile.delete();
            return false;
        }
        if (pingOutputContents.length() == 0) {
            Trace.out((String)("Empty file..no output from exectask in the file " + this.m_copiedOutFile));
            this.m_result.setStatus(2);
            String errorMessage = s_gMsgBundle.getMessage("13201", true, (Object[])new String[]{"cvu-param-empty-ping-cmd-output-file"});
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            this.m_result.addErrorDescription(errorDesc);
            File deleteFile = new File(this.m_copiedOutFile);
            deleteFile.delete();
            return false;
        }
        File deleteFile = new File(this.m_copiedOutFile);
        deleteFile.delete();
        retVal = this.processICMPPingOutput(pingOutputContents.toString());
        return retVal;
    }

    private boolean processICMPPingOutput(String output) {
        String[] ipList = this.m_connectivityMatrix.getIPList();
        int status = 3;
        String[] pingOutputs = VerificationUtil.fetchTextByTagsRepeat(output, "<CV_VAL>", "</CV_VAL>");
        if (pingOutputs.length == 0) {
            status = 3;
            this.m_result.setStatus(2);
            String errorMessage = s_gMsgBundle.getMessage("13201", true, (Object[])new String[]{"cvu-param-empty-ping-cmd-output"});
            ErrorDescription errorDesc = new ErrorDescription(errorMessage);
            this.m_result.addErrorDescription(errorDesc);
            return false;
        }
        boolean disconnectedIpsFound = false;
        for (String pingOutput : pingOutputs) {
            String sourceIP = VerificationUtil.fetchTextByTags(pingOutput, "SOURCE_IP");
            String destinationIP = VerificationUtil.fetchTextByTags(pingOutput, "DEST_IP");
            boolean connected = this.convertStringToBoolean(VerificationUtil.fetchTextByTags(pingOutput, "CONNECTED"));
            if (!VerificationUtil.isStringGood(sourceIP) || !VerificationUtil.isStringGood(destinationIP)) continue;
            int sourceIndex = 0;
            int destinationIndex = 0;
            boolean foundSourceIndex = false;
            boolean foundDestinationIndex = false;
            for (int i = 0; i < ipList.length; ++i) {
                if (sourceIP.equals(ipList[i])) {
                    sourceIndex = i;
                    foundSourceIndex = true;
                }
                if (destinationIP.equals(ipList[i])) {
                    destinationIndex = i;
                    foundDestinationIndex = true;
                }
                this.m_connectivityMatrix.setMatrixValue(true, i, i);
            }
            if (!foundSourceIndex || !foundDestinationIndex) continue;
            this.m_connectivityMatrix.setMatrixValue(connected, sourceIndex, destinationIndex);
            if (!connected) {
                disconnectedIpsFound = true;
                String errorMessage = VerificationUtil.fetchTextByTags(pingOutput, "ERROR");
                VerificationUtil.traceAndLog("Error occured during ping connectivity between the IP addresses " + sourceIP + " and " + destinationIP + " Error message: " + errorMessage);
                String msg = s_gMsgBundle.getMessage("11094", true, (Object[])new String[]{sourceIP, destinationIP, errorMessage});
                ErrorDescription errDesc = new ErrorDescription(msg);
                this.m_result.addErrorDescription(errDesc);
                this.m_result.setStatus(4);
                status = 2;
                continue;
            }
            if (status == 2) continue;
            status = 1;
        }
        if (!disconnectedIpsFound) {
            status = 1;
        }
        this.m_connectivityMatrix.setStatus(status, true);
        this.m_connectivityMatrix.getMatrixForOutput();
        this.m_result.setStatus(1);
        return true;
    }

    private boolean convertStringToBoolean(String value) {
        return VerificationUtil.isStringGood(value) && (value.equalsIgnoreCase("YES") || value.equalsIgnoreCase("TRUE"));
    }

    public static String getLocalPingFileName(String node, String key) {
        if (!VerificationUtil.isStringGood(node) || !VerificationUtil.isStringGood(key)) {
            return "";
        }
        StringBuilder pingInputFile = new StringBuilder();
        pingInputFile.append(m_cvuSubDirPath);
        pingInputFile.append(PING_FILE_NAME_PREFIX);
        pingInputFile.append(node);
        pingInputFile.append("_");
        pingInputFile.append(key);
        return pingInputFile.toString();
    }

    public static String getPingInputFileName(String node, String key) {
        if (!VerificationUtil.isStringGood(node) || !VerificationUtil.isStringGood(key)) {
            return "";
        }
        StringBuilder pingInputFile = new StringBuilder();
        pingInputFile.append(ICMPPingCommand.getLocalPingFileName(node, key));
        pingInputFile.append(".in");
        return pingInputFile.toString();
    }

    public static String getPingOutputFileName(String node, String key) {
        if (!VerificationUtil.isStringGood(node) || !VerificationUtil.isStringGood(key)) {
            return "";
        }
        StringBuilder pingInputFile = new StringBuilder();
        pingInputFile.append(ICMPPingCommand.getLocalPingFileName(node, key));
        pingInputFile.append(".out");
        return pingInputFile.toString();
    }
}

