/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import oracle.ops.mgmt.trace.Trace;

public enum NodeRoleCapability {
    HUB(0),
    HUB_CAPABLE(1),
    RIM(2),
    AUTO(3),
    HUB_ACTIVE(4),
    RIM_ACTIVE(5),
    ALL(6);

    private int m_type;
    private String m_typeStr;

    private NodeRoleCapability(int type) {
        this.m_type = type;
        switch (type) {
            case 0: {
                this.m_typeStr = "HUB";
                break;
            }
            case 1: {
                this.m_typeStr = "HUB_CAPABLE";
                break;
            }
            case 2: {
                this.m_typeStr = "LEAF";
                break;
            }
            case 3: {
                this.m_typeStr = "AUTO";
                break;
            }
            case 4: {
                this.m_typeStr = "HUB_ACTIVE";
                break;
            }
            case 5: {
                this.m_typeStr = "LEAF_ACTIVE";
                break;
            }
            case 6: {
                this.m_typeStr = "ALL";
            }
        }
    }

    public int getType() {
        return this.m_type;
    }

    public String getTypeStr() {
        return this.m_typeStr;
    }

    public static NodeRoleCapability getEnumMember(int value) throws EnumConstantNotPresentException {
        for (NodeRoleCapability t : NodeRoleCapability.values()) {
            if (t.getType() != value) continue;
            return t;
        }
        Trace.out((String)("Invalid node type value [" + value + "]"));
        throw new EnumConstantNotPresentException(NodeRoleCapability.class, Integer.toString(value));
    }

    public static NodeRoleCapability getEnumMember(String typeStr) throws EnumConstantNotPresentException {
        if (typeStr.equalsIgnoreCase("RIM")) {
            return RIM;
        }
        for (NodeRoleCapability t : NodeRoleCapability.values()) {
            if (!typeStr.equalsIgnoreCase(t.getTypeStr())) continue;
            return t;
        }
        Trace.out((String)("Invalid node type value [" + typeStr + "]"));
        throw new EnumConstantNotPresentException(NodeRoleCapability.class, typeStr);
    }

    public String toString() {
        return this.getTypeStr();
    }
}

