/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.verification;

import java.io.File;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.impl.verification.CommandExecResultSetImpl;
import oracle.cluster.impl.verification.NodeConnectivityResultSetImpl;
import oracle.cluster.impl.verification.SharedStorageResultSetImpl;
import oracle.cluster.install.ConfigurationSetup;
import oracle.cluster.install.InstallException;
import oracle.cluster.install.UserInfo;
import oracle.cluster.remote.RemoteUserInfo;
import oracle.cluster.verification.CollectionResultSet;
import oracle.cluster.verification.CommandExecID;
import oracle.cluster.verification.CommandExecResultSet;
import oracle.cluster.verification.DiskGroupResultSet;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.FixupException;
import oracle.cluster.verification.FixupManualInstruction;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.HAInstalledException;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeConnectivityResultSet;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.NodeRoleCapability;
import oracle.cluster.verification.OracleFileType;
import oracle.cluster.verification.OverallStatus;
import oracle.cluster.verification.ParamPreReqAppCluster;
import oracle.cluster.verification.ParamPreReqCRSInst;
import oracle.cluster.verification.ParamPreReqDBConfig;
import oracle.cluster.verification.ParamPreReqDBInst;
import oracle.cluster.verification.ParamPreReqDBProv;
import oracle.cluster.verification.ParamPreReqNodeAddDel;
import oracle.cluster.verification.PreReqNotSupportedException;
import oracle.cluster.verification.PreReqType;
import oracle.cluster.verification.ResultValuesUnavailableException;
import oracle.cluster.verification.SharedStorageResultSet;
import oracle.cluster.verification.ShellLimitType;
import oracle.cluster.verification.ShellResourceType;
import oracle.cluster.verification.ShellType;
import oracle.cluster.verification.SoftwareComponentType;
import oracle.cluster.verification.SpaceResultSet;
import oracle.cluster.verification.StoragePathResultSet;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.StorageType;
import oracle.cluster.verification.StorageUnit;
import oracle.cluster.verification.SubtasksNotCompleteException;
import oracle.cluster.verification.UserEquivCheckType;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationFileInfo;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.cluster.verification.VerificationTask;
import oracle.cluster.verification.constraints.CDMConstraintTypes;
import oracle.cluster.verification.constraints.CDMHost;
import oracle.cluster.verification.constraints.CDMSystem;
import oracle.cluster.verification.constraints.XmlParserException;
import oracle.cluster.verification.constraints.parser.XmlParser;
import oracle.cluster.verification.database.DatabaseConnectInfo;
import oracle.cluster.verification.fixup.CVUFixup;
import oracle.cluster.verification.fixup.FixupUtility;
import oracle.cluster.verification.fixup.RootAutomationException;
import oracle.cluster.verification.fixup.controller.SetupSSHUserEquivalence;
import oracle.cluster.verification.nodemgr.NodeManager;
import oracle.cluster.verification.nodemgr.NodeManagerException;
import oracle.cluster.verification.nodemgr.NodeManagerFactory;
import oracle.cluster.verification.nodemgr.NodeManagerFactoryException;
import oracle.cluster.verification.pluggable.ReferenceInfo;
import oracle.cluster.verification.util.DBUtils;
import oracle.cluster.verification.util.DBUtilsException;
import oracle.cluster.verification.util.DatabaseInfo;
import oracle.cluster.verification.util.VerificationType;
import oracle.cluster.verification.util.XmlFilePathException;
import oracle.cluster.winsecurity.Credentials;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.InvalidNodeListException;
import oracle.ops.mgmt.cluster.SharedDeviceException;
import oracle.ops.mgmt.cluster.Version;
import oracle.ops.mgmt.nativesystem.DeterminePlatform;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.config.VDMUtil;
import oracle.ops.verification.framework.engine.CollectionResultSetImpl;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.factory.context.PluggableTaskContext;
import oracle.ops.verification.framework.engine.factory.data.ArgType;
import oracle.ops.verification.framework.engine.factory.data.DataComparatorType;
import oracle.ops.verification.framework.engine.factory.data.DataType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableArgument;
import oracle.ops.verification.framework.engine.factory.data.ExecutableInfo;
import oracle.ops.verification.framework.engine.factory.data.ExecutableResultType;
import oracle.ops.verification.framework.engine.factory.data.ExecutableType;
import oracle.ops.verification.framework.engine.factory.data.OperationMode;
import oracle.ops.verification.framework.engine.factory.data.StdDataComparator;
import oracle.ops.verification.framework.engine.task.CompSoftwareConfigLoaderException;
import oracle.ops.verification.framework.engine.task.CompsXMLParser;
import oracle.ops.verification.framework.engine.task.PluggableTask;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.engine.task.TaskASMACLAttributeCheck;
import oracle.ops.verification.framework.engine.task.TaskASMDeviceChecks;
import oracle.ops.verification.framework.engine.task.TaskAdminPrivileges;
import oracle.ops.verification.framework.engine.task.TaskArchitecture;
import oracle.ops.verification.framework.engine.task.TaskAvailableMemory;
import oracle.ops.verification.framework.engine.task.TaskCFSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskCRSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterIntegrity;
import oracle.ops.verification.framework.engine.task.TaskClusterMgrIntegrity;
import oracle.ops.verification.framework.engine.task.TaskFactory;
import oracle.ops.verification.framework.engine.task.TaskFactoryException;
import oracle.ops.verification.framework.engine.task.TaskGNSIntegrity;
import oracle.ops.verification.framework.engine.task.TaskGroupExistence;
import oracle.ops.verification.framework.engine.task.TaskGroupMembership;
import oracle.ops.verification.framework.engine.task.TaskHAIntegrity;
import oracle.ops.verification.framework.engine.task.TaskKernelParam;
import oracle.ops.verification.framework.engine.task.TaskKernelVersion;
import oracle.ops.verification.framework.engine.task.TaskNodeAppCreation;
import oracle.ops.verification.framework.engine.task.TaskNodeConnectivity;
import oracle.ops.verification.framework.engine.task.TaskOCRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOLRIntegrity;
import oracle.ops.verification.framework.engine.task.TaskOSPatch;
import oracle.ops.verification.framework.engine.task.TaskOraclePatch;
import oracle.ops.verification.framework.engine.task.TaskPackage;
import oracle.ops.verification.framework.engine.task.TaskPathGroupPermissions;
import oracle.ops.verification.framework.engine.task.TaskPhysicalMemory;
import oracle.ops.verification.framework.engine.task.TaskProcessAlive;
import oracle.ops.verification.framework.engine.task.TaskRunLevel;
import oracle.ops.verification.framework.engine.task.TaskSharedStorageAccess;
import oracle.ops.verification.framework.engine.task.TaskShellLimits;
import oracle.ops.verification.framework.engine.task.TaskSoftwareDistribution;
import oracle.ops.verification.framework.engine.task.TaskSpaceAvail;
import oracle.ops.verification.framework.engine.task.TaskSwapSize;
import oracle.ops.verification.framework.engine.task.TaskTimeZoneSetting;
import oracle.ops.verification.framework.engine.task.TaskUpgradeSuitability;
import oracle.ops.verification.framework.engine.task.TaskUserEquivalence;
import oracle.ops.verification.framework.engine.task.TaskUserExistence;
import oracle.ops.verification.framework.engine.task.TaskVerifyServiceUser;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.network.NetworkDataDiscovery;
import oracle.ops.verification.framework.network.NetworkInfo;
import oracle.ops.verification.framework.network.NetworkUtility;
import oracle.ops.verification.framework.param.InvalidCommandlineException;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.ResponseConfigResolver;
import oracle.ops.verification.framework.param.VariableFileResolverException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.storage.StorageException;
import oracle.ops.verification.framework.storage.StorageInfo;
import oracle.ops.verification.framework.storage.StorageUtil;
import oracle.ops.verification.framework.storage.TypeFinder;
import oracle.ops.verification.framework.storage.sStorageUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtil;
import oracle.ops.verification.framework.util.ASMDiskGroupsUtilException;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.CVUVariableConstants;
import oracle.ops.verification.framework.util.CVUVariables;
import oracle.ops.verification.framework.util.CommandsUtil;
import oracle.ops.verification.framework.util.InvalidEnvironmentException;
import oracle.ops.verification.framework.util.NodeListUtil;
import oracle.ops.verification.framework.util.NodelistNotFoundException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class ClusterVerification {
    private static ParamManager m_pm = null;
    private static ClusterVerification s_clusterVerification;
    private static MessageBundle s_msgBundle;
    private static MessageBundle s_gMsgBundle;
    private static MessageBundle s_nMsgBundle;
    private static String LSEP;
    private static String m_localHost;
    private CVUFixup m_fixUpDriver = null;
    private static String CRSHOME;
    private static Set<String> m_variablesSetInSession;

    private ClusterVerification(String workDir, String frameworkHome) throws VerificationException {
        VerificationUtil.setDestLoc(workDir);
        VerificationUtil.setCVHome(frameworkHome);
        try {
            VerificationUtil.getExecutionEnvironment();
        }
        catch (InvalidEnvironmentException e) {
            throw new VerificationException((Throwable)((Object)e));
        }
    }

    public void setTracing(boolean trace) {
        String traceLvl;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. trace = " + trace));
        }
        if ((traceLvl = System.getProperty("TRACING.LEVEL")) == null) {
            traceLvl = new String("5");
        }
        if (trace) {
            System.setProperty("TRACING.ENABLED", "true");
            System.setProperty("TRACING.LEVEL", traceLvl);
        } else {
            System.setProperty("TRACING.ENABLED", "false");
        }
        VerificationUtil.setupTracing(false);
    }

    public static synchronized ClusterVerification getInstance() throws VerificationException {
        String checkAgainStr;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        if (s_clusterVerification == null) {
            ClusterVerification.setParamManagerLocalHost();
            s_clusterVerification = new ClusterVerification(ClusterVerification.getDefaultWorkDir(), ClusterVerification.getDefaultFrameworkHome());
        }
        if (!VerificationUtil.isStringGood(checkAgainStr = CVUVariables.getValue(CVUVariableConstants.CVU_CHECK_AGAIN))) {
            checkAgainStr = System.getProperty(CVUVariableConstants.CVU_CHECK_AGAIN.toString());
        }
        if (VerificationUtil.isStringGood(checkAgainStr) && checkAgainStr.equalsIgnoreCase("TRUE")) {
            Trace.out((String)"User requested Check Again operation. Clearing Network cache");
            NetworkDataDiscovery.clearCache();
        }
        return s_clusterVerification;
    }

    public static synchronized ClusterVerification getInstance(String workDir, String frameworkHome) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. workDir=" + workDir + " frameworkHome=" + frameworkHome));
        }
        if (s_clusterVerification == null) {
            Assert.assertWorkDir(workDir);
            Assert.assertFrameworkHome(frameworkHome);
            ClusterVerification.setParamManagerLocalHost();
            s_clusterVerification = new ClusterVerification(workDir, frameworkHome);
        }
        return s_clusterVerification;
    }

    public static synchronized ClusterVerification getInstance(String path, PathType type) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. path=" + path + " type=" + (Object)((Object)type)));
        }
        if (s_clusterVerification == null) {
            String frameworkHome;
            String workDir;
            if (type == PathType.WORK_DIR) {
                Assert.assertWorkDir(path);
                workDir = path;
                ClusterVerification.setParamManagerLocalHost();
                frameworkHome = ClusterVerification.getDefaultFrameworkHome();
            } else {
                Assert.assertFrameworkHome(path);
                frameworkHome = path;
                ClusterVerification.setParamManagerLocalHost();
                workDir = ClusterVerification.getDefaultWorkDir();
            }
            s_clusterVerification = new ClusterVerification(workDir, frameworkHome);
        }
        return s_clusterVerification;
    }

    private static void setParamManagerLocalHost() throws VerificationException {
        try {
            m_pm = ParamManager.getInstance(OperationMode.api, null);
        }
        catch (InvalidCommandlineException e) {
            throw new VerificationException(e);
        }
        try {
            m_localHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            throw new VerificationException(s_msgBundle.getMessage("0002", true));
        }
        VerificationUtil.setLocalHostName(m_localHost);
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] nodeList) throws PreReqNotSupportedException, VerificationException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        try {
            nodeList = Assert.assertAndConvertNodesToLower(nodeList);
            CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return this.getPreReqTasksForCRSInstInternal(nodeList);
    }

    private List<VerificationTask> getPreReqTasksForCRSInstInternal(String[] nodeList) throws PreReqNotSupportedException, VerificationException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        Assert.assertNodes(nodeList);
        this.assertFrameworkSetup(nodeList);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] nodeList, ParamPreReqCRSInst param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; param=%s", VerificationUtil.strArr2List(nodeList), param);
        try {
            nodeList = Assert.assertAndConvertNodesToLower(nodeList);
            CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return this.getPreReqTasksForCRSInstInternal(nodeList, param);
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String responseFilePath) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("responseFilePath=" + responseFilePath);
        String[] nodeList = null;
        if (VerificationUtil.isStringGood(responseFilePath)) {
            try {
                ResponseConfigResolver responseConfigResolver = new ResponseConfigResolver();
                responseConfigResolver.resolve(responseFilePath, null, null);
                String strNodes = CVUVariables.getValue(CVUVariableConstants.NODE_LIST);
                if (VerificationUtil.isStringGood(strNodes)) {
                    nodeList = strNodes.split(",");
                }
            }
            catch (VariableFileResolverException icre) {
                throw new VerificationException(icre.getMessage());
            }
        }
        return this.getPreReqTasksForCRSInstInternal(nodeList);
    }

    private List<VerificationTask> getPreReqTasksForCRSInstInternal(String[] nodeList, ParamPreReqCRSInst param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; param=%s", VerificationUtil.strArr2List(nodeList), param);
        Assert.assertNodes(nodeList);
        Assert.assertParamPreReq(param);
        this.assertFrameworkSetup(nodeList);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_CRS_INST, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] hubList, String[] autoList, String[] leafList, int targetHubSize) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("hubList=%s; autoList=%s; leafList=%s; targetHubSize=%s", VerificationUtil.strArr2List(hubList), VerificationUtil.strArr2List(autoList), VerificationUtil.strArr2List(leafList), targetHubSize);
        if (hubList != null && hubList.length != 0) {
            hubList = VerificationUtil.getNodenamesInLowerCase(hubList);
        }
        if (autoList != null && autoList.length != 0) {
            autoList = VerificationUtil.getNodenamesInLowerCase(autoList);
        }
        if (leafList != null && leafList.length != 0) {
            leafList = VerificationUtil.getNodenamesInLowerCase(leafList);
        }
        NodeListUtil.resetNodeInfo();
        NodeListUtil.setHubNodelist(hubList);
        NodeListUtil.setAutoNodelist(autoList);
        NodeListUtil.setRimNodelist(leafList);
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(hubList, leafList, autoList, targetHubSize);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(NodeListUtil.getAllNodes()));
        return this.getPreReqTasksForCRSInstInternal(NodeListUtil.getAllNodes());
    }

    public List<VerificationTask> getPreReqTasksForCRSInst(String[] hubList, String[] autoList, String[] leafList, int targetHubSize, ParamPreReqCRSInst param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("hubList=%s; autoList=%s; leafList=%s; targetHubSize=%s; param=%s", VerificationUtil.strArr2List(hubList), VerificationUtil.strArr2List(autoList), VerificationUtil.strArr2List(leafList), targetHubSize, param);
        if (hubList != null && hubList.length != 0) {
            hubList = VerificationUtil.getNodenamesInLowerCase(hubList);
        }
        if (autoList != null && autoList.length != 0) {
            autoList = VerificationUtil.getNodenamesInLowerCase(autoList);
        }
        if (leafList != null && leafList.length != 0) {
            leafList = VerificationUtil.getNodenamesInLowerCase(leafList);
        }
        NodeListUtil.resetNodeInfo();
        NodeListUtil.setHubNodelist(hubList);
        NodeListUtil.setAutoNodelist(autoList);
        NodeListUtil.setRimNodelist(leafList);
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(hubList, leafList, autoList, targetHubSize);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(NodeListUtil.getAllNodes()));
        return this.getPreReqTasksForCRSInstInternal(NodeListUtil.getAllNodes(), param);
    }

    public List<VerificationTask> getPreReqTasksForDBInst(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        this.createNodeManager(PreReqType.PREREQ_DB_INST);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBInst(String[] nodeList, ParamPreReqDBInst param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; param=%s", VerificationUtil.strArr2List(nodeList), param);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertParamPreReq(param);
        this.createNodeManager(PreReqType.PREREQ_DB_INST);
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_INST, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBProv(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        this.createNodeManager(PreReqType.PREREQ_DB_PROV);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_PROV, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBProv(String[] nodeList, ParamPreReqDBProv param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; param=%s", VerificationUtil.strArr2List(nodeList), param);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertParamPreReq(param);
        this.createNodeManager(PreReqType.PREREQ_DB_PROV);
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_PROV, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIHAInst() throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationUtil.setLocalNodeOperation(true);
        this.checkFrameworkSetup();
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_HA_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIDBInst() throws VerificationException, PreReqNotSupportedException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        this.createNodeManager(PreReqType.PREREQ_SI_DB_INST);
        this.checkFrameworkSetup();
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_DB_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForGenericInst() throws VerificationException, PreReqNotSupportedException {
        Trace.out((String)"Method Entry");
        this.createNodeManager(PreReqType.PREREQ_GENERIC_INST);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationUtil.setLocalNodeOperation(true);
        this.checkFrameworkSetup();
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_GENERIC_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForGenericInst(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        this.createNodeManager(nodeList);
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_GENERIC_INST, nodeList);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForAppClusterInstall(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        try {
            nodeList = Assert.assertAndConvertNodesToLower(nodeList);
            CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return this.getPreReqTasksForAppClusterInstallInternal(nodeList);
    }

    public List<VerificationTask> getPreReqTasksForAppClusterInstall(String[] hubList, String[] autoList, String[] leafList, int targetHubSize) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("hubList=%s ; autoList=%s ; leafList=%s ; targetHubSize=%s", VerificationUtil.strArr2List(hubList), VerificationUtil.strArr2List(autoList), VerificationUtil.strArr2List(leafList), targetHubSize);
        if (hubList != null && hubList.length != 0) {
            hubList = VerificationUtil.getNodenamesInLowerCase(hubList);
        }
        if (autoList != null && autoList.length != 0) {
            autoList = VerificationUtil.getNodenamesInLowerCase(autoList);
        }
        if (leafList != null && leafList.length != 0) {
            leafList = VerificationUtil.getNodenamesInLowerCase(leafList);
        }
        NodeListUtil.resetNodeInfo();
        NodeListUtil.setHubNodelist(hubList);
        NodeListUtil.setAutoNodelist(autoList);
        NodeListUtil.setRimNodelist(leafList);
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(hubList, leafList, autoList, targetHubSize);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(NodeListUtil.getAllNodes()));
        return this.getPreReqTasksForAppClusterInstallInternal(NodeListUtil.getAllNodes());
    }

    private List<VerificationTask> getPreReqTasksForAppClusterInstallInternal(String[] nodeList) throws VerificationException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        this.assertFrameworkSetup(nodeList);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_APPLICATION_CLUSTER_INST, nodeList, new ParamPreReqAppCluster());
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String oracleHome) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("oracleHome=" + oracleHome);
        Assert.assertOracleHome(oracleHome, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        VerificationUtil.setLocalNodeOperation(true);
        this.checkFrameworkSetup();
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String[] nodeList, String oracleHome) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; oracleHome=%s", VerificationUtil.strArr2List(nodeList), oracleHome);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertOracleHome(oracleHome, false);
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        this.createNodeManager(PreReqType.PREREQ_DB_CONFIG);
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForDBConfig(String[] nodeList, ParamPreReqDBConfig param) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s ; param=%s", VerificationUtil.strArr2List(nodeList), param);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertParamPreReq(param);
        this.createNodeManager(PreReqType.PREREQ_DB_CONFIG);
        this.assertFrameworkSetup(nodeList, false);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_DB_CONFIG, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForSIDBConfig(String oracleHome) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("oracleHome=" + oracleHome);
        Assert.assertOracleHome(oracleHome, true);
        this.createNodeManager(PreReqType.PREREQ_SI_DB_CONFIG);
        this.checkFrameworkSetup();
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ParamPreReqDBConfig paramCfg = new ParamPreReqDBConfig(oracleHome);
        VerificationUtil.setLocalNodeOperation(true);
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_SI_DB_CONFIG, nodeList, paramCfg);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPostReqTasksForDBConfig(String[] nodeList, String dbUniqueName, String userName, String password) throws VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " dbName=" + dbUniqueName + " userName= " + userName));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertUser(userName);
        Assert.assertPassword(password);
        this.createNodeManager(PreReqType.POSTREQ_DB_CONFIG);
        this.assertFrameworkSetup(nodeList, false);
        try {
            Version crsVer = VerificationUtil.getCRSActiveVersionObj();
            DBUtils dbUtils = new DBUtils(crsVer);
            DatabaseInfo dbInfo = dbUtils.getDatabaseInfo(dbUniqueName);
            ParamPreReqDBConfig param = new ParamPreReqDBConfig(dbInfo.getHome());
            param.setOraInv(VerificationUtil.getOraInventoryGroup());
            Version dbVer = dbInfo.getVersion();
            String minorVer = dbVer.getMinorVersion();
            minorVer = "0".equals(minorVer) ? "1" : minorVer;
            param.setRelease(dbVer.getMajorVersion() + "." + minorVer);
            DatabaseConnectInfo dbConnInfo = new DatabaseConnectInfo(dbUniqueName, userName, password);
            DatabaseConnectInfo.addDBConnectInfo(dbConnInfo);
            TaskFactory tf = TaskFactory.getInstance();
            List<Task> taskList = tf.getTaskList(VerificationType.POSTREQ_DB_CONFIG, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[taskList.size()]));
        }
        catch (TaskFactoryException tfe) {
            Trace.out((String)("TaskFactoryException occured. message: " + tfe.getMessage()));
            throw new VerificationException(tfe);
        }
        catch (DBUtilsException dbuEx) {
            Trace.out((String)("DBUtilsException occured. message: " + dbuEx.getMessage()));
            throw new VerificationException(dbuEx);
        }
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=" + VerificationUtil.strArr2List(nodeList));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        return this.getPreReqTasksForNodeAddInternal(nodeList, null, null);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList, String[] nodeVIPList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s; nodeVIPList=%s", VerificationUtil.strArr2List(nodeList), VerificationUtil.strArr2List(nodeVIPList));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertNodeVIPList(nodeVIPList, true);
        if (nodeList.length != nodeVIPList.length) {
            throw new VerificationException(s_gMsgBundle.getMessage("11407", true));
        }
        return this.getPreReqTasksForNodeAddInternal(nodeList, nodeVIPList, null);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList, NodeRoleCapability[] nodeRoleList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s; nodeRoleList=%s", VerificationUtil.strArr2List(nodeList), nodeRoleList == null ? "null" : VerificationUtil.objArr2String((Object[])nodeRoleList));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertNodeRoleList(nodeRoleList);
        if (nodeList.length != nodeRoleList.length) {
            throw new VerificationException(s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"CV-gPRTFNodeAdd-01"}));
        }
        return this.getPreReqTasksForNodeAddInternal(nodeList, null, nodeRoleList);
    }

    public List<VerificationTask> getPreReqTasksForNodeAdd(String[] nodeList, String[] nodeVIPList, NodeRoleCapability[] nodeRoleList) throws VerificationException, PreReqNotSupportedException {
        VerificationUtil.traceAndLog("nodeList=%s; nodeVIPList=%s nodeRoleList=%s", VerificationUtil.strArr2List(nodeList), VerificationUtil.strArr2List(nodeVIPList), nodeRoleList == null ? "null" : VerificationUtil.objArr2String((Object[])nodeRoleList));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Assert.assertNodeVIPList(nodeVIPList, false);
        Assert.assertNodeRoleList(nodeRoleList);
        if (nodeList.length != nodeVIPList.length || nodeList.length != nodeRoleList.length) {
            throw new VerificationException(s_gMsgBundle.getMessage("11408", true));
        }
        for (int i = 0; i < nodeList.length; ++i) {
            if (nodeRoleList[i] != NodeRoleCapability.HUB || VerificationUtil.isStringGood(nodeVIPList[i])) continue;
            throw new VerificationException(s_gMsgBundle.getMessage("11321", true, (Object[])new String[]{"node VIP list"}));
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < nodeList.length; ++i) {
            sb.append(LSEP + " " + nodeList[i] + " " + nodeVIPList[i] + " " + nodeRoleList[i].toString());
        }
        Trace.out((String)sb.toString());
        VerificationLogData.logInfo(sb.toString());
        return this.getPreReqTasksForNodeAddInternal(nodeList, nodeVIPList, nodeRoleList);
    }

    private List<VerificationTask> getPreReqTasksForNodeAddInternal(String[] nodeList, String[] nodeVIPList, NodeRoleCapability[] nodeRoleList) throws VerificationException, PreReqNotSupportedException {
        String[] clusterNodes;
        String[] validNodes = null;
        String[] newClusterNodes = null;
        ParamPreReqNodeAddDel param = new ParamPreReqNodeAddDel();
        NodeManagerFactory nmf = null;
        NodeManager nm = null;
        VerificationUtil.traceAndLog("nodeList=%s; nodeVIPList=%s nodeRoleList=%s", VerificationUtil.strArr2List(nodeList), VerificationUtil.strArr2List(nodeVIPList), nodeRoleList == null ? "null" : VerificationUtil.objArr2String((Object[])nodeRoleList));
        try {
            nmf = NodeManagerFactory.getInstance();
            nm = nmf.createNodeManager();
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        boolean isBC = nm.isBigCluster();
        Trace.out((String)("isBC=" + isBC));
        if (!isBC && nodeRoleList != null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11405", true));
        }
        if (isBC && nodeRoleList == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11406", true));
        }
        if (isBC) {
            VerificationUtil.validateNewNodeRoles(nodeList, nodeRoleList, param);
        }
        String[] nodesWithVIPArr = new String[]{};
        String[] realNodeVIPArr = new String[]{};
        if (nodeVIPList != null && nodeVIPList.length != 0) {
            ArrayList<String> realNodeVIPList = new ArrayList<String>();
            ArrayList<String> nodesWithVIPList = new ArrayList<String>();
            for (int i = 0; i < nodeList.length; ++i) {
                if (!VerificationUtil.isStringGood(nodeVIPList[i]) || nodeVIPList[i].equalsIgnoreCase("AUTO")) continue;
                nodesWithVIPList.add(nodeList[i]);
                realNodeVIPList.add(nodeVIPList[i]);
            }
            realNodeVIPArr = realNodeVIPList.toArray(new String[realNodeVIPList.size()]);
            nodesWithVIPArr = nodesWithVIPList.toArray(new String[nodesWithVIPList.size()]);
        }
        Trace.out((String)("nodesWithVIPArr='" + VerificationUtil.strArr2List(nodesWithVIPArr) + "'"));
        Trace.out((String)("realNodeVIPArr='" + VerificationUtil.strArr2List(realNodeVIPArr) + "'"));
        param.setNodes(nodeList);
        param.setVipList(realNodeVIPArr);
        param.setNodesWithVip(nodesWithVIPArr);
        param.setNodeRoleList(nodeRoleList);
        this.checkFrameworkSetup();
        try {
            clusterNodes = VerificationUtil.getStaticNodelist();
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("NODELISTNOTFOUNDEXCEPTION: Could not get static nodelist\n" + e.getMessage()));
            String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("4909", false) + e.getMessage();
            throw new VerificationException(errMsg);
        }
        Trace.out((String)("== Cluster nodelist: " + VerificationUtil.strArr2List(clusterNodes)));
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(clusterNodes);
        if (!setupResultSet.allSuccess()) {
            Trace.out((String)"At least one failure in checking framework setup");
            if (!setupResultSet.anySuccess()) {
                Trace.out((String)"All nodes failed framework setup check.");
                String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("7610", false);
                throw new VerificationException(errMsg);
            }
        }
        validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        param.setValidClusterNodes(validNodes);
        ArrayList<String> clusterList = new ArrayList<String>();
        Collections.addAll(clusterList, validNodes);
        Trace.out((String)("== VALID clusterList: " + ((Object)clusterList).toString()));
        ArrayList<String> existingClusterNodesList = new ArrayList<String>(Arrays.asList(clusterNodes));
        ArrayList<String> nodesAlreadyInClusterList = new ArrayList<String>();
        for (String node : nodeList) {
            if (!existingClusterNodesList.contains(node)) continue;
            nodesAlreadyInClusterList.add(node);
        }
        if (nodesAlreadyInClusterList.size() != 0) {
            String errMsg = s_gMsgBundle.getMessage("11409", true, (Object[])new String[]{VerificationUtil.strList2List(nodesAlreadyInClusterList)});
            throw new VerificationException(errMsg);
        }
        setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.allSuccess()) {
            Trace.out((String)"Failure checking 'nodeList' framework setup");
            if (!setupResultSet.anySuccess()) {
                Trace.out((String)"All nodes to be added failed framework setup check.");
                String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("7560", false);
                throw new VerificationException(errMsg);
            }
        }
        validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        param.setValidNodes(validNodes);
        ArrayList<String> newNodesList = new ArrayList<String>(Arrays.asList(validNodes));
        Trace.out((String)("== VALID NEW nodes: " + ((Object)newNodesList).toString()));
        for (String node : newNodesList) {
            if (clusterList.contains(node)) continue;
            clusterList.add(node);
        }
        newClusterNodes = clusterList.toArray(new String[clusterList.size()]);
        param.setValidNewClusterNodes(newClusterNodes);
        try {
            nm = nmf.createNodeManager();
            if (isBC) {
                ArrayList<String> newHubNodes = new ArrayList<String>();
                ArrayList<String> newLeafNodes = new ArrayList<String>();
                ArrayList<String> newAutoNodes = new ArrayList<String>();
                block16: for (int i = 0; i < nodeList.length; ++i) {
                    switch (nodeRoleList[i]) {
                        case HUB: {
                            newHubNodes.add(nodeList[i]);
                            continue block16;
                        }
                        case RIM: {
                            newLeafNodes.add(nodeList[i]);
                            continue block16;
                        }
                        case AUTO: {
                            newAutoNodes.add(nodeList[i]);
                        }
                    }
                }
                String[] at = new String[]{};
                nm.addNodes(newHubNodes.toArray(at), newLeafNodes.toArray(at), newAutoNodes.toArray(at));
            } else {
                nm.addNodes(nodeList);
            }
        }
        catch (NodeManagerException nmEx) {
            Trace.out((String)("NodeManagerException :" + nmEx.getMessage()));
            throw new VerificationException(nmEx);
        }
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_NODE_ADD, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public List<VerificationTask> getPreReqTasksForRACNodeAdd(String[] nodeList, String crsHome) throws VerificationException, PreReqNotSupportedException {
        NodeManagerFactory nmf;
        String[] clusterNodes;
        ArrayList<String> clusterList = new ArrayList<String>();
        String[] validNodes = null;
        String[] newClusterNodes = null;
        ParamPreReqNodeAddDel param = new ParamPreReqNodeAddDel();
        NodeManager nm = null;
        VerificationUtil.traceAndLog("nodeList=%s ; crsHome=%s", VerificationUtil.strArr2List(nodeList), crsHome);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        CVUVariables.setValue(CVUVariableConstants.NODE_LIST, VerificationUtil.strArr2List(nodeList));
        Trace.out((String)("ENTRY: nodeList: '" + VerificationUtil.strArr2List(nodeList) + "' crsHome: '" + crsHome + "'"));
        param.setNodes(nodeList);
        param.setRACHome(true);
        param.setCRSHome(crsHome);
        this.checkFrameworkSetup();
        try {
            clusterNodes = VerificationUtil.getStaticNodelist();
        }
        catch (NodelistNotFoundException e) {
            Trace.out((String)("NODELISTNOTFOUNDEXCEPTION: Could not get static nodelist\n" + e.getMessage()));
            String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("4909", false) + e.getMessage();
            throw new VerificationException(errMsg);
        }
        Trace.out((String)("== Cluster nodelist: " + VerificationUtil.strArr2List(clusterNodes)));
        try {
            nmf = NodeManagerFactory.getInstance();
            Trace.out((String)("Getting INITIAL NodeManager for cluster nodelist: '" + VerificationUtil.strArr2List(clusterNodes) + "'"));
            nm = nmf.createNodeManager();
        }
        catch (NodeManagerFactoryException nmfEx) {
            String exceptionMsg = new String("NODEMANAGERFACTORYEXCEPTION: " + nmfEx.getMessage());
            VerificationLogData.logError(exceptionMsg);
            Trace.out((String)exceptionMsg);
            Trace.stackTrace();
            throw new VerificationException(nmfEx);
        }
        boolean isBC = nm.isBigCluster();
        Trace.out((String)("INITIAL: isBC=" + isBC));
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(clusterNodes);
        if (!setupResultSet.allSuccess()) {
            Trace.out((String)"At least one failure in checking framework setup");
            if (!setupResultSet.anySuccess()) {
                Trace.out((String)"All nodes failed framework setup check.");
                String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("7610", false);
                throw new VerificationException(errMsg);
            }
        }
        validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        Trace.out((String)("VALID Cluster nodes: " + VerificationUtil.strArr2List(validNodes)));
        param.setValidClusterNodes(validNodes);
        setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.allSuccess()) {
            Trace.out((String)"Failure checking 'nodeList' framework setup");
            if (!setupResultSet.anySuccess()) {
                Trace.out((String)"All nodes to be added failed framework setup check.");
                String errMsg = s_msgBundle.getMessage("4853", false) + s_msgBundle.getMessage("7560", false);
                throw new VerificationException(errMsg);
            }
        }
        validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        param.setValidNodes(validNodes);
        ArrayList<String> newNodesList = new ArrayList<String>(Arrays.asList(validNodes));
        Trace.out((String)("VALID NEW nodes: " + ((Object)newNodesList).toString()));
        for (String node : newNodesList) {
            if (clusterList.contains(node)) continue;
            clusterList.add(node);
        }
        newClusterNodes = clusterList.toArray(new String[clusterList.size()]);
        param.setValidNewClusterNodes(newClusterNodes);
        try {
            nmf = NodeManagerFactory.getInstance();
            Trace.out((String)"Creating FINAL NodeManager");
            nm = nmf.createNodeManager();
        }
        catch (NodeManagerFactoryException nmfEx) {
            String exceptionMsg = new String("NODEMANAGERFACTORYEXCEPTION: " + nmfEx.getMessage());
            VerificationLogData.logError(exceptionMsg);
            Trace.out((String)exceptionMsg);
            Trace.stackTrace();
            throw new VerificationException(nmfEx);
        }
        isBC = nm.isBigCluster();
        Trace.out((String)("FINAL: isBC=" + isBC));
        try {
            List<Task> taskList = TaskFactory.getInstance().getTaskList(VerificationType.PREREQ_RACNODE_ADD, nodeList, param);
            return Arrays.asList(taskList.toArray(new Task[0]));
        }
        catch (TaskFactoryException tfe) {
            throw new VerificationException(tfe);
        }
    }

    public CommandExecResultSet executeCommand(String[] nodeList, String oracleHome, CommandExecID commandID, String[] args, int timeout) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome + " commandID=" + (Object)((Object)commandID) + "args=" + VerificationUtil.strArr2List(args) + " timeout=" + timeout));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertOracleHomeForCmdExec(oracleHome);
        CommandExecResultSetImpl cmdExecResultset = new CommandExecResultSetImpl(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.allSuccess()) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)"At least one failure in checking framework setup");
            }
            cmdExecResultset.setErrors(setupResultSet);
            if (!setupResultSet.anySuccess()) {
                if (Trace.isLevelEnabled((int)1)) {
                    Trace.out((String)"Failure on all the nodes in checking framework setup");
                }
                return cmdExecResultset;
            }
        }
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        String cmd = oracleHome + VerificationConstants.FSEP + "bin" + VerificationConstants.FSEP + (Object)((Object)commandID);
        if (args != null) {
            cmd = cmd + " " + VerificationUtil.strArr2List(args, " ");
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("cmd=" + cmd));
        }
        GlobalExecution globalExec = new GlobalExecution();
        Hashtable htRunExe = globalExec.runExeWithOutput(validNodes, cmd, new ResultSet());
        cmdExecResultset.setCommandExecutionResults(htRunExe);
        return cmdExecResultset;
    }

    public VerificationResult checkSpaceAvailability(String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. path=" + path + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        Assert.assertPath(path);
        Assert.assertSize(size);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ClusterCmd clusterCmd = new ClusterCmd();
        try {
            clusterCmd.pathExists(new String[]{"localnode"}, path, 1);
        }
        catch (ClusterException ce) {
            throw new InvalidPathException(s_msgBundle.getMessage("7509", false, (Object[])new String[]{path}), ce);
        }
        catch (ClusterOperationException ce) {
            throw new VerificationException(ce);
        }
        VerificationResultSet resultSet = this.checkSpaceAvailability(true, nodeList, path, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkSpaceAvailability(String[] nodeList, String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        return this.checkSpaceAvailability(false, nodeList, path, size, unit);
    }

    private VerificationResultSet checkSpaceAvailability(boolean localNode, String[] nodeList, String path, long size, StorageUnit unit) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskSpaceAvail spaceTask = new TaskSpaceAvail(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        spaceTask.setLocation(path);
        StorageSize reqdSpace = new StorageSize((double)size, unit);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)(" required space = " + reqdSpace));
        }
        spaceTask.setReqdSpace(reqdSpace);
        try {
            resultSet = spaceTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(spaceTask, resultSet);
        }
        return resultSet;
    }

    public DiskInfoResultSet getDiskInfo(String[] nodeList, String path) throws InvalidPathException, VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        Assert.assertWindowsPlatform();
        ResultSet setupResultSet = (ResultSet)this.assertFrameworkSetup(nodeList);
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(validNodes) + " path=" + path));
        }
        DiskInfoResultSet diskRS = VerificationUtil.getDiskInfoForPath(validNodes, path);
        ((ResultSet)((Object)diskRS)).addResultSetData(setupResultSet);
        return diskRS;
    }

    public boolean checkPathsForSameLocation(String[] nodeList, String path1, String path2) throws InvalidPathException, VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path1);
        Assert.assertPath(path2);
        Assert.assertWindowsPlatform();
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path1=" + path1 + " path2=" + path2));
        }
        DiskInfoResultSet path1ResSet = this.getDiskInfo(nodeList, path1);
        DiskInfoResultSet path2ResSet = this.getDiskInfo(nodeList, path2);
        String errorMsg = "";
        if (path1ResSet.getOverallStatus() != OverallStatus.SUCCESSFUL) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Failure in retrieval of disk information for " + path1));
            }
            for (String node : nodeList) {
                errorMsg = errorMsg + path1ResSet.getErrorsMessage(node);
            }
        }
        if (path2ResSet.getOverallStatus() != OverallStatus.SUCCESSFUL) {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Failure in retrieval of disk information for " + path2));
            }
            for (String node : nodeList) {
                errorMsg = errorMsg + path2ResSet.getErrorsMessage(node);
            }
        }
        if (errorMsg.trim().length() > 0) {
            throw new VerificationException(errorMsg);
        }
        return path1ResSet.checkPathForSameMountPoint(path2ResSet);
    }

    public VerificationResult checkPathGroupPermissions(String path) throws InvalidPathException, VerificationException {
        Trace.out((String)("Method Entry. path=" + path));
        Assert.assertPath(path);
        Assert.assertUnixPlatform();
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPathGroupPermissions(true, nodeList, path);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPathGroupPermissions(String[] nodeList, String path) throws InvalidPathException, VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path));
        Assert.assertNodes(nodeList);
        Assert.assertPath(path);
        Assert.assertUnixPlatform();
        return this.checkPathGroupPermissions(false, nodeList, path);
    }

    private VerificationResultSet checkPathGroupPermissions(boolean localNode, String[] nodeList, String path) throws InvalidPathException, VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskPathGroupPermissions groupTask = new TaskPathGroupPermissions(nodeList, path);
        try {
            resultSet = groupTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        this.traceTaskResultSet(groupTask, resultSet);
        return resultSet;
    }

    public SpaceResultSet getAvailableSpace(String[] nodeList, String path, boolean isWritePermissionRequired) throws InvalidPathException, VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " isWritePermissionRequired=" + isWritePermissionRequired));
        }
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        ResultSet setupResultSet = (ResultSet)this.assertFrameworkSetup(nodeList);
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        String localNode = this.getLocalNode();
        if (localNode != null && nodeList.length == 1 && nodeList[0].equalsIgnoreCase(localNode)) {
            VerificationUtil.setLocalNodeOperation(true);
        } else {
            VerificationUtil.setLocalNodeOperation(false);
        }
        SpaceResultSet spaceRS = VerificationUtil.getAvailableSpace(validNodes, path, isWritePermissionRequired);
        ((ResultSet)((Object)spaceRS)).addResultSetData(setupResultSet);
        return spaceRS;
    }

    public VerificationResult checkHAIntegrity() throws VerificationException, HAInstalledException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            try {
                return setupResultSet.getNodeResult(localNode, true);
            }
            catch (NodeResultsUnavailableException e) {
                throw new VerificationException(e);
            }
        }
        if (!VerificationUtil.isHAInstalled()) {
            throw new HAInstalledException(s_msgBundle.getMessage("4112", false));
        }
        TaskHAIntegrity taskHAI = new TaskHAIntegrity(nodeList);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Check HA integrity on: " + localNode));
        }
        try {
            resultSet = taskHAI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskHAI, resultSet);
        }
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResult checkGNSClientData(String clientDataFile) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        Assert.assertPath(clientDataFile);
        String[] nodeList = new String[]{m_localHost};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            try {
                return setupResultSet.getNodeResult(m_localHost, true);
            }
            catch (NodeResultsUnavailableException e) {
                throw new VerificationException(e);
            }
        }
        TaskGNSIntegrity taskGNSI = new TaskGNSIntegrity(nodeList);
        taskGNSI.setPreCheck(true);
        CVUVariables.setValue(CVUVariableConstants.USE_SHARED_GNS, "TRUE");
        CVUVariables.setValue(CVUVariableConstants.GNS_CLIENT_DATA_FILE, clientDataFile);
        try {
            resultSet = taskGNSI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        this.traceTaskResultSet(taskGNSI, resultSet);
        try {
            return ((ResultSet)resultSet).getNodeResult(m_localHost, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkNodeReachability(String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup();
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeConnectivity nodeReachTask = new TaskNodeConnectivity(nodeList);
        nodeReachTask.setTaskType(1);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Check node reachability to: " + nodeList));
        }
        try {
            resultSet = nodeReachTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeReachTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResultSet checkNodeReachability(String referenceNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. referenceNode= " + referenceNode + "nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        referenceNode = Assert.assertAndConvertNodeToLower(referenceNode);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(new String[]{referenceNode});
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeConnectivity nodeReachTask = new TaskNodeConnectivity(nodeList);
        nodeReachTask.setSourceNode(referenceNode);
        nodeReachTask.setTaskType(1);
        if (Trace.isLevelEnabled((int)1)) {
            if (Trace.isLevelEnabled((int)1)) {
                Trace.out((String)("referenceNode: " + referenceNode));
            }
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)("Check node reachability from " + referenceNode + " to: " + nodeList[i]));
            }
        }
        try {
            resultSet = nodeReachTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        this.traceTaskResultSet(nodeReachTask, resultSet);
        return resultSet;
    }

    public NodeConnectivityResultSet checkNodeConnectivity(String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"No interface(s) specified.");
        }
        if (!(setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList = Assert.assertAndConvertNodesToLower(nodeList))).anySuccess()) {
            NodeConnectivityResultSetImpl netConResSet = new NodeConnectivityResultSetImpl();
            netConResSet.addResultSetData(setupResultSet);
            return netConResSet;
        }
        Trace.out((String)"Clearing cached network details on all the nodes");
        NetworkDataDiscovery.clearCache();
        TaskNodeConnectivity nodeConnTask = new TaskNodeConnectivity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        nodeConnTask.setTaskType(0);
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Node(s): ");
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)nodeList[i]);
            }
        }
        try {
            resultSet = nodeConnTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        NodeConnectivityResultSetImpl nodeConResSetImpl = nodeConnTask.getNodeConnectivityResultSetImpl();
        nodeConResSetImpl.addResultSetData(setupResultSet);
        nodeConResSetImpl.addResultSetData((ResultSet)resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeConnTask, resultSet);
        }
        return nodeConResSetImpl;
    }

    public NodeConnectivityResultSet checkNodeConnectivity(String[] nodeList, String interfaceName) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " interfaceName=" + interfaceName));
        }
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)"Interface specified).");
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertInterface(interfaceName);
        String[] interfaceList = null;
        if (interfaceName != null) {
            interfaceList = new String[]{interfaceName};
        }
        if (!(setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList)).anySuccess()) {
            NodeConnectivityResultSetImpl netConResSet = new NodeConnectivityResultSetImpl();
            netConResSet.addResultSetData(setupResultSet);
            return netConResSet;
        }
        Trace.out((String)"Clearing cached network details on all the nodes");
        NetworkDataDiscovery.clearCache();
        TaskNodeConnectivity nodeConnTask = new TaskNodeConnectivity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        nodeConnTask.setTaskType(0);
        nodeConnTask.setNetworksToConsider(NetworkUtility.createClusterNetworksBasedOnNetworkNames(interfaceList));
        if (Trace.isLevelEnabled((int)1)) {
            for (int i = 0; i < nodeList.length; ++i) {
                Trace.out((String)("Node(s):" + nodeList[i]));
            }
            Trace.out((String)("Interface:" + interfaceList));
        }
        try {
            resultSet = nodeConnTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        NodeConnectivityResultSetImpl nodeConResSetImpl = nodeConnTask.getNodeConnectivityResultSetImpl();
        nodeConResSetImpl.addResultSetData(setupResultSet);
        nodeConResSetImpl.addResultSetData((ResultSet)resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeConnTask, resultSet);
        }
        return nodeConResSetImpl;
    }

    public NodeConnectivityResultSet checkNodeConnectivity(String[] nodeList, String interfaceName, String subnetNumber) throws VerificationException {
        VerificationResultSet resultSet;
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " interfaceName=" + interfaceName + " subnet=" + subnetNumber));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertInterface(interfaceName);
        Assert.assertSubnet(subnetNumber);
        String[] interfaceList = new String[]{interfaceName};
        String[] subnetList = new String[]{subnetNumber};
        int[] subnetTypeList = new int[]{4};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            NodeConnectivityResultSetImpl netConResSet = new NodeConnectivityResultSetImpl();
            netConResSet.addResultSetData(setupResultSet);
            return netConResSet;
        }
        Trace.out((String)"Clearing cached network details on all the nodes");
        NetworkDataDiscovery.clearCache();
        TaskNodeConnectivity nodeConnTask = new TaskNodeConnectivity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        nodeConnTask.setTaskType(0);
        HashSet<NetworkInfo> networks = new HashSet<NetworkInfo>();
        for (int networkCount = 0; networkCount < interfaceList.length; ++networkCount) {
            NetworkInfo network = new NetworkInfo();
            network.setInterfaceName(interfaceList[networkCount]);
            network.setSubnet(subnetList[networkCount]);
            network.setNetworkType(subnetTypeList[networkCount]);
            networks.add(network);
        }
        if (NetworkUtility.isNetworksSetGood(networks)) {
            nodeConnTask.setNetworksToConsider(networks);
        }
        try {
            resultSet = nodeConnTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        NodeConnectivityResultSetImpl nodeConResSetImpl = nodeConnTask.getNodeConnectivityResultSetImpl();
        nodeConResSetImpl.addResultSetData(setupResultSet);
        nodeConResSetImpl.addResultSetData((ResultSet)resultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(nodeConnTask, resultSet);
        }
        return nodeConResSetImpl;
    }

    public VerificationResultSet getSharedMemory(String[] nodeList, StorageUnit unit) throws VerificationException {
        Assert.assertUnixPlatform();
        Assert.assertStorageUnit(unit);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        return VerificationUtil.getSharedMemory(nodeList, unit);
    }

    public StorageType getStorageType(String path) throws VerificationException, InvalidPathException {
        Assert.assertPath(path);
        return this.getStorageType(m_localHost, path);
    }

    public StorageType getStorageType(String node, String path) throws VerificationException, InvalidPathException {
        Assert.assertPath(path);
        node = Assert.assertAndConvertNodeToLower(node);
        StorageType stType = null;
        this.assertFrameworkSetup(new String[]{node});
        try {
            StorageInfo stInfo = new TypeFinder().getStorageInstance(path, node);
            stType = sStorageUtil.getTypeEnum(stInfo.getType());
            if (StorageType.UNKNOWN.equals((Object)stType)) {
                throw new VerificationException(s_gMsgBundle.getMessage("11421", true));
            }
        }
        catch (StorageException e) {
            throw new VerificationException(s_gMsgBundle.getMessage("11420", true, (Object[])new String[]{path}), e);
        }
        return stType;
    }

    public VerificationResultSet checkDevicesAsmFilterDriverCapable(Hashtable<String, List<String>> nodeWiseASMDeviceListTable) throws VerificationException {
        String[] nodeList = nodeWiseASMDeviceListTable.keySet().toArray(new String[0]);
        Assert.assertAndConvertNodesToLower(nodeList);
        for (String node : nodeWiseASMDeviceListTable.keySet()) {
            for (String asmDisk : nodeWiseASMDeviceListTable.get(node)) {
                Assert.assertASMDisk(asmDisk, true);
            }
        }
        ResultSet setupResultSet = (ResultSet)this.assertFrameworkSetup(nodeList);
        ResultSet afdRS = new GlobalExecution().checkDiskAFDCapable(nodeWiseASMDeviceListTable);
        afdRS.addResultSetData(setupResultSet);
        return afdRS;
    }

    public VerificationResultSet checkDevicesAsmFilterDriverCapable(List<String> asmDeviceList) throws VerificationException {
        Hashtable<String, List<String>> localNodeASMDeviceListTable = new Hashtable<String, List<String>>();
        localNodeASMDeviceListTable.put(m_localHost, asmDeviceList);
        return this.checkDevicesAsmFilterDriverCapable(localNodeASMDeviceListTable);
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkSharedStorageAccessibility(nodeList, OracleFileType.RAC_DATA_FILES);
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] nodeList, OracleFileType fileType) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + "fileType=" + (Object)((Object)fileType)));
        }
        if (!(setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList = Assert.assertAndConvertNodesToLower(nodeList))).anySuccess()) {
            SharedStorageResultSetImpl ssConResSet = new SharedStorageResultSetImpl();
            ssConResSet.uploadResultSet(setupResultSet);
            return ssConResSet;
        }
        TaskSharedStorageAccess ssaTask = new TaskSharedStorageAccess(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        ssaTask.setOracleFileType(fileType);
        try {
            resultSet = ssaTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        SharedStorageResultSetImpl ssResSetImpl = ssaTask.getSharedStorageResultSetImpl();
        ssResSetImpl.uploadResultSet(setupResultSet);
        if (Trace.isTraceEnabled()) {
            this.traceTaskResultSet(ssaTask, resultSet);
            Trace.out((String)("ssResSetImpl(status)==>" + (Object)((Object)ssResSetImpl.getOverallStatus())));
            Trace.out((String)("ssResSetImpl(hasNodeValues)==>" + ssResSetImpl.hasNodeResults()));
        }
        return ssResSetImpl;
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean OCRorVDisk) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + "OCRorVDisk=" + OCRorVDisk));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, true, OCRorVDisk, OracleFileType.RAC_OCR_VDISK);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, false, false);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean spDev, boolean OCRorVDisk) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " spDev=" + spDev + " OCRorVDisk=" + OCRorVDisk));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        return this.checkSharedStorageAccessibility(nodeList, path, spDev, OCRorVDisk, OracleFileType.RAC_DATA_FILES);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, OracleFileType fileType) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " fileType=" + (Object)((Object)fileType)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        boolean ocrOrVdisk = fileType.equals((Object)OracleFileType.RAC_OCR_VDISK);
        return this.checkSharedStorageAccessibility(nodeList, path, ocrOrVdisk, ocrOrVdisk, fileType);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] nodeList, String path, boolean spDev, boolean OCRorVDisk, OracleFileType fileType) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path + " spDev=" + spDev + " OCRorVDisk=" + OCRorVDisk));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            SharedStorageResultSetImpl ssConResSet = new SharedStorageResultSetImpl();
            ssConResSet.uploadResultSet(setupResultSet);
            return ssConResSet;
        }
        TaskSharedStorageAccess ssaTask = new TaskSharedStorageAccess(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        ssaTask.setStorageID(path);
        ssaTask.setOracleFileType(fileType);
        if (spDev) {
            if (OCRorVDisk) {
                ssaTask.setOCRLocationFlag(true);
            } else {
                ssaTask.setVDiskLocationFlag(true);
            }
        }
        try {
            resultSet = ssaTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isTraceEnabled()) {
            this.traceTaskResultSet(ssaTask, resultSet);
        }
        return resultSet;
    }

    public SharedStorageResultSet checkSharedStorageAccessibility(String[] hubList, String[] autoList, int targetHubSize) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((int)5, (String)"Method Entry. hubList=%s, autoList=%s, targetHubSize=%s", (Object[])new Object[]{VerificationUtil.strArr2List(hubList), VerificationUtil.strArr2List(autoList), targetHubSize});
        }
        Assert.assertTargetHubSize(targetHubSize);
        if (hubList != null && hubList.length != 0) {
            hubList = VerificationUtil.getNodenamesInLowerCase(hubList);
        }
        if (autoList != null && autoList.length != 0) {
            autoList = VerificationUtil.getNodenamesInLowerCase(autoList);
        }
        NodeListUtil.resetNodeInfo();
        NodeListUtil.setHubNodelist(hubList);
        NodeListUtil.setAutoNodelist(autoList);
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(hubList, null, autoList, targetHubSize);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return this.checkSharedStorageAccessibility(NodeListUtil.getAllHubAutoNodes(), OracleFileType.ASM);
    }

    public VerificationResultSet checkSharedStorageAccessibility(String[] hubList, String[] autoList, int targetHubSize, String path) throws VerificationException, InvalidPathException {
        VerificationResultSet resultSet;
        if (Trace.isTraceEnabled()) {
            Trace.out((int)5, (String)"Method Entry. hubList=%s, autoList=%s, targetHubSize=%s, path=%s", (Object[])new Object[]{VerificationUtil.strArr2List(hubList), VerificationUtil.strArr2List(autoList), targetHubSize, path});
        }
        if (hubList != null && hubList.length != 0) {
            hubList = VerificationUtil.getNodenamesInLowerCase(hubList);
        }
        if (autoList != null && autoList.length != 0) {
            autoList = VerificationUtil.getNodenamesInLowerCase(autoList);
        }
        NodeListUtil.resetNodeInfo();
        NodeListUtil.setHubNodelist(hubList);
        NodeListUtil.setAutoNodelist(autoList);
        Assert.assertTargetHubSize(targetHubSize);
        Assert.assertPath(path);
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nmf.getNodeManager(hubList, null, autoList, targetHubSize);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(NodeListUtil.getAllHubAutoNodes());
        if (!setupResultSet.anySuccess()) {
            SharedStorageResultSetImpl ssConResSet = new SharedStorageResultSetImpl();
            ssConResSet.uploadResultSet(setupResultSet);
            return ssConResSet;
        }
        TaskSharedStorageAccess ssaTask = new TaskSharedStorageAccess(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        ssaTask.setStorageID(path);
        ssaTask.setOracleFileType(OracleFileType.ASM);
        try {
            resultSet = ssaTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isTraceEnabled()) {
            this.traceTaskResultSet(ssaTask, resultSet);
        }
        Map<String, VerificationResultSet> checkResulSetMap = ssaTask.getSharednessCheckResultSet();
        return checkResulSetMap.get(path);
    }

    public VerificationResult checkPhysicalMemory(long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPhysicalMemory(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPhysicalMemory(String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        return this.checkPhysicalMemory(false, nodeList, size, unit);
    }

    private VerificationResultSet checkPhysicalMemory(boolean localNode, String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize reqdPhyMem = new StorageSize((double)size, unit);
        TaskPhysicalMemory phyMemTask = new TaskPhysicalMemory(reqdPhyMem);
        phyMemTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("required physical memory = " + reqdPhyMem));
        }
        try {
            resultSet = phyMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(phyMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAvailableMemory(long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAvailableMemory(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAvailableMemory(String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        return this.checkAvailableMemory(false, nodeList, size, unit);
    }

    private VerificationResultSet checkAvailableMemory(boolean localNode, String[] nodeList, long size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize avlMem = new StorageSize((double)size, unit);
        TaskAvailableMemory availMemTask = new TaskAvailableMemory(avlMem);
        availMemTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("sizeInBytes(" + size + "," + (Object)((Object)unit) + ")=" + VerificationUtil.sizeInBytes(size, unit)));
        }
        try {
            resultSet = availMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(availMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkRunlevel(int runlevel) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. runLevel=" + runlevel));
        }
        Assert.assertRunlevel(runlevel);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ArrayList<Integer> runLevels = new ArrayList<Integer>();
        runLevels.add(runlevel);
        VerificationResultSet resultSet = this.checkRunlevel(true, nodeList, runLevels);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkRunlevel(String[] nodeList, int runlevel) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " runLevel=" + runlevel));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertRunlevel(runlevel);
        ArrayList<Integer> runLevels = new ArrayList<Integer>();
        runLevels.add(runlevel);
        return this.checkRunlevel(false, nodeList, runLevels);
    }

    public VerificationResult checkRunlevel(List<Integer> runLevels) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. runLevels=" + VerificationUtil.strCollection2String(runLevels)));
        }
        Assert.assertRunlevels(runLevels);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkRunlevel(true, nodeList, runLevels);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkRunlevel(String[] nodeList, List<Integer> runLevels) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " runLevels=" + VerificationUtil.strCollection2String(runLevels)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertRunlevels(runLevels);
        return this.checkRunlevel(false, nodeList, runLevels);
    }

    private VerificationResultSet checkRunlevel(boolean localNode, String[] nodeList, List<Integer> runLevels) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList = Assert.assertAndConvertNodesToLower(nodeList));
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskRunLevel runLevelTask = new TaskRunLevel(runLevels);
        runLevelTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Expected RunLevel: " + VerificationUtil.strCollection2String(runLevels)));
        }
        try {
            resultSet = runLevelTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(runLevelTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkSwapSize(double size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. size=" + size + " unit=" + (Object)((Object)unit)));
        }
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkSwapSize(true, nodeList, size, unit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkSwapSize(String[] nodeList, double size, StorageUnit unit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " size=" + size + " unit=" + (Object)((Object)unit)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertSize(size);
        Assert.assertStorageUnit(unit);
        return this.checkSwapSize(false, nodeList, size, unit);
    }

    private VerificationResultSet checkSwapSize(boolean localNode, String[] nodeList, double size, StorageUnit unit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        StorageSize swapSize = new StorageSize(size, unit);
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("require swap size = " + swapSize));
        }
        TaskSwapSize swapTask = new TaskSwapSize(swapSize);
        swapTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = swapTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(swapTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkProcAlive(String proc) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. proc=" + proc));
        }
        Assert.assertProc(proc);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkProcAlive(true, nodeList, proc);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkProcAlive(String[] nodeList, String proc) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " proc=" + proc));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertProc(proc);
        return this.checkProcAlive(false, nodeList, proc);
    }

    private VerificationResultSet checkProcAlive(boolean localNode, String[] nodeList, String proc) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskProcessAlive procAliveTask = new TaskProcessAlive(proc);
        procAliveTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Process Alive: " + proc));
        }
        try {
            resultSet = procAliveTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(procAliveTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkPackage(String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val=" + val));
        }
        Assert.assertName(name);
        Assert.assertVal(val);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPackage(true, nodeList, name, val, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPackage(String[] nodeList, String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertName(name);
        Assert.assertVal(val);
        return this.checkPackage(false, nodeList, name, val, null);
    }

    public VerificationResult checkPackage(String name, String val, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val=" + val + " arch=" + arch));
        }
        Assert.assertName(name);
        Assert.assertVal(val);
        Assert.assertArch(arch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkPackage(true, nodeList, name, val, arch);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkPackage(String[] nodeList, String name, String val, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val + " arch=" + arch));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertName(name);
        Assert.assertVal(val);
        Assert.assertArch(arch);
        return this.checkPackage(false, nodeList, name, val, arch);
    }

    private VerificationResultSet checkPackage(boolean localNode, String[] nodeList, String name, String val, String arch) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskPackage pkgTask = new TaskPackage(name, val, arch);
        pkgTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = pkgTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(pkgTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkArchitecture(String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. arch=" + arch));
        }
        Assert.assertArch(arch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkArchitecture(true, nodeList, Arrays.asList(arch));
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkArchitecture(String[] nodeList, String arch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " arch=" + arch));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertArch(arch);
        return this.checkArchitecture(false, nodeList, Arrays.asList(arch));
    }

    public VerificationResult checkArchitecture(List<String> archList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. archList=" + VerificationUtil.strCollection2String(archList)));
        }
        Assert.assertArchs(archList);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkArchitecture(true, nodeList, archList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkArchitecture(String[] nodeList, List<String> archList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " archList=" + VerificationUtil.strCollection2String(archList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertArchs(archList);
        return this.checkArchitecture(false, nodeList, archList);
    }

    private VerificationResultSet checkArchitecture(boolean localNode, String[] nodeList, List<String> archList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskArchitecture archTask = new TaskArchitecture(archList);
        archTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = archTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(archTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkUserExistence(String user) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. user=" + user));
        }
        Assert.assertUser(user);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserExistence(true, nodeList, user);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserExistence(String[] nodeList, String user) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " user=" + user));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertUser(user);
        return this.checkUserExistence(false, nodeList, user);
    }

    private VerificationResultSet checkUserExistence(boolean localNode, String[] nodeList, String user) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskUserExistence userTask = TaskUserExistence.generate(user, setupResultSet.getSuccessfulNodes().toArray(new String[0]), false);
        try {
            resultSet = userTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(userTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkGroupExistence(String group) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. group=" + group));
        }
        Assert.assertGroup(group);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkGroupExistence(true, nodeList, group);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkGroupExistence(String[] nodeList, String group) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " group=" + group));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertGroup(group);
        return this.checkGroupExistence(false, nodeList, group);
    }

    private VerificationResultSet checkGroupExistence(boolean localNode, String[] nodeList, String group) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskGroupExistence groupTask = TaskGroupExistence.generate(group, setupResultSet.getSuccessfulNodes().toArray(new String[0]), false);
        try {
            resultSet = groupTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(groupTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkGroupMembership(String user, String group, boolean primary) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. user=" + user + " group=" + group + " primary=" + primary));
        }
        Assert.assertUser(user);
        Assert.assertGroup(group);
        Assert.assertPrimaryGroup(primary);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkGroupMembership(true, nodeList, user, group, primary);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkGroupMembership(String[] nodeList, String user, String group, boolean primary) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " user=" + user + " group=" + group + " primary=" + primary));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertUser(user);
        Assert.assertGroup(group);
        Assert.assertPrimaryGroup(primary);
        return this.checkGroupMembership(false, nodeList, user, group, primary);
    }

    private VerificationResultSet checkGroupMembership(boolean localNode, String[] nodeList, String user, String group, boolean primary) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskGroupMembership grpMemTask = TaskGroupMembership.generate(user, group, primary, setupResultSet.getSuccessfulNodes().toArray(new String[0]), false);
        try {
            resultSet = grpMemTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(grpMemTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResultSet checkTZConsistency(String[] nodeList, int tasktype) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(false, nodeList = Assert.assertAndConvertNodesToLower(nodeList));
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskTimeZoneSetting tz = new TaskTimeZoneSetting(nodeList);
        tz.setTaskType(tasktype);
        try {
            resultSet = tz.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(tz.getResultSet());
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(tz, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkKernelVersion(String ver) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. ver=" + ver));
        }
        Assert.assertVersion(ver);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkKernelVersion(true, nodeList, ver);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkKernelVersion(String[] nodeList, String ver) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " ver=" + ver));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertVersion(ver);
        return this.checkKernelVersion(false, nodeList, ver);
    }

    private VerificationResultSet checkKernelVersion(boolean localNode, String[] nodeList, String ver) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskKernelVersion verTask = new TaskKernelVersion(ver);
        verTask.setNodeList(nodeList);
        try {
            resultSet = verTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(verTask.getResultSet());
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(verTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkKernelParam(String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. name=" + name + " val" + val));
        }
        Assert.assertName(name);
        Assert.assertVal(val);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkKernelParam(true, nodeList, name, val);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkKernelParam(String[] nodeList, String name, String val) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " name=" + name + " val=" + val));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertName(name);
        Assert.assertVal(val);
        return this.checkKernelParam(false, nodeList, name, val);
    }

    private VerificationResultSet checkKernelParam(boolean localNode, String[] nodeList, String name, String val) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskKernelParam kparamTask = new TaskKernelParam(name, val);
        kparamTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = kparamTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(kparamTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkShellLimit(ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. st=" + (Object)((Object)st) + " resourceType=" + (Object)((Object)resourceType) + " limitType=" + (Object)((Object)limitType) + " limit=" + limit));
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkShellLimit(true, nodeList, st, resourceType, limitType, limit);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkShellLimit(String[] nodeList, ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " st=" + (Object)((Object)st) + " resourceType=" + (Object)((Object)resourceType) + " limitType=" + (Object)((Object)limitType) + " limit=" + limit));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkShellLimit(false, nodeList, st, resourceType, limitType, limit);
    }

    private VerificationResultSet checkShellLimit(boolean localNode, String[] nodeList, ShellType st, ShellResourceType resourceType, ShellLimitType limitType, long limit) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskShellLimits task = new TaskShellLimits(setupResultSet.getSuccessfulNodes().toArray(new String[0]), st, resourceType, limitType, limit);
        try {
            resultSet = task.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(task, resultSet);
        }
        return resultSet;
    }

    public CollectionResultSet<List<VerificationFileInfo>> checkSoftwareHome(String[] nodeList, SoftwareComponentType component, String componentHome, boolean allFiles) throws InvalidPathException, VerificationException {
        CollectionResultSet<List<VerificationFileInfo>> collRsetCheck;
        ResultSet resultSet;
        CollectionResultSetImpl collRsetSetup = new CollectionResultSetImpl();
        String[] versionTokens = null;
        String releaseVersion = null;
        String softwareComponent = null;
        String componentReleaseVersion = null;
        VerificationUtil.traceAndLog("componentHome [" + componentHome + "]");
        Assert.assertPath(componentHome);
        Assert.assertNodes(nodeList);
        Assert.assertSoftwareComponentType(component);
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            collRsetSetup.uploadResultSet(setupResultSet);
            return collRsetSetup;
        }
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        releaseVersion = VerificationUtil.getCRSReleaseVersion(componentHome, false);
        componentReleaseVersion = releaseVersion;
        versionTokens = componentReleaseVersion.split("\\.");
        if (versionTokens != null) {
            componentReleaseVersion = versionTokens[0] + "." + versionTokens[1];
        }
        if (!VerificationUtil.isStringGood(releaseVersion) && !VerificationUtil.isStringGood(componentReleaseVersion = VerificationUtil.getConfiguredValue("CV_ORACLE_RELEASE", false))) {
            componentReleaseVersion = "12.2";
        }
        VerificationUtil.traceAndLog("validNodes[" + nodeList + "] " + "component[" + softwareComponent + "] " + "releaseVersion[" + componentReleaseVersion + "] " + "allFiles[" + allFiles + "]");
        TaskSoftwareDistribution taskSwDist = new TaskSoftwareDistribution(validNodes);
        taskSwDist.setSoftwareComponent(component.toString().toLowerCase());
        taskSwDist.setSoftwareComponentHome(componentHome);
        taskSwDist.setRelease(componentReleaseVersion);
        taskSwDist.setAll(allFiles);
        try {
            resultSet = (ResultSet)taskSwDist.verify();
            collRsetCheck = taskSwDist.getFileInfoResultSet();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        resultSet.uploadResultSet(setupResultSet);
        this.traceTaskResultSet(taskSwDist, resultSet);
        return collRsetCheck;
    }

    public CollectionResultSet checkSoftwareHome(String[] nodeList, String componentHome, boolean allFiles) throws InvalidPathException, VerificationException {
        boolean haConfigured;
        Assert.assertPath(componentHome);
        Assert.assertNodes(nodeList);
        SoftwareComponentType component = null;
        List<String> componentsCompsXml = null;
        try {
            CompsXMLParser compsParser = new CompsXMLParser(componentHome);
            componentsCompsXml = compsParser.parse();
        }
        catch (CompSoftwareConfigLoaderException csle) {
            throw new VerificationException(csle);
        }
        component = componentsCompsXml.contains("oracle.crs") ? ((haConfigured = VerificationUtil.isHAConfigured()) ? SoftwareComponentType.HA : SoftwareComponentType.CRS) : SoftwareComponentType.DATABASE;
        return this.checkSoftwareHome(nodeList, component, componentHome, allFiles);
    }

    public void setVariableValue(String varName, String varValue) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            String varTrcValue = varValue;
            if (varName != null && VerificationUtil.PASSWORD_VAR_NAME_PATTERN.matcher(varName).matches()) {
                varTrcValue = "*****";
            }
            Trace.out((String)("Method Entry. varName=" + varName + " varValue=" + varTrcValue));
        }
        Assert.assertName(varName);
        Assert.assertVal(varValue);
        m_variablesSetInSession.add(varName);
        CVUVariables.setValue(varName, varValue);
    }

    public void clearVariableValue(String varName) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. varName=" + varName));
        }
        Assert.assertName(varName);
        CVUVariables.clear(varName);
    }

    public void clearVariablesInSession() throws VerificationException {
        Trace.out((String)"All variables in this session are being cleared");
        for (String varName : m_variablesSetInSession) {
            this.clearVariableValue(varName);
        }
        m_variablesSetInSession.clear();
    }

    public void setConditionValue(String condition, boolean value) throws VerificationException {
        Trace.out((String)("Method Entry. condition=" + condition));
        Assert.assertName(condition);
        this.setVariableValue(condition, Boolean.toString(value));
    }

    public void clearConditionValue(String condition) throws VerificationException {
        Trace.out((String)("Method Entry. condition=" + condition));
        Assert.assertName(condition);
        CVUVariables.clear(condition);
    }

    public VerificationResult checkCRSIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkCRSIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkCRSIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkCRSIntegrity(false, nodeList);
    }

    private VerificationResultSet checkCRSIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskCRSIntegrity taskCRSI = new TaskCRSIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskCRSI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskCRSI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkUserEquiv() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserEquiv(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserEquiv(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkUserEquiv(false, nodeList, null);
    }

    public VerificationResult checkUserEquiv(EnumSet<UserEquivCheckType> checkType) throws VerificationException, UnsupportedOperationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. checkType=" + checkType));
        }
        Assert.assertCheckType(checkType);
        Assert.assertUnixPlatform();
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkUserEquiv(true, nodeList, checkType);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkUserEquiv(String[] nodeList, EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " checkType=" + checkType));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertCheckType(checkType);
        Assert.assertUnixPlatform();
        return this.checkUserEquiv(false, nodeList, checkType);
    }

    private VerificationResultSet checkUserEquiv(boolean localNode, String[] nodeList, EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        return this.checkUserEquiv(localNode, nodeList, checkType, false);
    }

    public VerificationResultSet checkUserEquivalenceCluster(String[] nodeList, EnumSet<UserEquivCheckType> checkType) throws VerificationException {
        ResultSet setupResultSet = (ResultSet)this.assertFrameworkSetup(nodeList);
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(validNodes)));
        VerificationResultSet userEquivRS = this.checkUserEquiv(false, validNodes, checkType, true);
        ((ResultSet)userEquivRS).addResultSetData(setupResultSet);
        return userEquivRS;
    }

    private VerificationResultSet checkUserEquiv(boolean localNode, String[] nodeList, EnumSet<UserEquivCheckType> checkType, boolean isStarUserEquivalence) throws VerificationException {
        VerificationResultSet resultSet;
        this.createNodeManager(nodeList);
        TaskUserEquivalence taskAP = new TaskUserEquivalence(nodeList);
        if (checkType != null) {
            taskAP.setUserEquivCheckTypeSet(checkType);
        }
        taskAP.setCheckStarEquivalence(isStarUserEquivalence);
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivCRSInst() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, null, null, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkAdminPrivCRSInst(false, nodeList, null, null, null);
    }

    public VerificationResult checkAdminPrivCRSInst(String oraInvGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oraInvGroup=" + oraInvGroup));
        }
        Assert.assertGroup(oraInvGroup);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, oraInvGroup, null, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResult checkAdminPrivCRSInst(String oraInvGroup, String asmAdminGrp) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oraInvGroup=" + oraInvGroup));
        }
        Assert.assertGroup(oraInvGroup);
        Assert.assertGroup(asmAdminGrp);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, oraInvGroup, asmAdminGrp, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResult checkAdminPrivCRSInst(String oraInvGroup, String asmAdminGrp, String asmDbaGrp) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oraInvGroup=" + oraInvGroup));
        }
        Assert.assertGroup(oraInvGroup);
        Assert.assertGroup(asmAdminGrp);
        Assert.assertGroup(asmDbaGrp);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivCRSInst(true, nodeList, oraInvGroup, asmAdminGrp, asmDbaGrp);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList, String oraInvGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oraInvGroup=" + oraInvGroup));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertGroup(oraInvGroup);
        return this.checkAdminPrivCRSInst(false, nodeList, oraInvGroup, null, null);
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList, String oraInvGroup, String asmAdminGrp) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oraInvGroup=" + oraInvGroup));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertGroup(oraInvGroup);
        Assert.assertGroup(asmAdminGrp);
        return this.checkAdminPrivCRSInst(false, nodeList, oraInvGroup, asmAdminGrp, null);
    }

    public VerificationResultSet checkAdminPrivCRSInst(String[] nodeList, String oraInvGroup, String asmAdminGrp, String asmDbaGrp) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oraInvGroup=" + oraInvGroup));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertGroup(oraInvGroup);
        Assert.assertGroup(asmAdminGrp);
        Assert.assertGroup(asmDbaGrp);
        return this.checkAdminPrivCRSInst(false, nodeList, oraInvGroup, asmAdminGrp, asmDbaGrp);
    }

    private VerificationResultSet checkAdminPrivCRSInst(boolean localNode, String[] nodeList, String oraInvGroup, String asmAdminGrp, String asmDbaGrp) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "crs_inst");
        if (VerificationUtil.isStringGood(oraInvGroup)) {
            taskAP.setOraInv(oraInvGroup);
        }
        if (VerificationUtil.isStringGood(asmAdminGrp)) {
            taskAP.setASMADMIN(asmAdminGrp);
        }
        if (VerificationUtil.isStringGood(asmDbaGrp)) {
            taskAP.setASMDBA(asmDbaGrp);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivDBInst() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBInst(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBInst(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkAdminPrivDBInst(false, nodeList, null);
    }

    public VerificationResult checkAdminPrivDBInst(String osdbaGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osdbaGroup=" + osdbaGroup));
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBInst(true, nodeList, osdbaGroup);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBInst(String[] nodeList, String osdbaGroup) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkAdminPrivDBInst(false, nodeList, osdbaGroup);
    }

    private VerificationResultSet checkAdminPrivDBInst(boolean localNode, String[] nodeList, String osdbaGroup) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "db_inst");
        if (osdbaGroup != null) {
            taskAP.setOSDBA(osdbaGroup);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkAdminPrivDBConfig() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBConfig(true, nodeList, null);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBConfig(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkAdminPrivDBConfig(false, nodeList, null);
    }

    public VerificationResult checkAdminPrivDBConfig(String oracleHome) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. oracleHome=" + oracleHome));
        }
        Assert.assertOracleHomeForCmdExec(oracleHome);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkAdminPrivDBConfig(true, nodeList, oracleHome);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkAdminPrivDBConfig(String[] nodeList, String oracleHome) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " oracleHome=" + oracleHome));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertOracleHomeForCmdExec(oracleHome);
        return this.checkAdminPrivDBConfig(false, nodeList, oracleHome);
    }

    private VerificationResultSet checkAdminPrivDBConfig(boolean localNode, String[] nodeList, String oracleHome) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskAdminPrivileges taskAP = new TaskAdminPrivileges(setupResultSet.getSuccessfulNodes().toArray(new String[0]), "db_config");
        if (oracleHome != null) {
            taskAP.setOracleHome(oracleHome);
        }
        try {
            resultSet = taskAP.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskAP, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkCFSIntegrity(String fileSystem) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. fileSystem=" + fileSystem));
        }
        Assert.assertPath(fileSystem);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkCFSIntegrity(true, nodeList, fileSystem);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkCFSIntegrity(String[] nodeList, String fileSystem) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " fileSystem=" + fileSystem));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(fileSystem);
        return this.checkCFSIntegrity(false, nodeList, fileSystem);
    }

    private VerificationResultSet checkCFSIntegrity(boolean localNode, String[] nodeList, String fileSystem) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskCFSIntegrity taskCFSI = new TaskCFSIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]), fileSystem);
        try {
            resultSet = taskCFSI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskCFSI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkClusterManagerIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry.");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkClusterMgrIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkClusterMgrIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkClusterMgrIntegrity(false, nodeList);
    }

    private VerificationResultSet checkClusterMgrIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskClusterMgrIntegrity taskClusterMgrI = new TaskClusterMgrIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskClusterMgrI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskClusterMgrI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkNodeApp() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkNodeApp(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkNodeApp(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkNodeApp(false, nodeList);
    }

    private VerificationResultSet checkNodeApp(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskNodeAppCreation taskNodeApp = new TaskNodeAppCreation(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskNodeApp.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskNodeApp, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkClusterIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkClusterIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkClusterIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkClusterIntegrity(false, nodeList);
    }

    private VerificationResultSet checkClusterIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskClusterIntegrity taskClusterI = new TaskClusterIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskClusterI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskClusterI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkOCRIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOCRIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOCRIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkOCRIntegrity(false, nodeList);
    }

    private VerificationResultSet checkOCRIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskOCRIntegrity taskOCRI = new TaskOCRIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskOCRI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskOCRI, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkOLRIntegrity() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOLRIntegrity(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOLRIntegrity(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkOLRIntegrity(false, nodeList);
    }

    private VerificationResultSet checkOLRIntegrity(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskOLRIntegrity taskOLRI = new TaskOLRIntegrity(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = taskOLRI.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(taskOLRI, resultSet);
        }
        return resultSet;
    }

    String getLocalNode() throws VerificationException {
        String localNode = VerificationUtil.getLocalNode();
        return Assert.assertAndConvertNodeToLower(localNode);
    }

    private static String getDefaultFrameworkHome() throws VerificationException {
        String giHome = null;
        if (VerificationUtil.isCRSConfigured()) {
            giHome = VerificationUtil.getCRSHome();
        } else if (VerificationUtil.isHAConfigured()) {
            giHome = VerificationUtil.getHAHome();
        }
        if (giHome == null) {
            throw new VerificationException(s_msgBundle.getMessage("7523", false));
        }
        return giHome;
    }

    private static String getDefaultWorkDir() throws VerificationException {
        return System.getProperty("java.io.tmpdir");
    }

    public VerificationResultSet checkFrameworkSetup() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        String localNode = this.getLocalNode();
        VerificationUtil.setLocalNodeOperation(true);
        return this.checkFrameworkSetup(true, new String[]{localNode});
    }

    public VerificationResultSet checkFrameworkSetup(String[] nodeList) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        }
        return this.checkFrameworkSetup((nodeList = Assert.assertAndConvertNodesToLower(nodeList)).length > 1 ? false : m_localHost.equalsIgnoreCase(nodeList[0]), nodeList);
    }

    private VerificationResultSet checkFrameworkSetup(boolean localNode, String[] nodeList) throws VerificationException {
        VerificationUtil.setLocalNodeOperation(localNode);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Trace.out((String)"creating NodeManager");
        this.createNodeManager(nodeList);
        return this.verifyFrameworkSetup(nodeList);
    }

    private VerificationResultSet checkFrameworkSetup(boolean localNode, String[] nodeList, boolean bCreateNodeManager) throws VerificationException {
        VerificationUtil.setLocalNodeOperation(localNode);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        if (bCreateNodeManager) {
            Trace.out((String)"creating NodeManager");
            this.createNodeManager(nodeList);
        }
        return this.verifyFrameworkSetup(nodeList);
    }

    public FixupResultSet setupSSHUserEquivalence(String[] nodeList, String user, String password) throws VerificationException, FixupException {
        return this.setupSSHUserEquivalence(nodeList, user, password, 0);
    }

    public FixupResultSet setupSSHUserEquivalenceUsingSudo(String[] nodeList, String sudoUser, String sudoPassword, String sudoLocation, String forUser) throws VerificationException, FixupException {
        return this.setupSSHUserEquivalenceUsingSudo(nodeList, sudoUser, sudoPassword, sudoLocation, forUser, 0);
    }

    public FixupResultSet setupSSHUserEquivalenceUsingRoot(String[] nodeList, String rootPassword, String forUser) throws VerificationException, FixupException {
        return this.setupSSHUserEquivalenceUsingRoot(nodeList, rootPassword, forUser, 0);
    }

    public FixupResultSet setupSSHUserEquivalenceUsingSudo(String[] nodeList, String sudoUser, String sudoPassword, String sudoLocation, String forUser, int timeOutInSeconds) throws VerificationException, FixupException {
        Assert.assertUnixPlatform();
        Assert.assertNodes(nodeList);
        Assert.assertUser(sudoUser);
        Assert.assertUser(forUser);
        Assert.assertPassword(sudoPassword);
        this.checkFrameworkSetup();
        if (!VerificationUtil.isStringGood(sudoLocation)) {
            sudoLocation = VerificationUtil.getSudoPbrunLocationFromConfigFile(ConfigurationSetup.ConfigMethod.SUDO);
        }
        RemoteUserInfo sudoCredentials = new RemoteUserInfo(sudoUser, sudoPassword, sudoLocation);
        SetupSSHUserEquivalence userEqFixup = new SetupSSHUserEquivalence(Arrays.asList(nodeList), sudoCredentials, forUser);
        if (timeOutInSeconds > 0) {
            userEqFixup.setMaximumCommandTimeOut(timeOutInSeconds);
        }
        return userEqFixup.performSetup();
    }

    public FixupResultSet setupSSHUserEquivalenceUsingRoot(String[] nodeList, String rootPassword, String forUser, int timeOutInSeconds) throws VerificationException, FixupException {
        Assert.assertUnixPlatform();
        Assert.assertNodes(nodeList);
        Assert.assertUser(forUser);
        Assert.assertPassword(rootPassword);
        this.checkFrameworkSetup();
        SetupSSHUserEquivalence userEqFixup = new SetupSSHUserEquivalence(Arrays.asList(nodeList), new RemoteUserInfo(rootPassword), forUser);
        if (timeOutInSeconds > 0) {
            userEqFixup.setMaximumCommandTimeOut(timeOutInSeconds);
        }
        return userEqFixup.performSetup();
    }

    public FixupResultSet setupSSHUserEquivalence(String[] nodeList, String user, String password, int timeOutInSeconds) throws VerificationException, FixupException {
        Assert.assertUnixPlatform();
        Assert.assertNodes(nodeList);
        Assert.assertUser(user);
        Assert.assertPassword(password);
        this.checkFrameworkSetup();
        SetupSSHUserEquivalence userEqFixup = new SetupSSHUserEquivalence(Arrays.asList(nodeList), new UserInfo(user, password));
        if (timeOutInSeconds > 0) {
            userEqFixup.setMaximumCommandTimeOut(timeOutInSeconds);
        }
        return userEqFixup.performSetup();
    }

    public void setDefaultFixupRequirement(boolean fixupReqd) {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. fixupReqd=" + fixupReqd));
        }
        FixupUtility.setDefaultFixupRequirement(fixupReqd);
    }

    public List<VerificationTask> getFixupTaskList() {
        return FixupUtility.getFixableTaskList();
    }

    public void executeFixupsAutomated() throws RootAutomationException, FixupException {
        Trace.out((String)"ENTRY");
        Assert.assertFixupDriver(this.m_fixUpDriver);
        this.m_fixUpDriver.fixAutomatically();
        CVUFixup.destroy();
        VerificationLogData.logInfo("Destroyed the instance of fixup driver");
        this.m_fixUpDriver = null;
        Trace.out((String)"EXIT");
    }

    public void executeFixupsManual() throws FixupException {
        Trace.out((String)"ENTRY");
        Assert.assertFixupDriver(this.m_fixUpDriver);
        this.m_fixUpDriver.fixManually();
        CVUFixup.destroy();
        VerificationLogData.logInfo("Destroyed the instance of fixup driver");
        this.m_fixUpDriver = null;
        Trace.out((String)"EXIT");
    }

    public void setupFixups(List<VerificationTask> listOfFixableTasks) throws FixupException {
        Trace.out((String)"ENTRY");
        CVUFixup.destroy();
        this.m_fixUpDriver = null;
        VerificationLogData.logInfo("Destroyed the existing instance of fixup driver (if it was already instantiated), Creating new instance with this setup.");
        this.m_fixUpDriver = CVUFixup.getInstance(listOfFixableTasks);
        try {
            String[] fixableNodes = this.m_fixUpDriver.getFixableNodes().toArray(new String[0]);
            if (fixableNodes.length > 0) {
                this.assertFrameworkSetup(fixableNodes);
            }
        }
        catch (VerificationException e) {
            throw new FixupException(e.getMessage());
        }
        this.m_fixUpDriver.setUp();
        Trace.out((String)"EXIT");
    }

    public FixupManualInstruction getManualFixupInstruction() throws FixupException {
        Assert.assertFixupDriver(this.m_fixUpDriver);
        return FixupUtility.getManualFixupInstruction(this.m_fixUpDriver);
    }

    private VerificationResultSet verifyFrameworkSetup(String[] nodeList) throws VerificationException {
        String crsenv = VerificationUtil.getEnv(CRSHOME);
        if (!VerificationUtil.isCVUTestEnv() && crsenv != null && crsenv.length() > 0) {
            throw new VerificationException(s_gMsgBundle.getMessage("1561", true));
        }
        CVUVariables.initialize();
        return VerificationUtil.verifyFrameworkSetup(nodeList);
    }

    public boolean checkPlatformArchitecture() throws VerificationException {
        Trace.out((String)"Method Entry");
        String osname = VerificationUtil.getCurrentOS();
        String osarch = VerificationUtil.getCurrentArch();
        return this.checkPlatformArchitecture(osname, osarch);
    }

    public boolean checkPlatformArchitecture(String osname, String osarch) throws VerificationException {
        Trace.out((String)("Method Entry. osname=" + osname + " osarch=" + osarch));
        Assert.assertName(osname);
        Assert.assertArch(osarch);
        return VerificationUtil.checkPlatform(osname, osarch);
    }

    public boolean checkPlatformOS() throws VerificationException {
        Trace.out((String)"Method Entry");
        String osname = VerificationUtil.getCurrentOS();
        return this.checkPlatformOS(osname);
    }

    public boolean checkPlatformOS(String osname) throws VerificationException {
        Trace.out((String)("Method Entry. osname=" + osname));
        Assert.assertName(osname);
        return VerificationUtil.checkPlatformOS(osname);
    }

    public VerificationResult checkOSPatch(String osPatch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. osPatch=" + osPatch));
        }
        Assert.assertOSPatch(osPatch);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkOSPatch(true, nodeList, osPatch);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkOSPatch(String[] nodeList, String osPatch) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " osPatch=" + osPatch));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertOSPatch(osPatch);
        return this.checkOSPatch(false, nodeList, osPatch);
    }

    private VerificationResultSet checkOSPatch(boolean localNode, String[] nodeList, String osPatch) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskOSPatch osPatchTask = new TaskOSPatch(osPatch);
        osPatchTask.setNodeList(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        try {
            resultSet = osPatchTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(osPatchTask, resultSet);
        }
        return resultSet;
    }

    public void setPreReqXmlFile(PreReqType prereqType, String xmlFile) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. prereqType=" + (Object)((Object)prereqType) + " xmlFile=" + xmlFile));
        }
        Assert.assertPath(xmlFile);
        VerificationUtil.setPreReqXmlFile(prereqType.getVerificationType(), xmlFile);
    }

    public void setPreReqXmlFile(String xmlFile) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. xmlFile=" + xmlFile));
        }
        Assert.assertPath(xmlFile);
        VerificationUtil.setPreReqXmlFile(xmlFile);
    }

    public List<String> checkSharedFileSystemPath(String pathName, String[] nodeList) throws VerificationException, InvalidPathException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(pathName);
        ClusterwareInfo clustInfo = new ClusterwareInfo();
        Result result = new Result(m_localHost);
        String crsHome = VerificationUtil.getCRSHome(m_localHost, result);
        try {
            return clustInfo.checkSharedFileSystemPath(pathName, m_localHost, nodeList, crsHome);
        }
        catch (InvalidNodeListException inle) {
            Trace.out((String)("Caught InvalidNodeListException : error is " + inle.getMessage()));
            throw new VerificationException(inle);
        }
        catch (SharedDeviceException sde) {
            Trace.out((String)("Caught SharedDeviceException : error is " + sde.getMessage()));
            throw new VerificationException(sde);
        }
        catch (InstallException ie) {
            String errMsg = ie.getMessage();
            Trace.out((String)("Caught InstallException : error is " + errMsg));
            NativeSystem nativeSys = new SystemFactory().CreateSystem();
            String activeVersion = VerificationUtil.getCRSActiveVersion();
            if (!nativeSys.isUnixSystem() && activeVersion != null && activeVersion.startsWith("11.2.0.2")) {
                Trace.out((String)"Windows NT 11.2.0.2, checking exception message");
                if (errMsg.indexOf("CLSU-00100") != -1 && errMsg.indexOf("CLSU-00103") != -1 && errMsg.indexOf("CLSU-00101") != -1 && errMsg.indexOf("ACFS-00513") != -1) {
                    Trace.out((String)"ignoring ie");
                    return new ArrayList<String>();
                }
            }
            throw new VerificationException(ie);
        }
    }

    public boolean isPreReqSupported() throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        this.checkFrameworkSetup();
        this.createNodeManager(PreReqType.PREREQ_CRS_INST);
        return VerificationUtil.isPreReqSupported();
    }

    public boolean isPreReqSupported(PreReqType prereqType) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. prereqType=" + (Object)((Object)prereqType)));
        }
        this.createNodeManager(prereqType);
        this.checkFrameworkSetup();
        return VerificationUtil.isPreReqSupported(prereqType.getVerificationType());
    }

    public VerificationResult getCRSUser(String node) throws VerificationException, UnsupportedOperationException {
        boolean crsConfigured;
        ErrorDescription errDesc;
        Result result;
        block7: {
            if (Trace.isTraceEnabled()) {
                Trace.out((String)("Method Entry. node =" + node));
            }
            Assert.assertUnixPlatform();
            node = Assert.assertAndConvertNodeToLower(node);
            this.assertFrameworkSetup(new String[]{node});
            result = new Result(node);
            errDesc = null;
            ClusterwareInfo clustInfo = new ClusterwareInfo();
            crsConfigured = false;
            try {
                crsConfigured = clustInfo.isCRSConfiguredOnNode(node);
            }
            catch (InstallException e) {
                result.setStatus(2);
                result.setHasResultValues(false);
                if (e.getMessage() == null) break block7;
                result.addErrorDescription(new ErrorDescription(e.getMessage()));
            }
        }
        if (crsConfigured) {
            String crsUser = VerificationUtil.getCRSUser(node, result, false);
            Trace.out((String)("The CRS User retrieved is: " + crsUser));
            if (crsUser != null && crsUser.trim().length() > 0 && result.getStatus() == 1) {
                result.setHasResultValues(true);
                result.setActualValue(crsUser);
                result.setExpectedValue("");
            } else {
                result.setHasResultValues(false);
                result.setStatus(2);
            }
        } else {
            Trace.out((String)("CRS Not found configured on node " + node));
            result.setHasResultValues(false);
            errDesc = new ErrorDescription(s_msgBundle.getMessage("5324", true, (Object[])new String[]{node}));
            result.addErrorDescription(errDesc);
            result.setStatus(2);
        }
        return result;
    }

    public VerificationResult getCRSUser() throws VerificationException, UnsupportedOperationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        Assert.assertUnixPlatform();
        String localNode = this.getLocalNode();
        this.checkFrameworkSetup();
        VerificationUtil.setLocalNodeOperation(true);
        return this.getCRSUser(localNode);
    }

    public VerificationResult getSIHAUser() throws VerificationException, UnsupportedOperationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)"Method Entry");
        }
        Assert.assertUnixPlatform();
        this.checkFrameworkSetup();
        String localNode = this.getLocalNode();
        Result result = new Result(localNode);
        if (VerificationUtil.isHAConfigured()) {
            String crsUser = VerificationUtil.getCRSUser(result, true);
            Trace.out((String)("The CRS User retrieved is: " + crsUser));
            if (crsUser != null && crsUser.trim().length() > 0 && result.getStatus() == 1) {
                result.setHasResultValues(true);
                result.setActualValue(crsUser);
                result.setExpectedValue("");
            } else {
                result.setHasResultValues(false);
                result.setStatus(2);
            }
        } else {
            Trace.out((String)"HA Not found configured on local node");
            result.setStatus(2);
            result.setHasResultValues(false);
            ErrorDescription errDesc = new ErrorDescription(s_msgBundle.getMessage("5318", true));
            result.addErrorDescription(errDesc);
        }
        return result;
    }

    public VerificationResult checkASMDisk(String asmDisk) throws VerificationException {
        return this.checkASMDiskList(new String[]{asmDisk});
    }

    public VerificationResult checkASMDiskList(String[] asmDiskList) throws VerificationException {
        Trace.out((String)("Method Entry. asmDiskList=" + VerificationUtil.strArr2List(asmDiskList)));
        Assert.assertASMDiskList(asmDiskList, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkASMDiskList(true, nodeList, asmDiskList, null, null, 0);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkASMDisk(String[] nodeList, String asmDisk) throws VerificationException {
        return this.checkASMDiskList(nodeList, new String[]{asmDisk});
    }

    public VerificationResultSet checkASMDiskList(String[] nodeList, String[] asmDiskList) throws VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " asmDiskList=" + VerificationUtil.strArr2List(asmDiskList)));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertASMDiskList(asmDiskList, true);
        return this.checkASMDiskList(false, nodeList, asmDiskList, null, null, 0);
    }

    public VerificationResult checkASMDisk(String asmDisk, String referenceOwner, String referenceGroup, int referencePermissions) throws VerificationException {
        return this.checkASMDiskList(new String[]{asmDisk}, referenceOwner, referenceGroup, referencePermissions);
    }

    public VerificationResult checkASMDiskList(String[] asmDiskList, String referenceOwner, String referenceGroup, int referencePermissions) throws VerificationException {
        Trace.out((String)("Method Entry. asmDisksList=" + VerificationUtil.strArr2List(asmDiskList)));
        Assert.assertASMDiskList(asmDiskList, true);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.checkASMDiskList(true, nodeList, asmDiskList, referenceOwner, referenceGroup, referencePermissions);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet checkASMDisk(String[] nodeList, String asmDisk, String referenceOwner, String referenceGroup, int referencePermissions) throws VerificationException {
        return this.checkASMDiskList(nodeList, new String[]{asmDisk}, referenceOwner, referenceGroup, referencePermissions);
    }

    public VerificationResultSet checkASMDiskGroup(String diskGroupName) throws VerificationException {
        return this.checkASMDiskGroup(diskGroupName, new String[]{m_localHost});
    }

    public StoragePathResultSet checkADVMCompatibility(List<String> acfsPathList) throws VerificationException, InvalidPathException {
        Trace.out((String)"ENTRY");
        StoragePathResultSet resSet = null;
        if (acfsPathList.isEmpty()) {
            String msg = s_gMsgBundle.getMessage("10530", true, (Object[])new String[]{"EMPTY INPUT LIST"});
            throw new VerificationException(msg);
        }
        for (String acfsPath : acfsPathList) {
            Assert.assertPath(acfsPath);
        }
        this.checkFrameworkSetup();
        try {
            resSet = StorageUtil.checkStorageADVMCompatibility(acfsPathList);
        }
        catch (StorageException e) {
            Trace.out((String)("StorageException :: " + e));
            throw new VerificationException(e);
        }
        return resSet;
    }

    public VerificationResultSet checkASMDiskGroup(String diskGroupName, String[] nodeList) throws VerificationException {
        ResultSet diskGroupRS = new ResultSet();
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertASMDiskGroup(diskGroupName, true);
        ResultSet setupResultSet = (ResultSet)this.assertFrameworkSetup(nodeList);
        try {
            Hashtable<String, Hashtable<String, List<String>>> nodeWiseDiskGroupDiskListTable = new Hashtable<String, Hashtable<String, List<String>>>();
            List<Object> diskList = new ArrayList();
            boolean result = new ASMDiskGroupsUtil().getDiskGroupsDiskMap(new String[]{m_localHost}, diskGroupRS, nodeWiseDiskGroupDiskListTable);
            if (result) {
                for (String node : nodeWiseDiskGroupDiskListTable.keySet()) {
                    Trace.out((String)("ASM Disk information on node: " + node));
                    for (String label : nodeWiseDiskGroupDiskListTable.get(node).keySet()) {
                        Trace.out((String)("The label (" + label + ") has following disks associated with it:"));
                        Trace.out(nodeWiseDiskGroupDiskListTable.get(node).get(label));
                    }
                }
                String diskGroupFiltered = null;
                diskGroupFiltered = diskGroupName.trim().startsWith("+") ? diskGroupName.trim().substring(diskGroupName.indexOf("+") + 1) : diskGroupName;
                if (VerificationUtil.isStringGood(diskGroupFiltered) && nodeWiseDiskGroupDiskListTable.containsKey(m_localHost) && (nodeWiseDiskGroupDiskListTable.get(m_localHost).containsKey(diskGroupFiltered) || nodeWiseDiskGroupDiskListTable.get(m_localHost).containsKey(diskGroupName))) {
                    if (nodeWiseDiskGroupDiskListTable.get(m_localHost).containsKey(diskGroupFiltered)) {
                        diskList = nodeWiseDiskGroupDiskListTable.get(m_localHost).get(diskGroupFiltered);
                    } else if (nodeWiseDiskGroupDiskListTable.get(m_localHost).containsKey(diskGroupName)) {
                        diskList = nodeWiseDiskGroupDiskListTable.get(m_localHost).get(diskGroupName);
                    }
                }
                Trace.out((String)("The ASM disk list is " + diskList));
                if (!diskList.isEmpty()) {
                    ResultSet diskListRS = (ResultSet)this.checkASMDiskList(nodeList, diskList.toArray(new String[0]));
                    diskListRS.traceResultSet("ASM Disk list check result");
                    diskGroupRS.uploadResultSet(diskListRS);
                } else {
                    Trace.out((String)("The retrieval of disk list associated with disk group (" + diskGroupName + ") did not return any disks"));
                    diskGroupRS.addResult(nodeList, 3);
                    diskGroupRS.addErrorDescription(nodeList, new ErrorDescription(s_gMsgBundle.getMessage("1613", true, (Object[])new String[]{diskGroupName})));
                }
            }
        }
        catch (ASMDiskGroupsUtilException adgue) {
            Trace.out((String)("Failed to discover the asm disks of the disk groups\n" + adgue.getMessage()));
            VerificationLogData.logError(adgue.getMessage());
            throw new VerificationException(adgue);
        }
        diskGroupRS.addResultSetData(setupResultSet);
        diskGroupRS.traceResultSet("ASM Disk group check result");
        return diskGroupRS;
    }

    public VerificationResultSet checkASMDiskList(String[] nodeList, String[] asmDiskList, String referenceOwner, String referenceGroup, int referencePermissions) throws VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " asmDiskList=" + VerificationUtil.strArr2List(asmDiskList)));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertASMDiskList(asmDiskList, true);
        return this.checkASMDiskList(false, nodeList, asmDiskList, referenceOwner, referenceGroup, referencePermissions);
    }

    private VerificationResultSet checkASMDiskList(boolean localNode, String[] nodeList, String[] asmDiskList, String referenceOwner, String referenceGroup, int referencePermissions) throws VerificationException {
        VerificationResultSet resultSet;
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        TaskASMDeviceChecks mTask = new TaskASMDeviceChecks(setupResultSet.getSuccessfulNodes().toArray(new String[0]));
        if (!VerificationUtil.isStringGood(referenceOwner) && !VerificationUtil.isStringGood(referenceOwner = CVUVariables.getValue(CVUVariableConstants.CRS_USER))) {
            referenceOwner = VerificationUtil.getDefaultCRSUser();
        }
        if (!VerificationUtil.isStringGood(referenceGroup) && (referenceGroup = CVUVariables.getValue(CVUVariableConstants.CRS_USER_GROUP)) == null) {
            referenceGroup = VDMUtil.getDefaultAsmAdminGroup();
        }
        String referencePermissionsStr = Integer.toString(referencePermissions);
        if (referencePermissions == 0) {
            referencePermissionsStr = VDMUtil.getDefaultAsmDisksPermissions();
        }
        mTask.setReferenceGroup(referenceGroup);
        mTask.setReferenceOwner(referenceOwner);
        mTask.setReferencePermissions(referencePermissionsStr);
        mTask.setVerifySharedness(false);
        mTask.setDeviceString(asmDiskList);
        try {
            resultSet = mTask.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(mTask, resultSet);
        }
        return resultSet;
    }

    public VerificationResultSet checkRootPassword(String[] nodeList, String password) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkRootPassword(nodeList, password);
    }

    public VerificationResultSet checkRootPassword(String[] nodeList, String password, int timeout) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkRootPassword(nodeList, password, timeout);
    }

    public VerificationResultSet checkSudoExistence(String[] nodeList, String sudoLocation, String username, String password) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkSudoExistence(nodeList, sudoLocation, username, password);
    }

    public VerificationResultSet checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkSudoExecution(nodeList, sudoLocation, username, password, 1000);
    }

    public VerificationResultSet checkSudoExecution(String[] nodeList, String sudoLocation, String username, String password, int timeout) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkSudoExecution(nodeList, sudoLocation, username, password, timeout);
    }

    public VerificationResultSet checkPbrunExistence(String[] nodeList, String pbLocation, String username, String password) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkPbrunExistence(nodeList, pbLocation, username, password);
    }

    public VerificationResultSet checkPbrunExecution(String[] nodeList, String pblocation, String username, String password) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.checkPbrunExecution(nodeList, pblocation, username, password, 1000);
    }

    public VerificationResultSet checkPbrunExecution(String[] nodeList, String pblocation, String username, String password, int timeout) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return RootAutomationUtility.checkPbrunExecution(nodeList, pblocation, username, password, timeout);
    }

    public void setRootExecutionInfo(ConfigurationSetup.ConfigMethod execMode, UserInfo creds) throws VerificationException {
        if (creds == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"user info"}));
        }
        if (execMode != ConfigurationSetup.ConfigMethod.ROOT) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"exec mode"}));
        }
        RootAutomationUtility.setRootExecutionInfo(execMode, creds, null);
    }

    public void setRootExecutionInfo(ConfigurationSetup.ConfigMethod execMode, UserInfo creds, String location) throws VerificationException {
        if (creds == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"userinfo"}));
        }
        if (execMode == ConfigurationSetup.ConfigMethod.ROOT) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"exec mode"}));
        }
        Assert.assertLocation(location);
        RootAutomationUtility.setRootExecutionInfo(execMode, creds, location);
    }

    public String getSudoLocation() {
        return new CommandsUtil().getSudo();
    }

    public void invalidateSudoCredentialsCache(String[] nodeList) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Trace.out((String)"invalidating sudo credentials cache");
        RootAutomationUtility.invalidateSudoCredentialsCache(nodeList);
    }

    public void deleteRootExecutionInfo() throws VerificationException {
        Trace.out((String)"deleting root execution information");
        RootAutomationUtility.deleteRootExecutionInfo();
    }

    public List<String> expandDevicePaths(String asmDiskPath) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. asmDiskPath=" + asmDiskPath));
        }
        Assert.assertASMDisk(asmDiskPath, false);
        this.checkFrameworkSetup();
        return StorageUtil.expandDevicePaths((String)null, new String[]{asmDiskPath});
    }

    public List<String> expandDevicePaths(String node, String asmDiskPath) throws VerificationException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. node=" + node + " asmDiskPath=" + asmDiskPath));
        }
        node = Assert.assertAndConvertNodeToLower(node);
        Assert.assertASMDisk(asmDiskPath, false);
        this.assertFrameworkSetup(new String[]{node});
        return StorageUtil.expandDevicePaths(node, new String[]{asmDiskPath});
    }

    private void traceTaskResultSet(Task task, VerificationResultSet resultSet) {
        if (Trace.isLevelEnabled((int)1)) {
            Trace.out((String)("Element Name ===>" + task.getElementName()));
            Trace.out((String)("Description of task ===>" + task.getDescription()));
            Trace.out((String)("status==>" + (Object)((Object)resultSet.getOverallStatus())));
            Trace.out((String)("hasNodeValues==>" + resultSet.hasNodeResults()));
            ((ResultSet)resultSet).traceResultSet("ResultSet data ===>");
        }
    }

    public VerificationResultSet checkValidRACServiceUser(Credentials credentials, String[] nodeList) throws VerificationException, UnsupportedOperationException {
        VerificationResultSet resultSet;
        Assert.assertWindowsPlatform();
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertCredentials(credentials);
        Trace.out((String)("Method Entry checkValidRacServiceUser. username=" + credentials.getUsername() + " nodelist=" + VerificationUtil.strArr2List(nodeList)));
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        String[] validNodes = setupResultSet.getSuccessfulNodes().toArray(new String[0]);
        TaskVerifyServiceUser taskServiceUser = new TaskVerifyServiceUser(validNodes, credentials, false);
        try {
            resultSet = taskServiceUser.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        ((ResultSet)resultSet).uploadResultSet(setupResultSet);
        return resultSet;
    }

    public List<String> getErrorLogs() {
        List<String> errorLogs = VerificationLogData.getVerificationLogData();
        VerificationLogData.setVerificationLogData(new ArrayList<String>());
        return errorLogs;
    }

    private NodeManager createNodeManager(String[] nodeList) throws VerificationException {
        NodeManager nm = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            nm = nmf.getNodeManager(nodeList);
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return nm;
    }

    private NodeManager createNodeManager(PreReqType prereqType) throws VerificationException {
        NodeManager nm = null;
        try {
            NodeManagerFactory nmf = NodeManagerFactory.getInstance();
            if (prereqType == PreReqType.PREREQ_CRS_INST) {
                String[] nodeList = new String[]{VerificationUtil.getLocalNode()};
                nm = this.createNodeManager(nodeList);
            } else {
                nm = prereqType == PreReqType.PREREQ_SI_DB_INST || prereqType == PreReqType.PREREQ_SI_DB_CONFIG || prereqType == PreReqType.PREREQ_GENERIC_INST ? nmf.getNodeManager(true) : nmf.createNodeManager();
            }
        }
        catch (NodeManagerFactoryException nmfEx) {
            Trace.out((String)("NodeManagerFactoryException :" + nmfEx.getMessage()));
            throw new VerificationException(nmfEx);
        }
        return nm;
    }

    public VerificationResult getDirSize(String path) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. path=" + path));
        }
        Assert.assertPath(path);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.getDirSize(true, nodeList, path);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet getDirSize(String[] nodeList, String path) throws VerificationException, InvalidPathException {
        if (Trace.isTraceEnabled()) {
            Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " path=" + path));
        }
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertPath(path);
        return this.getDirSize(false, nodeList, path);
    }

    private VerificationResultSet getDirSize(boolean localNode, String[] nodeList, String path) throws VerificationException {
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localNode, nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        ResultSet resultSet = new ResultSet();
        resultSet.uploadResultSet(setupResultSet);
        GlobalExecution globalExec = new GlobalExecution();
        globalExec.getDirSize(nodeList, path, resultSet);
        return resultSet;
    }

    public VerificationResultSet getUserGroups(String[] nodeList, Hashtable<String, String> primaryGroupMap, Hashtable<String, List<String>> groupMap) throws VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList)));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.getUserGroupsInternal(nodeList, null, primaryGroupMap, groupMap);
    }

    public VerificationResultSet getUserGroups(String[] nodeList, String username, Hashtable<String, String> primaryGroupMap, Hashtable<String, List<String>> groupMap) throws VerificationException {
        Trace.out((String)("Method Entry. nodeList=" + VerificationUtil.strArr2List(nodeList) + " username=" + username));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertUser(username);
        return this.getUserGroupsInternal(nodeList, username, primaryGroupMap, groupMap);
    }

    private VerificationResultSet getUserGroupsInternal(String[] nodeList, String username, Hashtable<String, String> primaryGroupMap, Hashtable<String, List<String>> groupMap) throws VerificationException {
        if (primaryGroupMap == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"primary group table"}));
        }
        if (groupMap == null) {
            throw new VerificationException(s_gMsgBundle.getMessage("11300", true, (Object[])new String[]{"group table"}));
        }
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            return setupResultSet;
        }
        if (username == null) {
            username = VerificationUtil.getDefaultOracleUser();
        }
        ResultSet resultSet = new ResultSet();
        VerificationUtil.getUserGroups(nodeList, username, primaryGroupMap, groupMap, resultSet);
        resultSet.uploadResultSet(setupResultSet);
        return resultSet;
    }

    public DiskGroupResultSet checkASMDgAclAttribute(List<String> dgList) throws VerificationException {
        VerificationResultSet resultSet;
        Assert.assertASMDiskGroupList(dgList, true);
        Trace.out((String)("Method Entry Diskgroups=" + VerificationUtil.strList2List(dgList)));
        this.checkFrameworkSetup();
        TaskASMACLAttributeCheck taskACLAttr = new TaskASMACLAttributeCheck(dgList);
        try {
            resultSet = taskACLAttr.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (resultSet.getOverallStatus() != OverallStatus.SUCCESSFUL) {
            return taskACLAttr.getDiskGroupResultSetImpl();
        }
        String eMsg = "";
        List<VerificationError> errList = resultSet.getErrors();
        for (VerificationError errMsg : errList) {
            eMsg = eMsg + errMsg.getErrorMessage() + LSEP;
        }
        throw new VerificationException(eMsg);
    }

    public DiskGroupResultSet checkASMDgAclAttribute() throws VerificationException {
        VerificationResultSet resultSet;
        Trace.out((String)"Method Entry. Performing check on all ASM disk groups");
        this.checkFrameworkSetup();
        TaskASMACLAttributeCheck taskACLAttr = new TaskASMACLAttributeCheck();
        try {
            resultSet = taskACLAttr.verify();
        }
        catch (SubtasksNotCompleteException e) {
            throw new VerificationException(e);
        }
        if (resultSet.getOverallStatus() == OverallStatus.SUCCESSFUL) {
            return taskACLAttr.getDiskGroupResultSetImpl();
        }
        Trace.out((String)"failed to perform the task ");
        String eMsg = "";
        List<VerificationError> errList = resultSet.getErrors();
        for (VerificationError errMsg : errList) {
            eMsg = eMsg + errMsg.getErrorMessage() + LSEP;
        }
        throw new VerificationException(eMsg);
    }

    public VerificationResult getPhysicalMemorySize() throws VerificationException {
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.getPhysicalMemorySize(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            VerificationUtil.traceAndLog("NODERESULTSUNAVAILABLEEXCEPTION: " + (nre != null ? nre.getMessage() : ""));
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet getPhysicalMemorySize(String[] nodeList) throws VerificationException {
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.getPhysicalMemorySize(false, nodeList);
    }

    private VerificationResultSet getPhysicalMemorySize(boolean localOp, String[] nodeList) throws VerificationException {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList)));
        VerificationResultSet resultSet = this.checkPhysicalMemory(localOp, nodeList, 0L, StorageUnit.MBYTE);
        List<String> succNodeList = resultSet.getSuccessfulNodes();
        if (succNodeList.size() == 0) {
            VerificationUtil.traceAndLog("FAILED on all nodes!");
            return resultSet;
        }
        for (String node : succNodeList) {
            try {
                VerificationResult result = ((ResultSet)resultSet).getNodeResult(node, true);
                String actValue = ((Result)result).getActualValue();
                VerificationUtil.traceAndLog("Node: '" + node + "' value: '" + actValue + "'");
            }
            catch (NodeResultsUnavailableException nre) {
                VerificationUtil.traceAndLog("NODERESULTSUNAVAILABLEEXCEPTION: " + (nre != null ? nre.getMessage() : ""));
                throw new VerificationException(nre);
            }
            catch (ResultValuesUnavailableException rve) {
                VerificationUtil.traceAndLog("RESULTVALUESUNAVAILABLEEXCEPTION: " + (rve != null ? rve.getMessage() : ""));
                throw new VerificationException(rve);
            }
        }
        List<String> failNodeList = resultSet.getFailedNodes();
        for (String node : failNodeList) {
            VerificationUtil.traceAndLog("FAILED on Node: '" + node + "'");
        }
        return resultSet;
    }

    public VerificationResult getDevSHMSize() throws VerificationException, UnsupportedOperationException {
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        VerificationResultSet resultSet = this.getDevSHMSize(true, nodeList);
        try {
            return ((ResultSet)resultSet).getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            VerificationUtil.traceAndLog("NODERESULTSUNAVAILABLEEXCEPTION: " + (nre != null ? nre.getMessage() : ""));
            throw new VerificationException(nre);
        }
    }

    public VerificationResultSet getDevSHMSize(String[] nodeList) throws VerificationException, UnsupportedOperationException {
        Trace.out((String)("nodeList=" + VerificationUtil.strArr2List(nodeList)));
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        return this.getDevSHMSize(false, nodeList);
    }

    private VerificationResultSet getDevSHMSize(boolean localOp, String[] nodeList) throws VerificationException, UnsupportedOperationException {
        Trace.out((String)("localOp=" + localOp + " nodeList=" + VerificationUtil.strArr2List(nodeList)));
        if (!VerificationUtil.isPlatformLinux()) {
            String msg = s_nMsgBundle.getMessage("1012", true, (Object[])new String[]{"/dev/shm", DeterminePlatform.getOSName()});
            VerificationUtil.traceAndLog("Not Linux platform: " + msg);
            throw new UnsupportedOperationException(msg);
        }
        Trace.out((int)1, (String)"Running on Linux");
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(localOp, nodeList);
        if (!setupResultSet.anySuccess()) {
            VerificationUtil.traceAndLog("checkFrameworkSetup FAILED on all nodes!");
            return setupResultSet;
        }
        Trace.out((int)1, (String)"Defining DataComparator, ExecutableInfo, Executable args and PluggableTask");
        StdDataComparator dc = new StdDataComparator(new ReferenceInfo(DataType.NUMERIC, "0", DataComparatorType.GE));
        ArrayList<ExecutableArgument> execArgs = new ArrayList<ExecutableArgument>();
        ExecutableInfo execInfo = new ExecutableInfo("checktmpfs.sh", ExecutableType.SHELL, ExecutableResultType.ANALYZED, dc);
        execArgs.add(new ExecutableArgument("arg0", ArgType.DEFINED, DataType.STRING, "1"));
        execInfo.setExecutableArgs(execArgs);
        PluggableTask pt = new PluggableTask(new PluggableTaskContext(execInfo, nodeList, null, false), "DEV_SHM_MOUNT");
        Trace.out((int)1, (String)"Running PluggableTask");
        pt.performTask();
        ResultSet resultSet = pt.getResultSet();
        for (String node : nodeList) {
            try {
                VerificationResult result = resultSet.getNodeResult(node, true);
                String actValue = ((Result)result).getActualValue();
                Trace.out((int)1, (String)("acutal value: '" + actValue + "' in MB"));
                if (!VerificationUtil.isStringGood(actValue)) {
                    Trace.out((String)"Value not present/bad, skipping unitize operation");
                    continue;
                }
                StorageSize unitizedValue = new StorageSize((double)new Double(actValue), StorageUnit.MBYTE);
                ((Result)result).setActualValue(ReportUtil.unitizeSize(unitizedValue));
                VerificationUtil.traceAndLog("Node: '" + node + "' unitized value: '" + ((Result)result).getActualValue() + "'");
            }
            catch (NodeResultsUnavailableException nre) {
                VerificationUtil.traceAndLog("NODERESULTSUNAVAILABLEEXCEPTION: " + (nre != null ? nre.getMessage() : ""));
                throw new VerificationException(nre);
            }
            catch (ResultValuesUnavailableException rve) {
                VerificationUtil.traceAndLog("RESULTVALUESUNAVAILABLEEXCEPTION: " + (rve != null ? rve.getMessage() : ""));
                throw new VerificationException(rve);
            }
        }
        resultSet.uploadResultSet(setupResultSet);
        if (Trace.isLevelEnabled((int)1)) {
            this.traceTaskResultSet(pt, resultSet);
        }
        return resultSet;
    }

    public VerificationResult checkUpgradeSuitability(String srcHome, String destVersion) throws VerificationException, InvalidPathException {
        String xmlFilePath = null;
        HashMap srcHomeVersionMap = new HashMap();
        Assert.assertPath(srcHome);
        Assert.assertVersion(destVersion);
        String localNode = this.getLocalNode();
        String[] nodeList = new String[]{localNode};
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(true, nodeList);
        if (!setupResultSet.anySuccess()) {
            try {
                return setupResultSet.getNodeResult(localNode, true);
            }
            catch (NodeResultsUnavailableException e) {
                throw new VerificationException(e);
            }
        }
        String errMsg = s_gMsgBundle.getMessage("1278", true, (Object[])new String[]{srcHome, destVersion});
        VerificationType vType = VerificationType.PREREQ_CRS_INST;
        try {
            xmlFilePath = VerificationUtil.getPreReqXmlPath(vType, destVersion);
            File xmlFile = new File(xmlFilePath);
            XmlParser xmlParser = new XmlParser(xmlFile);
            xmlParser.parse(vType);
            CDMHost cdmHost = xmlParser.getCDMData();
            if (cdmHost == null) {
                VerificationUtil.traceAndLog("ERROR: Invalid root element");
                String msg = errMsg + LSEP + s_gMsgBundle.getMessage("10496", true, (Object[])new String[]{xmlFilePath});
                throw new VerificationException(msg);
            }
            Vector<CDMSystem> cdmSystems = cdmHost.getCDMSystems();
            if (cdmSystems.size() != 1) {
                String elementSize = Integer.toString(cdmSystems.size());
                String msg = errMsg + LSEP + s_gMsgBundle.getMessage("10497", true, (Object[])new String[]{elementSize, xmlFilePath});
                VerificationUtil.traceAndLog(msg);
                throw new VerificationException(msg);
            }
            CDMSystem cdmSystem = cdmSystems.elementAt(0);
            srcHomeVersionMap = cdmSystem.getUpgradeSuitabilityHash();
        }
        catch (XmlFilePathException xfpe) {
            Trace.out((String)("XmlFilePathException: " + xfpe.getMessage()));
            String msg = errMsg + LSEP + xfpe.getMessage();
            throw new VerificationException(msg);
        }
        catch (XmlParserException xpe) {
            Trace.out((String)("XmlParserException : " + xpe.getMessage()));
            String msg = errMsg + LSEP + xpe.getMessage();
            throw new VerificationException(msg);
        }
        List srcHomeRangeList = (List)srcHomeVersionMap.get(CDMConstraintTypes.RANGE);
        TaskUpgradeSuitability task = null;
        ResultSet resultSet = new ResultSet();
        if (srcHomeRangeList != null && srcHomeRangeList.size() > 0) {
            task = new TaskUpgradeSuitability(srcHome, srcHomeRangeList, destVersion);
            task.setNodeList(nodeList);
            VerificationUtil.traceAndLog("Checking Upgrade suitability from source  home: " + srcHome + " to dest version: " + destVersion);
            try {
                resultSet = (ResultSet)task.verify();
            }
            catch (SubtasksNotCompleteException e) {
                throw new VerificationException(e);
            }
        }
        resultSet.uploadResultSet(setupResultSet);
        try {
            return resultSet.getNodeResult(localNode, true);
        }
        catch (NodeResultsUnavailableException nre) {
            throw new VerificationException(nre);
        }
    }

    public Hashtable<String, VerificationResultSet> checkOraclePatches(String home, String[] nodeList, String[] bugList, boolean isRacHome) throws VerificationException, InvalidPathException {
        Assert.assertPath(home);
        nodeList = Assert.assertAndConvertNodesToLower(nodeList);
        Assert.assertBugList(bugList);
        Hashtable<String, VerificationResultSet> resultHT = new Hashtable<String, VerificationResultSet>();
        ResultSet setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        if (!setupResultSet.anySuccess()) {
            for (String bug : bugList) {
                resultHT.put(bug, setupResultSet);
            }
            return resultHT;
        }
        for (String bug : bugList) {
            TaskOraclePatch task = new TaskOraclePatch(home, bug, isRacHome);
            task.setNodeList(nodeList);
            try {
                VerificationResultSet rs = task.verify();
                resultHT.put(bug, rs);
            }
            catch (SubtasksNotCompleteException e) {
                throw new VerificationException(e);
            }
        }
        return resultHT;
    }

    private VerificationResultSet assertFrameworkSetup(String[] nodeList) throws VerificationException {
        return this.assertFrameworkSetup(nodeList, true);
    }

    private VerificationResultSet assertFrameworkSetup(String[] nodeList, boolean bCreateNodeManager) throws VerificationException {
        ResultSet setupResultSet;
        if (bCreateNodeManager) {
            setupResultSet = (ResultSet)this.checkFrameworkSetup(nodeList);
        } else {
            boolean isLocalNode = false;
            if (nodeList.length > 1 && m_localHost.equalsIgnoreCase(nodeList[0])) {
                isLocalNode = true;
            }
            setupResultSet = (ResultSet)this.checkFrameworkSetup(isLocalNode, nodeList, false);
        }
        if (!setupResultSet.anySuccess()) {
            Trace.out((String)"All nodes failed framework setup check.");
            String errMsg = setupResultSet.getAllErrorsStr();
            throw new VerificationException(errMsg);
        }
        return setupResultSet;
    }

    static {
        s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
        s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
        s_nMsgBundle = VerificationUtil.getMessageBundle("Prkn");
        LSEP = System.getProperty("line.separator");
        m_localHost = null;
        CRSHOME = "ORA_CRS_HOME";
        m_variablesSetInSession = new HashSet<String>();
    }

    public static enum PathType {
        WORK_DIR,
        FRAMEWORK_HOME;

    }
}

