/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import oracle.cluster.impl.verification.FixupResultImpl;
import oracle.cluster.verification.FixupOverallStatus;
import oracle.cluster.verification.FixupResult;
import oracle.cluster.verification.FixupResultSet;
import oracle.cluster.verification.FixupStatus;
import oracle.cluster.verification.InvalidFixupNodeException;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.util.Assert;
import oracle.ops.verification.framework.util.VerificationLogData;
import oracle.ops.verification.framework.util.VerificationUtil;

public class FixupResultSetImpl
implements FixupResultSet {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private static MessageBundle s_gMsgBundle = VerificationUtil.getMessageBundle("Prvg");
    private FixupOverallStatus m_overAllStatus = FixupOverallStatus.UNKNOWN;
    private List<VerificationError> m_overallErrors = new ArrayList<VerificationError>();
    private Hashtable<String, FixupResultImpl> m_resultTable = new Hashtable();
    private boolean m_hasNodeResults = false;

    public FixupResultSetImpl(String[] nodeList) {
        for (String node : nodeList) {
            this.m_resultTable.put(node, new FixupResultImpl(node));
        }
    }

    public FixupResultSetImpl(List<String> nodeList) {
        this(nodeList.toArray(new String[0]));
    }

    @Override
    public FixupOverallStatus getFixupOverallStatus() {
        this.consolidateOverAllStatus();
        return this.m_overAllStatus;
    }

    private void consolidateOverAllStatus() {
        if (this.m_hasNodeResults) {
            this.m_overAllStatus = FixupOverallStatus.UNKNOWN;
            for (String node : this.m_resultTable.keySet()) {
                FixupResultImpl nodeResult = this.m_resultTable.get(node);
                if (nodeResult.getStatus() == FixupStatus.ERROR || nodeResult.getStatus() == FixupStatus.FAILED) {
                    this.updateOverAllStatus(FixupOverallStatus.FAILED);
                    continue;
                }
                if (nodeResult.getStatus() == FixupStatus.UNKNOWN) continue;
                this.updateOverAllStatus(FixupOverallStatus.SUCCESSFUL);
            }
        }
    }

    @Override
    public Collection<String> getParticipatingNodes() {
        return this.m_resultTable.keySet();
    }

    public void addNodeResult(String node, FixupResult result) throws InvalidFixupNodeException {
        try {
            node = Assert.assertAndConvertNodeToLower(node);
        }
        catch (VerificationException e) {
            Trace.out((String)e.getMessage());
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false) + System.getProperty("line.separator") + e.getMessage());
        }
        if (!this.m_resultTable.containsKey(node)) {
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false));
        }
        this.hasNodeResults(true);
        if (result.getStatus() != FixupStatus.UNKNOWN) {
            this.m_resultTable.put(node, (FixupResultImpl)result);
        }
    }

    public boolean anyFailures() {
        return this.getFailedNodes().size() > 0;
    }

    public boolean allSuccess() {
        return this.getFailedNodes().size() == 0;
    }

    @Override
    public List<String> getSuccessfulNodes() {
        ArrayList<String> m_succNodes = new ArrayList<String>();
        List<String> m_failedNodes = this.getFailedNodes();
        for (String node : this.m_resultTable.keySet()) {
            if (m_failedNodes.contains(node)) continue;
            m_succNodes.add(node);
        }
        return m_succNodes;
    }

    @Override
    public List<String> getFailedNodes() {
        ArrayList<String> m_failedNodes = new ArrayList<String>();
        for (String node : this.m_resultTable.keySet()) {
            if (this.m_resultTable.get(node).getStatus() != FixupStatus.ERROR && this.m_resultTable.get(node).getStatus() != FixupStatus.FAILED) continue;
            m_failedNodes.add(node);
        }
        return m_failedNodes;
    }

    @Override
    public List<FixupResult> getNodeResults() throws NodeResultsUnavailableException {
        if (!this.m_hasNodeResults) {
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        ArrayList<FixupResult> nodeResults = new ArrayList<FixupResult>(this.m_resultTable.size());
        Enumeration<String> e = this.m_resultTable.keys();
        while (e.hasMoreElements()) {
            String node = e.nextElement();
            nodeResults.add(this.m_resultTable.get(node));
        }
        return nodeResults;
    }

    @Override
    public FixupResult getResult(String node) throws InvalidFixupNodeException, NodeResultsUnavailableException {
        try {
            node = Assert.assertAndConvertNodeToLower(node);
        }
        catch (VerificationException e) {
            Trace.out((String)e.getMessage());
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false) + System.getProperty("line.separator") + e.getMessage());
        }
        if (!this.m_resultTable.containsKey(node)) {
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false));
        }
        if (!this.m_hasNodeResults) {
            throw new NodeResultsUnavailableException(s_msgBundle.getMessage("7503", false));
        }
        return this.m_resultTable.get(node);
    }

    public void addResult(String node, Result nodeResult) throws InvalidFixupNodeException {
        try {
            node = Assert.assertAndConvertNodeToLower(node);
        }
        catch (VerificationException e) {
            Trace.out((String)e.getMessage());
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false) + System.getProperty("line.separator") + e.getMessage());
        }
        if (!this.m_resultTable.containsKey(node)) {
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false));
        }
        this.hasNodeResults(true);
        this.m_resultTable.get(node).updateResult(nodeResult);
    }

    public void addResult(String node, FixupResult nodeResult) throws InvalidFixupNodeException {
        try {
            node = Assert.assertAndConvertNodeToLower(node);
        }
        catch (VerificationException e) {
            Trace.out((String)e.getMessage());
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false) + System.getProperty("line.separator") + e.getMessage());
        }
        if (!this.m_resultTable.containsKey(node)) {
            throw new InvalidFixupNodeException(s_msgBundle.getMessage("7503", false));
        }
        this.hasNodeResults(true);
        this.m_resultTable.get(node).updateResult(nodeResult);
    }

    @Override
    public List<VerificationError> getErrors() {
        ArrayList<VerificationError> allErrors = new ArrayList<VerificationError>();
        for (String node : this.m_resultTable.keySet()) {
            FixupResultImpl nodeResult = this.m_resultTable.get(node);
            if (nodeResult.getErrors().size() <= 0) continue;
            allErrors.addAll(nodeResult.getErrors());
        }
        return allErrors;
    }

    @Override
    public List<VerificationError> getGlobalErrors() {
        return this.m_overallErrors;
    }

    public void updateOverAllStatus(FixupOverallStatus status) {
        if (this.m_overAllStatus == FixupOverallStatus.SUCCESSFUL || this.m_overAllStatus == FixupOverallStatus.UNKNOWN) {
            this.m_overAllStatus = status;
        }
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_overallErrors.add(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_overallErrors.addAll(errorDescList);
    }

    @Override
    public boolean hasNodeResults() {
        return this.m_hasNodeResults;
    }

    private void hasNodeResults(boolean flag) {
        this.m_hasNodeResults = flag;
        if (this.m_hasNodeResults) {
            for (String node : this.m_resultTable.keySet()) {
                if (this.m_resultTable.containsKey(node)) continue;
                this.m_resultTable.put(node, new FixupResultImpl(node));
            }
        } else {
            this.m_resultTable.clear();
        }
    }

    public void updateResultSet(FixupResultSet resultSet) {
        this.traceFixupResultSet("<=== BEFORE UPLOAD ===>");
        ((FixupResultSetImpl)resultSet).traceFixupResultSet("<= SOURCE FixupResultSet =>");
        Set<String> nodes = this.m_resultTable.keySet();
        if (resultSet.hasNodeResults()) {
            for (String node : nodes) {
                try {
                    this.addNodeResult(node, resultSet.getResult(node));
                }
                catch (InvalidFixupNodeException ie) {
                    Trace.out((int)5, (String)("Caught InvalidFixupNodeException Skipping the node " + node));
                }
                catch (NodeResultsUnavailableException nrue) {
                    Trace.out((int)5, (String)("Caught NodeResultsUnavailableException Skipping the node " + node));
                }
            }
        }
        this.consolidateOverAllStatus();
        this.addErrorDescription(resultSet.getErrors());
        this.traceFixupResultSet("<=== FixupResultSet AFTER UPLOAD ===>");
    }

    public void updateResultSet(ResultSet resultSet) {
        this.traceFixupResultSet("<=== BEFORE UPLOAD ===>");
        resultSet.traceResultSet("<= SOURCE ResultSet =>");
        Set<String> nodes = this.m_resultTable.keySet();
        if (resultSet.hasNodeResults()) {
            for (String node : nodes) {
                Result result = null;
                try {
                    result = resultSet.getResult(node);
                    if (result != null) {
                        this.addResult(node, result);
                        continue;
                    }
                    Trace.out((String)("Not Adding: Result for fix-up node (" + node + ") is not available inside source resultSet"));
                }
                catch (InvalidFixupNodeException e) {
                    Trace.out((int)5, (String)("Caught InvalidFixupNodeException Skipping the node " + node));
                }
            }
        }
        this.consolidateOverAllStatus();
        this.addErrorDescription(resultSet.getErrors());
        this.traceFixupResultSet("<=== FixupResultSet AFTER UPLOAD ===>");
    }

    public void clear() {
        this.m_overAllStatus = FixupOverallStatus.UNKNOWN;
        this.m_overallErrors = new ArrayList<VerificationError>();
        if (this.m_resultTable != null) {
            for (String node : this.m_resultTable.keySet()) {
                this.m_resultTable.put(node, new FixupResultImpl(node));
            }
        }
    }

    public void traceFixupResultSet(String header) {
        StringBuffer strBuf = new StringBuffer();
        strBuf.append("\n\n" + header + "\n\tOverall Status->" + this.m_overAllStatus.toString() + "\n");
        Set<String> nodes = this.m_resultTable.keySet();
        for (String node : nodes) {
            FixupResultImpl result = this.m_resultTable.get(node);
            FixupStatus status = result.getStatus();
            strBuf.append(result.traceFixupResultInfo());
            if (Trace.isLevelEnabled((int)1)) {
                strBuf.append(result.traceFixupResultInfo());
                continue;
            }
            strBuf.append("\n\t" + node + "-->" + status.toString());
        }
        strBuf.append("\n\n");
        Trace.out((String)strBuf.toString());
        VerificationLogData.logInfo(strBuf.toString());
    }
}

