/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.List;
import oracle.cluster.verification.CommandExecResult;
import oracle.cluster.verification.CommandExecResultStatus;
import oracle.cluster.verification.CommandResultUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.util.VerificationUtil;

public class CommandExecResultImpl
implements CommandExecResult {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private CommandExecResultStatus m_resultStatus = CommandExecResultStatus.NOT_EXECUTED;
    private List<VerificationError> m_errorList = new ArrayList<VerificationError>();
    private String m_node;
    private String m_cmdOutput = "";
    private int m_cmdExitValue;

    public CommandExecResultImpl(String node) {
        this.m_node = node;
    }

    @Override
    public CommandExecResultStatus getCommandExecResultStatus() {
        return this.m_resultStatus;
    }

    @Override
    public String getNode() {
        return this.m_node;
    }

    @Override
    public List<VerificationError> getErrors() {
        return this.m_errorList;
    }

    @Override
    public String getCommandOutput() throws CommandResultUnavailableException {
        if (this.m_resultStatus == CommandExecResultStatus.NOT_EXECUTED) {
            throw new CommandResultUnavailableException(s_msgBundle.getMessage("7561", false, (Object[])new String[]{this.m_node}));
        }
        return this.m_cmdOutput;
    }

    @Override
    public int getCommandExitValue() throws CommandResultUnavailableException {
        if (this.m_resultStatus == CommandExecResultStatus.NOT_EXECUTED) {
            throw new CommandResultUnavailableException(s_msgBundle.getMessage("7561", false, (Object[])new String[]{this.m_node}));
        }
        return this.m_cmdExitValue;
    }

    public void setCommandExecResultStatus(CommandExecResultStatus resultStatus) {
        this.m_resultStatus = resultStatus;
    }

    public void setCommandExitValue(int cmdExitValue) {
        this.m_cmdExitValue = cmdExitValue;
    }

    public void setCommandOutput(String cmdOutput) {
        this.m_cmdOutput = cmdOutput;
    }

    public void addErrorDescription(ErrorDescription errorDesc) {
        this.m_errorList.add(errorDesc);
    }

    public void addErrorDescription(List<VerificationError> errorDescList) {
        this.m_errorList.addAll(errorDescList);
    }
}

