/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.lwAWT.LWLabel;
import oracle.ewt.lwAWT.lwText.LWTextField;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;

public class OiOIDRegisterOptions
extends OiifpWizPanel
implements ItemListener {
    private static final String DEFAULT_TITLE = "Title";
    private static final String DEFAULT_LABEL = "Label";
    private static final String DEFAULT_PROMPT = "Prompt";
    private static final String[] DEFAULT_CHOICES = new String[]{"No", "Yes"};
    private static final int INSETS = 2;
    private MultiLineLabel _textLabel;
    private MultiLineLabel prompt1;
    private MultiLineLabel prompt2;
    private LWLabel _hostPromptLabel;
    private LWLabel _portPromptLabel;
    private LWTextField textHost;
    private LWTextField textPort;
    private LWCheckbox useOnlySSLCheck;
    private String useOnlySSLCheckStr = "Use Only SSL to Connect to OID";
    private MultiLineLabel useOnlySSLPrompt;
    private String useOnlySSLPromptStr = "Explanation Use Only SSL Checkbox";
    private boolean defaultUseOnlySSL = false;
    private String defaultHost = "";
    private String defaultPort = "389";
    private String hostnameStr = "Host:";
    private String portnumberStr = "Port:";
    public LWCheckbox[] m_radio;
    private LWCheckboxGroup m_radioButtonGroup;
    public LWContainer m_selectPanel;
    private ItemListener m_itemListener;
    private GridBagLayout gridbag;
    private GridBagConstraints c;

    public OiOIDRegisterOptions() {
        this(DEFAULT_PROMPT);
        this.setTitleLabel(DEFAULT_TITLE);
        this.setChoices(DEFAULT_CHOICES);
        this.validate();
    }

    public OiOIDRegisterOptions(String promptString) {
        super(DEFAULT_TITLE);
        this._textLabel = new MultiLineLabel(WordWrapper.getTextWrapper(), promptString);
        GridBagLayout mgridbag = new GridBagLayout();
        this.mainPanel.setLayout((LayoutManager)mgridbag);
        GridBagConstraints mc = new GridBagConstraints();
        mc.fill = 1;
        mc.gridx = 0;
        mc.gridy = 0;
        mc.weightx = 0.5;
        mc.weighty = 0.5;
        mc.anchor = 18;
        mc.gridwidth = 0;
        mgridbag.setConstraints((Component)this._textLabel, mc);
        this.mainPanel.add((Component)this._textLabel);
        this.gridbag = new GridBagLayout();
        this.c = new GridBagConstraints();
        this.m_selectPanel = new LWContainer();
        this.c.fill = 0;
        this.c.anchor = 18;
        this.c.gridwidth = 0;
        this.c.insets = new Insets(0, 0, 0, 0);
        this.m_selectPanel.setLayout((LayoutManager)this.gridbag);
        this.m_selectPanel.setSize(100, 100);
        mc.gridwidth = 0;
        mc.insets = new Insets(0, 0, 0, 0);
        mc.fill = 1;
        mc.gridy = -1;
        mc.weightx = 0.1;
        mc.weighty = 0.4;
        mgridbag.setConstraints((Component)this.m_selectPanel, mc);
        this.mainPanel.add((Component)this.m_selectPanel, (Object)mc);
        this.m_itemListener = null;
        this.validate();
    }

    public void setPrompt(String text) {
        if (text != null) {
            this._textLabel.setText(text);
        }
    }

    public void setChoices(String[] choices) {
        this.removeChoices();
        if (choices != null) {
            this.addRadioButtons();
        }
        this.setCompInfo(choices);
    }

    public void setCompInfo(String[] choices) {
        for (int rowIdx = 0; rowIdx < choices.length; ++rowIdx) {
            this.m_radio[rowIdx].setLabel(choices[rowIdx]);
        }
    }

    public void setInputs(String[] text) {
        if (this.getSelection().equalsIgnoreCase("Yes")) {
            for (int i = 0; i < text.length - 1; ++i) {
                this.setHost(text[0]);
                this.setPort(text[1]);
                this.setUseOnlySSL(text[2]);
            }
        }
    }

    public void setHostnameStr(String text) {
        if (text != null) {
            this.invalidate();
            this.hostnameStr = text;
            this._hostPromptLabel.setText(this.hostnameStr);
            this.validate();
        }
    }

    public void setPortnumberStr(String text) {
        if (text != null) {
            this.invalidate();
            this.portnumberStr = text;
            this._portPromptLabel.setText(this.portnumberStr);
            this.validate();
        }
    }

    public void setHost(String text) {
        if (text != null) {
            this.invalidate();
            this.textHost.setText(text);
            this.validate();
        }
    }

    public void setPort(String text) {
        if (text != null) {
            this.invalidate();
            this.textPort.setText(text);
            this.validate();
        }
    }

    public void setUseOnlySSL(String YorN) {
        this.invalidate();
        if (YorN != null) {
            boolean useOnlySSL = YorN.equalsIgnoreCase("Y");
            this.useOnlySSLCheck.setState(useOnlySSL);
        }
        this.validate();
    }

    public void setUseOnlySSLStr(String text) {
        this.invalidate();
        if (text != null) {
            this.useOnlySSLCheckStr = text;
            this.useOnlySSLCheck.setLabel(this.useOnlySSLCheckStr);
        }
        this.validate();
    }

    public void setUseOnlySSLPrompt(String label) {
        this.invalidate();
        if (label != null) {
            this.useOnlySSLPromptStr = label;
            this.useOnlySSLPrompt.setText(this.useOnlySSLPromptStr);
        }
        this.validate();
    }

    public void setValidation(Integer i) {
    }

    private void removeChoices() {
        if (this.m_selectPanel != null) {
            Component[] clist = this.m_selectPanel.getComponents();
            for (int i = 0; i < clist.length; ++i) {
                this.m_selectPanel.remove(clist[i]);
            }
        }
    }

    public void setSelection(String selString) {
        int index = 0;
        if (this.m_radio != null) {
            for (int i = 0; i < this.m_radio.length; ++i) {
                if (!this.m_radio[i].getLabel().equals(selString)) continue;
                index = i;
                break;
            }
        }
        this.setSelection(index);
    }

    public void setSelection(int index) {
        if (this.m_radio != null && this.m_radio.length > index) {
            this.m_radioButtonGroup.setSelectedCheckbox(this.m_radio[index]);
        }
        if (index == 0) {
            this.textHost.setEnabled(false);
            this.textPort.setEnabled(false);
            this.useOnlySSLCheck.setState(false);
            this.useOnlySSLCheck.setEnabled(false);
            this.validate();
        } else {
            this.textHost.setEnabled(true);
            this.textPort.setEnabled(true);
            this.useOnlySSLCheck.setState(false);
            this.useOnlySSLCheck.setEnabled(true);
            this.validate();
        }
    }

    public void addRadioButtons() {
        this.c.anchor = 18;
        this.c.fill = 1;
        this.c.insets.top = 0;
        this.c.insets.left = 0;
        this.c.insets.bottom = 2;
        int size = 2;
        this.m_radioButtonGroup = new LWCheckboxGroup();
        this.m_radio = new LWCheckbox[2];
        this.m_radio[0] = new LWCheckbox("No", this.m_radioButtonGroup, false);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.insets.top = 0;
        this.c.insets.left = 15;
        this.c.insets.bottom = 2;
        this.c.weighty = 0.0;
        this.gridbag.setConstraints((Component)this.m_radio[0], this.c);
        this.m_radio[0].addItemListener((ItemListener)this);
        this.m_selectPanel.add((Component)this.m_radio[0]);
        this.m_radio[1] = new LWCheckbox("Yes", this.m_radioButtonGroup, false);
        this.c.insets.top = 0;
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.c.insets.left = 15;
        this.c.insets.bottom = 2;
        this.c.weighty = 0.0;
        this.gridbag.setConstraints((Component)this.m_radio[1], this.c);
        this.m_radio[1].addItemListener((ItemListener)this);
        this.m_selectPanel.add((Component)this.m_radio[1]);
        this._hostPromptLabel = new LWLabel(this.hostnameStr);
        this.c.weightx = 0.1;
        this.c.insets.top = 2;
        this.c.insets.left = 30;
        this.c.insets.right = 0;
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)this._hostPromptLabel, this.c);
        this.m_selectPanel.add((Component)this._hostPromptLabel);
        this.textHost = new LWTextField(this.defaultHost);
        this.c.gridx = 1;
        this.c.insets.left = 0;
        this.c.insets.right = 0;
        this.c.weightx = 0.1;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)this.textHost, this.c);
        this.m_selectPanel.add((Component)this.textHost);
        this._portPromptLabel = new LWLabel(this.portnumberStr);
        this.c.weightx = 0.1;
        this.c.insets.top = 2;
        this.c.insets.left = 30;
        this.c.insets.right = 0;
        this.c.gridx = 0;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)this._portPromptLabel, this.c);
        this.m_selectPanel.add((Component)this._portPromptLabel);
        this.textPort = new LWTextField(this.defaultPort);
        this.c.weightx = 0.1;
        this.c.insets.left = 0;
        this.c.insets.right = 0;
        this.c.gridx = 1;
        this.c.gridy = 3;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)this.textPort, this.c);
        this.m_selectPanel.add((Component)this.textPort);
        this.useOnlySSLCheck = new LWCheckbox(this.useOnlySSLCheckStr, null, this.defaultUseOnlySSL);
        this.c.insets.top = 2;
        this.c.insets.left = 30;
        this.c.gridx = 0;
        this.c.gridy = 4;
        this.c.gridwidth = 1;
        this.gridbag.setConstraints((Component)this.useOnlySSLCheck, this.c);
        this.m_selectPanel.add((Component)this.useOnlySSLCheck);
        this.useOnlySSLPrompt = new MultiLineLabel(WordWrapper.getTextWrapper(), this.useOnlySSLPromptStr);
        this.c.insets.top = 2;
        this.c.insets.left = 40;
        this.c.gridx = 0;
        this.c.gridy = 5;
        this.c.gridwidth = 0;
        this.gridbag.setConstraints((Component)this.useOnlySSLPrompt, this.c);
        this.m_selectPanel.add((Component)this.useOnlySSLPrompt);
        this.setSelection(1);
    }

    public synchronized void addItemListener(ItemListener listener) {
        this.m_itemListener = listener;
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        if (event.getStateChange() == 1) {
            String r_label = event.getItem().toString();
            if (r_label.equalsIgnoreCase(this.m_radio[0].getLabel())) {
                this.textHost.setEnabled(false);
                this.textPort.setEnabled(false);
                this.useOnlySSLCheck.setState(false);
                this.useOnlySSLCheck.setEnabled(false);
            } else {
                this.textHost.setEnabled(true);
                this.textPort.setEnabled(true);
                this.useOnlySSLCheck.setEnabled(true);
            }
        }
    }

    public String getPrompt() {
        return this._textLabel.getText();
    }

    public String getHost() {
        return new String(this.textHost.getText());
    }

    public String getPort() {
        return new String(this.textPort.getText());
    }

    public Integer getValidation() {
        return new Integer(0);
    }

    public String getUseOnlySSL() {
        boolean useOnlySSL = this.useOnlySSLCheck.getState();
        if (useOnlySSL) {
            return new String("Y");
        }
        return new String("N");
    }

    public String getSelection() {
        if (this.m_radio != null) {
            return this.m_radioButtonGroup.getSelectedCheckbox().getLabel();
        }
        return null;
    }

    public String[] getInputs() {
        String[] retVal = new String[3];
        if (this.m_radioButtonGroup.getSelectedCheckbox().getLabel().equalsIgnoreCase("Yes")) {
            retVal[0] = this.textHost.getText();
            retVal[1] = this.textPort.getText();
            retVal[2] = this.getUseOnlySSL();
        }
        return retVal;
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        OiOIDRegisterOptions panel1 = new OiOIDRegisterOptions();
        f.add((Component)((Object)panel1));
        f.resize(600, 400);
        f.show();
    }
}

