/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import oracle.ewt.lwAWT.LWCheckbox;
import oracle.ewt.lwAWT.LWCheckboxGroup;
import oracle.ewt.lwAWT.LWContainer;
import oracle.ewt.multiLineLabel.MultiLineLabel;
import oracle.ewt.textWrapper.WordWrapper;
import oracle.sysman.oii.oiif.oiifp.OiifpWizPanel;
import oracle.sysman.oii.oiix.OiixResourceBundle;

public class DBConfig
extends OiifpWizPanel {
    private static final String DEFAULT_TITLE = "Select Database Configuration";
    private static final String DEFAULT_PROMPT_0 = "Select the type of database you wish to create.";
    private static final String[] DEFAULT_OPTIONS = new String[]{"General Purpose or Transaction Processing", "A starter database designed for general purpose usage or transaction-heavy applications.", "Data Warehouse", "A starter database optimized for data warehousing applications", "Advanced", "Allows you to customize the configuration of your starter database"};
    private MultiLineLabel prompt0 = new MultiLineLabel(WordWrapper.getTextWrapper(), "Select the type of database you wish to create.");
    private LWCheckboxGroup checkgroup1 = new LWCheckboxGroup();
    private LWCheckbox[] options;
    private NonJAWSReadableMultiLineLabel[] optionsDesc;
    private LWContainer panel0 = null;
    private LWContainer panel1 = null;
    private LWContainer singleSelectPanel = new LWContainer();
    private GridBagLayout gridBag = new GridBagLayout();
    private GridBagConstraints c;
    private Color _defaultColor;
    private static final int CHECK_BOX_0 = 0;
    private static final int CHECK_BOX_1 = 1;

    public DBConfig() {
        super(DEFAULT_TITLE);
        this.mainPanel.setLayout((LayoutManager)this.gridBag);
        this.c = new GridBagConstraints();
        this.setOptions0(DEFAULT_OPTIONS);
        this.createPanel0();
        this.createPanel1();
        this.addComponent((Component)this.panel0, (Container)this.mainPanel, this.gridBag, this.c, 2, 17, 0, 1, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
        this.addComponent((Component)this.panel1, (Container)this.mainPanel, this.gridBag, this.c, 1, 17, 0, 2, 1, 1, 1.0, 1.0, new Insets(0, 0, 50, 0));
    }

    public void generateOptionsFromArray(String[] list) {
        int rows = list.length / 2;
        this.options = new LWCheckbox[rows];
        this.optionsDesc = new NonJAWSReadableMultiLineLabel[rows];
        for (int i = 0; i < rows; ++i) {
            this.options[i] = new LWCheckbox();
            this.options[i].setLabel(list[i * 2]);
            this.options[i].setCheckboxGroup(this.checkgroup1);
            this.options[i].getAccessibleContext().setAccessibleName(list[i * 2] + "\n" + list[i * 2 + 1]);
            this.optionsDesc[i] = new NonJAWSReadableMultiLineLabel(WordWrapper.getTextWrapper(), list[i * 2 + 1]);
        }
        this.options[0].setState(true);
    }

    public void createSingleSelectPanel(LWCheckbox[] options, NonJAWSReadableMultiLineLabel[] optionsDesc) {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.singleSelectPanel.removeAll();
        this.singleSelectPanel.setLayout((LayoutManager)gridbag0);
        for (int i = 0; i < options.length; ++i) {
            this.addComponent((Component)options[i], (Container)this.singleSelectPanel, gridbag0, c0, 2, 17, 0, i * 2 + 1, 0, 1, 1.0, 0.0, new Insets(2, 15, 0, 0));
            this.addComponent((Component)((Object)optionsDesc[i]), (Container)this.singleSelectPanel, gridbag0, c0, 1, 17, 0, i * 2 + 2, 0, 1, 1.0, 1.0, new Insets(2, 30, 0, 0));
            optionsDesc[i].setPreferredAspectRatio(15.0f);
            optionsDesc[i].setFont(new Font(OiixResourceBundle.getString((String)"oracle.sysman.oii.oiir.OiirRuntimeRes", (String)"S_DEFAULT_FONT"), 0, 11));
        }
    }

    public void createPanel0() {
        GridBagLayout gridBag1 = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        this.panel0 = new LWContainer();
        this.panel0.setLayout((LayoutManager)gridBag1);
        this.prompt0.setPreferredAspectRatio(15.0f);
        this.addComponent((Component)this.prompt0, (Container)this.panel0, gridBag1, c1, 2, 17, 0, 0, 1, 1, 1.0, 0.0, new Insets(0, 0, 0, 0));
    }

    public void createPanel1() {
        GridBagLayout gridbag0 = new GridBagLayout();
        GridBagConstraints c0 = new GridBagConstraints();
        this.panel1 = new LWContainer();
        this.panel1.setLayout((LayoutManager)gridbag0);
        this.addComponent((Component)this.singleSelectPanel, (Container)this.panel1, gridbag0, c0, 2, 17, 0, 0, 1, 1, 1.0, 1.0, new Insets(5, 0, 0, 0));
    }

    public void setPrompt0(String text) {
        if (text != null) {
            this.prompt0.setText(text);
        }
    }

    public String getPrompt0() {
        return this.prompt0.getText();
    }

    public void setOptions0(String[] list) {
        this.generateOptionsFromArray(list);
        this.createSingleSelectPanel(this.options, this.optionsDesc);
        this.options[0].setState(true);
    }

    public Integer getSelection() {
        for (int i = 0; i < this.options.length; ++i) {
            if (!this.options[i].getState()) continue;
            return new Integer(i + 1);
        }
        return new Integer(1);
    }

    public void setSelection(Integer index) {
        int idx = index;
        this.options[idx - 1].setState(true);
    }

    private void addComponent(Component src, Container dest, GridBagLayout gbl, GridBagConstraints gbc, int fill, int anchor, int x, int y, int w, int h, double weightx, double weighty, Insets insets) {
        gbc.fill = fill;
        gbc.anchor = anchor;
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.weightx = weightx;
        gbc.weighty = weighty;
        gbc.insets = insets;
        gbl.setConstraints(src, gbc);
        dest.add(src);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        DBConfig panel1 = new DBConfig();
        f.add((Component)((Object)panel1));
        f.setSize(630, 400);
        f.show();
    }
}

