/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipf.oipfc;

import java.util.Vector;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqEvent;
import oracle.sysman.oip.oipc.oipcp.OipcpPrereqProgress;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteCheck;
import oracle.sysman.oip.oipc.oipcp.OipcpPrerequisiteResult;
import oracle.sysman.oip.oipc.oipcu.OipcuPrereqProps;
import oracle.sysman.oip.oipf.oipfc.OipfcSilentModePrereqException;

public class OipfcSilentModeProgress
extends OipcpPrereqProgress {
    private static final String S_LINE_SEP = System.getProperty("line.separator", "\n");
    private int m_iFailures = 0;

    @Override
    public void initialize(OipcuPrereqProps oProps) {
        System.out.println(OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OIPCP0010"));
    }

    @Override
    public void onPrereqEvent(OipcpPrereqEvent oEvent) {
        switch (oEvent.getID()) {
            case 0: {
                Vector vChecks = (Vector)oEvent.getEventInfo();
                this.displaySessionStartProgress(vChecks);
                break;
            }
            case 1: {
                this.displaySessionEndProgress();
                break;
            }
            case 2: {
                OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                this.displayPrereqStartProgress(oCheck);
                break;
            }
            case 3: {
                OipcpPrerequisiteCheck oCheck = (OipcpPrerequisiteCheck)oEvent.getEventInfo();
                this.updateFailuresCount(oCheck);
                this.displayPrereqEndProgress(oCheck);
            }
        }
    }

    private void displaySessionStartProgress(Vector vChecks) {
        System.out.println("Total No of checks: " + vChecks.size() + "\n");
    }

    private void displaySessionEndProgress() {
        System.out.println("PrereqChecks complete\n");
    }

    private void displayPrereqStartProgress(OipcpPrerequisiteCheck oCheck) {
        System.out.println("Performing check for " + oCheck.getName());
        System.out.println(oCheck.getTitle());
    }

    private void displayPrereqEndProgress(OipcpPrerequisiteCheck oCheck) {
        OipcpPrerequisiteResult oResult = oCheck.getResult();
        System.out.println(oResult.getFormattedResultText());
        System.out.println("\nCheck complete: " + oResult.getResultText());
        if (!oResult.isSuccess()) {
            System.out.println(oCheck.getErrorText());
        }
        System.out.println("========================================================");
    }

    private void updateFailuresCount(OipcpPrerequisiteCheck oCheck) {
        OipcpPrerequisiteResult oResult = oCheck.getResult();
        int iResult = oResult.getResult();
        if (oCheck.isRequired() && iResult == 7) {
            ++this.m_iFailures;
        }
    }

    @Override
    public void waitForSessionEnd() throws OipfcSilentModePrereqException {
        if (this.m_iFailures > 0) {
            String sMsg = OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipcp.resources.OipcpRuntimeRes", (String)"OUI-62009");
            throw new OipfcSilentModePrereqException("OUI-62009", sMsg);
        }
    }
}

