/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipck;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import oracle.sysman.oii.oiix.OiixResourceBundle;
import oracle.sysman.oip.oipc.oipck.OipckIKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckIRefKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceInfo;
import oracle.sysman.oip.oipc.oipck.OipckKnowledgeSourceLibrary;
import oracle.sysman.oip.oipc.oipck.OipckRefKnowledgeSourceLibrary;
import oracle.sysman.oix.oixd.OixdDOMReader;
import oracle.sysman.oix.oixd.OixdInvalidDocumentException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class OipckKnowledgeSrcLibBuilder {
    private static final String S_SRC_LIST = "SOURCE_LIST";
    private static final String S_SOURCE = "SOURCE";
    private static final String S_SOURCE_NAME = "name";
    private static final String S_SOURCE_BUILDER = "builder";
    private static final String S_SOURCE_WRITER = "writer";
    private static final String S_SOURCE_ISREF = "ref";
    private OipckIKnowledgeSourceLibrary m_oKnowledgeSourceLibrary = null;
    private OipckIRefKnowledgeSourceLibrary m_oRefKnowledgeSourceLibrary = null;
    private Collection m_oFileNames = null;

    protected OipckKnowledgeSrcLibBuilder(Collection oFileNames) {
        this.m_oFileNames = oFileNames;
    }

    public static OipckKnowledgeSrcLibBuilder getLibraryBuilder(Collection oFileNames) {
        return new OipckKnowledgeSrcLibBuilder(oFileNames);
    }

    public void build() throws IOException, SAXException, ParserConfigurationException, OixdInvalidDocumentException {
        ArrayList oKnowledgeSourceInfoList = new ArrayList();
        for (String sFileName : this.m_oFileNames) {
            Document oDoc = OixdDOMReader.getDocument((String)sFileName);
            oKnowledgeSourceInfoList.addAll(this.build(oDoc, sFileName));
        }
        this.buildLibraries(oKnowledgeSourceInfoList);
    }

    private List build(Document oDoc, String sFileName) throws OixdInvalidDocumentException {
        ArrayList<OipckKnowledgeSourceInfo> oKnowledgeSourceInfoList = null;
        if (oDoc != null) {
            Element root = oDoc.getDocumentElement();
            if (!root.getTagName().equalsIgnoreCase(S_SRC_LIST)) {
                Object[] args = new String[]{sFileName};
                throw new OixdInvalidDocumentException("OUI-12011", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipck.resources.OipckRuntimeRes", (String)"OUI-12011", (Object[])args));
            }
            oKnowledgeSourceInfoList = new ArrayList<OipckKnowledgeSourceInfo>();
            NodeList oKnowledgeSrcNodes = root.getChildNodes();
            if (oKnowledgeSrcNodes != null) {
                int nKnowledgeSrcs = oKnowledgeSrcNodes.getLength();
                OipckKnowledgeSourceInfo oKnowledgeSrc = null;
                Node oAttrib = null;
                for (int i = 0; i < nKnowledgeSrcs; ++i) {
                    Node oKnowledgeSrcNode = oKnowledgeSrcNodes.item(i);
                    if (oKnowledgeSrcNode.getNodeType() != 1 || !oKnowledgeSrcNode.getNodeName().equalsIgnoreCase(S_SOURCE)) continue;
                    NamedNodeMap oKnowledgeSrcAttribs = oKnowledgeSrcNode.getAttributes();
                    String sName = null;
                    if (oKnowledgeSrcAttribs == null) {
                        Object[] args = new String[]{sFileName};
                        throw new OixdInvalidDocumentException("OUI-12012", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipck.resources.OipckRuntimeRes", (String)"OUI-12012", (Object[])args));
                    }
                    oKnowledgeSrc = new OipckKnowledgeSourceInfo();
                    oAttrib = oKnowledgeSrcAttribs.getNamedItem(S_SOURCE_NAME);
                    if (oAttrib == null) {
                        Object[] args = new String[]{sFileName};
                        throw new OixdInvalidDocumentException("OUI-12013", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipck.resources.OipckRuntimeRes", (String)"OUI-12013", (Object[])args));
                    }
                    sName = oAttrib.getNodeValue();
                    oKnowledgeSrc.setName(sName);
                    oAttrib = oKnowledgeSrcAttribs.getNamedItem(S_SOURCE_BUILDER);
                    if (oAttrib == null) {
                        Object[] args = new String[]{sFileName, sName};
                        throw new OixdInvalidDocumentException("OUI-12014", OiixResourceBundle.getString((String)"oracle.sysman.oip.oipc.oipck.resources.OipckRuntimeRes", (String)"OUI-12014", (Object[])args));
                    }
                    oKnowledgeSrc.setBuilder(oAttrib.getNodeValue());
                    boolean bRef = false;
                    oAttrib = oKnowledgeSrcAttribs.getNamedItem(S_SOURCE_ISREF);
                    if (oAttrib != null) {
                        String sRef = oAttrib.getNodeValue();
                        bRef = Boolean.valueOf(sRef);
                    }
                    oKnowledgeSrc.setReferenceSource(bRef);
                    if (!bRef && (oAttrib = oKnowledgeSrcAttribs.getNamedItem(S_SOURCE_WRITER)) != null) {
                        oKnowledgeSrc.setWriter(oAttrib.getNodeValue());
                    }
                    oKnowledgeSourceInfoList.add(oKnowledgeSrc);
                }
            }
        }
        return oKnowledgeSourceInfoList;
    }

    private void buildLibraries(List oKnowledgeSrcInfoLst) {
        if (oKnowledgeSrcInfoLst != null) {
            OipckKnowledgeSourceLibrary oKnowledgeSourceLibrary = new OipckKnowledgeSourceLibrary();
            OipckRefKnowledgeSourceLibrary oRefKnowledgeSourceLibrary = new OipckRefKnowledgeSourceLibrary();
            this.m_oKnowledgeSourceLibrary = oKnowledgeSourceLibrary;
            this.m_oRefKnowledgeSourceLibrary = oRefKnowledgeSourceLibrary;
            int nCount = oKnowledgeSrcInfoLst.size();
            for (int i = 0; i < nCount; ++i) {
                OipckKnowledgeSourceInfo ksi = (OipckKnowledgeSourceInfo)oKnowledgeSrcInfoLst.get(i);
                if (ksi.isReferenceSource()) {
                    oRefKnowledgeSourceLibrary.addKnowledgeSourceInfo(ksi);
                    continue;
                }
                oKnowledgeSourceLibrary.addKnowledgeSourceInfo(ksi);
            }
        }
    }

    public OipckIKnowledgeSourceLibrary getKnowledgeSourceLibrary() {
        return this.m_oKnowledgeSourceLibrary;
    }

    public OipckIRefKnowledgeSourceLibrary getRefKnowledgeSourceLibrary() {
        return this.m_oRefKnowledgeSourceLibrary;
    }
}

