/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.util.Vector;
import oracle.sysman.oii.oiil.OiilAction;
import oracle.sysman.oii.oiil.OiilActionException;
import oracle.sysman.oii.oiil.OiilActionInputElement;
import oracle.sysman.oii.oiil.OiilCommitException;
import oracle.sysman.oii.oiil.OiilDeinstallException;
import oracle.sysman.oii.oiil.OiilUndoException;
import oracle.sysman.oii.oiix.OiixInstantiateString;
import oracle.sysman.oii.oiix.OiixVectorOps;

public class setIniFile
implements OiilAction {
    private int index;
    private boolean variableFound = false;
    private boolean sectionFound = false;
    private String fileName;
    private String sectionName;
    private String variable;
    private String value;
    private String substr;
    private String line;
    private String content;
    private StringBuffer buf;
    private BufferedReader iniFile;

    public String getDescription(Vector inputs) {
        return "Set a variable value in INI file " + this.retItem(inputs, "FileName");
    }

    public void installAction(Vector inputs, Vector outLogObjects) throws OiilActionException {
        this.fileName = (String)this.retItem(inputs, "IniFileName");
        this.sectionName = (String)this.retItem(inputs, "SectionName");
        this.variable = (String)this.retItem(inputs, "VariableName");
        this.value = (String)this.retItem(inputs, "Value");
        try {
            File file = new File(this.fileName);
            if (!file.exists()) {
                RandomAccessFile newFile = new RandomAccessFile(this.fileName, "rw");
                newFile.close();
            }
            this.iniFile = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
            this.buf = new StringBuffer();
            while ((this.line = this.iniFile.readLine()) != null) {
                if (this.line.equals("")) {
                    this.buf.append(this.line);
                    continue;
                }
                if (this.line.equalsIgnoreCase("[" + this.sectionName + "]")) {
                    this.sectionFound = true;
                    this.buf.append(this.line + '\n');
                    this.line = this.iniFile.readLine();
                    while (this.line != null && !this.line.startsWith("[")) {
                        this.index = this.line.indexOf(61);
                        this.substr = this.line.substring(0, this.index);
                        if (this.variable.equalsIgnoreCase(this.substr)) {
                            this.buf.append(this.variable + "=" + this.value + '\n');
                            this.variableFound = true;
                            break;
                        }
                        this.buf.append(this.line + '\n');
                        this.line = this.iniFile.readLine();
                    }
                    if (!this.variableFound) {
                        this.buf.append(this.variable + "=" + this.value + '\n');
                    }
                }
                if (this.variableFound) {
                    this.variableFound = false;
                    continue;
                }
                if (this.line == null) break;
                this.buf.append(this.line + '\n');
            }
            if (!this.sectionFound) {
                this.buf.append("[" + this.sectionName + "]" + '\n');
                this.buf.append(this.variable + "=" + this.value + '\n');
            }
            this.iniFile.close();
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)));
            writer.write(this.buf.toString());
            writer.close();
        }
        catch (FileNotFoundException fnfe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "FileNotFoundException";
            String errString = OiActionIniRes.getString("FileNotFoundException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilActionException(exName, exString, severity);
        }
        catch (IOException ioe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "IOException";
            String errString = OiActionIniRes.getString("IOException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilActionException(exName, exString, severity);
        }
        catch (NullPointerException npe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "NullPointerException";
            String errString = OiActionIniRes.getString("NullPointerException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilActionException(exName, exString, severity);
        }
    }

    public void deinstallAction(Vector inputs, Vector inLogObjects) throws OiilDeinstallException {
        this.fileName = (String)this.retItem(inputs, "IniFileName");
        this.sectionName = (String)this.retItem(inputs, "SectionName");
        this.variable = (String)this.retItem(inputs, "VariableName");
        this.value = (String)this.retItem(inputs, "Value");
        boolean otherVariable = false;
        int sectionIndex = 0;
        String temp = "";
        this.variableFound = false;
        try {
            File file = new File(this.fileName);
            this.iniFile = new BufferedReader(new InputStreamReader(new FileInputStream(this.fileName)));
            this.buf = new StringBuffer();
            while ((this.line = this.iniFile.readLine()) != null) {
                if (this.line.equals("")) {
                    this.buf.append(this.line);
                    continue;
                }
                if (this.line.equalsIgnoreCase("[" + this.sectionName + "]")) {
                    sectionIndex = this.buf.length();
                    StringBuffer tempBuf = new StringBuffer();
                    tempBuf.append(this.line + '\n');
                    this.line = this.iniFile.readLine();
                    while (this.line != null && !this.line.startsWith("[")) {
                        this.index = this.line.indexOf(61);
                        this.substr = this.line.substring(0, this.index);
                        this.substr = this.substr.trim();
                        if (this.variable.equalsIgnoreCase(this.substr)) {
                            this.variableFound = true;
                        } else {
                            otherVariable = true;
                            tempBuf.append(this.line + '\n');
                        }
                        this.line = this.iniFile.readLine();
                    }
                    if (this.variableFound && !otherVariable) {
                        temp = this.buf.toString();
                        temp = temp.substring(0, sectionIndex);
                        this.buf.setLength(0);
                        this.buf.append(temp);
                    } else {
                        this.buf.append(tempBuf.toString());
                    }
                }
                if (this.variableFound) {
                    this.variableFound = false;
                }
                if (this.line == null) break;
                this.buf.append(this.line + '\n');
            }
            this.iniFile.close();
            if (this.buf.length() != 0) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(this.fileName)));
                writer.write(this.buf.toString());
                writer.close();
            } else {
                file.delete();
            }
        }
        catch (FileNotFoundException fnfe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "FileNotFoundException";
            String errString = OiActionIniRes.getString("FileNotFoundException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilDeinstallException(exName, exString, severity);
        }
        catch (IOException ioe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "IOException";
            String errString = OiActionIniRes.getString("IOException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilDeinstallException(exName, exString, severity);
        }
        catch (NullPointerException npe) {
            int severity = 2;
            String[] variables = new String[1];
            String[] values = new String[1];
            variables[0] = new String("%1%");
            values[0] = new String(this.fileName);
            String exName = "NullPointerException";
            String errString = OiActionIniRes.getString("NullPointerException_desc");
            String exString = OiixInstantiateString.processString((String)errString, (String[])variables, (String[])values);
            throw new OiilDeinstallException(exName, exString, severity);
        }
    }

    public static void main(String[] argv) {
        setIniFile obj = new setIniFile();
        Vector<OiilActionInputElement> inputs = new Vector<OiilActionInputElement>();
        Vector outlog = new Vector();
        String FileName = argv[0];
        String SectionName = argv[1];
        String VariableName = argv[2];
        String Value = argv[3];
        inputs.addElement(new OiilActionInputElement("IniFileName", (Object)FileName));
        inputs.addElement(new OiilActionInputElement("SectionName", (Object)SectionName));
        inputs.addElement(new OiilActionInputElement("VariableName", (Object)VariableName));
        inputs.addElement(new OiilActionInputElement("Value", (Object)Value));
        try {
            obj.deinstallAction(inputs, outlog);
        }
        catch (OiilDeinstallException oiilDeinstallException) {
            // empty catch block
        }
    }

    private Object retItem(Vector inputs, String param) {
        int pos = OiixVectorOps.vectIndexOf((Vector)inputs, (Object)param);
        if (pos == -1) {
            return null;
        }
        OiilActionInputElement aie = (OiilActionInputElement)inputs.elementAt(pos);
        return aie.getObject();
    }

    public void saveAndInstallAction(Vector inputs, Vector outLogObjects, Vector outBackupObjects) throws OiilActionException {
    }

    public void saveAndDeinstallAction(Vector inputs, Vector inLogObjects, Vector outLogObjects, Vector outBackupObjects) throws OiilDeinstallException {
    }

    public void undoInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilUndoException {
    }

    public void undoDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilUndoException {
    }

    public void commitInstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects, Vector outLogObjects) throws OiilCommitException {
    }

    public void commitDeinstallAction(Vector inputs, Vector inLogObjects, Vector inBackupObjects) throws OiilCommitException {
    }
}

