/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk.homecollection;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.opatch.Bug;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.opatchsdk.HomeCollectionHelper;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.homecollection.InstalledPatch;
import oracle.opatch.opatchsdk.homecollection.NGPatchInOH;
import oracle.opatch.opatchsdk.homecollection.PatchInOH;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledPatchesInventory {
    private String state = "State  0: InstalledPatchesInventory object created";
    private StringBuilder stateBuilder = new StringBuilder();
    private String oracleHomePath;
    private String invPtrLoc;

    public InstalledPatchesInventory(String oracleHomePath) throws OPatchException {
        this.stateBuilder.append(this.state + '\n');
        if (oracleHomePath == null || oracleHomePath.trim().length() == 0) {
            throw new IllegalArgumentException("Input argument error: Please provide valid oracle home location.");
        }
        this.oracleHomePath = oracleHomePath;
        this.invPtrLoc = oracleHomePath + File.separator + "oraInst.loc";
        this.state = "State 10: Oracle home path and invPtrLoc path set";
        this.stateBuilder.append(this.state + '\n');
        HomeCollectionHelper.loadInventory(oracleHomePath, this.invPtrLoc);
        this.state = "State 20: Oracle home inventory loaded";
        this.stateBuilder.append(this.state + '\n');
    }

    public List<PatchInOH> getInstalledActivePatches() throws OPatchException {
        OneOffEntry[] entriesList = HomeCollectionHelper.getInstalledActivePatches();
        ArrayList<PatchInOH> result = new ArrayList<PatchInOH>();
        for (OneOffEntry entry : entriesList) {
            NGPatchInOH patch = new NGPatchInOH.Builder(entry.getPatchID(), entry.getID(), entry.getAppliedDate()).description(entry.getPatchDesc()).build();
            result.add(patch);
        }
        Collections.sort(result);
        return result;
    }

    public InstalledPatch[] getInstalledPatches() throws OPatchException {
        this.state = "State 30: getInstalledPatched method called";
        this.stateBuilder.append(this.state + '\n');
        OneOffEntry[] entriesList = HomeCollectionHelper.getInstalledPatches();
        this.state = "State 40: Oneoff entries retrived from Oracle Home inventory";
        this.stateBuilder.append(this.state + '\n');
        ArrayList<InstalledPatch> result = new ArrayList<InstalledPatch>();
        for (OneOffEntry entry : entriesList) {
            String patchId = entry.getPatchID();
            if (entry.getIsComposite() && !entry.getActiveConstituent().equals(patchId)) continue;
            InstalledPatch patch = new InstalledPatch(patchId, entry.getPSENumber(), entry.getPatchLanguage(), entry.getAppliedDate().toString(), entry.getPatchDesc());
            this.state = "State 50: Patch " + patchId + " object created";
            this.stateBuilder.append('\n' + this.state + '\n');
            Bug[] bugs = entry.getBugsFixed();
            InstalledPatch.FixedBug[] bugList = new InstalledPatch.FixedBug[bugs.length];
            int i = 0;
            for (Bug bug : bugs) {
                bugList[i++] = new InstalledPatch.FixedBug(bug.getBugID(), bug.getDesc());
            }
            patch.addBugs(bugList);
            this.state = "State 60: Patch " + patchId + " bugList added";
            this.stateBuilder.append(this.state + '\n');
            PatchComponent[] comps = entry.getAllComponents();
            InstalledPatch.PatchComponent[] compList = new InstalledPatch.PatchComponent[comps.length];
            i = 0;
            for (PatchComponent comp : comps) {
                compList[i] = new InstalledPatch.PatchComponent(comp.getName(), comp.getVersion());
                PatchAction[] actions = comp.getAllActions();
                ArrayList<InstalledPatch.ComponentFile> compFiles = new ArrayList<InstalledPatch.ComponentFile>();
                for (PatchAction action : actions) {
                    compFiles.add(new InstalledPatch.ComponentFile(action.getParentFilePath(this.oracleHomePath), "n/a"));
                }
                compList[i].addComponentFiles(compFiles.toArray(new InstalledPatch.ComponentFile[compFiles.size()]));
                ++i;
            }
            patch.addComps(compList);
            this.state = "State 70: Patch " + patchId + " component list added";
            this.stateBuilder.append(this.state + '\n');
            result.add(patch);
            this.state = "State 80: Patch " + patchId + " object added to output list";
            this.stateBuilder.append(this.state + " ");
        }
        return result.toArray(new InstalledPatch[result.size()]);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("oracleHomePath: " + this.oracleHomePath + " ");
        sb.append("invPtrLoc: " + this.invPtrLoc + " ");
        sb.append("stateSeq: " + this.stateBuilder.toString() + " ");
        return sb.toString();
    }
}

