/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.regex.Pattern;
import oracle.opatch.BackupFailureException;
import oracle.opatch.ChecksumEntity;
import oracle.opatch.CopyAction;
import oracle.opatch.OPatchACL;
import oracle.opatch.OPatchEnv;
import oracle.opatch.OPatchOverCAS;
import oracle.opatch.OPatchSDK;
import oracle.opatch.OPatchSessionHelper;
import oracle.opatch.OneOffEntry;
import oracle.opatch.PatchAction;
import oracle.opatch.PatchComponent;
import oracle.opatch.PatchObject;
import oracle.opatch.SystemCall;
import oracle.opatch.ipm.IIPMReadServices;
import oracle.opatch.ipm.IPM;
import oracle.opatch.napplyhelper.NApplyDataSerializer;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchprereq.CheckNoOpPatchesOption;
import oracle.opatch.opatchprereq.PQSession;
import oracle.opatch.opatchprereq.PrereqAPI;
import oracle.opatch.opatchprereq.PrereqResult;
import oracle.opatch.opatchprereq.ProcessFileVersions;
import oracle.opatch.opatchsdk.FailedPrereqException;
import oracle.opatch.opatchsdk.IAnalysisReport;
import oracle.opatch.opatchsdk.OPatchAction;
import oracle.opatch.opatchsdk.OPatchAnalysisReport;
import oracle.opatch.opatchsdk.OPatchBackupFileNotFoundException;
import oracle.opatch.opatchsdk.OPatchComponent;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchCopyAction;
import oracle.opatch.opatchsdk.OPatchDeployAction;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchNApplyOptions;
import oracle.opatch.opatchsdk.OPatchNRollbackOptions;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchPatchLanguage;
import oracle.opatch.opatchsdk.OPatchPatchPrereq;
import oracle.opatch.opatchsdk.OPatchPatchType;
import oracle.opatch.opatchsdk.OPatchSnowballPatchingMode;
import oracle.opatch.opatchsdk.OPatchUtils;
import oracle.opatch.opatchutil.OUSession;
import oracle.opatch.ops.Feature;
import oracle.opatch.ops.OPS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OPatchTarget {
    public static final OPatchTarget HELP = new OPatchTarget();
    public static final int PASSED = 0;
    public static final int FAILED = 1;
    public static final int NOT_EXECUTED = 2;
    public static final String UNDEFINED_CHECKSUM = "-1";
    private static final String ID_OPTION = "-id";
    private static final String ID_FILE_OPTION = "-idfile";
    private static final String PATCH_BASE_FILE = "-phBaseFile";
    private static final String WORK_FILE = "SDKWork.txt";
    private static final String PREREQ_RESULT = "-prereq_result";
    protected static boolean isTargetInitialized;
    private OPatchContext context = null;
    private String lastTargetExeLogFile = "";
    private OPatchSnowballPatchingMode mode = null;

    private OPatchTarget() {
    }

    public OPatchSnowballPatchingMode getMode() {
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OPatchTarget(OPatchContext opatchContext) throws OPatchException {
        Class<OPatchTarget> clazz = OPatchTarget.class;
        synchronized (OPatchTarget.class) {
            block19: {
                if (opatchContext == null) {
                    throw new OPatchException("Argument OPatchContext <opatchContext> cannot be null.");
                }
                if (isTargetInitialized) {
                    throw new OPatchException("The target is already initialized for this context \"" + opatchContext.getOracleHome() + "\". Please reuse the same.");
                }
                this.context = opatchContext;
                String oracleHomePath = this.context.getOracleHome();
                OPatchEnv.setupPatchStorage((String)oracleHomePath);
                OPatchEnv.setOPatchSDKMode((boolean)true);
                boolean isCustom = false;
                if (OPatchEnv.getCustomLogDir() != null && !OPatchEnv.getCustomLogDir().equals("")) {
                    isCustom = true;
                }
                String workSheetPath = "";
                try {
                    if (OPatchEnv.getOhWritePermission()) {
                        try {
                            workSheetPath = OPatchTarget.getWorkSheet(oracleHomePath);
                            SystemCall.createNewFile((String)workSheetPath);
                        }
                        catch (Exception e) {
                            OPatchException oe = new OPatchException("Not able to create temporary file \"" + workSheetPath);
                            oe.setStackTrace(e.getStackTrace());
                            throw oe;
                        }
                    } else if (!isCustom) {
                        throw new OPatchException("This is a read-only Oracle Home. Please set custom scratch working directory and re-try");
                    }
                    Object var9_10 = null;
                    isTargetInitialized = true;
                }
                catch (Throwable throwable) {
                    Object var9_11 = null;
                    isTargetInitialized = true;
                    throw throwable;
                }
                try {
                    try {
                        OPatchSDK.initLogFileIfUninitialized((String)oracleHomePath);
                    }
                    catch (Exception e) {
                        if (OPatchEnv.isOPatchSDKMode()) {
                            try {
                                OPatchACL.invokeOLogger((Object)HELP, (String)"enableConsoleOutput", null);
                                throw new OPatchException(e.getMessage());
                            }
                            catch (Exception e1) {
                                throw new OPatchException(e1.getMessage());
                            }
                        }
                        Object var11_14 = null;
                        OPatchSDK.enableConsoleOutput();
                        break block19;
                    }
                    Object var11_13 = null;
                }
                catch (Throwable throwable) {
                    Object var11_15 = null;
                    OPatchSDK.enableConsoleOutput();
                    throw throwable;
                }
                OPatchSDK.enableConsoleOutput();
            }
            // ** MonitorExit[clazz] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void getFileVersions(HashMap<String, String> fileVersionMap) {
        block14: {
            StringBuffer timeMsg;
            OPatchUtils.disableConsoleOutput();
            OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getFileVersions(HashMap<String, String> fileVersionMap)");
            String oh = this.getContext().getOracleHome();
            Set<String> filePaths = fileVersionMap.keySet();
            Iterator<String> fileIter = filePaths.iterator();
            while (fileIter.hasNext()) {
                String path = fileIter.next();
                fileVersionMap.put(path, "");
                OLogger.debug((String)("Input: " + path));
            }
            OPatchEnv.setPrereqResult((String)OPatchTarget.getPrereqResultFileLoc(oh));
            boolean fvExist = ProcessFileVersions.existFvOh((String)oh);
            Map ohMap = new HashMap();
            if (fvExist) {
                try {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: cached OH file/version file exists, parse the file into HashMap. \n");
                    timeMsg = new StringBuffer("Begin Parse Cached Files");
                    OLogger.logTime((StringBuffer)timeMsg);
                    NApplyDataSerializer serializer = new NApplyDataSerializer();
                    ohMap = serializer.deserializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_oh.txt");
                    timeMsg = new StringBuffer("End Parse Cached Files");
                    OLogger.logTime((StringBuffer)timeMsg);
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Traverse OH file/version HashMap, update incoming fileVersionMap. \n");
                    timeMsg = new StringBuffer("Begin Search File Version");
                    OLogger.logTime((StringBuffer)timeMsg);
                    Set keys = ohMap.keySet();
                    for (String fileName : keys) {
                        String oldVersion;
                        int ret;
                        String fileVer = (String)ohMap.get(fileName);
                        if (!fileVersionMap.containsKey(fileName) || (ret = OPatchSessionHelper.isGreaterDecimal((String)(oldVersion = fileVersionMap.get(fileName)), (String)fileVer)) >= 0) continue;
                        fileVersionMap.put(fileName, fileVer);
                    }
                    timeMsg = new StringBuffer("End Search File Version");
                    OLogger.logTime((StringBuffer)timeMsg);
                }
                catch (Throwable t) {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Failed to get File Version from cached files, re-run regular process.");
                    OLogger.printStackTrace((Throwable)t);
                    fvExist = false;
                }
            }
            if (!fvExist) {
                try {
                    try {
                        timeMsg = new StringBuffer("Begin Load Inventory");
                        OLogger.logTime((StringBuffer)timeMsg);
                        IIPMReadServices readServices = this.getContext().loadInventory();
                        OneOffEntry[] installedOneOffs = readServices.getInstalledPatches();
                        timeMsg = new StringBuffer("End Load Inventory");
                        OLogger.logTime((StringBuffer)timeMsg);
                        timeMsg = new StringBuffer("Begin Search File Version");
                        OLogger.logTime((StringBuffer)timeMsg);
                        for (OneOffEntry myOneOff : installedOneOffs) {
                            PatchAction[] pa;
                            for (PatchAction paIndiv : pa = myOneOff.getPatchActions()) {
                                String oldVersion;
                                int ret;
                                CopyAction cp;
                                if (!(paIndiv instanceof CopyAction) || !(cp = (CopyAction)paIndiv).isSnowBallCopyAction()) continue;
                                String fileName = cp.getFilename();
                                String fileVer = cp.getFileVersion();
                                String logMesg = "file=" + fileName + ";fileVer=" + fileVer;
                                OLogger.debug((String)logMesg);
                                if (!fileVersionMap.containsKey(fileName) || (ret = OPatchSessionHelper.isGreaterDecimal((String)(oldVersion = fileVersionMap.get(fileName)), (String)fileVer)) >= 0) continue;
                                fileVersionMap.put(fileName, fileVer);
                            }
                        }
                        Object var26_31 = null;
                        timeMsg = new StringBuffer("End Search File Version");
                    }
                    catch (Throwable t) {
                        while (fileIter.hasNext()) {
                            String path = fileIter.next();
                            if (fileVersionMap.get(path) != "") continue;
                            fileVersionMap.put(path, null);
                        }
                        OLogger.logError((String)"OPatchTarget::getFileVersions", (Object[])new Object[]{"Can't get file version", t.getMessage()});
                        OLogger.printStackTrace((Throwable)t);
                        Object var26_32 = null;
                        timeMsg = new StringBuffer("End Search File Version");
                        OLogger.logTime((StringBuffer)timeMsg);
                        break block14;
                    }
                }
                catch (Throwable throwable) {
                    Object var26_33 = null;
                    timeMsg = new StringBuffer("End Search File Version");
                    OLogger.logTime((StringBuffer)timeMsg);
                    throw throwable;
                }
                OLogger.logTime((StringBuffer)timeMsg);
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getFileVersions(HashMap<String, String> fileVersionMap)");
        OPatchUtils.enableConsoleOutput();
    }

    public static int compareFileVersions(String firstVersion, String secondVersion) throws OPatchException {
        if (firstVersion != null && !Pattern.matches("^\\d+[.]\\d+|^$", firstVersion)) {
            throw new OPatchException("Invalid version " + firstVersion);
        }
        if (secondVersion != null && !Pattern.matches("^\\d+[.]\\d+|^$", secondVersion)) {
            throw new OPatchException("Invalid version " + secondVersion);
        }
        return OPatchSessionHelper.isGreaterDecimal((String)firstVersion, (String)secondVersion);
    }

    public synchronized OPatchPatch[] getPatchesToRollbackOnConflict() {
        OneOffEntry[] oneoff = OPatchEnv.getOneOffToRoll();
        if (oneoff == null) {
            return new OPatchPatch[0];
        }
        OPatchPatch[] op = new OPatchPatch[oneoff.length];
        for (int i = 0; i < oneoff.length; ++i) {
            op[i] = new OPatchPatch(oneoff[i]);
            op[i].setOracleHome(this.context.getOracleHome());
        }
        return op;
    }

    protected static String getWorkSheet(String oracleHomePath) {
        File workSheetFile;
        StringBuffer buff = new StringBuffer(OPatchEnv.getPatchStorageDirectoryPath((String)oracleHomePath));
        if (OPatchEnv.getCustomLogDir() != null && !OPatchEnv.getCustomLogDir().equals("")) {
            buff.setLength(0);
            buff.append(OPatchEnv.getCustomLogDir());
            buff.append(File.separator);
            buff.append("opatch");
        }
        if (!(workSheetFile = new File(buff.toString())).exists()) {
            workSheetFile.mkdirs();
        }
        buff.append(File.separator);
        buff.append(WORK_FILE);
        return buff.toString();
    }

    public static String getPrereqResultFileLoc(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("oneoffs");
        return buff.toString();
    }

    protected static String getCompsXMLLoc(String oracleHomePath) {
        StringBuffer buff = new StringBuffer(oracleHomePath);
        buff.append(File.separator);
        buff.append("inventory");
        buff.append(File.separator);
        buff.append("ContentsXML");
        buff.append(File.separator);
        buff.append("comps.xml");
        return buff.toString();
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset) throws OPatchException {
        int i;
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getInstalledPatches(String offset)");
        OPatchPatch[] installedPatches = this.context.getInstalledActivePatches();
        OPatchPatch[] inactivePatches = this.context.getInstalledInactivePatches();
        ArrayList<OPatchPatch> allPatches = new ArrayList<OPatchPatch>();
        for (i = 0; i < installedPatches.length; ++i) {
            allPatches.add(installedPatches[i]);
        }
        for (i = 0; i < inactivePatches.length; ++i) {
            allPatches.add(inactivePatches[i]);
        }
        OPatchPatch[] allPatchesArr = new OPatchPatch[allPatches.size()];
        allPatches.toArray(allPatchesArr);
        ArrayList<OPatchPatch> touchedPatches = new ArrayList<OPatchPatch>();
        for (int i2 = 0; i2 < allPatchesArr.length; ++i2) {
            if (!this.isFilePatched(allPatchesArr[i2], offset)) continue;
            touchedPatches.add(allPatchesArr[i2]);
        }
        Object[] touchedPatchArr = new OPatchPatch[touchedPatches.size()];
        touchedPatches.toArray(touchedPatchArr);
        Arrays.sort(touchedPatchArr);
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getInstalledPatches(String offset)");
        OPatchUtils.enableConsoleOutput();
        return touchedPatchArr;
    }

    private boolean isFilePatched(OPatchPatch patch, String offset) {
        try {
            OPatchAction[] oc = patch.getActions();
            for (int i = 0; i < oc.length; ++i) {
                OPatchCopyAction oca;
                String relativeFilePath;
                if (!(oc[i] instanceof OPatchCopyAction) || !OPatchUtils.compareFileOffsets(offset, relativeFilePath = (oca = (OPatchCopyAction)oc[i]).getRelativeChildPath(), this.context.getOracleHome())) continue;
                return true;
            }
            return false;
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return false;
        }
    }

    public synchronized String getChecksum(String offset, boolean fromInventory) throws OPatchException {
        String finalChecksum = UNDEFINED_CHECKSUM;
        try {
            boolean check;
            StringBuffer path = new StringBuffer(this.context.getOracleHome());
            path.append(File.separator);
            path.append(offset);
            File f = new File(path.toString());
            boolean bl = check = !f.exists() || f.exists() && f.isDirectory();
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            if (!fromInventory) {
                return OPatchTarget.getChecksum(f.getAbsolutePath());
            }
            OPatchPatch[] installPatches = this.getInstalledPatches(offset);
            if (installPatches.length == 0) {
                return UNDEFINED_CHECKSUM;
            }
            OPatchPatch latestPatch = installPatches[0];
            ChecksumEntity[] cke = latestPatch.getChecksumList();
            String canPath = f.getCanonicalPath();
            for (int i = 0; i < cke.length; ++i) {
                String computeFilePath = cke[i].getComputeFilePath();
                File fcompute = new File(computeFilePath);
                String computeCanPath = fcompute.getCanonicalPath();
                if (!canPath.equals(computeCanPath)) continue;
                finalChecksum = cke[i].getChecksum();
                break;
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return finalChecksum;
    }

    public static String getChecksum(String absoluteFileName) throws OPatchException {
        String checksum = "";
        try {
            boolean check;
            File f = new File(absoluteFileName);
            boolean bl = check = !f.exists() || f.exists() && f.isDirectory();
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            checksum = OPatchSessionHelper.computeChecksum((String)absoluteFileName);
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return checksum;
    }

    public synchronized String getChecksum(String fileOffset, OPatchPatch patch) throws OPatchException {
        String finalChecksum = UNDEFINED_CHECKSUM;
        try {
            boolean check;
            String oh = patch.getOracleHome();
            if (oh == null || oh.equals("")) {
                throw new OPatchException("The given OPatchPatch object is not an installed patch.");
            }
            ChecksumEntity[] cke = patch.getChecksumList();
            StringBuffer path = new StringBuffer(this.context.getOracleHome());
            path.append(File.separator);
            path.append(fileOffset);
            File f = new File(path.toString());
            boolean bl = check = !f.exists() || f.exists() && f.isDirectory();
            if (check) {
                return UNDEFINED_CHECKSUM;
            }
            String canPath = f.getCanonicalPath();
            for (int i = 0; i < cke.length; ++i) {
                String computeFilePath = cke[i].getComputeFilePath();
                File fcompute = new File(computeFilePath);
                String computeCanPath = fcompute.getCanonicalPath();
                if (!canPath.equals(computeCanPath)) continue;
                finalChecksum = cke[i].getChecksum();
                break;
            }
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        return finalChecksum;
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset, String patchID) throws OPatchException {
        OPatchPatch[] op = this.getInstalledPatches(offset);
        ArrayList<OPatchPatch> filteredPatches = new ArrayList<OPatchPatch>();
        for (int i = 0; i < op.length; ++i) {
            if (!op[i].getPatchId().equals(patchID)) continue;
            filteredPatches.add(op[i]);
        }
        Object[] newOP = new OPatchPatch[filteredPatches.size()];
        filteredPatches.toArray(newOP);
        Arrays.sort(newOP);
        return newOP;
    }

    public synchronized OPatchPatch[] getInstalledPatches(String offset, String patchID, String language) throws OPatchException {
        OPatchPatch[] patches = this.getInstalledPatches(offset);
        if (language == null) {
            language = "";
        }
        ArrayList<OPatchPatch> langPatches = new ArrayList<OPatchPatch>();
        String inputPatchID = patchID;
        for (int i = 0; i < patches.length; ++i) {
            Locale langLocale = patches[i].getPatchLanguage();
            String lang = OPatchPatchLanguage.getLanguageCode(langLocale);
            if (!language.equals("")) {
                if (!inputPatchID.equals(patches[i].getPatchId()) || !language.equals(lang)) continue;
                langPatches.add(patches[i]);
                continue;
            }
            if (!inputPatchID.equals(patches[i].getPatchId())) continue;
            langPatches.add(patches[i]);
        }
        if (langPatches.size() == 0) {
            return new OPatchPatch[0];
        }
        OPatchPatch[] langPatchArr = new OPatchPatch[langPatches.size()];
        langPatches.toArray(langPatchArr);
        return langPatchArr;
    }

    public synchronized FileInputStream getBackupFileStream(OPatchPatch patch, String offset) throws OPatchException, OPatchBackupFileNotFoundException {
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: getBackupFileStream(OPatchPatch patch,String offset)");
        try {
            String oracleHomePath = this.context.getOracleHome();
            String cookedPatchID = patch.getCookedPatchID();
            OPatchAction[] oc = patch.getActions();
            for (int j = 0; j < oc.length; ++j) {
                OPatchCopyAction oca;
                String relativeFilePath;
                if (!(oc[j] instanceof OPatchCopyAction) || !OPatchUtils.compareFileOffsets(offset, relativeFilePath = (oca = (OPatchCopyAction)oc[j]).getRelativeChildPath(), this.context.getOracleHome())) continue;
                String backupFile = oca.getBackupRollbackPath(oracleHomePath, cookedPatchID);
                File f = new File(backupFile);
                if (!f.exists()) {
                    throw new OPatchBackupFileNotFoundException("BackupFile path \"" + backupFile + "\" of patch \"" + patch.getPatchId() + "\" does not " + "exist.");
                }
                if (!f.canRead()) {
                    throw new OPatchException("BackupFile path \"" + backupFile + "\" of patch \"" + patch.getPatchId() + "\" cannot be " + "read.");
                }
                FileInputStream fin = new FileInputStream(f);
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: getBackupFileStream(OPatchPatch patch,String offset)");
                return fin;
            }
        }
        catch (OPatchBackupFileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        OPatchUtils.enableConsoleOutput();
        String msg = "Not able to find backup file for the input OPatchPatch object and the file offset.";
        throw new OPatchException(msg);
    }

    public synchronized FileInputStream getFileStream(OPatchPatch patch, String offset) throws OPatchException {
        try {
            OPatchPatch[] patches = this.getInstalledPatches(offset);
            for (int i = 0; i < patches.length; ++i) {
                if (!patch.equals(patches[i])) continue;
                if (i == 0) {
                    StringBuffer path = new StringBuffer(this.context.getOracleHome());
                    path.append(File.separator);
                    path.append(offset);
                    File f = new File(path.toString());
                    f = f.getCanonicalFile();
                    if (!f.exists()) {
                        System.out.println("Patched file does not exist");
                        return null;
                    }
                    if (f.exists() && !f.canRead()) {
                        throw new OPatchException("Patched file path \"" + path.toString() + "\" of patch \"" + patch.getPatchId() + "\" does not " + "exist (or) cannot be read.");
                    }
                    FileInputStream fin = new FileInputStream(f);
                    return fin;
                }
                return this.getBackupFileStream(patches[i - 1], offset);
            }
        }
        catch (IOException e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (OPatchException e) {
            throw e;
        }
        String msg = "Not able to find patched file for the input OPatchPatch object and the file offset.";
        throw new OPatchException(msg);
    }

    public synchronized boolean isPatchApplied(OPatchPatch patch) {
        try {
            int i;
            String uniqID = patch.getUniquePatchIdentifier();
            OPatchPatch[] installedPatches = this.getContext().getInstalledActivePatches();
            OPatchPatch[] inactivePatches = this.getContext().getInstalledInactivePatches();
            for (i = 0; i < installedPatches.length; ++i) {
                if (!patch.equals(installedPatches[i])) continue;
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isPatchApplied(OPatchPatch patch)");
                return true;
            }
            for (i = 0; i < inactivePatches.length; ++i) {
                if (!patch.equals(inactivePatches[i])) continue;
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: isPatchApplied(OPatchPatch patch)");
                return true;
            }
            return false;
        }
        catch (OPatchException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized OPatchAction[] getActionsThatCouldBeApplied(OPatchPatch patch) throws OPatchException {
        String oracleHomePath2;
        Vector<OPatchAction> validActions = new Vector<OPatchAction>();
        Vector<OPatchAction> finalActions = new Vector<OPatchAction>();
        try {
            try {
                OPatchCopyAction copyAct;
                if (this.isPatchApplied(patch)) {
                    throw new OPatchException("This API cannot be used for an installed patch. The input patch is already installed in the Oracle Home.");
                }
                PatchObject po = patch.po;
                Vector includedPC = new Vector();
                PrereqAPI.checkComponents((String)this.getOracleHome(), (PatchObject)po, includedPC);
                for (int i = 0; i < includedPC.size(); ++i) {
                    PatchComponent validPC = (PatchComponent)includedPC.get(i);
                    OPatchComponent oPC = new OPatchComponent(validPC);
                    OPatchAction[] oa = patch.getActions(oPC);
                    for (int j = 0; j < oa.length; ++j) {
                        validActions.add(oa[j]);
                    }
                }
                HashMap ohMap = new HashMap();
                OPatchEnv.setPrereqResult((String)OPatchTarget.getPrereqResultFileLoc(this.getOracleHome()));
                boolean fvExist = ProcessFileVersions.existFvOh((String)this.getOracleHome());
                if (fvExist) {
                    try {
                        NApplyDataSerializer serializer = new NApplyDataSerializer();
                        ohMap = new HashMap(serializer.deserializeFileVersion(OPatchEnv.getPrereqResult() + File.separator + "fv_oh.txt"));
                        if (patch.getPatchType() == OPatchPatchType.SNOWBALL) {
                            for (int i = 0; i < validActions.size(); ++i) {
                                OPatchAction act = (OPatchAction)validActions.get(i);
                                if (!(act instanceof OPatchCopyAction)) continue;
                                copyAct = (OPatchCopyAction)act;
                                if (!PrereqAPI.checkFileVersion((String)this.getOracleHome(), (CopyAction)copyAct.getCopyAction(), ohMap)) continue;
                                finalActions.add(act);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        fvExist = false;
                    }
                }
                if (!fvExist) {
                    Map m = PrereqAPI.getCopyActionMap((String)this.getOracleHome());
                    if (patch.getPatchType() == OPatchPatchType.SNOWBALL) {
                        for (int i = 0; i < validActions.size(); ++i) {
                            OPatchAction act = (OPatchAction)validActions.get(i);
                            if (!(act instanceof OPatchCopyAction)) continue;
                            copyAct = (OPatchCopyAction)act;
                            if (!PrereqAPI.checkFileVersion((String)this.getOracleHome(), (CopyAction)copyAct.getCopyAction(), (Map)m)) continue;
                            finalActions.add(act);
                        }
                    }
                }
                Object var13_22 = null;
                oracleHomePath2 = this.context.getOracleHome();
            }
            catch (Throwable e) {
                OPatchException oe = new OPatchException(e.getMessage());
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
        }
        catch (Throwable throwable) {
            Object var13_23 = null;
            String oracleHomePath2 = this.context.getOracleHome();
            try {
                if (oracleHomePath2.equals("")) throw throwable;
                OPatchUtils.unlockHome(oracleHomePath2);
                throw throwable;
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath2 + "\"" + "after read operation by API \"getActionsThatCouldBeApplied\"";
                OPatchException oe = new OPatchException(errorMsg);
                oe.setStackTrace(t.getStackTrace());
                throw oe;
            }
        }
        try {}
        catch (Throwable t) {
            String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath2 + "\"" + "after read operation by API \"getActionsThatCouldBeApplied\"";
            OPatchException oe = new OPatchException(errorMsg);
            oe.setStackTrace(t.getStackTrace());
            throw oe;
        }
        if (!oracleHomePath2.equals("")) {
            OPatchUtils.unlockHome(oracleHomePath2);
        }
        OPatchAction[] finalAct = new OPatchAction[finalActions.size()];
        finalActions.toArray(finalAct);
        return finalAct;
    }

    public synchronized void cleanupPatchStorage(boolean cleanupRollbackArea) throws OPatchException {
        try {
            try {
                OPatchContext oc = this.getContext();
                String oh = this.getOracleHome();
                OPatchUtils.disableConsoleOutput();
                OPatchACL.setSilent((Object)oc, (boolean)true);
                OUSession.cleanup((String)oh);
                if (cleanupRollbackArea) {
                    int i;
                    int i2;
                    OPatchPatch[] activePatches = oc.getInstalledActivePatches();
                    OPatchPatch[] inactivePatches = oc.getInstalledInactivePatches();
                    OPatchPatch[] allPatches = new OPatchPatch[(activePatches != null ? activePatches.length : 0) + (inactivePatches != null ? inactivePatches.length : 0)];
                    for (i2 = 0; i2 < activePatches.length; ++i2) {
                        allPatches[i2] = activePatches[i2];
                    }
                    for (i2 = 0; i2 < inactivePatches.length; ++i2) {
                        allPatches[allPatches.length - i2 - 1] = inactivePatches[i2];
                    }
                    File f = new File(OPatchEnv.getPatchStorageDirectoryPath((String)oh));
                    String[] elements = f.list();
                    ArrayList<String> allDirs = new ArrayList<String>();
                    ArrayList<String> noDeleteDirs = new ArrayList<String>();
                    String patchStorageDir = OPatchEnv.getPatchStorageDirectoryPath((String)oh);
                    for (i = 0; i < elements.length; ++i) {
                        String dirPath = patchStorageDir + File.separator + elements[i];
                        File fDir = new File(dirPath);
                        if (!fDir.isDirectory()) continue;
                        allDirs.add(dirPath);
                    }
                    for (i = 0; i < allPatches.length; ++i) {
                        String cookedPatchID = allPatches[i].getCookedPatchID();
                        String dirPath = patchStorageDir + File.separator + cookedPatchID;
                        noDeleteDirs.add(dirPath);
                    }
                    allDirs.removeAll(noDeleteDirs);
                    for (i = 0; i < allDirs.size(); ++i) {
                        String dirToDelete = (String)allDirs.get(i);
                        OPatchSessionHelper.deleteRecurse((String)dirToDelete);
                    }
                }
                Object var16_18 = null;
            }
            catch (IllegalAccessException e) {
                throw new OPatchException(e.getMessage());
            }
            catch (OPatchException e) {
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void apply(OPatchPatch patch) throws OPatchException {
        OPatchUtils.disableConsoleOutput();
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: apply(OPatchPatch patch)");
        try {
            try {
                if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                    OPatchEnv.setBranchKey((String)"SDK");
                    if (!this.canSkipCasPhase1()) {
                        OLogger.printlnOnLogAndVerbose((String)"SDK NApply::CAS Phase1 is not executed, re-run phase1.");
                        OPatchEnv.setCASPhase1();
                        OPatchPatch[] patches = new OPatchPatch[]{patch};
                        OPatchOverCAS.INSTANCE.serializeData(this.getOracleHome(), patches);
                    }
                    OPatchEnv.setCASPhase2();
                }
                OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
                OUSession.resetPHBaseDir();
                OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
                StringBuffer cmdOptionStr = new StringBuffer("");
                if (patch == null) {
                    throw new OPatchException("Input OPatchPatch cannot be null. Please have a proper OPatchPatch object.");
                }
                cmdOptionStr.append(patch.getPatchLocation());
                cmdOptionStr.append(" ");
                cmdOptionStr.append(this.context.getOtherArgs());
                OPatchDeployAction.resetCopyVerHashMap();
                try {
                    OPatchSDK.apply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                    Object var4_5 = null;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    try {
                        OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: apply(OPatchPatch patch)");
                    }
                    catch (OPatchException oPatchException) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                    OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: apply(OPatchPatch patch)");
                }
                catch (OPatchException oPatchException) {}
                Object var7_12 = null;
            }
            catch (Exception e) {
                OPatchException oe = new OPatchException(e.getMessage());
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
            catch (Throwable e) {
                OPatchException oe = new OPatchException(e.getMessage());
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
        }
        catch (Throwable throwable) {
            Object var7_13 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void rollback(OPatchPatch patch) throws OPatchException {
        try {
            StringBuffer cmdOptionStr = new StringBuffer("");
            if (patch == null) {
                throw new OPatchException("Input OPatchPatch cannot be null. Please have a proper OPatchPatch object.");
            }
            cmdOptionStr.append(ID_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(patch.getPatchLanguageId());
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.rollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                Object var4_5 = null;
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException oPatchException) {}
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(OPatchPatch[] patches, boolean skipConflict, boolean forceConflict) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(OPatchPatch[] patches,boolean skipConflict, boolean forceConflict)");
        try {
            if (skipConflict && forceConflict) {
                throw new OPatchException("OPatch does not allow 'skipConflict' & 'forceConflict' to be given together as 'true'.");
            }
            if (skipConflict) {
                this.getContext().skipConflict = true;
            }
            if (forceConflict) {
                this.getContext().forceConflict = true;
            }
            this.NApply(patches);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(OPatchPatch[] patches,boolean skipConflict, boolean forceConflict)");
            this.getContext().skipConflict = false;
            this.getContext().forceConflict = false;
            throw throwable;
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(OPatchPatch[] patches,boolean skipConflict, boolean forceConflict)");
        this.getContext().skipConflict = false;
        this.getContext().forceConflict = false;
    }

    private synchronized boolean canSkipCasPhase1() {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        OPatchEnv.setPrereqResult((String)OPatchTarget.getPrereqResultFileLoc(this.getOracleHome()));
        boolean done = false;
        try {
            done = serializer.deserializeCASNapplyStatus(OPatchEnv.getPrereqResult() + File.separator + "cas_napply.txt");
        }
        catch (IOException e) {
            OLogger.printlnOnLog((String)"OPatch failed to parse cas_napply.txt");
            done = false;
        }
        return done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(OPatchPatch[] patches) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(OPatchPatch[] patches)");
        try {
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                OPatchEnv.setBranchKey((String)"SDK");
                if (!this.canSkipCasPhase1()) {
                    OLogger.printlnOnLogAndVerbose((String)"SDK NApply::CAS Phase1 is not executed, re-run phase1.");
                    OPatchEnv.setCASPhase1();
                    OPatchOverCAS.INSTANCE.serializeData(this.getOracleHome(), patches);
                }
                OPatchEnv.setCASPhase2();
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            String prereqResultFileLoc = OPatchTarget.getPrereqResultFileLoc(this.getOracleHome());
            File wsObj = new File(workSheetLoc);
            FileWriter fw = new FileWriter(wsObj);
            PrintWriter pw = new PrintWriter(fw);
            for (int i = 0; i < patches.length; ++i) {
                String patchLocation = patches[i].getPatchLocation();
                pw.println(patchLocation);
            }
            pw.flush();
            fw.close();
            pw.close();
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                try {
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException oPatchException) {}
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(OPatchPatch[] patches)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NRollback(OPatchPatch[] patches) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollback(OPatchPatch[] patches)");
        try {
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            File wsObj = new File(workSheetLoc);
            FileWriter fw = new FileWriter(wsObj);
            PrintWriter pw = new PrintWriter(fw);
            for (int i = 0; i < patches.length; ++i) {
                String patchID = patches[i].getPatchLanguageId();
                pw.println(patchID);
            }
            pw.flush();
            fw.close();
            pw.close();
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                Object var10_13 = null;
            }
            catch (Throwable throwable) {
                Object var10_14 = null;
                try {
                    OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollback(OPatchPatch[] patches)");
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollback(OPatchPatch[] patches)");
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException oPatchException) {}
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public synchronized String getLastSessionLogFile() {
        if (!this.lastTargetExeLogFile.equals("")) {
            return this.lastTargetExeLogFile;
        }
        String defaultLogfileLocation = OPatchSDK.getCurrentOPatchSessionLogFile((String)this.getOracleHome());
        if (defaultLogfileLocation == null) {
            return null;
        }
        File logfile = new File(defaultLogfileLocation);
        if (!logfile.exists() || logfile.length() == 0L) {
            defaultLogfileLocation = null;
        }
        return defaultLogfileLocation;
    }

    public String getOracleHome() {
        return this.context.getOracleHome();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.context.toString());
        return sb.toString();
    }

    private synchronized StatusCheck prereqResultToInt(PrereqResult pRes) {
        int i = 0;
        if (pRes == null || pRes.getResult() == null) {
            i = 2;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
            i = 1;
        } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
            i = 2;
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (readServices.isLocked()) {
                readServices.release();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        StatusCheck sc = new StatusCheck(i, pRes.toString());
        return sc;
    }

    private synchronized StatusCheck prereqResultArrayListToInt(ArrayList resultsArray) {
        boolean isNotExecuted = false;
        Iterator itr = resultsArray.iterator();
        boolean neCount = false;
        boolean fCount = false;
        int combinedStatus = 0;
        StringBuffer buff = new StringBuffer("");
        boolean failStatus = false;
        boolean notExecutedStatus = false;
        if (resultsArray.size() == 0) {
            notExecutedStatus = true;
        }
        while (itr.hasNext()) {
            PrereqResult pRes = (PrereqResult)itr.next();
            if (pRes == null || pRes.getResult() == null) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.FAILED) {
                failStatus = true;
            } else if (pRes.getResult() == PrereqResult.ExecuteStatus.NOT_EXECUTED) {
                notExecutedStatus = true;
            }
            buff.append(pRes.toString());
        }
        if (failStatus) {
            combinedStatus = 1;
        } else if (notExecutedStatus) {
            combinedStatus = 2;
        }
        IIPMReadServices readServices = IPM.INSTANCE.getReadServices();
        try {
            if (readServices.isLocked()) {
                readServices.release();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        StatusCheck sc = new StatusCheck(combinedStatus, buff.toString());
        return sc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkActiveFilesAndExecutables() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkActiveFilesAndExecutablesAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Exception e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkActiveServices() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkActiveServices((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkApplicable() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkApplicableAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Exception e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkCentralInventoryForOH() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkCentralInventoryForOH((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkCentralInventoryForRWSession() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkCentralInventoryForRWSession((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkCentralInventoryLocation() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkCentralInventoryLocationAndPrint());
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkConflictAgainstOH() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            statusCheck = this.prereqResultToInt(PQSession.checkConflictAgainstOHWithDetailAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Exception e) {
            StatusCheck statusCheck2;
            try {
                OLogger.printStackTrace((Throwable)e);
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkConflictAmongPatches() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            statusCheck = this.prereqResultToInt(PQSession.checkConflictAmongPatchesAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Exception e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkIfOHLockedForPatching() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkIfOHLockedForPatching((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkInstalledOneOffs() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkInstalledOneOffsAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOracleHome() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkOracleHome((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOraInstLocation() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkOraInstLocation((String)this.context.getInvPtrLocation()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOUILocation() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkOUILocation((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOUIVersionCompatible() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkOUIVersionCompatible((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchApplicableOnCurrentPlatform() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchApplicableOnCurrentPlatformAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchApplyDependents() throws OPatchException {
        StatusCheck statusCheck;
        String beaHomePath = this.getContext().getBeaHomePath();
        if (beaHomePath != null && !beaHomePath.equals("")) {
            File f = null;
            try {
                f = new File(beaHomePath);
            }
            catch (NullPointerException e) {
                OPatchException oe = new OPatchException("Argument for BEA Home is null");
                oe.setStackTrace(e.getStackTrace());
                throw oe;
            }
            if (f.isAbsolute() && f.isDirectory() && f.canRead()) {
                OPatchEnv.setBeaHomePath((String)beaHomePath);
                OPatchEnv.setBeaHome((boolean)true);
            } else {
                throw new OPatchException("Invalid argument beaHomePath. Possible causes are: beaHomePath is not an absolute path, beaHomePath is not a path to a directory, beaHomePath is not readable. ");
            }
        }
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchApplyDependentsAndPrint((String)this.context.getOracleHome()));
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchRollbackDependents() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchRollbackDependentsAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchShipHome() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkPatchShipHomeAndPrint());
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkRequiredLibs() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkRequiredLibsAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkRollbackable() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkRollbackableAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkSystemCommandAvailable() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkSystemCommandAvailableAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkSystemSpace() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkSystemSpaceAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkUserAdminPrivilege() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PrereqAPI.checkUserAdminPrivilege((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkMinimumOpatchVersion() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkMinimumOpatchVersionAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkComponents() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultArrayListToInt(PQSession.checkComponentsAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkOneoffSuperset() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkOneoffSupersetAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkPatchingModel() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkPatchingModelAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck canApplyThisPatch(OPatchPatch patch) throws OPatchException {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchPatch[] patches = this.getContext().getPrereqPatches();
            this.getContext().setPrereqPatchesToTest(new OPatchPatch[]{patch}, true);
            PrereqResult presult = PQSession.checkPatchingModelAndPrint((String)this.context.getOracleHome());
            this.getContext().setPrereqPatchesToTest(patches, true);
            statusCheck = this.prereqResultToInt(presult);
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForNooppatches() {
        StatusCheck statusCheck;
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: checkForNooppatches()");
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkForNooppatchesAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: checkForNooppatches()");
            throw throwable;
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: checkForNooppatches()");
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForNooppatches(CheckNoOpPatchesOption option) {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkForNooppatchesAndPrint((String)this.context.getOracleHome(), (CheckNoOpPatchesOption)option));
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForIdenticalPatchInOracleHome() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            OPatchEnv.setSessionType((String)"prereq");
            statusCheck = this.prereqResultToInt(PQSession.checkForIdenticalPatchInOracleHomeAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkFusionAppsCompatible() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkFusionAppsCompatibleAndPrint((String)this.context.getOracleHome()));
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            OPatchUtils.enableConsoleOutput();
            throw throwable;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized StatusCheck checkForInputValues() {
        StatusCheck statusCheck;
        try {
            OPatchUtils.disableConsoleOutput();
            statusCheck = this.prereqResultToInt(PQSession.checkForInputValuesAndPrint((String)this.context.getOracleHome()));
            Object var4_3 = null;
        }
        catch (Throwable e) {
            StatusCheck statusCheck2;
            try {
                statusCheck2 = new StatusCheck(2, e.getMessage());
                Object var4_4 = null;
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                OPatchUtils.enableConsoleOutput();
                throw throwable;
            }
            OPatchUtils.enableConsoleOutput();
            return statusCheck2;
        }
        OPatchUtils.enableConsoleOutput();
        return statusCheck;
    }

    private void throwThrowableOnFail(boolean needThrowThrowableOnFirstFail, OPatchPatchPrereq prereqObject, StatusCheck checkResult, HashMap validationResult) throws FailedPrereqException {
        if (needThrowThrowableOnFirstFail && checkResult.getStatusCode() == 1) {
            throw new FailedPrereqException("Prerequisite " + prereqObject.toString() + " failed.");
        }
        validationResult.put(prereqObject, checkResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized HashMap runAllRollbackPrereqs(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        Throwable th;
        HashMap prereqResults;
        block13: {
            OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
            String oh = this.getContext().getOracleHome();
            prereqResults = new HashMap();
            th = null;
            if (prereqPatches == null || prereqPatches.length == 0) {
                throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for rollback pre-requisites.");
            }
            try {
                try {
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_INSTALLED_ONE_OFFS, this.checkInstalledOneOffs(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, this.checkFusionAppsCompatible(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_ROLLBACK_DEPENDENTS, this.checkPatchRollbackDependents(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ROLLBACKABLE, this.checkRollbackable(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, this.checkCentralInventoryForOH(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, this.checkCentralInventoryForRWSession(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, this.checkCentralInventoryLocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, this.checkOracleHome(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, this.checkOraInstLocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_LOCATION, this.checkOUILocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, this.checkOUIVersionCompatible(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, this.checkUserAdminPrivilege(), prereqResults);
                }
                catch (Throwable t) {
                    th = t;
                    Object var8_7 = null;
                    if (th != null) {
                        OLogger.printStackTrace((Throwable)new RuntimeException(th));
                    }
                    if (prereqResults != null) {
                        OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Rollback Prerequisite checks status -------\n ");
                        OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                    }
                    if (th != null) {
                        throw th;
                    }
                    return prereqResults;
                }
                Object var8_6 = null;
                if (th == null) break block13;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (th != null) {
                    OLogger.printStackTrace((Throwable)new RuntimeException(th));
                }
                if (prereqResults != null) {
                    OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Rollback Prerequisite checks status -------\n ");
                    OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                }
                if (th != null) {
                    throw th;
                }
                return prereqResults;
            }
            OLogger.printStackTrace((Throwable)new RuntimeException(th));
        }
        if (prereqResults != null) {
            OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Rollback Prerequisite checks status -------\n ");
            OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
        }
        if (th != null) {
            throw th;
        }
        return prereqResults;
    }

    private synchronized void backupForRollbackForTwoPhase() {
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        String oh = this.getContext().getOracleHome();
        OPatchPatch[] patches = this.getContext().getPrereqPatches();
        try {
            String[] noopPatchIDs = serializer.deserializeNoOpCheckResult(OPatchEnv.getPrereqResult() + File.separator + "pi_noOps.txt");
            for (OPatchPatch patch : patches) {
                if (OPatchUtils.checkNoOpId(noopPatchIDs, patch)) continue;
                PatchObject po = patch.po;
                try {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Start back up files for system roll-back. ");
                    po.backupForRollback(oh, "ApplySession");
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: End back up files for system roll-back. ");
                }
                catch (RuntimeException e) {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: backupForRollback() throws RuntimeException. ");
                    BackupFailureException b1 = new BackupFailureException(e.getMessage(), e.getCause());
                    b1.setStackTrace(e.getStackTrace());
                    throw b1;
                }
            }
            OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Save backupForRollback status (true) into disk. ");
            serializer.serializeBackUpStatus(OPatchEnv.getPrereqResult() + File.separator + "do_backup.txt", "true");
        }
        catch (Throwable t) {
            OLogger.printStackTrace((Throwable)t);
            try {
                serializer.serializeBackUpStatus(OPatchEnv.getPrereqResult() + File.separator + "do_backup.txt", "false");
            }
            catch (IOException e) {
                OLogger.printlnOnLog((String)"OPatch failed to store do_backup.txt");
            }
        }
    }

    private synchronized boolean canSkipPrereqChecks() {
        ProcessFileVersions proc = new ProcessFileVersions();
        String oh = this.getContext().getOracleHome();
        OPatchEnv.setPrereqResult((String)OPatchTarget.getPrereqResultFileLoc(oh));
        OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
        OneOffEntry[] pohs = new OneOffEntry[]{};
        OneOffEntry[] pis = new OneOffEntry[prereqPatches.length];
        for (int i = 0; i < prereqPatches.length; ++i) {
            OneOffEntry pi;
            pis[i] = pi = prereqPatches[i].patch;
        }
        try {
            pohs = PrereqAPI.getInstalledOneOff((String)oh);
        }
        catch (Throwable e) {
            OLogger.printlnOnLog((String)"Converting Throwable to RuntimeException");
            RuntimeException re = new RuntimeException(e.getMessage());
            re.setStackTrace(e.getStackTrace());
            return false;
        }
        boolean b1 = proc.validateResult(oh, pohs, pis);
        File pr = new File(OPatchEnv.getPrereqResult() + File.separator + "prereq_result.txt");
        boolean b2 = pr.exists();
        return b1 && b2;
    }

    public synchronized boolean checkPrereqResults(HashMap prereqResults) {
        for (Map.Entry entry : prereqResults.entrySet()) {
            StatusCheck re = (StatusCheck)entry.getValue();
            if (re.getStatusCode() == 0) continue;
            return false;
        }
        return true;
    }

    public synchronized HashMap runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode) throws FailedPrereqException, Throwable {
        boolean skipCasNapply;
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode)");
        String oh = this.getContext().getOracleHome();
        HashMap prereqResults = new HashMap();
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        boolean skipPrereq = this.canSkipPrereqChecks();
        OPatchEnv.setPrereqResult((String)OPatchEnv.getPrereqResultFileLoc((String)this.getOracleHome()));
        if (skipPrereq) {
            try {
                prereqResults = serializer.deserializePrereqResult(OPatchEnv.getPrereqResult() + File.separator + "prereq_result.txt");
                if (prereqResults != null) {
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Skip prereq checks, re-use cached prereq results. \n");
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Re-run prereq checks that relate to active file/active services. \n");
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
                    OLogger.printlnOnLogAndVerbose((String)"FA_TWO_PHASE: Finish all prereq checks. \n");
                    OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                    OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                } else {
                    skipPrereq = false;
                }
            }
            catch (Throwable t) {
                OLogger.printlnOnLog((String)"OPatch failed to parse prereq_result.txt, re-run all prereq checks");
                skipPrereq = false;
            }
        }
        if (!skipPrereq) {
            OPatchEnv.setFATwoPhase();
            prereqResults = this.runAllApplyPrereqs(needThrowThrowableOnFirstFail);
            try {
                serializer.serializePrereqResult(OPatchEnv.getPrereqResult() + File.separator + "prereq_result.txt", prereqResults);
            }
            catch (IOException e) {
                OLogger.printlnOnLog((String)"OPatch failed to store prereq_result.txt");
            }
            OPatchEnv.unsetFATwoPhase();
        }
        boolean bl = skipCasNapply = skipPrereq && this.canSkipCasPhase1();
        if (!skipCasNapply && OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS) && this.checkIfPrereqsPassed(prereqResults)) {
            OLogger.printlnOnLogAndVerbose((String)"runAllApplyPrereqs:: run CAS NApply phase1 to shadow OH");
            this.runCASNApply();
            OPatchEnv.unsetCASPhase1();
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail, OPatchSnowballPatchingMode mode)");
        return prereqResults;
    }

    private synchronized boolean checkIfPrereqsPassed(HashMap prereqResults) {
        OLogger.printlnOnLogAndVerbose((String)"checkIfPrereqsPassed:: check if all prereqs passed.");
        for (OPatchPatchPrereq key : prereqResults.keySet()) {
            StatusCheck statusCheck;
            if (key.equals(OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES) || key.equals(OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES) || (statusCheck = (StatusCheck)prereqResults.get(key)).getStatusCode() != 1) continue;
            StringBuffer tBuff = new StringBuffer("This prereq: ");
            tBuff.append(key.toString());
            tBuff.append(" failed. OPatch won't run CAS napply phase1. ");
            OLogger.printlnOnLogAndVerbose((String)tBuff.toString());
            return false;
        }
        return true;
    }

    private synchronized void runCASNApply() {
        OLogger.printlnOnLogAndVerbose((String)"runCASNApply:: OPatch SDK calls CAS NApply phase1");
        NApplyDataSerializer serializer = new NApplyDataSerializer();
        String oh = this.getContext().getOracleHome();
        String logFile = "";
        this.lastTargetExeLogFile = "";
        OPatchPatch[] patches = this.getContext().getPrereqPatches();
        try {
            this.lastTargetExeLogFile = logFile;
            String workSheetLoc = OPatchTarget.getWorkSheet(oh);
            OLogger.printlnOnLogAndVerbose((String)("runCASNApply:: Get worksheetloc for incoming patches from " + workSheetLoc));
            File wsObj = new File(workSheetLoc);
            FileWriter fw = new FileWriter(wsObj);
            PrintWriter pw = new PrintWriter(fw);
            for (int i = 0; i < patches.length; ++i) {
                String patchLocation = patches[i].getPatchLocation();
                OLogger.printlnOnLogAndVerbose((String)("runCASNApply:: This incoming patch is " + patchLocation));
                pw.println(patchLocation);
            }
            pw.flush();
            fw.close();
            pw.close();
            OUSession.setPatchBaseFile((String)workSheetLoc);
            try {
                OLogger.printlnOnLogAndVerbose((String)"runCASNApply:: serialize current OH and pi status, and run napply phase1");
                OPatchEnv.setBranchKey((String)"SDK");
                OPatchOverCAS.INSTANCE.serializeData(oh, patches);
                OPatchOverCAS.INSTANCE.prepareSnowballPatching();
            }
            catch (Throwable e) {
                OLogger.printlnOnLog((String)"napply phase1 in validation fails");
                e.printStackTrace();
                throw e;
            }
            serializer.serializeCASNapplyStatus(OPatchEnv.getPrereqResult() + File.separator + "cas_napply.txt", "true");
            OLogger.printlnOnLogAndVerbose((String)"runCASNApply: Saved CAS Napply status (true) into disk, finished CAS Phase1. ");
        }
        catch (Throwable t) {
            OLogger.printStackTrace((Throwable)t);
            try {
                serializer.serializeCASNapplyStatus(OPatchEnv.getPrereqResult() + File.separator + "cas_napply.txt", "false");
            }
            catch (IOException e) {
                OLogger.printlnOnLog((String)"OPatch failed to store cas_napply.txt");
            }
        }
    }

    private void print(HashMap PR) {
        for (Object prereqname : PR.keySet()) {
            OPatchPatchPrereq pr = (OPatchPatchPrereq)prereqname;
            int pValue = pr.getValue();
            StatusCheck sc = (StatusCheck)PR.get(pr);
            int rStatus = sc.getStatusCode();
            String rResult = sc.getResult();
            System.out.println(pValue + " --- " + "< " + rStatus + " , " + rResult + " >");
            System.out.println("\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized HashMap runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail) throws FailedPrereqException, Throwable {
        Throwable th;
        HashMap prereqResults;
        block16: {
            OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
            OPatchPatch[] prereqPatches = this.getContext().getPrereqPatches();
            String oh = this.getContext().getOracleHome();
            prereqResults = new HashMap();
            th = null;
            if (prereqPatches == null || prereqPatches.length == 0) {
                throw new FailedPrereqException("Please set patches (OPatchPatch objects) in OPatchContext to test for apply pre-requisites.");
            }
            try {
                try {
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_OUI_FUSION_APPLICATIONS_COMPATIBLE, this.checkFusionAppsCompatible(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ACTIVE_FILES_AND_EXECUTABLES, this.checkActiveFilesAndExecutables(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_WINDOWS_ACTIVE_SERVICES_FROM_ORACLE_HOME, this.checkActiveServices(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE, this.checkApplicable(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_ORACLE_HOME, this.checkCentralInventoryForOH(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_FOR_READ_WRITE_SESSION, this.checkCentralInventoryForRWSession(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_LOCATION, this.checkCentralInventoryLocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES_AND_AGAINST_ORACLE_HOME, this.checkConflictAgainstOH(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CONFLICT_AMONG_PATCHES, this.checkConflictAmongPatches(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_ORACLE_HOME_ALREADY_LOCKED_FOR_PATCHING, this.checkIfOHLockedForPatching(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_ORACLE_HOME_SANITY, this.checkOracleHome(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_CENTRAL_INVENTORY_POINTER_FILE, this.checkOraInstLocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_LOCATION, this.checkOUILocation(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_OUI_VERSION_COMPATIBLE, this.checkOUIVersionCompatible(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLICABLE_ON_CURRENT_PLATFORM, this.checkPatchApplicableOnCurrentPlatform(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_APPLY_DEPENDENTS, this.checkPatchApplyDependents(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCH_SHIPHOME, this.checkPatchShipHome(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_REQUIRED_LIBRARIES, this.checkRequiredLibs(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_COMMANDS_AVAILABLE, this.checkSystemCommandAvailable(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_SYSTEM_SPACE, this.checkSystemSpace(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_MINIMUM_OPATCH_VERSION, this.checkMinimumOpatchVersion(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_PATCHING_MODEL, this.checkPatchingModel(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_ALL_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_ALL_NO_OPS), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_IF_SOME_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_SOME_NO_OPS), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_NO_OPERATION_PATCHES, this.checkForNooppatches(CheckNoOpPatchesOption.IF_NONE_NO_OPS), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_IDENTICAL_PATCHES_IN_ORACLE_HOME, this.checkForIdenticalPatchInOracleHome(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_FOR_INPUT_VALUES, this.checkForInputValues(), prereqResults);
                    this.throwThrowableOnFail(needThrowThrowableOnFirstFail, OPatchPatchPrereq.CHECK_USER_ADMIN_PRIVILEGE, this.checkUserAdminPrivilege(), prereqResults);
                }
                catch (Throwable t) {
                    th = t;
                    Object var8_7 = null;
                    if (th != null) {
                        OLogger.printStackTrace((Throwable)new RuntimeException(th));
                    }
                    if (prereqResults != null) {
                        OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                        OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                    }
                    if (OPatchEnv.isFATwoPhase()) {
                        OLogger.printlnOnLog((String)"FA_TWO_PHASE: Save prereq checks results into disk. \n");
                    }
                    OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
                    if (th != null) {
                        throw th;
                    }
                    return prereqResults;
                }
                Object var8_6 = null;
                if (th == null) break block16;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                if (th != null) {
                    OLogger.printStackTrace((Throwable)new RuntimeException(th));
                }
                if (prereqResults != null) {
                    OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
                    OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
                }
                if (OPatchEnv.isFATwoPhase()) {
                    OLogger.printlnOnLog((String)"FA_TWO_PHASE: Save prereq checks results into disk. \n");
                }
                OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
                if (th != null) {
                    throw th;
                }
                return prereqResults;
            }
            OLogger.printStackTrace((Throwable)new RuntimeException(th));
        }
        if (prereqResults != null) {
            OLogger.justlog((int)OLogger.INFO, (String)"\n------- Final Apply Prerequisite checks status -------\n ");
            OLogger.justlog((int)OLogger.INFO, (String)prereqResults.toString());
        }
        if (OPatchEnv.isFATwoPhase()) {
            OLogger.printlnOnLog((String)"FA_TWO_PHASE: Save prereq checks results into disk. \n");
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: runAllApplyPrereqs(boolean needThrowThrowableOnFirstFail)");
        if (th != null) {
            throw th;
        }
        return prereqResults;
    }

    public OPatchContext getContext() {
        return this.context;
    }

    private synchronized void compositeAdapter(boolean napply, OPatchPatch[] patches) throws OPatchException {
        HashSet<String> activeConstituents = new HashSet<String>();
        ArrayList<OPatchPatch> activeComposites = new ArrayList<OPatchPatch>();
        ArrayList<OPatchPatch> oneOffs = new ArrayList<OPatchPatch>();
        for (OPatchPatch patch : patches) {
            if (!patch.getActiveConstituent().equals("")) {
                activeConstituents.add(patch.getActiveConstituent());
                continue;
            }
            oneOffs.add(patch);
        }
        for (OPatchPatch patch : patches) {
            String patchId = patch.getPatchId();
            if (!activeConstituents.contains(patchId)) continue;
            activeComposites.add(patch);
        }
        try {
            if (activeConstituents.size() > 1) {
                throw new Exception("OPatchSDK only support one composite in NApply/NRollback session.");
            }
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            File wsObj = new File(workSheetLoc);
            FileWriter fw = new FileWriter(wsObj);
            PrintWriter pw = new PrintWriter(fw);
            if (napply) {
                String patchLocation;
                for (OPatchPatch oneOff : oneOffs) {
                    patchLocation = oneOff.getPatchLocation();
                    pw.println(patchLocation);
                }
                for (OPatchPatch oneOff : activeComposites) {
                    patchLocation = oneOff.getPatchLocation();
                    pw.println(new File(patchLocation).getParent());
                }
            } else {
                String patchID;
                for (OPatchPatch oneOff : oneOffs) {
                    patchID = oneOff.getPatchLanguageId();
                    pw.println(patchID);
                }
                for (OPatchPatch oneOff : activeComposites) {
                    patchID = oneOff.getPatchLanguageId();
                    pw.println(patchID);
                }
            }
            pw.flush();
            fw.close();
            pw.close();
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized IAnalysisReport NApplyReport(OPatchPatch[] patches, OPatchNApplyOptions options) throws FailedPrereqException, OPatchException {
        OPatchAnalysisReport report;
        block9: {
            OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApplyReport(OPatchPatch[] patches,OPatchNApplyOptions options)");
            report = new OPatchAnalysisReport();
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
                this.getContext().local = options.isLocal();
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(true, patches);
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            cmdOptionStr.append(" -report");
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            Object var7_8 = null;
            try {
                this.getContext().skipConflict = false;
                this.getContext().forceConflict = false;
                this.getContext().optimize = false;
                this.getContext().ohInstanceUp = false;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException e2) {
                OLogger.printStackTrace((Throwable)e2);
            }
            break block9;
            {
                catch (Throwable e) {
                    OLogger.printStackTrace((Throwable)e);
                    OPatchAnalysisReport ereport = report;
                    ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
                    Object var7_9 = null;
                    try {
                        this.getContext().skipConflict = false;
                        this.getContext().forceConflict = false;
                        this.getContext().optimize = false;
                        this.getContext().ohInstanceUp = false;
                        OPatchEnv.setOhInstanceUp((boolean)false);
                        OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                    }
                    catch (OPatchException e2) {
                        OLogger.printStackTrace((Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    this.getContext().skipConflict = false;
                    this.getContext().forceConflict = false;
                    this.getContext().optimize = false;
                    this.getContext().ohInstanceUp = false;
                    OPatchEnv.setOhInstanceUp((boolean)false);
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException e2) {
                    OLogger.printStackTrace((Throwable)e2);
                }
                throw throwable;
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApplyReport(OPatchPatch[] patches,OPatchNApplyOptions options)");
        return report;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NApply(IAnalysisReport report) throws OPatchException {
        OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NApply(IAnalysisReport report)");
        List<OPatchPatch> arrPatches = report.getNApplyPatches();
        OPatchPatch[] patches = new OPatchPatch[arrPatches.size()];
        arrPatches.toArray(patches);
        try {
            if (report.getOptions() != null) {
                OPatchNApplyOptions options = report.getOptions();
                this.getContext().skipConflict = options.getskipConflict();
                this.getContext().forceConflict = options.getforceConflict();
                this.getContext().optimize = options.getOptimize();
                this.getContext().local = options.isLocal();
            }
            OPatchACL.setUserSuppliedPatchIDs((Object)this, (String[])new String[0]);
            OUSession.resetPHBaseDir();
            OPatchEnv.setOneOffToRoll((OneOffEntry[])new OneOffEntry[0]);
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            String prereqResultFileLoc = OPatchTarget.getPrereqResultFileLoc(this.getOracleHome());
            OPatchEnv.setPrereqResult((String)prereqResultFileLoc);
            this.compositeAdapter(true, patches);
            cmdOptionStr.append(PATCH_BASE_FILE);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            OPatchDeployAction.resetCopyVerHashMap();
            if (OPS.INSTANCE.getSupportServices().isSupport(Feature.CAS)) {
                OPatchEnv.setBranchKey((String)"SDK");
                OPatchEnv.setCASPhase1();
                OPatchEnv.setCASPhase2();
            }
            try {
                OPatchSDK.NApply((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                Object var8_11 = null;
            }
            catch (Throwable throwable) {
                Object var8_12 = null;
                try {
                    this.getContext().skipConflict = false;
                    this.getContext().forceConflict = false;
                    this.getContext().optimize = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getContext().skipConflict = false;
                this.getContext().forceConflict = false;
                this.getContext().optimize = false;
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException oPatchException) {}
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NApply(IAnalysisReport report)");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void NRollback(IAnalysisReport report) throws OPatchException {
        List<OPatchPatch> arrPatches = report.getNRollbackPatches();
        OPatchPatch[] patches = new OPatchPatch[arrPatches.size()];
        arrPatches.toArray(patches);
        try {
            if (report.getNRollbackOptions() != null) {
                OPatchNRollbackOptions options = report.getNRollbackOptions();
                this.getContext().optimize = options.getOptimize();
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            try {
                OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
                Object var7_10 = null;
            }
            catch (Throwable throwable) {
                Object var7_11 = null;
                try {
                    this.getContext().optimize = false;
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException oPatchException) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                this.getContext().optimize = false;
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException oPatchException) {}
        }
        catch (Exception e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
        catch (Throwable e) {
            OPatchException oe = new OPatchException(e.getMessage());
            oe.setStackTrace(e.getStackTrace());
            throw oe;
        }
    }

    public synchronized IAnalysisReport NRollbackReport(OPatchPatch[] patches) throws OPatchException, FailedPrereqException {
        return this.NRollbackReport(patches, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public synchronized IAnalysisReport NRollbackReport(OPatchPatch[] patches, OPatchNRollbackOptions options) throws OPatchException, FailedPrereqException {
        OPatchAnalysisReport report;
        block9: {
            OLogger.justlog((int)OLogger.INFO, (String)"ENTERING METHOD: NRollbackReport(OPatchPatch[] patches)");
            report = new OPatchAnalysisReport();
            report = new OPatchAnalysisReport(patches, this, options);
            if (options != null) {
                this.getContext().optimize = options.getOptimize();
                this.getContext().local = options.isLocal();
                this.getContext().ohInstanceUp = options.isOhInstanceUp();
                OPatchEnv.setOhInstanceUp((boolean)options.isOhInstanceUp());
            }
            StringBuffer cmdOptionStr = new StringBuffer("");
            String workSheetLoc = OPatchTarget.getWorkSheet(this.getOracleHome());
            this.compositeAdapter(false, patches);
            cmdOptionStr.append(ID_FILE_OPTION);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(workSheetLoc);
            cmdOptionStr.append(" ");
            cmdOptionStr.append(this.context.getOtherArgs());
            cmdOptionStr.append(" -report");
            this.lastTargetExeLogFile = "";
            OPatchDeployAction.resetCopyVerHashMap();
            OUSession.setIAnalysisReport((IAnalysisReport)report);
            OPatchSDK.NRollback((String)this.getOracleHome(), (String)cmdOptionStr.toString());
            Object var7_8 = null;
            try {
                this.getContext().optimize = false;
                this.getContext().ohInstanceUp = false;
                this.getContext().local = true;
                OPatchEnv.setOhInstanceUp((boolean)false);
                OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
            }
            catch (OPatchException e2) {
                OLogger.printStackTrace((Throwable)e2);
            }
            break block9;
            {
                catch (Throwable e) {
                    OLogger.printStackTrace((Throwable)e);
                    OPatchAnalysisReport ereport = report;
                    ereport.addOPatchPatchPrereqResult(OPatchPatchPrereq.CHECK_NAPPLY_REPORT_PREREQS, PrereqResult.getPrereqResult((PrereqResult.ExecuteStatus)PrereqResult.ExecuteStatus.FAILED, (String)e.getMessage()));
                    Object var7_9 = null;
                    try {
                        this.getContext().optimize = false;
                        this.getContext().ohInstanceUp = false;
                        this.getContext().local = true;
                        OPatchEnv.setOhInstanceUp((boolean)false);
                        OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                    }
                    catch (OPatchException e2) {
                        OLogger.printStackTrace((Throwable)e2);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var7_10 = null;
                try {
                    this.getContext().optimize = false;
                    this.getContext().ohInstanceUp = false;
                    this.getContext().local = true;
                    OPatchEnv.setOhInstanceUp((boolean)false);
                    OPatchDeployAction.setCopyVerHashMap(this.getContext().getOracleHome());
                }
                catch (OPatchException e2) {
                    OLogger.printStackTrace((Throwable)e2);
                }
                throw throwable;
            }
        }
        OLogger.justlog((int)OLogger.INFO, (String)"EXITING METHOD: NRollbackReport(OPatchPatch[] patches)");
        return report;
    }

    public synchronized void clearCachedFiles() {
        this.lastTargetExeLogFile = "";
        try {
            OUSession.clearcache((String)this.getOracleHome());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        OLogger.setOPatchCmdLineMode((boolean)false);
        isTargetInitialized = false;
    }

    public static class StatusCheck {
        public static final int PASSED = 0;
        public static final int FAILED = 1;
        public static final int NOT_EXECUTED = 2;
        private int status = 2;
        private String result = "n/a";

        public StatusCheck(int status, String result) {
            this.status = status;
            this.result = result;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String statusStr = "";
            if (this.status == 0) {
                statusStr = "PASSED";
            } else if (this.status == 1) {
                statusStr = "FAILED";
            } else if (this.status == 2) {
                statusStr = "NOT ATTEMPTED (serious failure)";
            }
            buff.append("[ Prerequisite Status: " + statusStr);
            if (this.result == null || this.result.equals("")) {
                this.result = "\"n/a\"";
            }
            if (this.status != 0) {
                buff.append(", Prerequisite output: " + this.result + "");
            }
            buff.append("]\n");
            return buff.toString();
        }

        protected void setResult(String mixedResult) {
            this.result = mixedResult;
        }

        public String getResult() {
            return this.result;
        }

        public int getStatusCode() {
            return this.status;
        }

        protected void setStatusCode(int value) {
            this.status = value;
        }
    }
}

