/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import oracle.ops.mgmt.cluster.CSSConfigInfo;
import oracle.ops.mgmt.cluster.ClusterCmd;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.Version;

public class VendorClusterUtils {
    private static HashMap nodeMap = new HashMap();

    public static void main(String[] args) {
    }

    public static boolean isNodeAlive(String node) {
        int timeout = 3;
        String[] s = new String[]{node};
        try {
            ClusterCmd Ccmd = new ClusterCmd();
            boolean flag = Ccmd.areNodesAlive(s, timeout, null);
            if (flag) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static boolean isOlderCssConfigured(String Node2) {
        Version ver10 = new Version();
        Version ver92 = Version.get92Version();
        try {
            CSSConfigInfo ci = ClusterInfo.getCSSConfig((String)Node2, (Version)ver10);
            boolean ifCss = ci.isClusterConfig();
            if (ifCss) {
                return true;
            }
            ifCss = ci.isLocalConfig();
            if (ifCss) {
                return true;
            }
            ci = ClusterInfo.getCSSConfig((String)Node2, (Version)ver92);
            ifCss = ci.isClusterConfig();
            if (ifCss) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static String[] getPrivNodeNames(String[] nodes, String orahome) {
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < nodes.length; ++i) {
            String privNode = VendorClusterUtils.getPrivateNodeName(nodes[i], orahome);
            if (privNode == nodes[i]) {
                l.add(nodes[i] + "-priv");
                continue;
            }
            l.add(privNode);
        }
        return l.toArray(new String[0]);
    }

    public static String getPrivateNodeName(String nName, String OraHome) {
        String pName = nName;
        try {
            String s = ClusterInfo.getPrivateNodeName((String)nName);
            System.out.println("Private Interconnect : " + s);
            if (s != null) {
                pName = s;
            }
        }
        catch (ClusterInfoException cie) {
            cie.printStackTrace();
        }
        return pName;
    }

    public static String[] getNodeNames(String lsNodeOption, IProcess process) {
        String pathname = new String(System.getProperty("oracle.installer.NatLibDir"));
        String iLine = "";
        if (pathname == null) {
            System.out.println("Something is wrong : No property set for oracle.installer.NatLibDir");
            return new String[0];
        }
        String lsNodes = pathname + "/lsnodes";
        String command = lsNodes + lsNodeOption;
        File lsFile = new File(lsNodes);
        if (!lsFile.exists()) {
            return new String[0];
        }
        ssClusterSysQueriesux.setPermission(lsNodes);
        Runtime rt = Runtime.getRuntime();
        ArrayList<String> l = new ArrayList<String>();
        try {
            Process p = rt.exec(command);
            p.waitFor();
            BufferedReader reader = new BufferedReader(new InputStreamReader(p.getInputStream()));
            while ((iLine = reader.readLine()) != null) {
                String s = process.execute(iLine.trim());
                l.add(s);
            }
            reader.close();
        }
        catch (Exception e) {
            System.out.println("Exception : " + e);
        }
        return l.toArray(new String[0]);
    }

    /*
     * Inner class renamed, behaviour may change
     */
    public static String[] getNodeNames() {
        String option = " -v";
        class Process
        implements IProcess {
            Process() {
            }

            @Override
            public String execute(String l) {
                StringTokenizer st = new StringTokenizer(l);
                String hostName = (String)st.nextElement();
                String nodeNumber = (String)st.nextElement();
                nodeMap.put(hostName, nodeNumber);
                return "";
            }
        }
        return VendorClusterUtils.getNodeNames(option, new Process2());
    }

    private static void makePublicNodeAndNodenumberMapping() {
        String option = " -n";
        VendorClusterUtils.getNodeNames(option, (IProcess)new Process());
    }

    public static String getNodeNumber(String publicNode) {
        if (nodeMap.isEmpty()) {
            VendorClusterUtils.makePublicNodeAndNodenumberMapping();
        }
        if (nodeMap.containsKey(publicNode)) {
            return (String)nodeMap.get(publicNode);
        }
        return "-1";
    }

    public static String[] getPrivateNodeNumberList() {
        String[] publicNodes = VendorClusterUtils.getNodeNames();
        String[] privateNodes = VendorClusterUtils.getPrivNodeNames(publicNodes, "/tmp");
        ArrayList<String> l = new ArrayList<String>();
        for (int i = 0; i < publicNodes.length; ++i) {
            String number = VendorClusterUtils.getNodeNumber(publicNodes[i]);
            l.add(privateNodes[i]);
            l.add(number);
        }
        return l.toArray(new String[0]);
    }
}

