/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.util.engine;

import com.jcraft.jsch.ChannelExec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.install.commons.base.util.job.ExecutionResult;

public class ExecutionProcessHandler {
    private static final Logger logger = Logger.getLogger(ExecutionProcessHandler.class.getName());

    public void handleProcess(final Process process, final ExecutionResult executionResult, final Map<String, String> stdIn) throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(2);
        Future<Integer> future = service.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                ExecutionProcessHandler.this.handleInputOutput(process.getInputStream(), process.getOutputStream(), executionResult, stdIn);
                int exitCode = process.waitFor();
                executionResult.setExitCode(exitCode);
                return process.exitValue();
            }
        });
        Future<Void> stderrFuture = service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExecutionProcessHandler.this.handleStderr(process.getErrorStream(), executionResult);
                return null;
            }
        });
        service.shutdown();
        future.get();
    }

    public void handleChannel(final ChannelExec channel, final ExecutionResult executionResult, final Map<String, String> stdIn) throws InterruptedException, ExecutionException {
        ExecutorService service = Executors.newFixedThreadPool(2);
        Future<Integer> future = service.submit(new Callable<Integer>(){

            @Override
            public Integer call() throws IOException, InterruptedException {
                ExecutionProcessHandler.this.handleInputOutput(channel.getInputStream(), channel.getOutputStream(), executionResult, stdIn);
                while (true) {
                    if (channel.isClosed()) break;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ee) {
                        logger.log(Level.WARNING, "interrupted while waiting for cmd to write " + ee.getMessage());
                    }
                }
                int exitCode = channel.getExitStatus();
                executionResult.setExitCode(exitCode);
                return channel.getExitStatus();
            }
        });
        Future<Void> stderrFuture = service.submit(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ExecutionProcessHandler.this.handleStderr(channel.getErrStream(), executionResult);
                return null;
            }
        });
        service.shutdown();
        future.get();
    }

    protected void handleInputOutput(InputStream outputStream, OutputStream inputStream, ExecutionResult executionResult, Map<String, String> stdIn) throws IOException, InterruptedException {
        StringBuffer stdoutBuffer = new StringBuffer();
        logger.log(Level.INFO, "... CommandExecutionJob.handleProcess() entered.");
        logger.log(Level.INFO, "... CommandExecutionJob: checking secretArguments.");
        if (stdIn == null || stdIn.isEmpty()) {
            logger.log(Level.INFO, "No arguments to pass to stdin");
        } else {
            logger.log(Level.FINEST, "secretArguments {0}", stdIn.keySet());
        }
        PrintWriter stdin = new PrintWriter(inputStream);
        BufferedReader stdout = new BufferedReader(new InputStreamReader(outputStream));
        String line = "";
        logger.log(Level.INFO, "... CommandExecutionJob: starting read loop.");
        while ((line = stdout.readLine()) != null) {
            logger.log(Level.INFO, "Read: {0}", line);
            stdoutBuffer.append(line + "\n");
            if (stdIn == null || stdIn.isEmpty()) continue;
            String secretArgValue = null;
            for (String prompt : stdIn.keySet()) {
                logger.log(Level.FINEST, "Matching regex: {0}", prompt);
                Pattern p = Pattern.compile(prompt, 2);
                Matcher m = p.matcher(line);
                if (!m.matches()) continue;
                secretArgValue = stdIn.get(prompt);
            }
            if (secretArgValue != null) {
                logger.log(Level.INFO, "Processing: {0} for secrete argument argument", new String[]{line});
                stdin.println(secretArgValue);
                stdin.flush();
                continue;
            }
            logger.log(Level.INFO, "Skipping line: {0}", line);
        }
        stdin.close();
        executionResult.addOutput(stdoutBuffer.toString());
    }

    protected Void handleStderr(InputStream erorrStream, ExecutionResult executionResult) throws IOException {
        StringBuffer stderrBuffer = new StringBuffer();
        BufferedReader stderr = new BufferedReader(new InputStreamReader(erorrStream));
        String line = "";
        while ((line = stderr.readLine()) != null) {
            logger.log(Level.INFO, "Stderr Read: {0}", line);
            stderrBuffer.append(line + "\n");
        }
        executionResult.addError(stderrBuffer.toString());
        return null;
    }
}

