/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui.etc;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationResult;
import oracle.cluster.verification.VerificationResultSet;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.StringUtils;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.exception.UncheckedException;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.ContentType;
import oracle.install.commons.util.message.PlainContent;

public class UnhandledDriverException
extends UncheckedException {
    Severity severity;
    public static final Resource stringResBundle = Application.getInstance().getResource("oracle.install.commons.util.resource.StringResourceBundle");
    public static final Resource resource = Application.getInstance().getResource("oracle.install.library.resource.StringResourceBundle");
    private static final Logger logger = Logger.getLogger(UnhandledDriverException.class.getName());

    public UnhandledDriverException(ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.init();
    }

    public UnhandledDriverException(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.init();
    }

    public UnhandledDriverException(Throwable cause) {
        super(cause);
        this.init();
    }

    public UnhandledDriverException(Content extraDetails, ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Content extraDetails, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    public UnhandledDriverException(Throwable cause, Content extraDetails) {
        super(cause);
        super.getErrorInfo().setExtraDetails(extraDetails);
        this.init();
    }

    private void init() {
        this.severity = super.getErrorInfo().getSeverity();
        if (Application.isCommandLineSwitchEnabled("-ignoreInternalDriverError") && this.severity != Severity.WARNING) {
            this.severity = Severity.WARNING;
        }
    }

    public static PlainContent createExtraDetails(VerificationResultSet resultSet) {
        StringBuffer messageBuffer = new StringBuffer();
        if (resultSet != null) {
            List vErrors = resultSet.getErrors();
            for (VerificationError error : vErrors) {
                String message = error.getErrorMessage();
                String action = error.getAction();
                String cause = error.getCause();
                if (message != null) {
                    messageBuffer.append("&nbsp;-&nbsp;");
                    messageBuffer.append(StringUtils.textToHtml(message) + "<br>");
                }
                if (cause != null) {
                    messageBuffer.append("&nbsp;-&nbsp;").append(stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;");
                    messageBuffer.append(StringUtils.textToHtml(cause) + "<br>");
                }
                if (action == null) continue;
                messageBuffer.append("&nbsp;-&nbsp;").append(stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;");
                messageBuffer.append(StringUtils.textToHtml(action) + "<br>");
            }
            List failedNodes = resultSet.getFailedNodes();
            if (failedNodes != null && failedNodes.size() > 0) {
                messageBuffer.append("<b>" + resource.getString("ErrorMessage.extraDetails.nodeSpecificErrors", "Summary of the failed nodes", new Object[0]) + "</b><br>");
                for (String failedNode : failedNodes) {
                    if (failedNode == null) continue;
                    try {
                        messageBuffer.append("<b>" + failedNode + "</b><br>");
                        VerificationResult nodeResult = resultSet.getNodeResult(failedNode);
                        if (nodeResult == null) continue;
                        List nodeSpecificErrors = nodeResult.getErrors();
                        for (VerificationError error : nodeSpecificErrors) {
                            String message = error.getErrorMessage();
                            String cause = error.getCause();
                            String action = error.getAction();
                            if (message != null) {
                                messageBuffer.append("&nbsp;-&nbsp;");
                                messageBuffer.append(StringUtils.textToHtml(message) + "<br>");
                            }
                            if (cause != null) {
                                messageBuffer.append("&nbsp;-&nbsp;").append(stringResBundle.getString("ErrorMessage.details.titles.cause", "Cause *", new Object[0])).append(":&nbsp;");
                                messageBuffer.append(StringUtils.textToHtml(cause) + "<br>");
                            }
                            if (action == null) continue;
                            messageBuffer.append("&nbsp;-&nbsp;").append(stringResBundle.getString("ErrorMessage.details.titles.action", "Action *", new Object[0])).append(":&nbsp;");
                            messageBuffer.append(StringUtils.textToHtml(action) + "<br>");
                        }
                    }
                    catch (NodeResultsUnavailableException e) {
                        logger.log(Level.INFO, "Exception while getting node results to display in extra details of error message", e);
                    }
                }
            }
        }
        PlainContent content = new PlainContent(messageBuffer.toString());
        ContentType contentType = ContentType.HTML;
        content.setContentType(contentType);
        return content;
    }

    @Override
    public Severity getSeverity() {
        return this.severity;
    }
}

