/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationHelper;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.progress.Job;

public class RootScriptException
extends CheckedException {
    private Job rootScriptJob;
    private List<String> failedNodes;
    private Logger logger = Logger.getLogger(RootScriptException.class.getName());

    public RootScriptException(Job job, List<String> failedNodes) {
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(severity);
    }

    public RootScriptException(Job job, List<String> failedNodes, ErrorCode errorCode, Severity severity, String helpId) {
        super(errorCode, severity, helpId);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(severity);
    }

    public RootScriptException(Job job, List<String> failedNodes, String message, ErrorCode errorCode, Severity severity) {
        super(message, errorCode, severity);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(severity);
    }

    public RootScriptException(Job job, List<String> failedNodes, String message, Throwable cause, ErrorCode errorCode, Severity severity) {
        super(message, cause, errorCode, severity);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(severity);
    }

    public RootScriptException(Job job, List<String> failedNodes, String message, Throwable cause) {
        super(message, cause);
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, String message) {
        super(message);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(severity);
    }

    public RootScriptException(Job job, List<String> failedNodes, Throwable cause, ErrorInfo errorInfo) {
        super(cause, errorInfo);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public RootScriptException(Job job, List<String> failedNodes, Throwable cause) {
        super(cause);
        this.rootScriptJob = job;
        this.failedNodes = failedNodes;
        this.init(null);
    }

    public Job getRootScriptJob() {
        return this.rootScriptJob;
    }

    public List<String> getFailedNodes() {
        return this.failedNodes;
    }

    protected void init(Severity severity) {
        if (severity == null) {
            Severity newSeverity = ValidationHelper.getActionableValidationSeverity();
            if (newSeverity != null) {
                this.setSeverity(newSeverity);
            } else {
                this.logger.log(Level.INFO, "Property: actionable.validation.advisor.severity is not specified. So using default severity.");
            }
        }
    }
}

