/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallerErrorCode;
import oracle.install.commons.base.driver.common.SetupDriver;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.LogManager;
import oracle.install.commons.util.Option;
import oracle.install.commons.util.Resource;
import oracle.install.commons.util.exception.Advice;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ExceptionManager;
import oracle.install.commons.util.progress.Job;
import oracle.install.commons.util.progress.ProgressUI;
import oracle.install.commons.util.progress.Status;
import oracle.install.driver.oui.DriverConstants;
import oracle.install.driver.oui.FileTransferProgressListener;
import oracle.install.driver.oui.RemoteCopyException;
import oracle.install.driver.oui.RemoteCopyHelper;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.StringResourceBundle;
import oracle.ops.mgmt.cluster.ClusterException;
import oracle.ops.mgmt.cluster.ClusterInfo;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.ClusterOperationException;
import oracle.ops.mgmt.cluster.RemoteFileOperationException;
import oracle.ops.mgmt.cluster.Version;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIOUIAPISession;
import oracle.sysman.oii.oiic.OiicSessionContext;
import oracle.sysman.oii.oiif.oiifr.OiifrProgressPhases;
import oracle.sysman.oii.oiis.OiisVariableOwner;

public class RemoteCopyJob
extends Job
implements Callable<Void> {
    private boolean multiNodeSetup;
    private boolean sharedHome;
    private String oracleHome;
    private String[] remoteNodes;
    private String oracleBase;
    private SetupJob setupJob;
    private String excludeFilePath;
    private boolean tolerantMode;
    private ProgressUI<?> progressBar;
    public static final Resource resource = Application.getInstance().getResource(StringResourceBundle.class.getName());
    private Logger logger = Logger.getLogger(RemoteCopyJob.class.getName());

    public RemoteCopyJob(Object id, String description, float weightage, boolean multiNode, boolean sharedhome, String oracleHome, String oracleBase, String[] remoteNodesArr, String excludeFilePath, SetupJob setupJob, boolean tolerantMode) {
        super(id, description, weightage);
        this.multiNodeSetup = multiNode;
        this.sharedHome = sharedhome;
        this.oracleHome = oracleHome;
        this.oracleBase = oracleBase;
        this.remoteNodes = remoteNodesArr;
        this.excludeFilePath = excludeFilePath;
        this.setupJob = setupJob;
        this.tolerantMode = tolerantMode;
        this.setRequired(true);
        this.setRetryEnabled(false);
    }

    @Override
    public Callable<?> getWork() {
        return this;
    }

    @Override
    public Void call() throws Exception {
        if (this.setupJob != null) {
            this.progressBar = this.setupJob.getInstallProgressMonitor().getProgressUI();
        }
        if (this.multiNodeSetup && !this.sharedHome) {
            ArrayList<String> nodeListOBCheckFailed = new ArrayList<String>();
            ArrayList<String> nodeListOBNotExist = new ArrayList<String>();
            for (int i = 0; i < this.remoteNodes.length; ++i) {
                String remoteNode = this.remoteNodes[i];
                boolean dirExists = false;
                try {
                    this.logger.log(Level.FINEST, "Checking existence of " + this.oracleBase + " on node " + remoteNode);
                    dirExists = RemoteCopyHelper.getInstance().dirExists(remoteNode, this.oracleBase);
                    if (dirExists) continue;
                    nodeListOBNotExist.add(remoteNode);
                    continue;
                }
                catch (ClusterException cex) {
                    nodeListOBCheckFailed.add(remoteNode);
                    this.logger.log(Level.WARNING, "ClusterException occurred while checking " + this.oracleBase + " existence on node " + remoteNode, cex);
                    continue;
                }
                catch (ClusterOperationException copex) {
                    nodeListOBCheckFailed.add(remoteNode);
                    this.logger.log(Level.WARNING, "ClusterOperationException occurred while checking " + this.oracleBase + " existence on node " + remoteNode, copex);
                }
            }
            if (!nodeListOBNotExist.isEmpty()) {
                this.logger.log(Level.INFO, "Creating " + this.oracleBase + " on nodes " + nodeListOBNotExist);
                RemoteCopyHelper.getInstance().createDirWithPermissionsOnNodes(nodeListOBNotExist.toArray(new String[0]), this.oracleBase, "0755");
            }
            String tempDir = System.getProperty("java.io.tmpdir");
            String includeListFile = null;
            String remoteNodeCommonDestDir = this.oracleHome;
            try {
                this.setStatus(Status.INPROGRESS);
                this.logger.finest("Job:" + this.getDescription() + " started. Status:" + (Object)((Object)this.getStatus()));
                this.logger.log(Level.INFO, "Copying {0} to remote nodes {1}", new Object[]{this.oracleHome, Arrays.toString(this.remoteNodes)});
                if (this.progressBar != null) {
                    this.progressBar.log(Level.INFO, resource.getString("RemoteCopy.message", "Copying {0} to remote nodes", this.oracleHome), new Object[0]);
                }
                RemoteCopyHelper.getInstance().transferDirStructureToNodes(this.oracleHome, this.remoteNodes, this.oracleHome, includeListFile, true, this.excludeFilePath, true, tempDir, remoteNodeCommonDestDir, new FileTransferProgressListener(this, this.progressBar));
                this.setStatus(Status.SUCCEEDED);
                this.logger.finest("Job:" + this.getDescription() + " completed with the status:" + (Object)((Object)this.getStatus()));
            }
            catch (RemoteFileOperationException rfoex) {
                List<String> failedNodes = RemoteCopyHelper.getInstance().getFailedNodes();
                if (this.tolerantMode) {
                    RemoteCopyException remoteOpEx = new RemoteCopyException((ErrorCode)InstallerErrorCode.ACTIONABLE_REMOTE_COPY_OPERATION_FAILED, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
                    Option advice = ExceptionManager.report(remoteOpEx);
                    if (advice == Advice.CONTINUE) {
                        Job saveInvJob;
                        ArrayList<String> remoteNodeList = new ArrayList<String>(Arrays.asList(this.remoteNodes));
                        this.logger.log(Level.FINEST, "Original list of remote nodes selected for remote copy : " + remoteNodeList);
                        remoteNodeList.removeAll(failedNodes);
                        this.logger.log(Level.INFO, "List of remote nodes where remote copy succeeded : " + remoteNodeList);
                        this.setupJob.setSuccessfulRemoteNodes(remoteNodeList);
                        this.logger.log(Level.FINEST, "Updating the bean to trim the remote nodes where remote copy failed.");
                        Object setupDriver = SetupDriver.getInstance();
                        ((SetupDriver)setupDriver).updateConfig(failedNodes);
                        String localNode = null;
                        try {
                            localNode = ClusterInfo.getHostName((String)"localnode", (Version)new Version());
                            this.logger.log(Level.INFO, "Local Host Name : " + localNode);
                        }
                        catch (ClusterInfoException e) {
                            this.logger.warning("Could not get the hostname of : localnode");
                        }
                        ArrayList<String> clusterNodes = new ArrayList<String>();
                        clusterNodes.add(localNode);
                        clusterNodes.addAll(remoteNodeList);
                        this.logger.log(Level.INFO, "Cluster nodes : " + clusterNodes);
                        OiicAPIInstaller ouiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
                        OiicIOUIAPISession ouiSession = ouiInstaller.getOUIAPISession();
                        OiisVariableOwner ouiContext = ouiSession.getISession().getContext();
                        if (ouiContext instanceof OiicSessionContext) {
                            OiicSessionContext ouiSessionContext = (OiicSessionContext)ouiContext;
                            ouiSessionContext.setVarValue("REMOTE_NODES", (Object)remoteNodeList.toArray(new String[0]));
                            this.logger.info("REMOTE_NODES=" + ouiSessionContext.getVarValue("REMOTE_NODES"));
                            ouiSessionContext.setVarValue("CLUSTER_NODES", (Object)clusterNodes.toArray(new String[0]));
                            this.logger.info("CLUSTER_NODES=" + ouiSessionContext.getVarValue("CLUSTER_NODES"));
                        }
                        this.setStatus(Status.SUCCEEDED);
                        this.logger.finest("Job:" + this.getDescription() + " completed with the status:" + (Object)((Object)this.getStatus()));
                        if (remoteNodeList != null && remoteNodeList.size() == 0 && (saveInvJob = this.setupJob.getInstallProgressMonitor().getJob(OiifrProgressPhases.ADD_NODE_SAVE_INV_PHASE)) != null) {
                            Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
                            this.progressBar.log(Level.INFO, resource.getString("setupJob.install.remoteinventorycopy.text", "Saving cluster inventory", new Object[0]), new Object[0]);
                            saveInvJob.setStatus(Status.SUCCEEDED);
                            this.logger.finest("Job:" + saveInvJob.getDescription() + " completed with the status:" + (Object)((Object)saveInvJob.getStatus()));
                        }
                    }
                    this.setStatus(Status.FAILED);
                    this.logger.finest("Job:" + this.getDescription() + " completed with the status:" + (Object)((Object)this.getStatus()));
                    throw remoteOpEx;
                }
                RemoteCopyException remoteOpEx = new RemoteCopyException((ErrorCode)InstallerErrorCode.REMOTE_COPY_OPERATION_FAILED, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
                throw remoteOpEx;
            }
            catch (ClusterException cex) {
                ArrayList<String> failedNodes = new ArrayList<String>();
                failedNodes.addAll(Arrays.asList(this.remoteNodes));
                RemoteCopyException remoteOpEx = new RemoteCopyException((ErrorCode)InstallerErrorCode.REMOTE_COPY_OPERATION_FAILED, this.oracleHome, failedNodes, LogManager.getInstance().getDefaultLogFile());
                throw remoteOpEx;
            }
        }
        return null;
    }
}

