/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.flow.validation.ValidationHelper;
import oracle.install.commons.util.exception.CheckedException;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.commons.util.exception.ErrorInfo;
import oracle.install.commons.util.exception.Severity;
import oracle.install.commons.util.message.Content;
import oracle.install.commons.util.message.PlainContent;
import oracle.install.driver.oui.RemoteCopyHelper;

public class RemoteCopyException
extends CheckedException {
    private Logger logger = Logger.getLogger(RemoteCopyException.class.getName());

    public RemoteCopyException() {
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(ErrorCode errorCode, Object ... messageArgs) {
        super(errorCode, messageArgs);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(errorCode, severity, messageArgs);
        this.init(severity);
        this.updateExtraDetails();
    }

    public RemoteCopyException(ErrorCode errorCode, Severity severity, String helpId) {
        super(errorCode, severity, helpId);
        this.init(severity);
        this.updateExtraDetails();
    }

    public RemoteCopyException(ErrorInfo errorInfo) {
        super(errorInfo);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(String message, ErrorCode errorCode, Severity severity) {
        super(message, errorCode, severity);
        this.init(severity);
        this.updateExtraDetails();
    }

    public RemoteCopyException(String message, Throwable cause, ErrorCode errorCode, Severity severity) {
        super(message, cause, errorCode, severity);
        this.init(severity);
        this.updateExtraDetails();
    }

    public RemoteCopyException(String message, Throwable cause) {
        super(message, cause);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(String message) {
        super(message);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(Throwable cause, ErrorCode errorCode, Object ... messageArgs) {
        super(cause, errorCode, messageArgs);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(Throwable cause, ErrorCode errorCode, Severity severity, Object ... messageArgs) {
        super(cause, errorCode, severity, messageArgs);
        this.init(severity);
        this.updateExtraDetails();
    }

    public RemoteCopyException(Throwable cause, ErrorInfo errorInfo) {
        super(cause, errorInfo);
        this.init(null);
        this.updateExtraDetails();
    }

    public RemoteCopyException(Throwable cause) {
        super(cause);
        this.init(null);
        this.updateExtraDetails();
    }

    protected void init(Severity severity) {
        if (severity == null) {
            Severity newSeverity = ValidationHelper.getActionableValidationSeverity();
            if (newSeverity != null) {
                this.setSeverity(newSeverity);
            } else {
                this.logger.log(Level.INFO, "Property: actionable.validation.advisor.severity is not specified. So using default severity.");
            }
        }
    }

    protected void updateExtraDetails() {
        ErrorInfo errorInfo = this.getErrorInfo();
        if (errorInfo != null) {
            errorInfo.setExtraDetails(this.computeExtraDetails());
        }
    }

    protected Content computeExtraDetails() {
        PlainContent content = null;
        RemoteCopyHelper helper = RemoteCopyHelper.getInstance();
        if (!helper.isResultSetDirty()) {
            content = helper.getExtraDetails();
            helper.setResultSetDirty(true);
        }
        return content;
    }
}

