/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.install.commons.base.driver.common.InstallEngineErrorCode;
import oracle.install.commons.base.driver.common.SetupDriverException;
import oracle.install.commons.base.util.PlatformInfo;
import oracle.install.commons.base.util.cli.CommandLineArgumentHandler;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.exception.ErrorCode;
import oracle.install.driver.oui.InventoryInfo;
import oracle.install.driver.oui.OUICommandHelper;
import oracle.install.driver.oui.OUILogHandler;
import oracle.install.driver.oui.OUISetupDriver;
import oracle.install.driver.oui.SetupJob;
import oracle.install.driver.oui.resource.OUIErrorCode;
import oracle.sysman.oii.oiic.OiicAPIInstaller;
import oracle.sysman.oii.oiic.OiicIllegalStateException;
import oracle.sysman.oii.oiic.OiicInstallAPIException;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;

public abstract class OUINodeScalerDriver<T>
extends OUISetupDriver<T> {
    private static Logger logger = Logger.getLogger(OUINodeScalerDriver.class.getName());
    private String inventoryLoc;

    public void setInventoryLoc(String inventoryLoc) {
        this.inventoryLoc = inventoryLoc;
    }

    public OUINodeScalerDriver() {
        OUICommandHelper.setMode(SetupJob.OUISetupMode.ADDNODE);
    }

    @Override
    public void showUsage() {
        System.setProperty("application.commandline.hideMutuallyExclusiveArgsNotMatchingContextOrPlatform", "true");
        CommandLineArgumentHandler commandLineArgumentHandler = CommandLineArgumentHandler.getInstance();
        commandLineArgumentHandler.setContextId(System.getProperty("application.commandline.currentContextId", null));
        commandLineArgumentHandler.showHelp(Application.getInstance().getArguments());
    }

    @Override
    public void load() throws SetupDriverException {
        super.load();
        this.setAdditionalOUIProperties(this.properties);
        String useOUIRemoteCopy = System.getProperty("oracle.installer.performRemoteCopyInAPIMode");
        if (useOUIRemoteCopy != null && useOUIRemoteCopy.length() > 0) {
            System.setProperty("oracle.installer.performRemoteCopyInAPIMode", useOUIRemoteCopy.trim());
        } else {
            System.setProperty("oracle.installer.performRemoteCopyInAPIMode", Boolean.FALSE.toString());
        }
        OiicAPIInstaller apiInstaller = OiicAPIInstaller.getAPIInstallerInstance();
        int exitStatus = 0;
        try {
            exitStatus = this.inventoryLoc != null ? apiInstaller.initInstallEnvironment(this.properties, false, 4, this.inventoryLoc) : apiInstaller.initInstallEnvironment(this.properties, false, 4);
        }
        catch (OiicIllegalStateException e) {
            logger.log(Level.INFO, "Excpetion while initializing add node mode", e);
        }
        catch (OiicInstallAPIException e) {
            logger.log(Level.INFO, "Exception while initializing add node mode", e);
        }
        if (this.isOUILogUsed()) {
            OUILogHandler.setDirectLoggingEnabled(true);
        }
        if (exitStatus == 1001 && !OiiiInstallAreaControl.isCleanMachine()) {
            throw new SetupDriverException((ErrorCode)InstallEngineErrorCode.INVENTORY_INIT_FAILED, new Object[0]);
        }
        if (!PlatformInfo.getInstance().isWindows() && !Boolean.getBoolean("oracle.install.skipInventoryGroupCheck") && InventoryInfo.getInstance().isInventoryExist() && (InventoryInfo.getInstance().getUnixGroupName() == null || InventoryInfo.getInstance().getUnixGroupName().isEmpty())) {
            throw new SetupDriverException((ErrorCode)OUIErrorCode.NO_INVENTORY_GROUP_PRESENT_ORAINST_LOC_FILE, new Object[0]);
        }
    }

    protected void setAdditionalOUIProperties(Properties properties) {
    }

    protected boolean isOUILogUsed() {
        return true;
    }

    protected String[] transformToNonFQDN(String[] nodes) {
        String[] nonFQDN = new String[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            int dotIndex = nodes[i].indexOf(46);
            nonFQDN[i] = dotIndex > -1 ? nodes[i].substring(0, dotIndex) : nodes[i];
        }
        return nonFQDN;
    }
}

