/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.driver.oui;

import java.util.logging.Level;
import oracle.install.commons.util.Application;
import oracle.install.commons.util.ExitStatus;
import oracle.install.commons.util.Resource;
import oracle.install.driver.oui.DriverConstants;

public enum OUIExitStatus implements ExitStatus
{
    SUCCESS(0, Level.INFO),
    FAILURE(-1, Level.SEVERE),
    SUCCESS_MINUS_OPTTOOLS(1, Level.WARNING),
    LOCAL_SUCCESS_REMOTE_FAILURE(2, Level.WARNING),
    SUCCESS_MINUS_RECTOOL(3, Level.WARNING),
    VAR_VALIDATION_FAILURE(-2, Level.SEVERE),
    PREREQ_FAILURE(-3, Level.SEVERE),
    STOP_INSTALL(-4, Level.SEVERE);

    private int intValue;
    private Level level;

    private OUIExitStatus(int intValue, Level level) {
        this.intValue = intValue;
        this.level = level;
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public String getMessage() {
        Resource resource = Application.getInstance().getResource(DriverConstants.STRING_RESOURCE_BUNDLE_NAME);
        return resource.getString(this, new Object[0]);
    }

    @Override
    public int getIntValue() {
        return this.intValue;
    }

    public static OUIExitStatus valueOf(int intValue) {
        OUIExitStatus value = null;
        for (OUIExitStatus item : OUIExitStatus.values()) {
            if (item.intValue != intValue) continue;
            value = item;
            break;
        }
        return value;
    }
}

